theory isar_proof_optimized_trivial
imports Main
begin

typedecl point
typedecl line
typedecl plane

consts eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts not_eq_point :: "point \<Rightarrow> point \<Rightarrow> bool"
consts eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts not_eq_line :: "line \<Rightarrow> line \<Rightarrow> bool"
consts eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts not_eq_plane :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts not_inc_po_l :: "point \<Rightarrow> line \<Rightarrow> bool"
consts inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts not_inc_po_pl :: "point \<Rightarrow> plane \<Rightarrow> bool"
consts inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts not_inc_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts not_int_l_l :: "line \<Rightarrow> line \<Rightarrow> bool"
consts int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts not_int_l_pl :: "line \<Rightarrow> plane \<Rightarrow> bool"
consts int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts not_int_pl_pl :: "plane \<Rightarrow> plane \<Rightarrow> bool"
consts cop :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_cop :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_col :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_bet :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_cong :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_cong_angle :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts order :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_order :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts cut :: "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts not_cut :: "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow> bool"
consts pash :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow> bool"
consts not_pash :: "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow> bool"
consts parallel :: "line \<Rightarrow> line \<Rightarrow> bool"
consts not_parallel :: "line \<Rightarrow> line \<Rightarrow> bool"

axiomatization where
ax_D11b: "inc_po_l PO1 LI2 \<and> not_inc_po_pl PO1 PL3 \<Longrightarrow> not_inc_l_pl LI2 PL3"

and
ax_D11: "inc_l_pl LI2 PL3 \<and> inc_po_l PO1 LI2 \<Longrightarrow> inc_po_pl PO1 PL3"

and
ax_D1a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> not_inc_po_l PO3 LI4 \<Longrightarrow> not_col PO1 PO2 PO3"

and
ax_D1: "inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4 \<Longrightarrow> col PO1 PO2 PO3"

and
ax_D2a: "PO1 ~= PO2 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> not_col PO1 PO2 PO3 \<Longrightarrow> not_inc_po_l PO3 LI4"

and
ax_D3a: "not_col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> not_inc_po_pl PO4 PL5 \<Longrightarrow> not_cop PO1 PO2 PO3 PO4"

and
ax_D3: "inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5 \<Longrightarrow> cop PO1 PO2 PO3 PO4"

and
ax_D4a: "not_col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> not_cop PO1 PO2 PO3 PO4 \<Longrightarrow> not_inc_po_pl PO4 PL5"

and
ax_D5a: "LI1 ~= LI2 \<and> not_int_l_l LI1 LI2 \<and> inc_po_l PO3 LI1 \<Longrightarrow> not_inc_po_l PO3 LI2"

and
ax_D5: "LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2 \<Longrightarrow> int_l_l LI1 LI2"

and
ax_D7a: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> not_int_pl_pl PL1 PL2 \<Longrightarrow> not_inc_po_pl PO3 PL2"

and
ax_D7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_pl_pl PL1 PL2"

and
ax_D9a: "not_inc_l_pl LI1 PL2 \<and> not_int_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<Longrightarrow> not_inc_po_pl PO3 PL2"

and
ax_D9b: "not_inc_l_pl LI1 PL2 \<and> not_int_l_pl LI1 PL2 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> not_inc_po_l PO3 LI1"

and
ax_D9: "not_inc_l_pl LI1 PL2 \<and> inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> int_l_pl LI1 PL2"

and
ax_false_bet: "bet PO1 PO2 PO3 \<and> not_bet PO1 PO2 PO3 \<Longrightarrow> False"

and
ax_false_col: "col PO1 PO2 PO3 \<and> not_col PO1 PO2 PO3 \<Longrightarrow> False"

and
ax_false_cop: "cop PO1 PO2 PO3 PO4 \<and> not_cop PO1 PO2 PO3 PO4 \<Longrightarrow> False"

and
ax_false_inc_l_pl: "inc_l_pl LI1 PL2 \<and> not_inc_l_pl LI1 PL2 \<Longrightarrow> False"

and
ax_false_inc_po_l: "inc_po_l PO1 LI2 \<and> not_inc_po_l PO1 LI2 \<Longrightarrow> False"

and
ax_false_inc_po_pl: "inc_po_pl PO1 PL2 \<and> not_inc_po_pl PO1 PL2 \<Longrightarrow> False"

and
ax_false_int_l_l: "int_l_l LI1 LI2 \<and> not_int_l_l LI1 LI2 \<Longrightarrow> False"

and
ax_false_int_l_pl: "int_l_pl LI1 PL2 \<and> not_int_l_pl LI1 PL2 \<Longrightarrow> False"

and
ax_false_int_pl_pl: "int_pl_pl PL1 PL2 \<and> not_int_pl_pl PL1 PL2 \<Longrightarrow> False"

and
ax_I2: "PO1 ~= PO2 \<and> inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3 \<and> inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<Longrightarrow> LI3 = LI4"

and
ax_I5: "not_col PO1 PO2 PO3 \<and> inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4 \<and> inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<Longrightarrow> PL4 = PL5"

and
ax_I6: "PO1 ~= PO2 \<and> inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3 \<and> inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<Longrightarrow> inc_l_pl LI3 PL4"

and
ax_sym_col1: "col PO1 PO2 PO3 \<Longrightarrow> col PO2 PO3 PO1"

and
ax_sym_col2: "col PO1 PO2 PO3 \<Longrightarrow> col PO2 PO1 PO3"

and
ax_sym_col: "col PO1 PO2 PO3 \<Longrightarrow> (col PO1 PO3 PO2 \<and> col PO2 PO1 PO3 \<and> col PO2 PO3 PO1 \<and> col PO3 PO1 PO2 \<and> col PO3 PO2 PO1)"

and
ax_sym_cop1: "cop PO1 PO2 PO3 PO4 \<Longrightarrow> cop PO2 PO3 PO4 PO1"

and
ax_sym_cop2: "cop PO1 PO2 PO3 PO4 \<Longrightarrow> cop PO2 PO1 PO3 PO4"

and
ax_sym_cop: "cop PO1 PO2 PO3 PO4 \<Longrightarrow> (cop PO1 PO2 PO4 PO3 \<and> cop PO1 PO3 PO2 PO4 \<and> cop PO1 PO3 PO4 PO2 \<and> cop PO1 PO4 PO2 PO3 \<and> cop PO1 PO4 PO3 PO2 \<and> cop PO2 PO1 PO3 PO4 \<and> cop PO2 PO1 PO4 PO3 \<and> cop PO2 PO3 PO1 PO4 \<and> cop PO2 PO3 PO4 PO1 \<and> cop PO2 PO4 PO1 PO3 \<and> cop PO2 PO4 PO3 PO1 \<and> cop PO3 PO1 PO2 PO4 \<and> cop PO3 PO1 PO4 PO2 \<and> cop PO3 PO2 PO1 PO4 \<and> cop PO3 PO2 PO4 PO1 \<and> cop PO3 PO4 PO1 PO2 \<and> cop PO3 PO4 PO2 PO1 \<and> cop PO4 PO1 PO2 PO3 \<and> cop PO4 PO1 PO3 PO2 \<and> cop PO4 PO2 PO1 PO3 \<and> cop PO4 PO2 PO3 PO1 \<and> cop PO4 PO3 PO1 PO2 \<and> cop PO4 PO3 PO2 PO1)"

and
ax_sym_int_l_l: "int_l_l LI1 LI2 \<Longrightarrow> int_l_l LI2 LI1"

and
ax_sym_int_pl_pl: "int_pl_pl PL1 PL2 \<Longrightarrow> int_pl_pl PL2 PL1"

and
ax_sym_ncol1: "not_col PO1 PO2 PO3 \<Longrightarrow> not_col PO2 PO3 PO1"

and
ax_sym_ncol2: "not_col PO1 PO2 PO3 \<Longrightarrow> not_col PO2 PO1 PO3"

and
ax_sym_ncol: "not_col PO1 PO2 PO3 \<Longrightarrow> (not_col PO1 PO3 PO2 \<and> not_col PO2 PO1 PO3 \<and> not_col PO2 PO3 PO1 \<and> not_col PO3 PO1 PO2 \<and> not_col PO3 PO2 PO1)"

and
ax_sym_ncop1: "not_cop PO1 PO2 PO3 PO4 \<Longrightarrow> not_cop PO2 PO3 PO4 PO1"

and
ax_sym_ncop2: "not_cop PO1 PO2 PO3 PO4 \<Longrightarrow> not_cop PO2 PO1 PO3 PO4"

and
ax_sym_ncop: "not_cop PO1 PO2 PO3 PO4 \<Longrightarrow> (not_cop PO1 PO2 PO4 PO3 \<and> not_cop PO1 PO3 PO2 PO4 \<and> not_cop PO1 PO3 PO4 PO2 \<and> not_cop PO1 PO4 PO2 PO3 \<and> not_cop PO1 PO4 PO3 PO2 \<and> not_cop PO2 PO1 PO3 PO4 \<and> not_cop PO2 PO1 PO4 PO3 \<and> not_cop PO2 PO3 PO1 PO4 \<and> not_cop PO2 PO3 PO4 PO1 \<and> not_cop PO2 PO4 PO1 PO3 \<and> not_cop PO2 PO4 PO3 PO1 \<and> not_cop PO3 PO1 PO2 PO4 \<and> not_cop PO3 PO1 PO4 PO2 \<and> not_cop PO3 PO2 PO1 PO4 \<and> not_cop PO3 PO2 PO4 PO1 \<and> not_cop PO3 PO4 PO1 PO2 \<and> not_cop PO3 PO4 PO2 PO1 \<and> not_cop PO4 PO1 PO2 PO3 \<and> not_cop PO4 PO1 PO3 PO2 \<and> not_cop PO4 PO2 PO1 PO3 \<and> not_cop PO4 PO2 PO3 PO1 \<and> not_cop PO4 PO3 PO1 PO2 \<and> not_cop PO4 PO3 PO2 PO1)"

and
ax_sym_nint_l_l: "not_int_l_l LI1 LI2 \<Longrightarrow> not_int_l_l LI2 LI1"

and
ax_sym_nint_pl_pl: "not_int_pl_pl PL1 PL2 \<Longrightarrow> not_int_pl_pl PL2 PL1"

and
ax_branch_bet: "bet PO1 PO2 PO3 \<or> not_bet PO1 PO2 PO3"

and
ax_branch_col: "PO1 ~= PO2 \<and> PO1 ~= PO3 \<and> PO2 ~= PO3 \<Longrightarrow> col PO1 PO2 PO3 \<or> not_col PO1 PO2 PO3"

and
ax_branch_cop: "PO1 ~= PO2 \<and> PO1 ~= PO3 \<and> PO1 ~= PO4 \<and> PO2 ~= PO3 \<and> PO2 ~= PO4 \<and> PO3 ~= PO4 \<Longrightarrow> cop PO1 PO2 PO3 PO4 \<or> not_cop PO1 PO2 PO3 PO4"

and
ax_branch_inc_l_pl: "inc_l_pl LI1 PL2 \<or> not_inc_l_pl LI1 PL2"

and
ax_branch_inc_po_l: "inc_po_l PO1 LI2 \<or> not_inc_po_l PO1 LI2"

and
ax_branch_inc_po_pl: "inc_po_pl PO1 PL2 \<or> not_inc_po_pl PO1 PL2"

and
ax_branch_int_l_l: "LI1 ~= LI2 \<Longrightarrow> int_l_l LI1 LI2 \<or> not_int_l_l LI1 LI2"

and
ax_branch_int_l_pl: "int_l_pl LI1 PL2 \<or> not_int_l_pl LI1 PL2"

and
ax_branch_int_pl_pl: "PL1 ~= PL2 \<Longrightarrow> int_pl_pl PL1 PL2 \<or> not_int_pl_pl PL1 PL2"

and
ax_g1: "PO1 = PO2 \<or> PO1 ~= PO2"

and
ax_g2: "LI1 = LI2 \<or> LI1 ~= LI2"

and
ax_g3: "PL1 = PL2 \<or> PL1 ~= PL2"

and
ax_g4: "inc_po_l PO1 LI2 \<or> not_inc_po_l PO1 LI2"

and
ax_g5: "inc_po_pl PO1 PL2 \<or> not_inc_po_pl PO1 PL2"

and
ax_D10: "int_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> inc_po_pl PO3 PL2 \<and> not_inc_l_pl LI1 PL2)"

and
ax_D11a: "not_inc_l_pl LI1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). inc_po_l PO3 LI1 \<and> not_inc_po_pl PO3 PL2)"

and
ax_D2: "col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (LI4::line). inc_po_l PO1 LI4 \<and> inc_po_l PO2 LI4 \<and> inc_po_l PO3 LI4)"

and
ax_D4: "cop PO1 PO2 PO3 PO4 \<Longrightarrow> ( \<exists>  (PL5::plane). inc_po_pl PO1 PL5 \<and> inc_po_pl PO2 PL5 \<and> inc_po_pl PO3 PL5 \<and> inc_po_pl PO4 PL5)"

and
ax_D6: "int_l_l LI1 LI2 \<Longrightarrow> ( \<exists>  (PO3::point). LI1 ~= LI2 \<and> inc_po_l PO3 LI1 \<and> inc_po_l PO3 LI2)"

and
ax_D8: "int_pl_pl PL1 PL2 \<Longrightarrow> ( \<exists>  (PO3::point). PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2)"

and
ax_I1: "PO1 ~= PO2 \<Longrightarrow> ( \<exists>  (LI3::line). inc_po_l PO1 LI3 \<and> inc_po_l PO2 LI3)"

and
ax_I3a: "( \<exists>  (PO2::point) (PO3::point). PO2 ~= PO3 \<and> inc_po_l PO2 LI1 \<and> inc_po_l PO3 LI1)"

and
ax_I4a: "not_col PO1 PO2 PO3 \<Longrightarrow> ( \<exists>  (PL4::plane). inc_po_pl PO1 PL4 \<and> inc_po_pl PO2 PL4 \<and> inc_po_pl PO3 PL4)"

and
ax_I4b: "( \<exists>  (PO2::point). inc_po_pl PO2 PL1)"

and
ax_I7: "PL1 ~= PL2 \<and> inc_po_pl PO3 PL1 \<and> inc_po_pl PO3 PL2 \<Longrightarrow> ( \<exists>  (PO4::point). PO3 ~= PO4 \<and> inc_po_pl PO4 PL1 \<and> inc_po_pl PO4 PL2)"

and
ax_I3b: "( \<exists>  (PO1::point) (PO2::point) (PO3::point). not_col PO1 PO2 PO3)"

and
ax_I8: "( \<exists>  (PO1::point) (PO2::point) (PO3::point) (PO4::point). not_cop PO1 PO2 PO3 PO4)"


lemma Hilbert:
assumes "PO1 = PO2"
shows " (PO1 = PO2)"
proof -

(* po redu: 1*)

(*BRANCH END THESIS*)
from `PO1 = PO2`
have ?thesis
by auto
from this
show ?thesis
by auto
qed
