#include <iostream>
#include <fstream>
#include <cstring>
#include <time.h>

#include "auto.h"
#include <sys/stat.h>

typedef struct stat Stat;

using namespace std;

int main(int argc, char* argv[])
{
  char name[1000];
  ifstream in;

  if (argc != 4 || argv[1][0] != '-' || argv[2][0] != '-'){
    cout << "Run with: ./make_theorems [-e|-a] [-n|-r] file_with_tptp_formulas" << endl;
    cout << "Option -e will include all theorems and axioms in tptp file!" << endl;
    cout << "Option -a will include only axioms in tptp file!" << endl;
    cout << "Use -n for testing with normal order of axioms." << endl;
    cout << "Use -r for testing with normal and reversed order of axioms." << endl;
    cout << "Creates folders:" << endl;
    cout << "(1) theorems - with tptp files for each individual step of original conjecture, and set of axioms and definitions;" << endl;
    cout << "(2) tptp_axioms - with separate files for each axiom, definition and conjecture that will be proved, in two forms (with goal-name and with original-name)." << endl;
    cout << endl;
    exit(1);
  } 
  
  strcpy(name, argv[3]);
  in.open(name, ifstream::in);
  if (in.fail()){
    cerr << "File: " << name << " is missing!" << endl;
    exit(1);
  }

  /*
  ofstream out_signatura;
  out_signatura.open("signature_tptp.txt", ofstream::out);
  ofstream out_axioms;
  out_axioms.open("axioms_tptp.txt", ofstream::out);
  ofstream out_theorem;
  out_theorem.open("theorem_tptp.txt", ofstream::out);
  vector<string> premise_teoreme;
  */

  Stat st;
  if (stat("theorems", &st) != 0)
    mkdir("theorems", 0700);
  if (stat("tptp_axioms", &st) != 0)
    mkdir("tptp_axioms", 0700);

  parse(argv[1],argv[2], in, argv[3]);
}
