#include <iostream>
#include <fstream>
#include <cstring>
#include <time.h>

#include "tptp.h"
#include <sys/stat.h>

typedef struct stat Stat;

using namespace std;

int main(int argc, char* argv[])
{
  char name[1000];
  ifstream in;

  if (argc != 3){
    cout << "Used with: ";
    for(int i =0; i<argc; i++)
      cout << argv[i] << " ";
    cout << endl;
    cout << "Usage: ./tptp_parse -u/-s name_of_the_tptp_file" << endl;
    cout << "Choose -u if theory is unsorted" << endl;
    cout << "Choose -s if theory is sorted" << endl;
    cout << "Signature file will be: signature_tptp.txt" << endl;
    cout << "Folder with all axioms and theorems in argo format is axioms";
    cout << endl;
    exit(1);
  } 
  
  strcpy(name, argv[2]);
  in.open(name, ifstream::in);
  if (in.fail()){
    cerr << "File: " << name << " is missing!" << endl;
    exit(1);
  }

  ofstream out_signatura;
  out_signatura.open("signature_tptp.txt", ofstream::out);

  Stat st;
  if (stat("axioms", &st)!=0)
    //directory does not exists
    mkdir("axioms", 0700);

  vector<string> premise_teoreme;

  if (strcmp(argv[1], "-u")==0)
    parse_tptp(1, string(name), in, out_signatura); 
  else if (strcmp(argv[1], "-s")==0)
    parse_tptp(0, string(name), in, out_signatura);
  else {
    cout << "Not supported format!" << endl;
    exit(1);
  }
}
