#include <time.h>

#include "opste.h"
#include "Variable.h"
#include "Relation.h"
#include "Expression.h"
#include "Signature.h"

// fja koja radi sa granajucim aksiomama i za unifikator dobijen na premisama
// (na osnovu prve grane za koju je vec provereno da prosiruje bz)
// proverava da li neka od drugih grana vec postoji u bz, cime cela 
// aksioma postaje neprimenljiva i fja vraca u tom slucaju 0
// inace, ako ima smisla primeniti granajucu aks.po svim granama, fja vraca 1
int check_all_branches(vector<vector<Expression*> > &have_st, Unifier &u_fix){
  
  //za negranajuce aksiome vracamo 1
  if (have_st.size() == 1) return 1;

  //za granajuce aksiome proveravamo redom po granama...
  for(int i=1; i<have_st.size(); i++){
    Unifier u(u_fix);
    vector<Expression *> sub_have = have_st[i];
    Expression *first = *(sub_have.begin());
    sub_have.erase(sub_have.begin());
    
    //ako za tekucu granu mozemo da nadjemo unifikaciju za koju 
    //postoje svi objekti u bz onda granajuca aksioma nije 
    //primenljiva pa vracamo 0
    if (first->unify_loop_have(have_st, sub_have, u, u) == TRY_ANOTHER_FROM)
      return 0;

  }
  
  // ako su sve grane primenljive
  return 1;
}


// funkcija koja vraca indeks stringa s u vektoru stringova                    
// ako postoji ili -1 u suprotnom                                              
int position(vector<string> v, string s){                                     
  
  int i;                                                 
  for(i=0; i < v.size(); i++)                         
    // proveravamo da li se nalazi na poziciji i                               
    if (s.compare(v.at(i)) == 0)                                 
      return i;                                                               
                                            
  // ako ga nismo nasli do sad znaci da se ne nalazi u vektoru                 
  return -1;                                          
} 

/* Ulazni fajl se sastoji od niza aksioma.                      
   Svaka aksioma moze biti oblika:                          

   premises                                                   
   (                                                       
   from1                                                    
   |                      
   from 2                                    
   |                 
   ...               
   )                  
   conclusions            
   (   
   have1      
   |     
   have2         
   | 
   ... 
   )  

  Ova funkcija cita iz fajla jedno tvrdjenje (aksiomu ili teoremu) 
  i vraca je kao povratnu vrednost
*/
Statement* pars_axiom(ifstream &in){
  vector<Expression *> from_i;             //jedan disjunkt from_i    
  vector<Expression *> have_i;
  vector<vector<Expression *> > _from, _have;
  string _name;
  char line[500];
  int ind;     // indikator koji ima vrednost 1 ako se nalazimo u premisama 
               // a 0 ako se nalazimo u zakljucku  
  int first;   // indikator da li citamo prvu aksiomu        
  ind = 0;
  first = 1;
  
  while(1){
    // zapamtimo poziciju  
    streampos pos = in.tellg();
    // citamo tekuci red i parsiramo ga   
    in.getline(line, 500);
    if (in.eof())      
      break;

    // ako je prvi karakter % u pitanju je komentar i preskacemo obradu
    if (line[0] == '%')
      continue;

    // citamo ime aksiome (ovo nece postojati za teoreme)
    if (line[0]=='#'){
      // pre navodjenja aksiome ide # ax_p18
      char* p = strchr(line, '#');      
      _name = string(p+1);
      continue;
    }
    // brise praznine iz procitanog reda 
    trim(line);
    // ako je prazan nastavlja dalje  
    if (!strcmp(line, ""))
      continue;
    
    if ((ind == 0) && (!strcmp(line, "premises"))){
      ind = 1;  //usli smo u premise  
      if (first == 1)
        first = 0;
      else {
	
        // treba da vrati poziciju u ulaznom fajlu na prethodni red 
	in.seekg(pos);
        break;
      }
    } else if ((ind == 1) && (!strcmp(line, "conclusions"))){
      ind = 0;  // usli smo u zakljucak                           
    } else if (strcmp(line, "|")){
      Expression * exp = pars_line(line);
      
      if (ind == 1)
        from_i.push_back(exp);
      else if (ind == 0)
        have_i.push_back(exp);
    } else {
      //procitali smo '|' 
      if (ind == 1){
        _from.push_back(from_i);
        from_i.erase(from_i.begin(), from_i.end());
      } else {
        _have.push_back(have_i);
        have_i.erase(have_i.begin(), have_i.end());
      }
    }
  }
  // ubacujemo poslednju aksiomu                 
  _from.push_back(from_i);
  _have.push_back(have_i);

  if (_name.empty())
    _name = "undefined_name";
  
  // formiramo tvrdjenje
  Statement *s = new Statement(_from, _have, _name);
  // poziv funkcije koja odredjuje i postavlja tip aksiome
  s->set_type();   
  s->set_flags();
  
  return s;
}

// funkcija koja iz fajla sa aksiomama cita sve aksiome i vraca ih kao 
// vector statement-a
vector<Statement*> pars_axioms(ifstream &in){
  vector<Statement*> v;

  while(1){
    // citamo aksiomu po aksiomu
    v.push_back(pars_axiom(in));
    if (in.eof())
      break;
  }
  
  return v;
}

// funkcija koja parsira jednu liniju fajla i kreira odgovarajuci izraz 
// (promenljivu ili relaciju)
Expression* pars_line(char* line){
  int flag;
  vector<int> argv;
  char* s, rel_name[100];
  Expression* p;

  flag = 0;
  s = strtok(line, "(");
  while (s != NULL){
    if (flag == 0){
      // ako je prvi karakter ~ u rel_name smesta n pa ime relacije
      // inace samo ime relacije
      //if (s[0] == '~')
      //s[0] = 'n';
      strcpy(rel_name, s);
      flag = 1;
    }
    else
      // citanje "stvarnih" argumenata (iz aksiome ili teoreme)
      argv.push_back(atoi(s));
    s = strtok(NULL, ",)");
  }
 
  p = num_rel(rel_name,argv);
  return p;
}

// funkcija koja brise beline iz stringa
void trim(char* s){
  int i,j;
  char t[50];

  // kopiramo sve osim belina
  for(i=0, j=0; s[i]; i++)
    if (s[i] != ' ' && s[i] != '\t' && s[i] != '\n'){
      t[j] = s[i];
      j++;
    }
  t[j] = '\0';
  strcpy(s, t);
}

// fja koja vraca izraz na osnovu datog f-jskog simbola i vektora argumenata
Expression*  num_rel(char *rel, vector<int> &argv){

  Signature *sig = Signature::instance();
  // ako je rel string koji se nalazi u Signature._types 
  // onda je u pitanju promenljiva, inace je u pitanju relacija
  string rel_s(rel);
  vector<string> types = sig->get_types();
  vector<string> relations = sig->get_relations();

  int p =  position(types, rel_s);
  if (p >= 0)
    {
      // onda smo nasli promenljivu i treba da je napravimo                 
      return new Variable(p, argv);
    }
  else {
    // nasli smo relaciju i kreiramo je  
    p = position(relations, rel_s);
    return new Relation(p, argv);
  }
}


// fja koja vraca razliku dva vremena
double diffclock(clock_t clock1, clock_t clock2){

  double diffticks=clock1-clock2;
  double diffms=diffticks/CLOCKS_PER_SEC;
  return diffms;


}

// metod koji u vektor sym smesta simetricne relacije iz vektora have 
// koje nisu sortirane
void extract_symetric(vector<Expression *> have, Unifier u,
		      vector<Expression *>& sym){

  Relation *r = new Relation();

  for (int i=0; i<have.size();i++)
    if ((r = dynamic_cast<Relation*>(have[i]))!=NULL)
      if ((r->symmetric())){
	Expression *e = r->make_unified_expression(u);
	Relation *er = dynamic_cast<Relation*>(e);
	if (!((*er)==(*(er->sort_arguments())))){
	  sym.push_back(e);
	}
      }
  

}


// metod koji u vektor sym smesta simetricne relacije iz vektora have 
// koje nisu sortirane
void extract_uncanonical(vector<Expression *> have, Unifier u,
			 vector<Expression *>& uncan){

  Relation *r, *rs;
  Expression *erc;

  for (int i=0; i<have.size();i++)
    if ((r = dynamic_cast<Relation*>(have[i]))!=NULL){
      Expression *e = r->make_unified_expression(u);
      Relation *er = dynamic_cast<Relation*>(e);
      rs=er->sort_arguments();
      erc=er->canonical_representative();
      Relation *rc = dynamic_cast<Relation*>(erc);
      if (!((*rs)==*(rc)))
	uncan.push_back(rs);
    }
   
}

vector<int> pars_conf(ifstream &in){

  string opcija;
  int podrzano;
  vector<int> flag(8); 
  //vektor inicijalizovan za 6 nula:
  //equality                                   
  //excluded_middle                            
  //branching_only_primitive                   
  //superproductive_last                       
  //axioms_consisting_theorem_relations        
  //axioms_consisting_theorem_relations_only   
  //nonproductive_non_sentinel
  //ax_ex_middle_non_sentinel

  while(1){
    in >> opcija >> podrzano;

    if (podrzano){
      int p = pozicija(opcija);
      flag[p] = podrzano;   //tj. 1
    }
    if (in.eof())
      break;
  }

  return flag;
}

int pozicija(string s){

  if (!s.compare("equality")) return 0;                                   
  if (!s.compare("excluded_middle")) return 1;                            
  if (!s.compare("branching_only_primitive")) return 2;                   
  if (!s.compare("superproductive_last")) return 3;                      
  if (!s.compare("axioms_consisting_theorem_relations")) return 4;        
  if (!s.compare("axioms_consisting_theorem_relations_only")) return 5;
  if (!s.compare("nonproductive_non_sentinel")) return 6;
  if (!s.compare("ax_ex_mid_non_sentinel")) return 7;
 
}

int same_prefix(string a, string b){

  for(int i=0; i<a.size() && i<b.size(); i++){
    if (a[i]=='_') break;
    if (a[i]!=b[i]) return 0;
  }

  return 1;

}

string nl_name(int type, int value){

  Signature *sig = Signature::instance();
  string var;

  /*

  int broj_tacaka = 'Z'-'A'+1;

  vector<char> prave;
  prave.push_back('p');
  prave.push_back('q');
  prave.push_back('r');
  prave.push_back('s');
  prave.push_back('t');
  prave.push_back('u');
  prave.push_back('v');
  prave.push_back('w');
  int broj_pravih = prave.size();

  vector<string> ravni;
  ravni.push_back("\\alpha");
  ravni.push_back("\\beta");
  ravni.push_back("\\gamma");
  int broj_ravni = ravni.size();

  */

  vector<char> prave = sig->get_prave();
  int broj_pravih = prave.size();

  vector<string> ravni = sig->get_ravni();
  int broj_ravni = ravni.size();

  int broj_tacaka = sig->get_broj_tacaka();

  int ostatak;
  int kolicnik;
  char ime[10];



  value = value - 1;

  if (sig->get_types(type)=="point"){
    ostatak = value % broj_tacaka;
    kolicnik = value / broj_tacaka;

    char slovo = 'A' + ostatak;
    
    ime[0] = slovo;
    if (kolicnik){
      ime[1] = kolicnik + '0';
      var = string(ime,2);
    }
    else
      var = string(ime,1);
  }
  else if (sig->get_types(type)=="line"){
    ostatak = value % broj_pravih;
    kolicnik = value / broj_pravih;
    
    char slovo = prave[ostatak];
    
    ime[0] = slovo;
    if (kolicnik){
      ime[1] = kolicnik + '0';
      var = string(ime,2);
    }
    else
      var = string(ime,1);
    
  }
  else if(sig->get_types(type)=="plane"){
    ostatak = value % broj_ravni;
    kolicnik = value / broj_ravni;
    
    string slovo = ravni[ostatak];

    //strcpy(ime,slovo);
  
    if (kolicnik){
      //ime[strlen(ime)] = kolicnik + '0';
      char im[3];
      im[0] = kolicnik+'0';
      string broj(im,1);
      //var = string(ime,strlen(ime));
      var = string(slovo);
      var.append(broj);   
    }
    else {
      //var = string(ime,strlen(ime));
      var = string(slovo);
    }


  } 
  
  // inace vracamo standardnu formu
  else{

    var = sig->get_type_id(type);
    var += value;
  }
  return var;
}

string zameni_podvlake(string s){

  int i;
  string novi;
  for(i=0; i<s.size(); i++){
    if (s[i] != '_')
      novi.push_back(s[i]);
    else{
      novi.append("\\_");
    }
  }
  return novi;
}

int nalazi_se(Expression* e, vector<vector<Expression*> > v){

  int i, j;
  for(i=0; i<v.size(); i++)
    for(j=0; j<v[i].size(); j++)
      //ako smo nasli element vracamo 1
      if (*v[i][j] == *e)
	return 1;

  return 0;
}

int isti(vector<vector<Expression *> > a, vector<vector<Expression *> > b){

  /*
  int i, j;
  for(i=0; i<a.size();i++)
    for(j=0;j<a[i].size();j++){
      //ako se neki element prvog vektora ne nalazi u drugom vektoru vrati 0
      if (!nalazi_se(a[i][j], b))
	return 0;
    }
    return 1;*/

  int i,j;

  if (a.size()!=b.size())
    return 0;

  for(i=0;i<a.size();i++){
    if(a[i].size()!=b[i].size())
      return 0;

    for(j=0; j<a[i].size();j++)
      if(!(*a[i][j] == *b[i][j]))
	return 0;
  }
  return 1;
}


int isti1(vector<Expression *> a, vector<Expression *> b){

  int i,j;

  if (a.size()!=b.size())
    return 0;

  for(i=0;i<a.size();i++){
    if(!(*a[i] == *b[i]))
      return 0;
  }
  return 1;
}

int isti_rel_simbol(Expression *e1, Expression *e2){

  string f_e1, f_e2, f_e1_neg;

  f_e1 = e1->get_f_name();
  f_e2 = e2->get_f_name();
  f_e1_neg = Signature::instance()->get_oposite_name(f_e1);

  if ((f_e2.compare(f_e1)==0)||(f_e2.compare(f_e1_neg)==0))
    return 1;
  else 
    return 0;
}
