#ifndef _OPSTE_H_
#define _OPSTE_H_

#include <vector>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstring>

#include "Expression.h"
#include "Statement.h"

using namespace std;
using namespace __gnu_cxx;

extern ostream& operator<<(ostream & ostr, Statement &e);
extern ostream& operator<<(ostream & ostr, Expression &e);

/* proverava da li su za dati unifikator sve ostale grane 
   granajuce aksiome zadovoljene ili ne - ovo bi znacilo da je
   granajuca aksioma u celosti primenljiva
*/
int check_all_branches(vector<vector<Expression*> >&, Unifier&);

// sablonska funkcija koja stampa vektor proizvoljnog tipa
template <class myType>
ostream& printvector (vector<myType> &v, ostream &ostr){
  int i;                             
  for(i=0; i < v.size(); i++)                           
    ostr << v.at(i) << endl;                           
  ostr << endl;                                            
  return ostr;
}

// funkcija koja vraca poziciju datog stringa u datom vektoru stringova
int position(vector<string> v, string s);

// funkcija koja iz datog ulaznog fajla cita jednu aksiomu
Statement* pars_axiom(ifstream &in);

// funkcija koja iz datog ulaznog fajla cita skup aksioma
vector<Statement*> pars_axioms(ifstream &in);

// funkcija koja cita flagove
vector<int> pars_conf(ifstream &in);

int pozicija(string);

// funkcija koja formira izraz na osnovu procitanog reda
Expression* pars_line(char* line);

// funkcija koja brise beline
void trim(char* s);

// funkcija koja na osnovu funkcijskog simbola i vektora argumenata
// kreira odgovarajuci izraz
Expression* num_rel(char *rel, vector<int> &argv);

// fja koja vraca razliku dva vremena                                        
double diffclock(clock_t clock1, clock_t clock2);

// metod koji u vektor sym smesta simetricne relacije iz vektora have         
void extract_symetric(vector<Expression *> have, Unifier u, vector<Expression *>& sym);


void extract_uncanonical(vector<Expression *> have, Unifier u, vector<Expression *>& sym);

int same_prefix(string, string);

string nl_name(int type, int value);

string zameni_podvlake(string);

int isti(vector<vector<Expression *> > , vector<vector<Expression *> > );

int isti1(vector<Expression *> , vector<Expression *> );

int nalazi_se(Expression*, vector<vector<Expression *> >);

int isti_rel_simbol(Expression*, Expression*);

#endif
