#include "tptp.h"
using namespace std;

int parse_tptp(int unsorted, string name, ifstream &in, ofstream &sout){
  
  char line[50000];
  char ime_aksiome[1000];

  char ime_fajla[1000];
  char ime_rev_fajla[1000];

  char ime_fajla_axioms[1000];
  char ime_rev_fajla_axioms[1000];

  ofstream aout;
  
  vector<string> relations;
  vector<int> arities;
 
  vector<vector<string> > signatura;
 
  while(1){
    in.getline(line, 50000);
    if (in.eof())
      break;

    //prvo brisemo praznine iz reda (za slucaj da se % ne nalazi na pocetku)  
    trim(line);
    
    //preskacemo redove koji pocinju sa %
    //ostali su neobradjeni viselinijski komentari (od /* do */)
    if (line[0] == '%')
      continue;

    if (strlen(line) == 1 || !strcmp(line, ""))
      continue;
    
    //preskacemo aksiome koje imaju false, njih obradjujemo na drugi nacin
    //if (strstr(line, "false"))
    //  continue;

    //cout << "citamo: " << line << endl;

    int ulaz;

    //vadimo ime aksiome, ono se nalazi izmedju "(" i prvog ","
    char* zagrada = strchr(line, '(');
    char* prvi_zarez = strchr(line, ',');
    int duzina_imena = prvi_zarez-zagrada-1;
    //ono izmedju je ime aksiome
    strncpy(ime_aksiome, zagrada+1, duzina_imena);
    ime_aksiome[duzina_imena] = '\0'; 
    
    //cout << "ime: " << ime_aksiome << endl;

    strcpy(ime_fajla, "axioms/");
    strcat(ime_fajla, ime_aksiome);
    strcat(ime_fajla, ".txt");
    aout.open(ime_fajla, ofstream::out);

    strcpy(ime_rev_fajla, "axioms/");
    strcat(ime_rev_fajla, ime_aksiome);
    strcat(ime_rev_fajla, "_reversed.txt");

    //pravimo imena za _axioms fajlove
    strcpy(ime_fajla_axioms, "axioms/");
    strcat(ime_fajla_axioms, ime_aksiome);
    strcat(ime_fajla_axioms, "_axioms.txt");

    strcpy(ime_rev_fajla_axioms, "axioms/");
    strcat(ime_rev_fajla_axioms, ime_aksiome);
    strcat(ime_rev_fajla_axioms, "_axioms");
    strcat(ime_rev_fajla_axioms, "_reversed.txt");

    //trazimo drugo pojavljivanje zareza, tj pocetak formule
    char *p, *q;
    char ime[100];
    p = strchr(line, ',');
    p = strchr(p+1, ',');      
    
    char *r;
    r = p;
    int arnost;
    
    char kopija[50000];
    strcpy(kopija, p);

    //cout << "p = " << p << endl;
    //cout << "kopija = " << kopija << endl;
    
    vector<string> premise_varijable;
    
    if (!extract_axiom(unsorted, kopija, ime_aksiome, aout)){
      cerr << "Axiom is not in the coherent logic format!";
      cerr << endl << line << endl;      
    }
    
    aout.close();

    //ako smo procitali teoremu pravimo th2_1_reversed.txt
    if (strstr(ime_aksiome, "th")){
      char naredba[10000]; 
      strcpy(naredba, "cp ");
      strcat(naredba, ime_fajla);
      strcat(naredba, " ");
      strcat(naredba, ime_rev_fajla);

      //cout << "naredba: " << naredba << endl;
      if (system(naredba) == -1){
	cerr << "Command: " << naredba << " failed!" << endl;
      }

      //pravimo th_2_1_axioms.txt
      char naredba_axioms[10000];
      strcpy(naredba_axioms, "cp ");
      strcat(naredba_axioms, ime_fajla);
      strcat(naredba_axioms, " ");
      strcat(naredba_axioms, ime_fajla_axioms);

      //cout << "naredba: " << naredba_axioms << endl;
      if (system(naredba_axioms) == -1)	{
	cerr << "Command: " << naredba_axioms << " failed!" << endl;
      }

      //pravimo th_2_1_axioms_reversed.txt
      strcpy(naredba_axioms, "cp ");
      strcat(naredba_axioms, ime_fajla);
      strcat(naredba_axioms, " ");
      strcat(naredba_axioms, ime_rev_fajla_axioms);

      //cout << "naredba: " << naredba_axioms << endl;
      if (system(naredba_axioms) == -1)	{
	cerr << "Command: " << naredba_axioms << " failed!" << endl;
      }

    }
  }
    
}

int next_relation(char** p, char *ime, int *i){
  char *q;

  //TRAZIMO POCETAK RELACIJSKOG SIMBOLA
  //pomeramo se udesno dok ne nadjemo slovo
  while ((*p[0])!='\0'){

    if (isalpha((*p)[0]))
      break;
    // ako procitamo promenljive citamo ih do kraja
    else if ((*p)[0]=='['){
      *p = strchr(*p,']');
      if (*p==NULL){
	cerr << "Error in the format: " << *p <<  endl;
	cerr << "funkcion next_relation " << endl;
	return 0;
      }
      continue;
    }
    
    // napredujemo 
    (*p)++;
  }
  
  if ((*p)[0]=='\0')
    return 0;

  //ODREDJUJEMO CELO IME
  //sad je p na pocetku imena relacijskog simbola
  //i trazimo kraj imena tako sto trazimo sledecu zagradu
  q = strchr(*p, '(');
  //kada se nakon relacijskog simbola ne nalaze argumeti, vraca 0, 
  //npr goal
  if (q==NULL)
    return 0;
  strncpy(ime, *p, q-*p);
  ime[q-*p] = '\0';

  //ODREDJUJEMO ARNOST RELACIJSKOG SIMBOLA
  //tako sto brojimo koliko ima zareza do ')'
  for(*i=0; *p[0]!=')'; (*p)++){
    if (*p[0]==',')
      (*i)++;
  }

  (*i)++;
  
   return 1;
}

int extract_axiom(int unsorted, char *line, char* ime_aksiome, ofstream& aout){

  //cout << "extract_axiom" << endl << endl;
  //cout << "obradjujemo: " << endl << line << endl;

  char *p;

  vector<string> branch_varijable, branch_relacije;

  //uvodimo dva vektora koji ce cuvati tip varijable i njeno ime
  //ne vade se iz dela [...] vec iz dela sa relacijama
  //moze se proveriti da li se nalaze i u [...] za slucaj greske
  vector<string> variable_type; 
  vector<string> variable_name;
	
  //sana: odredjujemo premise cele aksiome
  //ODREDJUJEMO VARIJABLE IZ PREMISE AKSIOME
  char premise[10000];
  char zakljucci[10000];

  char *pokazivac_poz_strelice = strstr(line, "=>");

  //ako aksioma ima relacije u premisama, imace strelicu

  if(pokazivac_poz_strelice!=NULL){
  //  if (poz_strelice != strlen(line)){


    int poz_strelice = strstr(line, "=>")-line;

    //cout << "AKSIOMA SA =>" << endl;
    //cout << "ZNACI IMA RELACIJE I U PREMISAMA I U ZAKLJUCCIMA" << endl;

    strncpy(premise, line, poz_strelice);
    premise[poz_strelice] = '\0';
    strcpy(zakljucci, line+poz_strelice+1);
    
    //cout << "PREMISE: " << premise << endl;
    //cout << "ZAKLJUCCI: " << zakljucci << endl;
    
    aout << "premises" << endl;
    aout << "#" << ime_aksiome << endl << endl;
    
    
    //provera da li se u premisama nalazi |, ako se nalazi greska, 
    //ne podrzavamo grananje u premisama
    if (strcspn(premise, "|")!=strlen(premise)){
      cerr << "We don't support branching in premises" << endl;
      return 0;
    } 
    
    //poziv funkcije obradi negranajucu moze da se primeni i na premise 
    //aksiome
    string premise_string = string(premise);
    vector<string> premise_varijable;
    vector<string> premise_relacije;

    //cout << "pre_obradi_negranajucu" << endl;
    obradi_negranajucu(unsorted, variable_type, variable_name, premise_string, premise_varijable, premise_relacije);
    //cout << "posle_obradi_negranajucu" << endl;

    //ispis varijabli i ispis relacija
    print_vectors(unsorted, premise_varijable, premise_relacije, aout, string(line));

    //cout << "ZAKLJUCCI" << endl;
    aout << "conclusions" << endl << endl;

    //prvo formiramo vektor stringova u kojima se nalaze grane
    vector<string> branches;

    char veznik_or[] = "|";
    char zakljucci1[10000];
    strcpy(zakljucci1, zakljucci);
    branches = extract_relations(unsorted, variable_type, variable_name, zakljucci1, veznik_or);

    /*
    cout << "zakljucci: " << zakljucci1 << endl;
    cout << "vektor branches: " << endl;
    for(int k=0; k<branches.size(); k++)
      cout << branches[k] << endl;
    cout << endl << endl;
    */

    if (branches.size() == 1){
      //cout << "AKSIOMA NIJE GRANAJUCA" << endl;
      //cout << branches[0] << endl;

      int productive_axiom;
      productive_axiom = obradi_negranajucu(unsorted, variable_type, 
					    variable_name, branches[0], 
					    branch_varijable, branch_relacije);

      print_spojene_vektore(unsorted, premise_varijable, branch_varijable, 
			    branch_relacije, aout, string(line));
    }
    else {
      //cout << "granajuca aksioma" << endl;

      int productive_axiom = 0;

      for(int i = 0; i<branches.size(); i++){
	if (i) 
	  aout << "|" << endl;	

	int productive_branch;
	//ako je bar jedna grana produktivna onda je cela aksioma 
	//produktivna
	productive_branch = obradi_negranajucu(unsorted, variable_type, 
					       variable_name, branches[i], 
					       branch_varijable, 
					       branch_relacije);
	productive_axiom += productive_branch;	


	print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
			      branch_relacije, aout, string(line));

	//spoj_vektore(premise_varijable, branch_varijable);
	//print_vectors(premise_varijable, branch_relacije, aout);
	//vector<string> relation_specifics = 
	// extract_relation_specifics(branches[i]);
	//for(int j=0; j<relation_specifics.size(); j++)
	//aout << relation_specifics[j] << " ";
	//aout << endl;

      }
      aout << endl;
    
    }
  }

  //AKSIOMA KOJA NEMA STRELICU
  //I DALJE MOZE A NE MORA DA IMA VARIJABLE U PREMISAMA    
  else {
    //cout << "AKSIOMA KOJA NEMA STRELICU" << endl;
    //cout << "MOZE IMATI VARIJABLE I U PREMISAMA I U ZAKLJUCCIMA" << endl;
    

    //ako ima ! onda promenljive idu sa leve strane, u premise
    //ako ima ? onda promenljive idu sa desne strane, u zakljucke i premise
    //su prazne u tom slucaju 
    
    aout << "premises" << endl;
    aout << "#" << ime_aksiome << endl << endl;
        
    //proveravamo da li ima univerzalno kvantifikovane promenljive, 
    //ako ima one idu u premise

    //proveravamo da li postoji ! ali ne kao deo !=
    char *puz = strchr(line, '!');

    //ako postoje univerzalno kvantifikovane
    if (puz!=NULL && line[puz-line+1] != '='){    

      //cout <<"IMA ! U AKSIOMI" << endl;

      int kraj_premisa = strcspn(line, ":");
      strncpy(premise, line, kraj_premisa+1);
      premise[kraj_premisa+1] = '\0';
      strcpy(zakljucci, line+kraj_premisa+1);

      //cout << "premise: " << premise << endl;
      //cout << "zakljucci: " << zakljucci << endl;
    } else {
      //cout << "NEMA ! U AKSIOMI, SAMO ?" << endl;

      //nema varijabli u premisama, sve je zakljucak
      //premise ostaju prazne
      strcpy(premise, "");
      strcpy(zakljucci, line);
    }
    

    //ako ima ? onda je sve zakljucak
    //NIJE!!!, ONO SA ! IDE U PREMISE
    char* upitnik = strchr(line, '?');
    if (upitnik!=NULL){

      //cout << "IMA ?" << endl;
      /*
      //ovde bi sad morao da bude uzvicnik
      //ako ga nema greska
      char* uzvicnik = strchr(line, '!');
      if (uzvicnik==NULL){
	cout << "greska u unosu" << endl;
	cout << line << endl;
      }
      */
      vector<string> premise_varijable;
      vector<string> premise_relacije;

	
      //poziv funkcije obradi negranajucu moze da se primeni i na premise 
      //aksiome
      string premise_string = string(premise);

      obradi_negranajucu(unsorted, variable_type, variable_name, 
			 premise_string, 
			 premise_varijable, premise_relacije);
      
      //ispis varijabli i ispis relacija
      print_vectors(unsorted, premise_varijable, premise_relacije, aout, string(line));
      	
      aout << "conclusions" << endl << endl;
      
      //prvo formiramo vektor stringova u kojima se nalaze grane
      vector<string> branches;
      char veznik_or[] = "|";
      char zakljucci1[1000];
      strcpy(zakljucci1, zakljucci);
      
      branches = extract_relations(unsorted, variable_type, variable_name, 
				   zakljucci1, veznik_or);


      if (branches.size() == 1){
	//cout << "AKSIOMA NIJE GRANAJUCA" << endl;
	//cout << branches[0] << endl;
	
	vector<string> branch_varijable, branch_relacije;

	int productive_axiom;
	productive_axiom = obradi_negranajucu(unsorted, variable_type, 
					      variable_name, branches[0], 
					      branch_varijable, 
					      branch_relacije);

	//fja koja stampa promenljive iz branch_varijable koje se ne nalaze 
	//u premise_varijable ali sa rednim brojem spojenog vektora
	//pa onda branch_relacije sa tim spojenim vektorom
	print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
			      branch_relacije, aout, string(line));
      }
      else {
	//cout << "AKSIOMA JE GRANAJUCA" << endl;
	
	for(int i = 0; i<branches.size(); i++){
	  //cout << endl << "tekuca grana: ";
	  //cout << branches[i] << endl;
	  
	  if (i) 
	    aout << "|" << endl;	
	  
	  int productive_branch;
	  //ako je bar jedna grana produktivna onda je cela aksioma 
	  //produktivna
	  productive_branch = obradi_negranajucu(unsorted, variable_type, 
						 variable_name, 
						 branches[i], 
						 branch_varijable,
						 branch_relacije);
	  print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
				branch_relacije, aout, string(line));
	  
	}
	aout << endl;


      }
    }

    else {
      //cout << "NEMA => I NEMA ? ZNACI IMAMO OBICNU AKSIOMU KOJA IZGLEDA NE";
      //cout << " RADI DOBRO ZA GRANAJUCE AKSIOME" << endl;     

       //ovde bi sad morao da bude uzvicnik
      //ako ga nema greska
      char* uzvicnik = strchr(line, '!');
      if (uzvicnik==NULL){
      	cerr << "Error in the format: ! is missing in the line: " << endl;
	cerr << line << endl;
      }
	//poziv funkcije obradi negranajucu moze da se primeni i na premise 
	//aksiome
	string premise_string = string(premise);
	vector<string> premise_varijable;
	vector<string> premise_relacije;
	
	obradi_negranajucu(unsorted, variable_type, variable_name, 
			   premise_string, 
			   premise_varijable, premise_relacije);

	//ispis varijabli i ispis relacija
	print_vectors(unsorted, premise_varijable, premise_relacije, aout, string(line));
	
	
      //provera da li se u premisama nalazi |, ako se nalazi greska, 
      //ne podrzavamo grananje u premisama
	if (strcspn(premise, "|")!=strlen(premise)){
	  cerr << "We don't support branching in premises" << endl;
	  return 0;
	} 
 	
	aout << "conclusions" << endl << endl;

	//prvo formiramo vektor stringova u kojima se nalaze grane
	vector<string> branches;

	char veznik_or[] = "|";
	char zakljucci1[1000];
	strcpy(zakljucci1, zakljucci);
	branches = extract_relations(unsorted, variable_type, variable_name, 
				     zakljucci1, veznik_or);

	if (branches.size()==1){
	  //cout << "aksioma nije granajuca" << endl;
	  //cout << branches[0] << endl;
	  int productive_axiom;
	  productive_axiom = obradi_negranajucu(unsorted, variable_type, 
						variable_name, branches[0], 
						branch_varijable,
						branch_relacije);
	  print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
				branch_relacije, aout, string(line));

	  //spoj_vektore(premise_varijable, branch_varijable);
	  //print_vectors(unsorted, premise_varijable, branch_relacije, aout);
	}
	else {
	  //cout << "aksioma je granajuca: " << endl;
	  int productive_axiom = 0;
	  for(int i=0; i<branches.size(); i++){
	    if (i)
	      aout << "|" << endl;
	    int productive_branch = obradi_negranajucu(unsorted, 
						       variable_type, 
						       variable_name, 
						       branches[i],
						       branch_varijable,
						       branch_relacije);
	    productive_axiom += productive_branch;
	    print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
				  branch_relacije, aout, string(line));
	    //print_vectors(unsorted, branch_varijable, branch_relacije, aout);
	  }
	}

	//}
      

    }
    
  }
  
  
  return 1;
  
  
}

int extract_premises(int unsorted, vector<string> &variable_type,
		     vector<string> &variable_name,
		     string name, char *line, ofstream& tout,
		     vector<string> &premise_varijable){

  //cout << endl << endl << "obradjujemo: " << endl << line << endl;

  char *p;

  vector<string> branch_varijable, branch_relacije;
	
  //sana: odredjujemo premise cele aksiome
  //ODREDJUJEMO VARIJABLE IZ PREMISE AKSIOME

  char premise[1000];
  char zakljucci[1000];

  strcpy(premise, line);
  
  tout << "premises" << endl;

  //iz name skinemo .p sa kraja
  size_t poz = name.find(".p");
  string ime;
  
  if (poz != string::npos)
    ime.assign(name, 0, (int)poz);
  else 
    ime = name;
  tout << "#" << ime << endl << endl;
  
  //izvaditi promenljive i za svaku napisati point(promenljiva)

  //provera da li se u premisama nalazi |, ako se nalazi greska, 
  //ne podrzavamo grananje u premisama
  if (strcspn(premise, "|")!=strlen(premise)){
    cerr << "We don't support branching in premises" << endl;
    return 0;
  } 
  
  //poziv funkcije obradi negranajucu moze da se primeni i na premise 
  //aksiome
  string premise_string = string(premise);
  //vector<string> premise_varijable;
  vector<string> premise_relacije;
  
  obradi_negranajucu(unsorted, variable_type, variable_name, premise_string, 
		     premise_varijable, premise_relacije);
  
  //ispis varijabli i ispis relacija
  print_vectors(unsorted, premise_varijable, premise_relacije, tout, string(line));
  
}

int extract_conclusions(int unsorted, vector<string> &variable_type,
			vector<string> &variable_name, 
			char* line, ofstream &tout, 
			vector<string> premise_varijable){


  vector<string> branch_varijable, branch_relacije;
  char zakljucci[1000];
  int poz_strelice = strcspn(line, "=");
  if (poz_strelice == strlen(line)){
    cerr << "Error in the format of the conclusion of a theorem" << endl;
  }
  else {
    //relacije iz zakljucka se sada nalaze pre strelice
    strncpy(zakljucci, line, poz_strelice);
	
    tout << "conclusions" << endl << endl;

    //cout << "ZAKLJUCCI TEOREME" << endl;

    //prvo formiramo vektor stringova u kojima se nalaze grane
    vector<string> branches;

    char veznik_or[] = "|";
    char zakljucci1[1000];
    strcpy(zakljucci1, zakljucci);
    
    branches = extract_relations(unsorted, variable_type, variable_name, 
				 zakljucci1, veznik_or);

    if (branches.size() == 1){
      //cout << "AKSIOMA NIJE GRANAJUCA" << endl;
      //cout << branches[0] << endl;

      int productive_axiom;
      productive_axiom = obradi_negranajucu(unsorted, variable_type, 
					    variable_name, branches[0], 
					    branch_varijable, 
					    branch_relacije);

      print_spojene_vektore(unsorted,premise_varijable, branch_varijable, 
			    branch_relacije, tout, string(line));

      //spoj_vektore(premise_varijable, branch_varijable);
      //print_vectors(unsorted, premise_varijable, branch_relacije, tout);

    }
    else {
      //cout << "AKSIOMA JE GRANAJUCA" << endl;

      //cout << "grane: " << endl;
      //for(int i = 0; i<branches.size(); i++)
      //cout << branches[i] << endl;    
      //cout << endl;

      int productive_axiom = 0;

      for(int i = 0; i<branches.size(); i++){
	//cout << endl << "tekuca grana: ";
	//cout << branches[i] << endl;

	if (i) 
	  tout << "|" << endl;	

	int productive_branch;
	//ako je bar jedna grana produktivna onda je cela aksioma 
	//produktivna
	productive_branch = obradi_negranajucu(unsorted, variable_type,
					       variable_name, branches[i], 
					       branch_varijable, 
					       branch_relacije);
	productive_axiom += productive_branch;	


	print_vectors(unsorted, branch_varijable, branch_relacije, tout, string(line));
      }
      tout << endl;
    
    }
  }
}

vector<string> extract_variables(char* p){
 
  vector<string> v;
  char p1[1000];
  strcpy(p1,p);

  char *r;
  r = strtok(p1, "[");
  r = strtok(NULL, ",] ");

  while (r!=NULL){
    v.push_back(r);
    r = strtok(NULL, "[,] ");
  }
  
  return v;
}

//i ovo radi preko char*, promeni na stringove
vector<string> extract_variables_string(string p){

  vector<string> v;
  char p1[1000];
  strcpy(p1,p.c_str());

  char *r;
  r = strtok(p1, "[");
  r = strtok(NULL, ",] ");

  while (r!=NULL){
    v.push_back(r);
    r = strtok(NULL, "[,] ");
  }
  
  return v;
}

//izvadi stringove razdvojene znakom c
//vector<string> extract_relations(int unsorted, char* p, char* c){
vector<string> extract_relations(int unsorted, vector<string> &variable_type,
				 vector<string> &variable_name,
				 char* p, char* c){
 
  //cout << "extract_relations za p = " << p << " c = " << c << endl << endl;

  vector<string> v;
  char p1[10000];
  strcpy(p1,p);

  char *r;
  r = strtok(p1, c);

  while (r!=NULL){
    //cout << "izvadili: r = " << r << endl;

    //ovo se poziva samo kada idemo do samih relacija, tj.
    //ako je c = | onda nista, samo ako je &
    if (!strcmp(c, "&"))
      r = transform_equalities(unsorted, r, variable_type, variable_name);

    v.push_back(r);
    r = strtok(NULL, c);
  }
  
  return v;
}

//ako s sadrzi = ili != pravimo izraz eq_points(_,_) ili ~eq_points(_,_)
char * transform_equalities(int unsorted, char *s, 
			    vector<string> &variable_type,
			    vector<string> &variable_name){

  //cout << "trasform_equalities za: " << s << endl;

  char* poz = strstr(s, "=");
  char* pozneg;
  char* nova = (char*)malloc(100);
  char prva[500];
  char druga[500];
  int negacija;
  
  string s1(s);

  vector<string> current_relation;
  string current_type, current_name;
  int i;
  int poz_prva, poz_druga;

  if (poz == NULL){ 
    
    size_t pos = 0;
    size_t newpos;

    //brisemo zagrade i : sa pocetka stringa
    while((s1.find_first_of(">:(),", pos) == pos))
      pos++;

    //izdvajamo ime relacije i argumente
    while((newpos = s1.find_first_of("(),", pos)) != string::npos) {
      if (newpos!=pos)
	current_relation.push_back(s1.substr(pos, newpos-pos));
      pos = newpos+1;
    }

    //ako je izvadio line L1, znaci da je duzina 2
    if (current_relation.size() == 2){
      current_type = current_relation[0];
      current_name = current_relation[1]; 

      //cout << "Nadjeno: " << current_type << " " << current_name << endl;

      //ako se current_name ne nalazi u vektoru variable_name dodajemo ga
      for(i=0; i<variable_name.size(); i++)
	if (variable_name[i] == current_name)
	  break;

      //ako nije nasao dodajemo ga
      if (i == variable_name.size()){
	//cout << "DODAJEMO: " << current_type << " " << current_name << endl;
	
	variable_name.push_back(current_name);
	variable_type.push_back(current_type);
      } else {
	//ako je nasao... ne bi trebalo da se desi ali proveravamo svakako
	if (variable_type[i] != current_type){
	  cerr << "There is an error in the format: " << endl;
	  cerr << "Variable " << current_name;
	  cerr << " has two different types assined: " << endl;
	  cerr << current_type << " and " << variable_type[i] << endl;
	  exit(1);
	}
      }
    }     
    
    return s;
  } 

  //sada obradjujemo jednakosti i nejednakosti
  if ((pozneg = strstr(s, "!="))){
    strncpy(prva, s, pozneg-s);
    prva[pozneg-s] = '\0';
    strcpy(druga, pozneg+2);

    negacija = 1;
  }
  else {
    strncpy(prva, s, poz-s);
    prva[poz-s] = '\0';
    strcpy(druga, poz+1);

    negacija = 0;
  }
  only_letters_and_numbers(prva);
  only_letters_and_numbers(druga);

  //ako teorija nema tipove od jednakosti uvek pravimo eq_point i neq_point
  if (unsorted == 1){  
    if (negacija)
      strcpy(nova, "neq_point(");
    else 
      strcpy(nova, "eq_point(");

    strcat(nova, prva);
    strcat(nova, ", ");
    strcat(nova, druga);
    strcat(nova, ")");
    return nova;

  } else {
    //ako teorija ima tipove onda pravimo eq_TYPE na osnovu tipova koji 
    //su dodeljeni promenljivim: prva i druga
    
    for(poz_prva = 0; poz_prva<variable_name.size(); poz_prva++)
      if (variable_name[poz_prva] == prva)
	break;

    for(poz_druga = 0; poz_druga<variable_name.size(); poz_druga++)
      if (variable_name[poz_druga] == druga)
	break;

    if (poz_prva == variable_name.size() || poz_druga == variable_name.size()){
      cerr << "There is an error in the format: " << endl;
      cerr << "One of variables: " << prva << " and " << druga;
      cerr << " are not defined, they are missing a type" << endl;
      cerr << "Or maybe there is an error in the file" << endl;
      exit(1);
    }    

    if (variable_type[poz_prva] != variable_type[poz_druga]){
      cerr << "There is an error in the format: " << endl;
      cerr << "Variables: " << prva << " and " << druga;
      cerr << " have different types" << endl;
      exit(1);
    }
    if (negacija)
      strcpy(nova, "neq_");
    else 
      strcpy(nova, "eq_");

    strcat(nova, variable_type[poz_prva].c_str());
    strcat(nova,"(");
    strcat(nova, prva);
    strcat(nova, ", ");
    strcat(nova, druga);
    strcat(nova, ")");

    return nova;
  }
}

void only_letters_and_numbers(char* s){
  int i=0;
  int j;

  //izbacivanje gluposti sa pocetka
  for(; s[i]; i++)
    if (isdigit(s[i]) || isalpha(s[i]))
      break;

  if (i>0){
    //treba da obrisemo pocetak 
    for(j=0; s[i]; j++, i++)
      s[j] = s[i];
    s[j] = '\0';
  }

  //izbacivanje gluposti sa kraja
  for(i=strlen(s); i>0; i--)
    if(!(isdigit(s[i]) | isalpha(s[i])))
      s[i] = '\0';
}

//izvadi stringove razdvojene znakom c
vector<string> extract_relations_string(string p, string c){
 
  vector<string> v;

  //cout << "FJA: extract_relations_string za " << p << " i " << c << endl;

  /*  
  int i = p.find(c);
  while(i!=string::npos){
    v.push_back(p.substr(0,i));
    i = p.find(c, i);
  }
  */

  /*
  char p1[100];
  strcpy(p1,p);

  char *r;
  r = strtok(p1, c);

  while (r!=NULL){
    v.push_back(r);
    r = strtok(NULL, c);
  }
  */
  return v;
}


//odredjuje poziciju stringa s u vektoru stringova v
//vraca -1 ako se string ne nalazi u vektoru
int pozicija(vector<string> v, string s){
  int i;
  for(i=0; i<v.size();i++)
    if (v[i].compare(s)==0)
      return i;
  return -1;
}

//iz tvrdjenja vadimo prvo varijable ako postoje pa onda i relacije ako 
//postoje, relacije su razdvojene sa "&"
//fja vraca 1 ako je grana produktivna, ova informacija je bitna samo 
//ako smo u zakljucku aksiome posto se u premisama uvek nalaze varijable
int obradi_negranajucu(int unsorted, 
		       vector<string> &variable_type,
		       vector<string> &variable_name,
		       string tvrdjenje, 
		       vector<string> &varijable, 
		       vector<string> &relacije){

  int productive = 0;

  //odredjujemo vektor sa varijablama, koji ako postoji se nalazi pre :
  //vektor relacija se nalazi iza : ako : postoji ili je vec u tvrdjenju
  //ako varijable ne postoje
 
  //cout << endl << endl << "FJA OBRADI NEGRANAJUCU: " << endl << endl;
  //cout << "obradjuje " << tvrdjenje << endl;

  string tvrdjenje_varijable;
  string tvrdjenje_relacije;
  vector<string> relacije_vector;

  char veznik_and[] = "&";
  char tvrdjenje_relacije1[1000];

  int poz = tvrdjenje.find_first_of(":");
  if (poz != string::npos){
    productive = 1;
    /*
    cout << "postoje varijable" << endl;
    cout << "PRODUKTIVNA ako smo u zakljucku aksiome " << endl;
    cout << "u premisama uvek postoje varijable" << endl << endl;
    */
    tvrdjenje_varijable = tvrdjenje.substr(0, poz);
    //cout << "tvrdjenje_varijable: " << tvrdjenje_varijable << endl << endl;

    tvrdjenje_relacije = tvrdjenje.substr(poz);
    //cout << "tvrdjenje_relacije: " << tvrdjenje_relacije << endl << endl;

    varijable = extract_variables_string(tvrdjenje_varijable);
    /*
    if (unsorted){
      cout << "vektor varijabli: " << endl;
      for(int i=0; i<varijable.size(); i++)
	cout << "point(" << varijable[i] << ")" << endl;
      cout <<  endl;
    }
    */
    int slova = 0;
    //ako nema alphabetskih karaktera
    for(int k=0; k<tvrdjenje_relacije.size(); k++)
      if (isalpha(tvrdjenje_relacije[k]))
	slova++;
    
    
    if (slova == 0){
      //cout << "nema slova" << endl;
    }
    else {
      //cout << "ima slova" << endl;
      //tvrdjenje_relacije1 = tvrdjenje_relacije;
      strcpy(tvrdjenje_relacije1, tvrdjenje_relacije.c_str());
      relacije = extract_relations(unsorted, variable_type, variable_name, 
				   tvrdjenje_relacije1, veznik_and);
      
      /*
      cout << "izvadjene relacije: " << endl;
      for(int i=0; i<relacije.size(); i++)
	cout << relacije[i]<< endl;
      cout << endl << endl;
      */
    }
    
    //relacije_vector=extract_relations(unsorted, variable_type, variable_name,
    //tvrdjenje_relacije1, veznik_and);
    //cout << "relacije_vector: " << endl;
    for(int i=0; i<relacije_vector.size();i++){
      vector<string> relation_specifics = 
	extract_relation_specifics(relacije_vector[i]);

      /*
      for(int j=0; j<relation_specifics.size();j++)
	cout << relation_specifics[j] << " ";
      cout << endl;
      */
    }
    

    /*
      OVO PREBACI NA STRINGOVE KAD BUDES IMALA NET
    vector<string> relacije_vector1;
    string veznik_and_string = string(veznik_and);
    relacije_vector1=extract_relations_string(tvrdjenje_relacije, 
					      veznik_and_string);
    cout << "relacije_vector1: (preko stringova)";
    for(int i=0; i<relacije_vector1.size();i++)
      cout << " & " << relacije_vector1[i];
    cout << endl;
    */

 
  }
  else {
    /*
    cout << "nema ovde varijabli" << endl;
    cout << "NEPRODUKTIVNA" << endl;
    cout << "Ili je FALSE" << endl;
    cout << "ILI SMO U PREMISAMA TEOREME" << endl;
    */

    tvrdjenje_relacije = tvrdjenje;

    if (strlen(tvrdjenje_varijable.c_str()))    
      ;      
    //cout << "tvrdjenje_varijable: " << tvrdjenje_varijable << endl;
    //cout << "tvrdjenje_relacije: " << tvrdjenje_relacije << endl;

    strcpy(tvrdjenje_relacije1, tvrdjenje_relacije.c_str());
    
    //cout << "tvrdjenje: " << tvrdjenje << endl;
    //cout << "tvrdjenje_relacije: " << tvrdjenje_relacije << endl;

    //relacije_vector=extract_relations(unsorted, variable_type, variable_name,tvrdjenje_relacije1, veznik_and);
    relacije = extract_relations(unsorted, variable_type, variable_name, tvrdjenje_relacije1, veznik_and);
    /*    
    cout << "relacije_vector: ";
    for(int i=0; i<relacije_vector.size();i++)
     cout << " & " << relacije_vector[i];
    cout << endl;
    */
    /*
    cout << "relacije: " << endl;
    for(int i=0; i<relacije.size(); i++)
      cout << relacije[i] << endl;
    cout << endl;
    */

    //iz relacija treba izvaditi varijable
    for(int i=0; i<relacije.size(); i++){
      //izvadimo iz tekuce relacije varijable
      vector<string> relacija_i = extract_relation_specifics(relacije[i]);
      //ako se ne nalaze u vektoru varijabli dodamo je
      //j ide od 1 jer je na 0-toj poziciji uvek ime relacije
      for(int j=1; j<relacija_i.size(); j++){
	int nasli = 0;
	for(int k=0; k<varijable.size(); k++)
	  if (strcmp(varijable[k].c_str(), relacija_i[j].c_str())==0)
	    nasli = 1;
	
	if (nasli == 0)
	  varijable.push_back(relacija_i[j]);
      }
    }
  }
  

  //cout << "ha" << endl;
  return productive;
}

//povratna vrednost ove funkcije treba da bude:
//prvi string - ime relacije
//ostatak vektora - argumenti relacije 
//broj argumenta nije bitan posto moze da se odredi preko velicine vectora
vector<string> extract_relation_specifics(string cela_relacija){

  //cout << endl << "fja: extract_relation_specifics" << endl;
  //cout << "dobijen string: " << cela_relacija << endl;

  //ignorisemo eventualne zagrade i razmake pre imena relacije, tj. 
  //pomeramo se dok ne dodjemo do prvog slova
  int i=0;
  while(!isalpha(cela_relacija[i]))
    i++;

  vector<string> v;
  char p1[1000];
  strcpy(p1,cela_relacija.c_str()+i);

  char *r;
  r = strtok(p1, "(");
  
  //cout << "p1 = " << p1 << endl;

  while (r!=NULL){
    v.push_back(r);
    //cout << "tekuci: " << r << endl;
    r = strtok(NULL, ", ).");
  }
  return v;
  
}

//fja koja stampa dva vektora stringova
void print_vectors(int unsorted, vector<string> branch_varijable, 
		   vector<string> branch_relacije, ofstream& aout, 
		   string line){
       
  //cout << "print_vectors: " << endl;
  //cout << "unsorted = " << unsorted << endl;

  //stampamo branch_varijable ako postoje
  //cout << "vektor varijabli: " << endl;
  if (unsorted)
    for(int i=0; i<branch_varijable.size(); i++){
      aout << "point(" << i+1 << ")" << endl;
      //cout << "point(" << i+1 << " = " << branch_varijable[i] << ")" << endl;
    }
  
  //stampamo branch_relacije
  for(int i=0; i<branch_relacije.size();i++){
    //od branch_relacije[i] koja je oblika "((line(L1)"
    //pravimo vektor stringova relation_specifics koji je oblika
    //"line" "L1" 
    
    //cout << "Obradjujemo: " << branch_relacije[i] << endl;

    vector<string> relation_specifics = 
      extract_relation_specifics(branch_relacije[i]);
    
    stampaj_relaciju_zagrade(relation_specifics, branch_varijable, aout, 
			     line);    
    /*
    cout << "relation_specifics" << endl << endl;    
    for(int j=0; j<relation_specifics.size();j++)
      cout << relation_specifics[j] << " ";
    cout << endl;
    */
  }
  aout << endl;
}

void stampaj_relaciju_zagrade(vector<string> relacija, 
			      vector<string> varijable, ofstream& aout, 
			      string line){
  /*  
  cout << "stampaj_relaciju_zagrade: " << endl << endl;

  cout << endl << "ISPISUJEMO VEKTOR: velicina = " << relacija.size() << endl;
  for(int i=0; i<relacija.size(); i++)
    cout << relacija[i] << " ";
  cout << endl << endl;
  */
  //ako je samo $false ostao ne ispisujemo nista
  //ili eventualno false 
  if (relacija.size() == 1)
    ;
  else 

    for(int i=0; i<relacija.size(); i++)
      if (i==0){
	
	if (relacija[i][0] == 'n'){
	  relacija[i][0] = '~';
	}
      aout << relacija[i] << "(";
      }
      else   {
	if (i==relacija.size()-1){
	  aout << pozicija_stringa(relacija[i], varijable, line) << ")"; 
	  //aout << relacija[i] << ")";
	}
	else {
	  aout << pozicija_stringa(relacija[i], varijable, line) << ", "; 
	  //aout << relacija[i] << ", ";
	}
      }
  aout << endl;
}

int pozicija_stringa(string v, vector<string> varijable, string line){
  /*
    cout << "trazimo: " << v << endl;
  cout << "u vektoru: " << endl;

  
  for(int i=0; i<varijable.size(); i++)
    cout << varijable[i] << " " ;
  cout << endl;
  */

  for(int i=0; i<varijable.size(); i++){
    if (v.compare(varijable[i])==0)
      return i+1;
  }
  //cout << endl;
  cerr << "There is an error in the format: " << endl;
  cerr << "in the line: " << endl;
  cerr << line << endl;
  cerr << "Variable " << v << " is not declared" << endl;
  exit(1);
  return -1;
}



void izbaci(vector<string> premise_varijable, 
	    vector<string>& branch_varijable){
  /*
  cout << endl << "IZBACI ZA VEKTORE: " << endl;
  cout << "premise_varijable: ";
  for(int i=0; i<premise_varijable.size(); i++)
    cout << premise_varijable[i] << " " ;
  cout << endl;
  cout << "branch_varijable: ";
  for(int i=0; i<branch_varijable.size(); i++)
    cout << branch_varijable[i] << " ";
  cout << endl;
  */
  //izbaciti iz branch_varijable varijable koje su se nasle u premisama
  //premise_varijable
  for(int i=0; i<premise_varijable.size(); i++)
    for(int j=0; j<branch_varijable.size(); j++)
      if (strcmp(branch_varijable[j].c_str(), premise_varijable[i].c_str())==0)
	//brisemo j-ti element iz branch_varijable
	branch_varijable.erase(branch_varijable.begin()+j);
}

void spoj_vektore(vector<string> &premise, vector<string> zakljucci){
  int nadjeno = 0;

  for(int i=0; i<zakljucci.size(); i++){
    for(int j=0; j<premise.size(); j++)
      if (premise[j] == zakljucci[i])
	nadjeno = 1;
    if (nadjeno == 0)
      premise.push_back(zakljucci[i]);
    nadjeno = 0;
  }
}

void print_spojene_vektore(int unsorted,
			   vector<string> premise_varijable, 
			   vector<string> branch_varijable, 
			   vector<string> branch_relacije, 
			   ofstream &aout, string line){
  vector <string> original = premise_varijable;
  /*  
cout << "PRINT_SPOJENE_VEKTORE" << endl;
  cout << "premise_varijable: " << endl;
  for(int i=0; i<premise_varijable.size(); i++)
    cout << premise_varijable[i] << " ";
  cout << endl;

  cout << "branch_varijable: " << endl;
  for(int i=0; i<branch_varijable.size(); i++)
    cout << branch_varijable[i]<< " ";
  cout << endl;
  */
  spoj_vektore(premise_varijable, branch_varijable);
  /*
  cout << "sad spajamo vektore i dobijemo: " << endl;
  cout << "premise_varijable nakon spajanja: " << endl;
  for(int i=0; i<premise_varijable.size(); i++)
    cout << premise_varijable[i] << " ";
  cout << endl;
  */

  
  //stampamo branch_varijable ako postoje
  //cout << "vektor varijabli: " << endl;
  for(int i=0; i<branch_varijable.size(); i++){
    int stampaj = 1;
    //ako se varijabla nalazi u premise_varijable onda je ne stampamo
    for(int j=0; j<original.size(); j++)
      if (branch_varijable[i].compare(original[j])==0){
	stampaj = 0;

	//cout << "nasli " << branch_varijable[i];
	//cout << " na poziciji " << j <<endl;
	break;
      }
    if (unsorted){
      if (stampaj == 1){
	aout << "point(" << i+1+original.size() << ")" << endl;
	//cout << "AAA2" << endl;
	//cout << "point(" << i+1+original.size() << " = " << branch_varijable[i] << ")" << endl;
      }
    }
  }
  
  //stampamo branch_relacije
  for(int i=0; i<branch_relacije.size();i++){
    vector<string> relation_specifics = 
      extract_relation_specifics(branch_relacije[i]);
    
    stampaj_relaciju_zagrade(relation_specifics, premise_varijable, aout, 
			     line);    
  }
  aout << endl;
  
}

void trim(char* s){

  int i, j;
  char t[50000];
  //kopiramo sve osim belina
  for(i = 0, j=0; s[i]; i++)
    if (s[i] != ' ' && s[i] != '\t' && s[i] != '\n'){
      t[j] = s[i];
      j++;
    }
  t[j] = '\0';

  //trazimo . - tacku, i posle nje postavljamo \0
  char* poz = strchr(t, '.');
  if (poz != NULL)
    t[poz-t+1] = '\0';

  strcpy(s,t);
}
