#ifndef _OPSTE_H_
#define _OPSTE_H_

#include <vector>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstring>

using namespace std;

//dodajemo indikator da li je teorija sortirana ili ne, ima vrednos 1 ako 
//jeste i 0 ako nije.
//ako nije sortirana onda uvek stampamo point(A),...
int parse_tptp(int sorted, string, ifstream&, ofstream&);

//funkcija koja odredjuje sledecu relaciju iz prvog argumenta 
//ime relacije se smesta u drugi argument 
//a arnost relacije u treci
//funkcija vraca 1 ako uspe parsiranje, 0 u suprotnom
int next_relation(char**, char*, int *);

//funkcija koja iz karakterske niske vadi aksiomu
//funkcija vraca 1 ako uspe parsiranje, 0 u suprotnom
int extract_axiom(int, char*, char*, ofstream&);

int extract_premises(int, vector<string>&, vector<string>&, 
		     string, char*, ofstream&, vector<string>&);
int extract_conclusions(int, vector<string>&, vector<string>&, 
			char*, ofstream&, vector<string>);

char* transform_equalities(int, char*, vector<string>&, vector<string>&);

void only_letters_and_numbers(char*);

//funkcija koja iz niske vadi sve varijable i formira vektor od njih
//u nisci ocekujemo da se varijable nadju izmedju [ i ]
vector<string> extract_variables(char*);
vector<string> extract_variables_string(string);

//fja koja prvi argument deli na nekoliko stringova koji su razdvojeni 
//drugim argumentom
vector<string> extract_relations(int, vector<string>&, vector<string>&, char*, char*);
vector<string> extract_relations_string(string, string);

int pozicija(vector<string>, string);
int obradi_negranajucu(int, vector<string>&, vector<string>&, string, 
		       vector<string>&, vector<string>&);
vector<string> extract_relation_specifics(string);

void print_vectors(int, vector<string>, vector<string>, ofstream&, string);

void print_spojene_vektore(int, vector<string>, vector<string>, vector<string>,
			   ofstream&, string);

void stampaj_relaciju_zagrade(vector<string> relacija, vector<string>, ofstream&, string);

int pozicija_stringa(string, vector<string>, string line);

void izbaci(vector<string>, vector<string>&);

void spoj_vektore(vector<string>&, vector<string>);

void trim(char*);
#endif
