#include <iostream>
#include <fstream>
#include <cstring>
#include <time.h>

#include "auto.h"

using namespace std;

int main(int argc, char* argv[])
{
  if (argc == 1){
    cout << "Usage: ./Auto -p whole_theory" << endl;
    cout << "if we want to preprocess a theory!" << endl;
    cout << endl;
    cout << "Usage: ./Auto [-n|-r] results_file proofs_folder theorem_name" << endl;
    cout << "if we want to prove a single theorem." << endl;
    cout << "Option [-n|-r] determines if prover uses only normal order" << endl;
    cout << "of conjectures from the file, or normal and reversed." << endl;
    cout << "theorem_name must be a theorem in folder \"theorems\"" << endl;
    cout << "results_file is a file that will held the results" << endl;
    cout << "proofs_folder is a folder wich will contain proofs of a theorem" << endl << endl;
    exit(1);
  } 

  
  if (argc ==3){
    
    cout << "Argumenti: " << argv[0] << " " << argv[1] << " " << argv[2] << endl;

    cout << "TPTP file " << argv[2] << " is parsed" << endl;
    cout << "all axioms and theorems are in the folder axioms" << endl;

    char naredba[1000];
    strcpy(naredba, "~/doktorat/automatic/parsiranje_tptp/./tptp_parse ");
    strcat(naredba, argv[2]);
    if (system(naredba) == -1)
      cout << "Command: " << naredba << " failed!" << endl;
    
    char naredba1[1000];
    strcpy(naredba1, "~/doktorat/automatic/make_theorems/./make_theorems ");
    strcat(naredba1, argv[2]);
    if (system(naredba1) == -1)
      cout << "Command: " << naredba1 << " failed!" << endl;
    
    cout << "all tptp theorems are in the folder theorems" << endl;

  } else if (argc == 5) 
    run(argv[1][1], argv[4], argv[2], argv[3]);
  else if (argc == 2) //ako se pozove kako se pozivalo nekada
    run(argv[1][1],argv[2], "results.txt", "proofs");
  else {
    cerr << "Error in parameters." << endl;
  }
}
