#include "auto.h"
using namespace std;

typedef struct stat Stat;

int run(char option_reversed, char* teorema, string rezultati, string folder){

  int reversed;
  if (option_reversed == 'r')
    reversed = 1;
  else if (option_reversed == 'n')
    reversed = 0;
  else {
    cerr << "Called with: " << option_reversed << endl;
    cerr << "Option [-n|-r] expected!" << endl;
    exit(1);
  }

  //otvaramo vampire_results.txt i u njih upisujemo sve rezultate
  ofstream aout;
  //RANIJE JE OTVARAN FAJL ZA NADOVEZIVANJE
  //aout.open(rezultati.c_str(), ofstream::app);
  //SADA GA OTVARAMO ZA UPISIVANJE - BRISE SE PRETHODNI SADRZAJ
  //JEDAN FAJL CE SADRZATI PODATKE O JEDNOJ TEOREMI
  aout.open(rezultati.c_str(), ofstream::out);
  if (aout.fail()){
    cerr << "File: " << rezultati.c_str() << " is missing!" << endl;
    exit(1);
  }
  Stat st;
  if (stat("vampire_proofs", &st)!=0)
    //directory does not exists pa ga kreiramo                                 
    mkdir("vampire_proofs", 0700);

  if (stat("spass_proofs", &st)!=0)
    //directory does not exists pa ga kreiramo                                 
    mkdir("spass_proofs", 0700);

  if (stat("E_proofs", &st)!=0)
    //directory does not exists pa ga kreiramo                                 
    mkdir("E_proofs", 0700);

  char *rr;
  char p[100];
  vector<string> minimal_axioms;
  char teorema_axioms[1000];
  char* pom;

  strcpy(teorema_axioms, teorema);
  //pom = strchr(teorema_axioms, '.');
  //strcpy(pom, "_axioms.p");

  /*
    DODATI 
    - teorema_axioms = teorema + _axioms
    - pozvati prvo rd+argo 
    - pozvati argo 
    - oba prethodna koraka treba u sebi da imaju pokretanje 
      u normalnom i obrnutom redosledu (da li se svuda ispisuje 
      koji je bolji i nije toliko bitno)
  */
  
  //Prvo pokusavamo da dokazemo tekucu teoremu kada se prosledi dokazivacu
  //skup svih prethodnih aksioma i teorema 
  //Pozivamo prvo RD pa argo
  //aout << setw(20) << teorema << "|" << setw(7) << "all" << "|";
  aout << setw(20) << teorema << "|";
  
  string vampire_command = "../atp/vampires/./vampire_lin64 --output_axiom_names on --time_limit 60 < ";
  string e_command = "../atp/e_prover/E/PROVER/./eproof --tstp-format --auto --resources-info --cpu-limit=60 ";
  string spass_command = "../atp/spass/SPASS-3.5/./SPASS -TPTP -DocProof -TimeLimit=60 ";
  
  string dokazivac, order;
  
  double tptp_argoclp_time;
  //string tptp_argoclp_command = "~/doktorat/ArgoCLP_17_12_13_vesna/source/./ArgoCLP1 -t -s ";
  //string tptp_argoclp_command = "~/doktorat/ArgoCLP_17_12_13_vesna_nova_optimizacija/source/./ArgoCLP1 -t -s ";
  string tptp_argoclp_command = "../atp/ArgoCLP/./ArgoCLP -t -s ";
  //NA JOS JEDNOM MESTU SE POKRECE ARGO!!!
  //IZDVOJITI OVAKO I ARGO KOMANDU...
  //string tptp_argoclp_command = "~/doktorat/ArgoCLP_18_01/source/./ArgoCLP -t -s ";
  //string tptp_argoclp_command = "~/doktorat/ArgoCLP_NEWNEW/source/./ArgoCLP1 -t -s ";
  
  //funkcija koja poziva prvo rezolucijske dokazivace 
  //pa sa skupom dobijenih tvrdjenja poziva argo
  //pozivamo prvo za tptp fajl koji sadrzi sve prethodne aksiome i teoreme
  tptp_run_resolution_then_argo(reversed, aout, teorema, vampire_command, e_command, 
				spass_command, minimal_axioms, dokazivac, 
				order, folder);

  //TRENUTNO NE POKUSAVAMO SAMO SA ARGOCLP-OM, RADIMO SAMO KOMBINACIJU RD+ARGO
  /*  
  //sada pokusavamo i sa ArgoCLP-om samim, direktno primena na tptp fajl
  //koji sadrzi teoremu
  tptp_argoclp_time = tptp_run_argoclp(reversed, teorema, tptp_argoclp_command, 
				       folder);
  if (tptp_argoclp_time >= 0)
    aout << setw(10) << tptp_argoclp_time << "||";
  else {
    cout << "Teorema: " << teorema << endl;
    aout << setw(10) << "Time limit" << "||";
  }
  */
  aout << endl;
  
  /* --- RANIJE SMO POKRETALI I SA TEOREMAMA I SAMO SA AKSIOMAMA
         SADA TU OPCIJU BIRAMO U STARTU I DOKAZUJEMO SAMO ZA JEDAN SKUP
  //Onda pokusavamo da dokazemo tekucu teoremu kada se prosledi dokazivacu
  //skup svih prethodnih aksioma (bez teorema) 
  //Pozivamo prvo RD pa argo
  
  //aout << setw(20) << teorema << "|" << setw(7) << "axioms" << "|";
  aout << endl;
  aout << setw(20) << "" << "|" << setw(7) << "axioms" << "|";
  //aout << endl << setw(28) << "axioms" << "|";

  //fajl koji sadrzi samo prethodne aksiome
  tptp_run_resolution_then_argo(aout, teorema_axioms, vampire_command, 
				e_command, spass_command, minimal_axioms, 
				dokazivac, order, folder);
  
  //sada pokusavamo i sa ArgoCLP-om samim, direktno primena na tptp fajl
  //koji sadrzi teoremu
  tptp_argoclp_time = tptp_run_argoclp(teorema_axioms, tptp_argoclp_command, 
				       folder);
  if (tptp_argoclp_time >= 0)
    aout << setw(10) << tptp_argoclp_time << "||" << endl;
  else {
    cout << "Teorema_axioms: " << teorema_axioms << endl;
    aout << setw(10) << "Time limit" << "||" << endl;
  }
  */

}

void tptp_run_resolution_then_argo(int reversed, ofstream& aout, char* teorema, 
				   string vampire_command, 
				   string e_command, string spass_command, 
				   vector<string> &minimal_axioms, 
				   string &dokazivac, string &order, 
				   string folder){
  
  char cat_naredba_argo[100000];  
  float v_time, e_time, s_time;

  //fja koja dokazuje teoremu, minimizuje skup aksioma
  //i ispisuje dokazivac koji je dokazao i aksiome
  prove_theorem(reversed, teorema, vampire_command, e_command, 
		spass_command, minimal_axioms, dokazivac, order, 
		&v_time, &e_time, &s_time);
    
  if (dokazivac.compare("none")!=0){

    //redosled ispisujemo samo ako je podrzan opcijom
    if (reversed)
      aout << setw(2) << order << "|";

    aout << setw(8) << dokazivac << "|";

    if (v_time != -10)
      aout << setw(6) << std::fixed << std::setprecision(2) << v_time << "|";  
    else 
      aout << setw(7) << "|";

    if (e_time != -10)
      aout << setw(6) << std::fixed << std::setprecision(2) << e_time << "|";  
    else 
      aout << setw(7) << "|";
    /*
    if (s_time != -10)
      aout << setw(6) << std::fixed << std::setprecision(2) << s_time << "|";  
    else 
      aout << setw(7) << "|";
    */
    //aout << "|";
    /*
    cout << "skup aksioma sa kojima radimo: " << endl;
    for(int i=0; i<minimal_axioms.size(); i++){
      cout <<  minimal_axioms[i] << " ";
    }
    cout << endl;
    */
    
    //od dobijenog skupa aksioma pravimo fajl za pokretanje argoclp-a
    strcpy(cat_naredba_argo, "cat");
    for(int i=0; i<minimal_axioms.size(); i++){
      //dodajemo uvek aksiomu, cak i ako ima false
      //if (minimal_axioms[i].find("false")==string::npos){
      strcat(cat_naredba_argo, " axioms/");
      strcat(cat_naredba_argo, minimal_axioms[i].c_str());
      strcat(cat_naredba_argo, ".txt");
      //}
    }
    
    //u teoremi menjamo .p na kraju sa .txt zbog argoclp-a
    char* pp = strchr(teorema, '.');
    strcpy(pp+1, "txt");
    
    strcat(cat_naredba_argo, "> axioms/ax_for_");
    strcat(cat_naredba_argo, teorema);

    //cout << "cat_naredba_argo: " << cat_naredba_argo << endl;

    if (system(cat_naredba_argo) == -1)
      cout << "Command: " << cat_naredba_argo << " failed!" << endl;

    //ispisujemo dobijene aksiome
    string ax;
    for(int i=0; i<minimal_axioms.size(); i++){
      ax += minimal_axioms[i];
      ax += " ";
    }
    aout << setw(50) << ax << "|";
    
    
    //pokrecemo argo
    
    double argoclp_time;
    //string argoclp_command = "~/doktorat/ArgoCLP_radi/source/./ArgoCLP1 ";
    //string argoclp_command = "~/doktorat/ArgoCLP_02_08_13/source/./ArgoCLP1 -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_17_12_13_vesna/source/./ArgoCLP1 -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_17_12_13_vesna_nova_optimizacija/source/./ArgoCLP1 -n ";
    string argoclp_command = "../atp/ArgoCLP/./ArgoCLP -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_18_01/source/./ArgoCLP -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_NEWNEW/source/./ArgoCLP1 -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_04_07_14_vesna/source/./ArgoCLP1 -n ";
    //string argoclp_command = "~/doktorat/ArgoCLP_optimizacija/source/./ArgoCLP -n";
    //string argoclp_command = "~/doktorat/ArgoCLP_30_12_13/source/./ArgoCLP1 -n ";    
    
    argoclp_time = run_argoclp(teorema, argoclp_command, folder);
    
    if (argoclp_time >= 0)
      aout << setw(10) << argoclp_time << "||";
    else 
      aout << setw(10) << "Time limit" << "||"; 
  }
  else {
    //ako rezolucijski dokazivaci nisu uspeli ispisujemo prazne kolone
    if (reversed)
      aout << setw(2) << " " << "|";
    aout << setw(8) << " " << "|";
    aout << setw(21) << " " << "|";
    aout << setw(50) << " " << "|";
    aout << setw(10) << " " << "||";
  }
}

void prove_theorem(int reversed, char* teorema, string vampire_command, 
		   string e_command, string spass_command, 
		   vector<string> &minimal_axioms, 
		   string &dokazivac, string &order, 
		   float *v_time, float *e_time, float *s_time){

  //za jedan parametar pozivamo prvo teoremu pa onda 
  //reversed teoremu
  int n = 1;  
  
  //prvo pokretanje dokazivaca
  string dokazivac_old, order_old;
  vector<string> minimal_axioms_old;
  prove_theorem_once(reversed, teorema, vampire_command, e_command, spass_command, 
		     minimal_axioms_old, dokazivac_old, order_old, 
		     v_time, e_time, s_time);
  dokazivac = dokazivac_old;
  order = order_old;
  
  if (dokazivac == "none")
    return;

  /*
  cout << "minimal_axioms_old: ";
  for(int ii=0; ii<minimal_axioms_old.size(); ii++)
    cout << minimal_axioms_old[ii] << " ";
  cout << endl;
  */

  //izdvajamo samo ime teoreme bez .p
  char th[1000];
  //skidamo .p sa kraja imena teoreme
  strcpy(th, teorema);
  char* pz = strchr(teorema, '.');
  th[pz-teorema] = '\0';

  int smanji = 1;
  
  //pokusavamo da smanjimo dobijeni skup aksioma
  while(smanji){  
    //pravimo novi manji fajl koji ce sadrzati teoremu koju dokazujemo 
    //i spisak aksioma
    char cat_naredba[100000];
    strcpy(cat_naredba, "cat ");

    //dodajemo teoremu    
    strcat(cat_naredba, "tptp_axioms/");
    strcat(cat_naredba, th);
    strcat(cat_naredba, "_goal.txt");
    
    //dodajemo aksiome
    for(int i=0; i<minimal_axioms_old.size(); i++){
      strcat(cat_naredba, " tptp_axioms/");
      strcat(cat_naredba, minimal_axioms_old[i].c_str());
      strcat(cat_naredba, ".txt");
    }
    
    //upisujemo je u fajl sa imenom theorem_short_N
    //N - redni broj ponovnog pokretanja dokazivaca
    strcat(cat_naredba, " > theorems/");

    //pravimo novo ime teoreme (za nju cemo pokretati ponovo dokazivace)
    char th_short[1000];
    strcpy(th_short, th); 
    strcat(th_short, "_short_");
    char broj[10];
    sprintf(broj, "%d", n);
    strcat(th_short, broj);
    strcat(th_short, ".p");
    
    strcat(cat_naredba, th_short);
    
    //cout << "Naredba: " << cat_naredba << endl;

    if (system(cat_naredba) == -1)
      cout << "Command: " << cat_naredba << " failed!" << endl;
    
    //cout << "Ponovo pokrecemo za teoremu: " << th_short << endl;

    //ako je izabrana opcija -r
    if (reversed){
      //prvo moramo da napravimo th_short_reversed
      char th_short_reversed[1000];
      char* pt = strchr(th_short,'.');
      
      strncpy(th_short_reversed, th_short, pt-th_short);
      th_short_reversed[pt-th_short] = '\0';
      strcat(th_short_reversed, "_reversed.p");
      
      char okreni[10000];
      strcpy(okreni, "tac ");
      strcat(okreni, "theorems/");
      strcat(okreni, th_short);
      strcat(okreni, " > ");
      strcat(okreni, "theorems/");
      strcat(okreni, th_short_reversed);
      
      if (system(okreni) == -1)
	cerr << "Command: " << okreni << " failed!" << endl;
    }

    vector<string> minimal_axioms_new;
    string dokazao_new, order_new;
    float v_time_new, e_time_new, s_time_new;
    prove_theorem_once(reversed, th_short, vampire_command, e_command, 
		       spass_command, 
		       minimal_axioms_new, dokazao_new, order_new, 
		       &v_time_new, &e_time_new, &s_time_new);
    
    /*
      cout << "minimal_axioms_new: ";
      for(int ii=0; ii<minimal_axioms_new.size(); ii++)
      cout << minimal_axioms_new[ii] << " ";
      cout << endl;
    */
    
    
    //ako je dobijen manji skup aksioma ponovo pokrecemo sa manjim skupom
    //if (compare_vector_length(minimal_axioms_new, minimal_axioms_old) < 0) {
    if (minimal_axioms_new.size() < minimal_axioms_old.size()) {  
      minimal_axioms_old = minimal_axioms_new;
      //menjamo ime i prelazimo na sledecu iteraciju
      n++;
      //cout << endl << "novi skup aksioma je kraci" << endl;
    }
    else //skup aksioma se nije smanjio 
      {
	//cout << endl << "novi skup aksioma je iste duzine" << endl;
	smanji = 0;    
      }
  }
  minimal_axioms = minimal_axioms_old;
}

void prove_theorem_once(int reversed, char* teorema, string vampire_command, 
			string e_command, string spass_command, 
			vector<string> &minimal_axioms, 
			string &dokazao, string &order, 
			float *v_time, float *e_time, float *s_time){
  
  //cout << "prove_theorem_once: " << endl;
  //cout << teorema << endl;

  string dokazivac, dokazivac_reversed; 
  vector<string> minimal_axioms_reversed;
  
  dokazivac = run_provers(teorema, vampire_command, e_command, 
			  spass_command, minimal_axioms,
			  v_time, e_time, s_time);
  order = "n";
  dokazao = dokazivac;
  
  //ako je korisnik odabrao opciju -r onda pozivamo i reversed teoremu, 
  //inace radimo samo sa obicnim redosledom
  if (reversed){
    char teorema_reversed[1000];
    strcpy(teorema_reversed,teorema);
    char* poz = strchr(teorema_reversed,'.');
    if (poz != NULL)
      strcpy(poz, "_reversed.p");
    else {
      poz = strchr(teorema_reversed, '\0');
      strcpy(poz, "_reversed.p");
    }
    
    dokazivac_reversed = run_provers(teorema_reversed, vampire_command, 
				     e_command, spass_command, 
				     minimal_axioms_reversed, 
				     v_time, e_time, s_time);
    
    if (dokazivac.compare("none")!=0){
      if (dokazivac_reversed.compare("none")!=0)
	//ako su dokazala oba
	if (minimal_axioms_reversed.size() < minimal_axioms.size()){
	  minimal_axioms = minimal_axioms_reversed;
	  order = "r";  //reversed
	  dokazao = dokazivac_reversed;
	} else 
	  order = "n";  //normal
      else 
	//ako je dokazao samo normalan
	order = "n";
    } else
      //ako je dokazao samo reversed 
      if (dokazivac_reversed.compare("none")!=0){
	minimal_axioms = minimal_axioms_reversed;
	order = "r";
	dokazao = dokazivac_reversed;
      } else
	order = " ";
  }

  //dokazao = dokazivac;  
}

float run_vampire(char* teorema, string vampire_command, 
		vector<string> &vampire_axioms){
  
  char naredba[10000];
  strcpy(naredba, vampire_command.c_str());
  
  strcat(naredba, "theorems/");
  strcat(naredba, teorema);
  strcat(naredba, " > vampire_proofs/proof_");
  strcat(naredba, teorema);

  //cout << "Vampire: " << naredba << endl;

  if (system(naredba) == -1)
    cout << "Command: " << naredba << " failed!" << endl;
  
  char name[10000];
  strcpy(name, "vampire_proofs/proof_");
  strcat(name, teorema);
  ifstream in;
  char axiome[10000];
  in.open(name, ifstream::in);
  
  char line[10000];
  char* pom;
  int broj=0;
  
  while(1){
    in.getline(line, 50000);
    if (in.eof())
      break;
    
    //zanimaju nas samo redovi koji sadrze rec input
    if ((pom = strstr(line, "input"))){
      
      char s[1000];
      strcpy(s, pom+6);
      s[strlen(s)-1] = '\0';
      
      /*
      //ako nije u pitanju ax_false_beg ubacujemo je
      if (! strstr(s, "false")){ 
	strcat(axiome, s);
	strcat(axiome, " ");
	broj++;
      }
      */
      //sve ide u vektor vampire_axioms
      vampire_axioms.push_back(s);
    }    
    
    if ((strstr(line, "Time limit" ))){
      //cout << "Nije dokazao" << endl;
      return -10;
      break;
    }
    
    if ((pom = strstr(line, "Time elapsed"))){
      return atof(pom+14); 
    }
   
  }
}  

float run_e(char* teorema, string e_command, 
		vector<string> &e_axioms){

  char naredba[10000];
  strcpy(naredba, e_command.c_str());

  strcat(naredba, "theorems/");
  strcat(naredba, teorema);
  strcat(naredba, " > E_proofs/proof_");
  strcat(naredba, teorema);
  strcat(naredba, " 2>/dev/null");
  //strcat(naredba, " 2> E_proofs/error_proof_");
  //strcat(naredba, teorema);

  //cout << "E: " << naredba << endl;

  if (system(naredba) == -1)
    cout << "Command: " << naredba << " failed!" << endl;

  //cout << endl << naredba << endl;

  //vadjenje skupa aksioma koje su koriscene u dokazu

  char name[10000];
  strcpy(name, "E_proofs/proof_");
  strcat(name, teorema);
  ifstream in;
  char axiome[10000];
  in.open(name, ifstream::in);

  char line[10000];
  char* pom;
  int broj=0;
  float vreme = -10;

  while(1){
    in.getline(line, 50000);

    if (in.eof())
      break;

    //zanimaju nas samo redovi koji sadrze rec axiom                            
    if ((pom = strstr(line, "axiom"))){
      char s[1000];
      char *zarez, *zagrada;
      //ime se nalazi iza poslednjeg zareza                                     
      zarez = strrchr(line, ',');
      zagrada = strchr(zarez, ')');

      strncpy(s, zarez+2, zagrada-zarez-2);
      s[zagrada-zarez-2] = '\0';

      /*
      //ako nije u pitanju ax_false_beg ubacujemo je                            
      if (! strstr(s, "false")){
        strcat(axiome, s);
        strcat(axiome, " ");
        broj++;
      }
      */

      //ako nije u pitanju goal ubacujemo je
      if (!strstr(s, "goal"))
	e_axioms.push_back(s);
    }

    if ((strstr(line, "Cannot determine problem status")))
      vreme = -10;;

    if ((pom = strstr(line, "Total time")))
      vreme =  atof(pom+26);    

  }
  return vreme;
}

float run_spass(char* teorema, string spass_command, 
		vector<string> &spass_axioms){

  char naredba[10000];
  strcpy(naredba, spass_command.c_str());

  strcat(naredba, "theorems/");
  strcat(naredba, teorema);
  strcat(naredba, " > spass_proofs/proof_");
  strcat(naredba, teorema);

  //cout << "SPASS: " << naredba << endl;

  if (system(naredba) == -1)
    cout << "Command: " << naredba << " failed!" << endl;

  //vadjenje skupa aksioma koje su koriscene u dokazu

  char name[10000];
  strcpy(name, "spass_proofs/proof_");
  strcat(name, teorema);
  ifstream in;
  char axiome[10000];
  in.open(name, ifstream::in);

  char line[10000];
  char* pom;
  int broj=0;
  float vreme = -10;

  while(1){
    in.getline(line, 50000);
    if (in.eof())
      break;
    
    if ((pom = strstr(line, "Formulae used in the proof : "))){
      
      char* r;
      char s[1000];
      
      r = strtok(pom+strlen("Formulae used in the proof : "), " ");
      while(r!=NULL){
	strcpy(s,r);
	pom = r;
	
	r = strtok(NULL, " ");
	/*
	if ((!strstr(s, "false"))){
	  strcat(axiome, s);
	  strcat(axiome, " ");
	  broj++;
	}
	*/
	if (!strstr(s, "goal"))
	  spass_axioms.push_back(s);
      }
    }
    
    int h, m; 
    float fms;
    if ((strstr(line, "Ran out of time"))){
      vreme = -10;
      return vreme;
    }
    else if (pom = strstr(line, "SPASS spent")){
      char vreme_h_m_s[20];
      strncpy(vreme_h_m_s, pom+12, 10);
      vreme_h_m_s[10] = '\0';
      if (sscanf(vreme_h_m_s, "%d:%d:%f", &h, &m, &fms) >= 2){
	vreme = h *3600 + m*60;
      }
      return vreme+fms;
    }
    
  }
}

double run_argoclp(char* teorema, string argoclp_command, string proofs){

  //POZIVANJE ARGOCLP-A
  char argo_naredba[10000];
  strcpy(argo_naredba, argoclp_command.c_str());
  strcat(argo_naredba, "axioms/");
  strcat(argo_naredba, teorema);
  strcat(argo_naredba, " axioms/ax_for_");
  strcat(argo_naredba, teorema);

  char izlaz[500];
  char line[10000];
  char *pom;

  // Ispisujemo izlaz iz dokazivaca u folder proofs
  strcpy(izlaz, proofs.c_str());
  strcat(izlaz, "/izlaz_");
  strcat(izlaz, teorema);

  strcat(argo_naredba, " > ");
  strcat(argo_naredba, izlaz);
 
  if (system(argo_naredba) == -1)
    cout << "Command: " << argo_naredba << " failed!" << endl;

  //cout << "Argo: " << argo_naredba << endl;
  //cout << argo_naredba << endl;

  ifstream argo;
  argo.open(izlaz, ifstream::in);
  int dokazano = 0;

  //cout << endl << "Dokaz se nalazi u: " << izlaz << endl;
  while(1){
    argo.getline(line, 50000);
    if (argo.eof())
      break;

    if ((pom = strstr(line, "Basic time"))){
      dokazano = 1;
      //cout << endl << "Dokazano" << endl;
      return atof(pom+12);
    }
  }

  if (dokazano == 0){
    //cout << endl << "Nije dokazano" << endl;
    return -10;
  }
}

double tptp_run_argoclp(int reversed, char* teorema, string argoclp_command, 
			string proofs){

  //POZIVANJE ARGOCLP-A
  char argo_naredba[10000];

  //teorema trenutno sadrzi .txt na kraju, treba vratiti na .p
  char* poz = strchr(teorema,'.');
  if (poz != NULL)
    strcpy(poz, ".p");

  strcpy(argo_naredba, argoclp_command.c_str());
  strcat(argo_naredba, "theorems/");
  strcat(argo_naredba, teorema);
  
  char izlaz[500];
  char line[10000];
  char *pom;

  // Izlaz iz ArgoCLP
  strcpy(izlaz, proofs.c_str());
  strcat(izlaz, "/izlaz_");
  strcat(izlaz, teorema);

  strcat(argo_naredba, " > ");
  strcat(argo_naredba, izlaz);

  //sad treba pozvati argoclp za:
  //teorema i teorema_reversed
  //ako jedna od njih da rezultat ispisati ga

  //cout << argo_naredba << endl;
  //cout << reversed_argo_naredba << endl;

  if (system(argo_naredba) == -1)
    cout << "Command: " << argo_naredba << " failed!" << endl;

  //pozivamo argo za originalnu teoremu
  ifstream argo;
  argo.open(izlaz, ifstream::in);

  //cout << "Izlaz: " << izlaz << endl << endl;
  int dokazano = 0;
  while(1){
    argo.getline(line, 50000);
    if (argo.eof())
      break;

    if ((pom = strstr(line, "Basic time"))){
      //cout << "Dokazano normal " << endl;
      dokazano = 1;
      return atof(pom+12);
    }
  }

  if (dokazano == 0 && reversed){
    //ako nije dokazao originalnu pokusavamo reversed

    char reversed_argo_naredba[10000];
    char izlaz_reversed[500];
    
    //pravljenje imena za reversed theoremu
    char teorema_reversed[1000];
    strcpy(teorema_reversed,teorema);
    poz = strchr(teorema_reversed,'.');
    if (poz != NULL)
      strcpy(poz, "_reversed.p");
    else {
      poz = strchr(teorema_reversed, '\0');
      strcpy(poz, "_reversed.p");
    }
    
    strcpy(reversed_argo_naredba, argoclp_command.c_str());
    strcat(reversed_argo_naredba, "theorems/");
    strcat(reversed_argo_naredba, teorema_reversed);
    strcpy(izlaz_reversed, proofs.c_str());
    strcat(izlaz_reversed, "/izlaz_");
    strcat(izlaz_reversed, teorema_reversed);
    strcat(reversed_argo_naredba, " > ");
    strcat(reversed_argo_naredba, izlaz_reversed);
    
    //cout << reversed_argo_naredba << endl;
    if (system(reversed_argo_naredba) == -1)
      cout << "Command: " << reversed_argo_naredba << " failed!" << endl;

    ifstream argo_reversed;
    argo_reversed.open(izlaz_reversed, ifstream::in);
    int dokazano_reversed = 0;
    while(1){
      argo_reversed.getline(line, 50000);
      if (argo_reversed.eof())
	break;
      
      if ((pom = strstr(line, "Basic time"))){
	dokazano_reversed = 1;
	//cout << "Dokazano reversed " << endl << endl;
	return atof(pom+12);
      }
    }

    if (dokazano_reversed == 0){
      //cout << "niko nije dokazao" << endl << endl;
      return -10;
    }
  }
  //ako je stigao dovde svakako nista nije dokazao pa vracamo -10
  //cout << "pih" << endl;
  return -10;
}

//funkcija koja odredjuje koji je dokazivac nasao minimalni
//skup aksioma
string minimal(vector<string> vampire_axioms, 
	       vector<string> spass_axioms, 
	       vector<string> e_axioms){
  /*
  cout << "vampire_axioms.size() = " << vampire_axioms.size() << endl;
  cout << "e_axioms.size() = " << e_axioms.size() << endl;
  cout << "spass_axioms.size() = " << spass_axioms.size() << endl;
  */

  string dokazivac;
  if (vampire_axioms.size() > 0) {
    if (e_axioms.size() > 0) {
      if (spass_axioms.size() > 0){
	//sva tri su dokazala nesto
	if (vampire_axioms.size() > e_axioms.size()){
	  if (e_axioms.size() > spass_axioms.size())
	    dokazivac = "spass";
	  else 
	    dokazivac = "e";
	} else //vampire_axioms.size() < e_axioms.size()
	  if (vampire_axioms.size() > spass_axioms.size())
	    dokazivac = "spass";
	  else 
	    dokazivac = "vampire";	
      } 
      else 
	//samo su vampire i e dokazali nesto
	if (vampire_axioms.size() > e_axioms.size())
	  dokazivac = "e";
	else 
	  dokazivac = "vampire";
    } 
    else 
      //e nije dao dokaz, vampire jeste
      if (spass_axioms.size() > 0) {
	if (spass_axioms.size() > vampire_axioms.size())
	  dokazivac = "vampire";
	else 
	  dokazivac = "spass";
      }
      else 
	//samo vampire je dao dokaz 
	dokazivac = "vampire";
  } else 
    //vampire nije dao dokaz ali jeste jedan ili oba e i spass 
    if (e_axioms.size() > 0) {
      if (spass_axioms.size() > 0){
	if (spass_axioms.size() > e_axioms.size())
	  dokazivac = "e";
	else 
	  dokazivac = "spass";
      }
      else //e dokazao a vampire i spass nisu
	dokazivac = "e";
    }
    else //nije dokazao ni vampire ni e, samo spass
      if (spass_axioms.size() > 0)
	dokazivac = "spass";
      else 
	cout << "greska" << endl;
  
  return dokazivac;
}


string run_provers(char* teorema, string vampire_command, 
		   string e_command, string spass_command, 
		   vector<string> &minimal_axioms, 
		   float *v_time, float *e_time, float *s_time){
  
  //cout << endl << "Pokrecemo: " << endl;
  //cout << teorema << endl;
  //cout << "Dokazujemo samo sa vampirom" << endl;

  //pokrecemo vampire
  vector<string> vampire_axioms;
  *v_time = -10;
  *v_time = run_vampire(teorema, vampire_command, vampire_axioms);
  
  //cout << "zavrsio vampire" << endl;
  
  //pokrecemo e
  vector<string> e_axioms;
  *e_time = -10;
  //cout << " bez e";
  *e_time = run_e(teorema, e_command, e_axioms);

  //cout << "zavrsio e" << endl;
  
  //pokrecemo spass
  vector<string> spass_axioms;
  *s_time = -10;
  //cout << " i bez spass" << endl;
  //*s_time = run_spass(teorema, spass_command, spass_axioms);

  //cout << "zavrsio spass" << endl;

  /*
  if (vampire_axioms.size() == 0)
    cout << "vampire nije dokazao" << endl;
  else {
    cout << "vampire je dokazao: " << endl;
    for(int i=0; i<vampire_axioms.size(); i++)
      cout << vampire_axioms[i] << " ";
    cout << endl;
  }
  if (e_axioms.size() == 0)
    cout << "e nije dokazao" << endl;
  else {
    cout << "e je dokazao: " << endl;
    for(int i=0; i<e_axioms.size(); i++)
      cout << e_axioms[i] << " ";
    cout << endl;
  }
  if (spass_axioms.size() == 0)
    cout << "spass nije dokazao" << endl;
  else {
    cout << "spass je dokazao: " << endl;
    for(int i=0; i<spass_axioms.size(); i++)
      cout << spass_axioms[i] << " ";
    cout << endl;
  }
 
  */
  
  //proveravamo koji je dokazivac dokazao teoremu najbrze
  //ako nijedan nije dokazao ne pozivamo argoclp
  string dokazivac;
  
  if (vampire_axioms.size() == 0 & e_axioms.size() == 0 & 
      spass_axioms.size() == 0){
    return "none";
  } 
  //inace odredjujemo koji dokazivac je dokazao teoremu najbrze
  else 
    dokazivac = minimal(vampire_axioms, spass_axioms, e_axioms);
  
  if (dokazivac.compare("vampire") == 0){
    minimal_axioms = vampire_axioms;
    return "vampire";
  } else 
    if (dokazivac.compare("spass") == 0){
      minimal_axioms = spass_axioms;
      return "spass";	
    } else 
      if (dokazivac.compare("e") == 0){
	minimal_axioms = e_axioms;
	return "e";
      } else 
	cout << "greska" << endl;
}

int compare_vector_length(vector<string> v1, vector<string> v2){
  if (v1.size() < v2.size())
    return -1;
  else if (v1.size() > v2.size())
    return +1;
  else 
    return 0;
}
