(*
Title: High school geometry theorems
Authors: Hilbert's axiomatic system
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoGeoChecker
Date: 30.03.2018.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter plane : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_plane : plane -> plane -> Prop.
Parameter not_eq_plane : plane -> plane -> Prop.
Parameter inc_po_l : point -> line -> Prop.
Parameter not_inc_po_l : point -> line -> Prop.
Parameter inc_po_pl : point -> plane -> Prop.
Parameter not_inc_po_pl : point -> plane -> Prop.
Parameter inc_l_pl : line -> plane -> Prop.
Parameter not_inc_l_pl : line -> plane -> Prop.
Parameter int_l_l : line -> line -> Prop.
Parameter not_int_l_l : line -> line -> Prop.
Parameter int_l_pl : line -> plane -> Prop.
Parameter not_int_l_pl : line -> plane -> Prop.
Parameter int_pl_pl : plane -> plane -> Prop.
Parameter not_int_pl_pl : plane -> plane -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter order : point -> point -> point -> point -> Prop.
Parameter not_order : point -> point -> point -> point -> Prop.
Parameter cut : line -> point -> point -> Prop.
Parameter not_cut : line -> point -> point -> Prop.
Parameter pash : point -> point -> point -> line -> plane -> Prop.
Parameter not_pash : point -> point -> point -> line -> plane -> Prop.

Axiom ax_sym_ncol : forall (A:point) (B:point) (C:point), not_col A B C -> (not_col A C B /\ not_col B A C /\ not_col B C A /\ not_col C A B /\ not_col C B A).
Axiom ax_D1a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_inc_po_l C s) -> not_col A B C.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (alpha:plane) (beta:plane), alpha = beta \/ alpha <> beta.

(* Chapter : th_1_02 *)

Theorem th_1_02 : forall (A:point) (p:line) (B:point) (C:point), (not_inc_po_l A p /\ B <> C /\ inc_po_l B p /\ inc_po_l C p) -> not_col A B C.
Proof.
 intros.
 assert (not_col B C A) by applying (ax_D1a B C p A ) .
 assert (not_col B A C /\ not_col C B A /\ not_col C A B /\ not_col A B C /\ not_col A C B) by applying (ax_sym_ncol B C A ) .
 conclude.
Qed.

