(*
Title: High school geometry theorems
Authors: Hilbert's axiomatic system
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoGeoChecker
Date: 30.03.2018.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter plane : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_plane : plane -> plane -> Prop.
Parameter not_eq_plane : plane -> plane -> Prop.
Parameter inc_po_l : point -> line -> Prop.
Parameter not_inc_po_l : point -> line -> Prop.
Parameter inc_po_pl : point -> plane -> Prop.
Parameter not_inc_po_pl : point -> plane -> Prop.
Parameter inc_l_pl : line -> plane -> Prop.
Parameter not_inc_l_pl : line -> plane -> Prop.
Parameter int_l_l : line -> line -> Prop.
Parameter not_int_l_l : line -> line -> Prop.
Parameter int_l_pl : line -> plane -> Prop.
Parameter not_int_l_pl : line -> plane -> Prop.
Parameter int_pl_pl : plane -> plane -> Prop.
Parameter not_int_pl_pl : plane -> plane -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter order : point -> point -> point -> point -> Prop.
Parameter not_order : point -> point -> point -> point -> Prop.
Parameter cut : line -> point -> point -> Prop.
Parameter not_cut : line -> point -> point -> Prop.
Parameter pash : point -> point -> point -> line -> plane -> Prop.
Parameter not_pash : point -> point -> point -> line -> plane -> Prop.

Axiom ax_I6 : forall (A:point) (B:point) (r:line) (alpha1:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1) -> inc_l_pl r alpha1.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (alpha:plane) (beta:plane), alpha = beta \/ alpha <> beta.

(* Chapter : th_1_04 *)

Theorem th_1_04 : forall (A:point) (p:line) (B:point) (C:point) (alpha:plane), (not_inc_po_l A p /\ B <> C /\ inc_po_l B p /\ inc_po_l C p /\ not_col A B C /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl C alpha) -> (inc_l_pl p alpha /\ inc_po_pl A alpha).
Proof.
 intros.
 assert (inc_l_pl p alpha) by applying (ax_I6 B C p alpha ) .
 conclude.
Qed.

