<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:saxon="http://icl.com/saxon"
xsl:extension-element-prefixes="saxon">

<xsl:strip-space elements="*"/>

<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>

<xsl:template match="/">
<html>
    <head>
        <style> 
	  <!--            font.name       {font: italic;}         -->
        </style>
    </head>

    <body>
    <xsl:for-each select="main">
           
	<xsl:text>theory </xsl:text>
	<xsl:value-of select="theory/theory_name"/>
	<xsl:text>&#xA;</xsl:text>

	<xsl:text>imports Main &#xA;</xsl:text> 
	<xsl:text>begin&#xA;</xsl:text> 

	<xsl:apply-templates select="theory/signature"/>
           
        <hr/>
           
	<xsl:if test="theory/axiom">
	  <xsl:text>&#xA;&#xA;axiomatization where &#xA;&#xA;</xsl:text>
	</xsl:if>
        <xsl:apply-templates  select="theory/axiom"/>

	<xsl:for-each select="chapter">
	  <xsl:apply-templates select="."/>
	</xsl:for-each>
	
	<xsl:text>end&#xA;&#xA;</xsl:text>   
        <hr/>
        <font color="#0000ff">
        <xsl:text>(*Transformed by Vernacular package (2018)*)</xsl:text>
        </font>
   </xsl:for-each>

    </body>
</html>
</xsl:template>

<xsl:template match="signature">
  <xsl:for-each select = "type">
    <xsl:text>typedecl </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>

  <xsl:apply-templates select="relation_symbol"/>
</xsl:template>

<xsl:template match="chapter">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match = "proof_name">
  <!--<xsl:value-of select="@name"/>-->
</xsl:template>

<xsl:template match="relation_symbol">
	<xsl:text>&#xA;consts </xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text> :: </xsl:text>
	
	<xsl:text> "</xsl:text>
	<xsl:for-each select="type">
	  <xsl:value-of select="."/>
	  <xsl:text> \&lt;Rightarrow&gt; </xsl:text>
	</xsl:for-each>
	<xsl:text> bool </xsl:text>
	<xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="attributes">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="attribute">
	<xsl:value-of select="@type"/>
	<xsl:text> \&lt;Rightarrow&gt; </xsl:text>
</xsl:template>

<xsl:template match="axiom">
  <xsl:value-of select="@name"/>
  <xsl:text>: </xsl:text> 
  
  <xsl:text>"</xsl:text>
  <xsl:apply-templates  select="cl_formula/from"/>    
  
  <xsl:if test="cl_formula/from">  
    <xsl:text> \&lt;Longrightarrow&gt; </xsl:text> 
  </xsl:if>

  <xsl:if test="cl_formula/have">
    <xsl:if test="cl_formula/have/variables">
      <xsl:text>\&lt;exists&gt;</xsl:text>
      <xsl:for-each select="cl_formula/have/variables/variable">
	<xsl:text>(</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>::</xsl:text>
	<xsl:value-of select="@type"/>
	<xsl:text>)</xsl:text>
      </xsl:for-each>
      <xsl:text>.</xsl:text>
    </xsl:if>

    <xsl:apply-templates  select="cl_formula/have/dnf"/>
      
    
  </xsl:if>
  
  <xsl:text>"</xsl:text>
  
  <xsl:if test="position()!=last()">
    <xsl:text>&#xA;and </xsl:text>
  </xsl:if>
  
  
</xsl:template>


<xsl:template match="atom">

  <xsl:if test="@type = 'general'">
    <xsl:choose>
      <xsl:when test = "starts-with(relation_symbol/@name, 'not_')">
	<xsl:text>\&lt;not&gt; </xsl:text>
	<xsl:value-of select="substring-after(relation_symbol/@name,'not_')"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="relation_symbol/@name"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:for-each select="parameter">
      <xsl:text> </xsl:text>
      <xsl:apply-templates/>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="@type = 'equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> = </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

  <xsl:if test="@type = 'not_equal'">
    <xsl:value-of select="parameter[1]"/>
    <xsl:text> ~= </xsl:text>
    <xsl:value-of select="parameter[2]"/>
  </xsl:if>

</xsl:template>

<xsl:template match="theorem">
  
  <xsl:apply-templates select="theorem_name"/>
  
  <xsl:if test="cl_formula/from">
     <xsl:text> assumes </xsl:text>
  </xsl:if>

  <xsl:for-each select="cl_formula/from/conj/atom">
    <xsl:text> "</xsl:text>
    
    <xsl:apply-templates select="."/>
    <xsl:text>" </xsl:text>
    <xsl:if test="position()!=last()">
	<xsl:text>and</xsl:text>
    </xsl:if>  

  </xsl:for-each>
  <xsl:text> shows "</xsl:text>

  <xsl:if test="cl_formula/have/variables">
    <xsl:text>\&lt;exists&gt;</xsl:text>

    <xsl:for-each select="cl_formula/have/variables/variable">
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>)</xsl:text>
    </xsl:for-each>
    <xsl:text>.</xsl:text>
    
  </xsl:if>

  <xsl:apply-templates select="cl_formula/have/dnf"/>
  <xsl:text>" </xsl:text> 
  

  <xsl:text>&#xA;&#xA;proof - </xsl:text>
  <xsl:apply-templates  select="proof"/>

  
  <xsl:variable name = "first_branch"
                select = "proof/proof_closing/case_split/assumption[1]/conj/atom/relation_symbol/@name"/>
  <xsl:variable name = "second_branch"
                select = "proof/proof_closing/case_split/assumption[2]/conj/atom/relation_symbol/@name"/>

  <xsl:choose>
    <xsl:when test="count(proof/proof_closing/case_split/assumption) = 2 and 
                    ((starts-with($first_branch, 'not_') and              
                    substring-after($first_branch,'not_') =             
                    $second_branch) or                      
                    (starts-with($second_branch, 'not_') and          
                    substring-after($second_branch,'not_') =         
                    $first_branch))">
      <xsl:text>&#xA;qed&#xA;&#xA;</xsl:text>

    </xsl:when>
    <xsl:otherwise>

      <xsl:text>&#xA;&#xA;</xsl:text>  
      <xsl:text>from this</xsl:text>
      <xsl:text>&#xA;show ?thesis </xsl:text>
      <xsl:text>&#xA;.</xsl:text>
      <xsl:text>&#xA;qed&#xA;&#xA;</xsl:text>

    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="conjecture">

  <xsl:apply-templates select="name"/>
  
  <xsl:if test="cl_formula/from">
     <xsl:text> assumes </xsl:text>
  </xsl:if>

  <xsl:for-each select="cl_formula/from/conj/atom">
    <xsl:text> "</xsl:text>
    
    <xsl:apply-templates select="."/>
    <xsl:text>" </xsl:text>
    <xsl:if test="position()!=last()">
	<xsl:text>and</xsl:text>
    </xsl:if>  

  </xsl:for-each>
  <xsl:text> shows "</xsl:text>

  <xsl:if test="cl_formula/have/variables">
    <xsl:text>\&lt;exists&gt;</xsl:text>
    <xsl:for-each select="cl_formula/have/variables/variable">
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>)</xsl:text>
    </xsl:for-each>
    <xsl:text>.</xsl:text>
    
  </xsl:if>

  <xsl:apply-templates select="cl_formula/have/dnf"/>
  <xsl:text>" </xsl:text> 

  <xsl:text>&#xA;sorry &#xA;</xsl:text>

   
</xsl:template>

<xsl:template match="theorem_name">
  
  <xsl:text>&#xA;&#xA;lemma </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> : </xsl:text>
  
</xsl:template>

<xsl:template match="name">
  
  <xsl:text>&#xA;&#xA;lemma </xsl:text>
  <xsl:value-of select="."/>
  <xsl:text> : </xsl:text>
  
</xsl:template>



<xsl:template match="cl_formula">
  <xsl:text>"</xsl:text>
  <xsl:apply-templates  select="from"/>    

  <xsl:if test="from">  
    <xsl:text> \&lt;Longrightarrow&gt; </xsl:text> 
  </xsl:if>


  <xsl:if test="have">
    <xsl:apply-templates  select="have"/> 
  </xsl:if>

  <xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="variables">
     <xsl:apply-templates />         
</xsl:template>

<xsl:template match="variable">
     <xsl:text>"</xsl:text>
     <xsl:value-of select="@name"/>
     <xsl:text>" </xsl:text>
</xsl:template>

<xsl:template match="from">
  <xsl:text>\&lt;lbrakk&gt;</xsl:text> 

  <xsl:for-each select="conj/atom">    
    <xsl:apply-templates select="." />
    <xsl:if test="position()!=last()">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:for-each>


  <xsl:text>\&lt;rbrakk&gt;</xsl:text> 

</xsl:template>


<xsl:template match="dnf">

  <xsl:for-each select="conj">
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="." />
      
    <xsl:if test="not(atom)">
      <xsl:text>False</xsl:text>
    </xsl:if>
    
    <xsl:text>)</xsl:text>
  
    <xsl:if test="position()!=last()">
      <xsl:text>\&lt;or&gt;</xsl:text>
    </xsl:if>
  </xsl:for-each>

</xsl:template>

<xsl:template match="conj">

  <xsl:for-each select="atom">
    
    <xsl:apply-templates select="." />
    <xsl:if test="position()!=last()">
      <xsl:text> \&lt;and&gt; </xsl:text>
  
    </xsl:if>
  </xsl:for-each>
  
</xsl:template>

<xsl:template match="proof">

  <xsl:apply-templates />         
</xsl:template>


<xsl:template name="repeat">
  <xsl:param name="count" />
  <xsl:if test = "$count &gt; 0">
    <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:if test="$count &gt; 1">
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="$count - 1" />
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template match="proof_step">

  <xsl:apply-templates select="modus_ponens"/>  
  
</xsl:template>


<xsl:template match="proof_closing">

  <xsl:if test ="from">
    <xsl:text>&#xA;&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="indentation/@depth"/>
    </xsl:call-template>

    <xsl:text>from </xsl:text>
    
    <xsl:for-each select="from/conj/atom">
      <xsl:text>`</xsl:text>
      <xsl:apply-templates select="."/>
      <xsl:text>`</xsl:text>
      <xsl:if test="position()!=last()">
        <xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test = "not(case_split) and not(from)">
    <xsl:text>&#xA;&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="indentation/@depth"/>
    </xsl:call-template>
    
    <xsl:text>from this</xsl:text>
  </xsl:if>

  <xsl:apply-templates select="efq"/>

  <xsl:apply-templates select="case_split"/>

  <xsl:if test="goal_reached_thesis and not(case_split)">
    
    <xsl:if test="not(case_split) and not(from)">
      <xsl:text>&#xA;&#xA;</xsl:text>
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="indentation/@depth"/>
      </xsl:call-template>

      <xsl:text>from this </xsl:text>       
    </xsl:if>

    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="indentation/@depth"/>
    </xsl:call-template>

    <xsl:variable name = "first_branch"
                  select = "../../../assumption[1]/conj/atom/relation_symbol/@name"/>
    <xsl:variable name = "second_branch"
                  select = "../../../assumption[2]/conj/atom/relation_symbol/@name"/>
    
    <xsl:choose>
      <xsl:when test="count(../../../assumption) = 2 and             
                      ((starts-with($first_branch, 'not_') and                 
                      substring-after($first_branch,'not_') =                
                      $second_branch) or                                     
                      (starts-with($second_branch, 'not_') and                
                      substring-after($second_branch,'not_') =                
                      $first_branch))">

	<xsl:text>show ?thesis </xsl:text>
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="indentation/@depth+2"/>
	</xsl:call-template>
	   
      </xsl:when>
      
      <xsl:otherwise>
	<xsl:text>have ?thesis</xsl:text>
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="indentation/@depth+2"/>
	</xsl:call-template>
	
      </xsl:otherwise>
    </xsl:choose>
    
    <xsl:choose>
      
      <xsl:when test="ancestor::theorem[1]/cl_formula/have/variables">
	<xsl:text>by auto </xsl:text>
	<!--<xsl:text>(*by (rule_tac x="A" in exI, rule_tac x = "D" in exI)*)</xsl:text>-->
      </xsl:when>

      <!--if  we have brahcning theorem-->
      <xsl:when test="count(ancestor::theorem[1]/cl_formula/have/dnf/conj)>1">
	<xsl:text>by auto</xsl:text>
      </xsl:when>
      
      <xsl:otherwise>

	<!-- if we have one relation in a conclusion of a theorem -->
	<xsl:if test = "count(from/conj/atom) = 1">
	  <xsl:text>by assumption</xsl:text>
	</xsl:if>
	
	<xsl:if test = "count(from/conj/atom) > 1">
	  <xsl:text>by -((rule conjI, assumption)+, assumption)</xsl:text>
	</xsl:if>
	
      </xsl:otherwise>
    </xsl:choose>
    
    
    
  </xsl:if>
  

  <xsl:if test="goal_reached_contradiction and
		not(case_split)">
    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="indentation/@depth"/>
    </xsl:call-template>

    <xsl:text>show ?thesis </xsl:text>
    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="indentation/@depth+2"/>
    </xsl:call-template>

    <xsl:text>by (rule FalseE) </xsl:text>
  </xsl:if>  

</xsl:template>


<xsl:template match="modus_ponens">

  <xsl:text>&#xA;</xsl:text>
  
  <xsl:if test="from">
    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth"/>
    </xsl:call-template>
    
    <xsl:text>from </xsl:text>
    <xsl:for-each select="from/conj/atom">
      <xsl:text>`</xsl:text>
      <xsl:apply-templates select="."/>
      <xsl:text>`</xsl:text>
      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test = "have/obtain_witness">
    
    <xsl:text>&#xA;</xsl:text>

    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth"/>
    </xsl:call-template>
    
    <xsl:text>obtain </xsl:text>
    <xsl:for-each select="have/obtain_witness/constant">
      <xsl:value-of select="@name"/>
      <xsl:text>::</xsl:text>
      <xsl:value-of select="@type"/>

      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>

    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth+2"/>
    </xsl:call-template>

    <xsl:text>where </xsl:text>
  </xsl:if>
  

  <xsl:if test = "not(have/obtain_witness) and have">
    <xsl:text>&#xA;</xsl:text>

    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth"/>
    </xsl:call-template>

    <xsl:text>have </xsl:text>
  </xsl:if>

  <xsl:if test = "have"> 
    <xsl:text>"</xsl:text>

    <xsl:for-each select="have/dnf/conj">

      <xsl:if test="atom">	
	<xsl:for-each select="atom">
	  <xsl:apply-templates select="."/>
	  <xsl:if test="position()!=last()">
	    <xsl:text>" and "</xsl:text>
	  </xsl:if>
	</xsl:for-each>
	
	<xsl:if test= "position()!= last()">
	  <xsl:text> \&lt;or&gt; </xsl:text>
	</xsl:if>
      </xsl:if>

      <xsl:if test="not(atom)">
	<xsl:text>False</xsl:text>
      </xsl:if>

    </xsl:for-each>
    <xsl:text>"</xsl:text>
        
  </xsl:if>
  
  <xsl:if test = "have/dnf/conj/atom">
    <xsl:if test = "@axiom_name">

      <xsl:choose>
	<!-- productive or there are more conclusions-->
	<xsl:when test = "have/obtain_witness or 
			count(have/dnf/conj/atom) &gt;1">
	  <xsl:text>&#xA;</xsl:text>
	  <xsl:call-template name="repeat">
	    <xsl:with-param name="count" select="../indentation/@depth+2"/>
	  </xsl:call-template>

	  <xsl:variable name = "first_predicate" 
			select = "have/dnf/conj[1]/atom/relation_symbol/@name"/>
	  <xsl:variable name = "second_predicate" 
			select = "have/dnf/conj[2]/atom/relation_symbol/@name"/>
	  <xsl:choose>
	    <!-- if the branching is on col or not_col -->
	    <xsl:when test = "count(have/dnf/conj) = 2 and
			      ((starts-with($first_predicate, 'not_') and 
			      substring-after($first_predicate,'not_') =
			      $second_predicate) or 
			      (starts-with($second_predicate, 'not_') and 
			      substring-after($second_predicate,'not_') =
			      $first_predicate))">
		  <xsl:text>by (subst disj_commute, rule excluded_middle)</xsl:text>
		
	    </xsl:when>

	    <!-- nonproductive axiom with two conclusions -->
	    <xsl:when test = "not(have/obtain_witness) and 
			      count(have/dnf/conj/atom) = 2 and
			      count(have/dnf/conj) = 1">
	      <xsl:text>by (</xsl:text>
	      <xsl:for-each select="have/dnf/conj/atom">
		
		<xsl:text>rule </xsl:text>
		<xsl:value-of select="../../../../@axiom_name"/>

		<xsl:text> [THEN conjunct</xsl:text>
		<xsl:value-of select="position()"/>
 
		<xsl:text>]</xsl:text>
		<xsl:if test="position()!=last()">
		  <xsl:text>, </xsl:text>
		</xsl:if>

	      </xsl:for-each>
	      <xsl:text>)</xsl:text>
	      <xsl:text>&#xA;</xsl:text>

	    </xsl:when>
	    
	    <!--productive or branching -->
	    <xsl:otherwise>

	      <xsl:text>using </xsl:text>
	      <xsl:value-of select="@axiom_name"/>
	      
	      <xsl:if test="constants">
		<xsl:text> [of</xsl:text>
		<xsl:for-each select="constants/constant">
		  <xsl:text> "</xsl:text>
		  <xsl:value-of select="@name"/>
		  <xsl:text>"</xsl:text>
		</xsl:for-each>
		<xsl:text>] </xsl:text>
	      </xsl:if>
	      <xsl:text>&#xA;</xsl:text>
	      <xsl:call-template name="repeat">
		<xsl:with-param name="count" select="../indentation/@depth+2"/>
	      </xsl:call-template>
	      <xsl:text>by auto </xsl:text> 

	    </xsl:otherwise>
	  </xsl:choose>

	</xsl:when>	
    
	<xsl:otherwise>
	  <xsl:text>&#xA;</xsl:text>
	  <xsl:call-template name="repeat">
	    <xsl:with-param name="count" select="../indentation/@depth+2"/>
	  </xsl:call-template>
	 
	  <xsl:text>by (rule </xsl:text>
	  <xsl:value-of select="@axiom_name"/>
	  <xsl:text>)</xsl:text>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:if>

    <xsl:if test = "not(@axiom_name)">
      <xsl:text>&#xA;</xsl:text> 
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth+2"/>
      </xsl:call-template>

      <xsl:variable name="first" select="from/conj/atom/relation_symbol/@name"/>
      <xsl:variable name="second" select="have/dnf/conj/atom/relation_symbol/@name"/>


      <xsl:choose>
	<!-- A=B => B=A -->
	<xsl:when test = "count(from/conj/atom) = 1 and 
			  count(have/dnf/conj/atom) = 1 and
			  $first = $second and
			  $first = 'eq_point'">
	  <xsl:text>by (rule sym)</xsl:text>
	</xsl:when>

	<!-- A~=B => B~=A -->
	<xsl:when test = "count(from/conj/atom) = 1 and 
			  count(have/dnf/conj/atom) = 1 and
			  $first = $second and
			  $first = 'not_eq_point'">
	  <xsl:text>by (rule not_sym)</xsl:text>
	</xsl:when>

	<xsl:otherwise>
	  <xsl:text>by simp</xsl:text> 
	</xsl:otherwise>
      </xsl:choose>
    </xsl:if>
        
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom) and @axiom_name">
    
    <xsl:text>&#xA;</xsl:text>

    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth+2"/>
    </xsl:call-template>

    <xsl:text>by (rule notE)</xsl:text>

  </xsl:if>
  
  <xsl:if test = "not(have/dnf/conj/atom) and not(@axiom_name)">
    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="count" select="../indentation/@depth+2"/>
    </xsl:call-template>

    <xsl:choose>
      <xsl:when test = "count(from/conj/atom) &gt; 1">
	<xsl:text>by (rule notE)</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<!-- A~=A =>False-->
	<xsl:text>by - (erule notE, rule refl)</xsl:text>
      </xsl:otherwise> 
    </xsl:choose>
  </xsl:if>
  
  

</xsl:template>

<xsl:template match="have">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="case_split">

  <xsl:text>&#xA;&#xA;</xsl:text>
	
  <xsl:variable name = "first_branch" 
		select = "assumption[1]/conj/atom/relation_symbol/@name"/>
  <xsl:variable name = "second_branch" 
		select = "assumption[2]/conj/atom/relation_symbol/@name"/>

  <!-- if branching is on col or not_col then we use proof (cases "R") -->
  <xsl:choose>
    <xsl:when test="count(assumption) = 2 and 
		    ((starts-with($first_branch, 'not_') and 
		    substring-after($first_branch,'not_') =
		    $second_branch) or 
		    (starts-with($second_branch, 'not_') and 
		    substring-after($second_branch,'not_') =
		    $first_branch))">
      
      
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth"/>
      </xsl:call-template>

      <xsl:text>show ?thesis</xsl:text>
      <xsl:text>&#xA;</xsl:text>

      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth"/>
      </xsl:call-template>

      <xsl:text>proof(cases </xsl:text>
      <xsl:text>"</xsl:text>
      <xsl:apply-templates select="assumption[1]/conj"/>
      <xsl:text>"</xsl:text>
      <xsl:text>)</xsl:text>
      <xsl:text>&#xA;</xsl:text>

      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth+2"/>
      </xsl:call-template>

      <xsl:text>case True</xsl:text>
      <xsl:text>&#xA;</xsl:text>

      <xsl:apply-templates  select="assumption[1]/proof"/> 
      
      <xsl:text>&#xA;</xsl:text>
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth"/>
      </xsl:call-template>

      <xsl:text>next</xsl:text>
      <xsl:text>&#xA;</xsl:text>
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth+2"/>
      </xsl:call-template>

      <xsl:text>case False</xsl:text>
      <xsl:text>&#xA;</xsl:text>
      
      <xsl:apply-templates select="assumption[2]/proof"/>

      <xsl:text>&#xA;</xsl:text>
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth"/>
      </xsl:call-template>
      <xsl:text>qed</xsl:text>

    </xsl:when>
    
    <xsl:otherwise>
     
      <xsl:for-each select="assumption">
	
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../../indentation/@depth"/>
	</xsl:call-template>
	
	<xsl:text>{assume </xsl:text>
	<xsl:text> "</xsl:text>
	<xsl:apply-templates  select="conj"/>
	<xsl:text>" </xsl:text> 
	
	<xsl:apply-templates  select="proof"/> 
	
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../../indentation/@depth"/>
	</xsl:call-template>
	
	<xsl:text>} note </xsl:text>
	<xsl:value-of select="proof/proof_name/@name"/>
	<xsl:text> = this </xsl:text>
	<xsl:text>&#xA;</xsl:text>
      </xsl:for-each>
      
      <xsl:text>&#xA;&#xA;</xsl:text>
      <xsl:call-template name="repeat">
	<xsl:with-param name="count" select="../indentation/@depth"/>
      </xsl:call-template>
      
      <xsl:text>from </xsl:text>
      
      <xsl:for-each select="disjunction_elimination/proof_names/proof_name">
	<xsl:value-of select="@name"/>
	<xsl:text> and </xsl:text>
      </xsl:for-each>
      
      <xsl:text>`</xsl:text>
      <xsl:apply-templates select="disjunction_elimination/dnf"/>
      <xsl:text>`</xsl:text>
      
      <xsl:if test="../goal_reached_thesis">
	
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../indentation/@depth"/>
	</xsl:call-template>
	
	<xsl:text>have ?thesis </xsl:text>
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../indentation/@depth+2"/>
	</xsl:call-template>
	
	<xsl:text>by auto </xsl:text>
      </xsl:if>
      
      <xsl:if test="../goal_reached_contradiction">
	
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../indentation/@depth"/>
	</xsl:call-template>
	
	<xsl:text>have False </xsl:text>
	<xsl:text>&#xA;</xsl:text>
	<xsl:call-template name="repeat">
	  <xsl:with-param name="count" select="../indentation/@depth+2"/>
	</xsl:call-template>
	
	<xsl:text>by auto </xsl:text>
	
      </xsl:if>  
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
