theory theorem_th_1_02
imports Main 
begin
typedecl point
typedecl line
typedecl plane

consts eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts not_eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts not_inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "

axiomatization where 

ax_sym_ncol: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col A C B \<and> \<not> col B A C \<and> \<not> col B C A \<and> \<not> col C A B \<and> \<not> col C B A)"
and ax_D1a: "\<lbrakk>A ~= B; inc_po_l A s; inc_po_l B s; \<not> inc_po_l C s\<rbrakk> \<Longrightarrow> (\<not> col A B C)"
and ax_g1: "(A = B)\<or>(A ~= B)"
and ax_g2: "(p = q)\<or>(p ~= q)"
and ax_g3: "(alpha = beta)\<or>(alpha ~= beta)"

lemma th_1_02 :  assumes  "\<not> inc_po_l A p" and "B ~= C" and "inc_po_l B p" and "inc_po_l C p"  shows "(\<not> col A B C)" 

proof - 

from `B ~= C` and `inc_po_l B p` and `inc_po_l C p` and `\<not> inc_po_l A p`
have "\<not> col B C A"
  by (rule ax_D1a)

from `\<not> col B C A`
have "\<not> col B A C" and "\<not> col C B A" and "\<not> col C A B" and "\<not> col A B C" and "\<not> col A C B"
  using ax_sym_ncol [of "B" "C" "A"] 
  by auto 

from `\<not> col A B C`
have ?thesis
  by assumption

from this
show ?thesis 
.
qed

end

(*Transformed by Vernacular package (2018)*)