<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:saxon="http://icl.com/saxon"
xsl:extension-element-prefixes="saxon">

<xsl:strip-space elements="*"/>

<xsl:variable name="counter" select="0" saxon:assignable="yes"/>


<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>

<xsl:template match="/">
<html>
  <head>
    <style> 
      <!--font.name       {font: italic;}         -->
    </style>
  </head>
  
  <body>
    <xsl:for-each select="main">
      
      <!-- argochecker izmena: 

      <xsl:text>\documentclass{book}&#xa;</xsl:text>
      -->
      <xsl:text>\documentclass{article}&#xa;</xsl:text>

      <xsl:text>\usepackage{argoclp}&#xa;</xsl:text>
      <xsl:text>\catcode`\_=\active&#xa;</xsl:text>
      <xsl:text>\def_{\_}&#xa;&#xa;</xsl:text>
      <xsl:text>\def\d{{\fontencoding{T1}\selectfont\dj}}&#xa;&#xa;</xsl:text>
      <xsl:text>\def\D{{\fontencoding{T1}\selectfont\DJ}}&#xa;&#xa;</xsl:text>

      <!-- argochecker izmena: 

      <xsl:text>\oddsidemargin 19mm &#xa;</xsl:text>
      <xsl:text>\evensidemargin 19mm &#xa;</xsl:text>
      -->
      <xsl:text>\setlength{\textheight}{22cm} &#xa;</xsl:text>
      
      <xsl:text>\newtheorem{axiom}{Axiom}&#xa;</xsl:text>
      <xsl:text>\newtheorem{theorem}{Theorem}&#xa;</xsl:text>
      <xsl:text>\newcounter{proofstepnum} &#xa;</xsl:text>
      <xsl:text>&#xa;\begin{document}&#xa;&#xa;</xsl:text>
      <xsl:apply-templates  select="frontpage"/>         
      <xsl:text>\maketitle&#xa;&#xa;</xsl:text>
      <xsl:apply-templates  select="theory"/> 
      <xsl:for-each select="chapter">
	<xsl:apply-templates  select="."/>
      </xsl:for-each>

      <!-- argochecker izmena -->
      <xsl:for-each select="theorem">
	<xsl:apply-templates  select="."/>
      </xsl:for-each>

      <!-- argochecker izmena -->
      <xsl:for-each select="conjecture">
	<xsl:apply-templates  select="."/>
      </xsl:for-each>

      <xsl:text>&#xa;\end{document}&#xa;</xsl:text>
    </xsl:for-each>
  </body>
</html>
</xsl:template>



<xsl:template match="frontpage">
   <xsl:apply-templates />   
</xsl:template>

<xsl:template match="title">    
     <xsl:text>\title{</xsl:text>
     <xsl:apply-templates />   
     <xsl:text>}&#xa;</xsl:text>
</xsl:template>

<xsl:template match="authors">    
     <xsl:text>\author{</xsl:text>
     <xsl:apply-templates />   
     <xsl:text>\\&#xa;</xsl:text>
</xsl:template>

<xsl:template match="formalizedby">    
     <xsl:text>Formalized by: </xsl:text>
     <xsl:for-each select = "name">
       <xsl:value-of select= "."/>
       <xsl:text> </xsl:text>
     </xsl:for-each>
     <xsl:text>\\&#xa;</xsl:text>
</xsl:template>

<xsl:template match="provedby">    
     <xsl:text>Proved by: </xsl:text>
     <xsl:apply-templates />   
     <xsl:text>}&#xa;</xsl:text>
</xsl:template>

<xsl:template match="date">    
     <xsl:text>\date{</xsl:text>
     <xsl:apply-templates />   
     <xsl:text>}&#xa;</xsl:text>
</xsl:template>


<!-- ArgoChecker izmena-->
<xsl:template match="chapter"> 
<!--   
    <xsl:text>\chapter{</xsl:text>
     <xsl:value-of select="@name"/>
     <xsl:text>}&#xa;&#xa;</xsl:text>
-->
     <xsl:apply-templates/>
</xsl:template>


<xsl:template match="theory">    

<!-- argochecker izmena -->
<!-- kada se za svaku teoremu pravi pojedinacan fajl ovaj deo nije potreban

     <xsl:text>\chapter{Theory description}&#xa;&#xa;</xsl:text>
     <xsl:text>\section{Name}&#xa;&#xa;</xsl:text>
     <xsl:apply-templates  select="theory_name"/>       
     <xsl:text>&#xa;&#xa;\section{Signature}&#xa;&#xa;</xsl:text>
     <xsl:text>Types:&#xa;\begin{itemize}&#xa;</xsl:text>   
     <xsl:apply-templates  select="signature"/>  
     <xsl:text>\end{itemize}&#xa;&#xa;</xsl:text>   
     <xsl:apply-templates  select="relation_symbol"/>  
     <xsl:apply-templates  select="function_symbol"/>  
     <xsl:text>\section{Axioms}&#xa;&#xa;</xsl:text>
     <xsl:apply-templates  select="axiom"/>
     <xsl:text>\hrule &#xa;&#xa;</xsl:text>
-->
</xsl:template>


<xsl:template match="signature">
     <xsl:apply-templates  select="type"/>  
</xsl:template>


<xsl:template match="type">
       <xsl:text>\item $</xsl:text> 
       <xsl:apply-templates/>
       <xsl:text>$&#xa;</xsl:text> 
</xsl:template>


<xsl:template match="relation_symbol">
       <xsl:value-of select="@name"/>
       <xsl:apply-templates/>
</xsl:template>


<xsl:template match="axiom">
    <xsl:text>\begin{axiom}[</xsl:text>   
       <xsl:text>$</xsl:text> 
       <xsl:value-of select="@name"/>
       <xsl:text>$</xsl:text> 
       <xsl:text>]&#xa;</xsl:text> 
       <xsl:apply-templates />  
    <xsl:text>&#xa;\end{axiom}&#xa;&#xa;</xsl:text>   
</xsl:template>


<xsl:template match="theorem">
    <xsl:text>\begin{theorem}[</xsl:text> 
    <xsl:apply-templates select = "theorem_name"/>
    <xsl:text>]&#xa;</xsl:text> 
    <xsl:apply-templates select = "cl_formula"/>     
    <xsl:text>&#xa;\end{theorem}&#xa;&#xa;</xsl:text>
    <xsl:if test = "proof">
      <xsl:text>{\em Proof:}&#xa;</xsl:text>  
      <xsl:text>\setcounter{proofstepnum}{0} &#xa;&#xa;</xsl:text>
      
    </xsl:if>
    <xsl:apply-templates select = "proof"/>  
    <xsl:if test = "proof">
      <xsl:text>&#xa;QED&#xa;</xsl:text>   
    </xsl:if>
    <xsl:text>\hrule &#xa;</xsl:text>
</xsl:template>

    
<xsl:template match="theorem_name">
   <font class="name"><xsl:value-of select="."/>.</font>
</xsl:template>



<xsl:template match="conjecture">
    <xsl:text>\begin{theorem}[</xsl:text> 
    <xsl:apply-templates select = "name"/>
    <xsl:text>]&#xa;</xsl:text> 
    <xsl:apply-templates select = "cl_formula"/>     
    <xsl:text>&#xa;\end{theorem}&#xa;&#xa;</xsl:text>
    <xsl:text>\hrule &#xa;</xsl:text>
</xsl:template>

    
<xsl:template match="name">
   <font class="name"><xsl:value-of select="."/>.</font>
</xsl:template>


<xsl:template match="cl_formula">
   <xsl:if test = "from">
    <xsl:text>Assuming that </xsl:text>

    <xsl:for-each select = "from/conj/atom">
      <xsl:text>$</xsl:text>
      <xsl:apply-templates select = "."/>
      <xsl:text>$</xsl:text>
      <xsl:if test = "position()!=last()">
        <xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>

  </xsl:if>

  <xsl:apply-templates select = "have/obtain_witness"/>

  <xsl:if test = "from/conj/atom and have/variables">
    <xsl:text> there exist </xsl:text>
  </xsl:if>
  
  <xsl:if test = "not(from/conj/atom) and have/variables">
    <xsl:text>There exist </xsl:text>
  </xsl:if>

  <xsl:for-each select="have/variables/variable">

    <xsl:choose>
      <xsl:when test = "@type = 'plane'">
	<xsl:value-of select= "@type"/>
	<xsl:text> $\</xsl:text>  
	<xsl:value-of select="@name"/>
	<xsl:text>$, </xsl:text>
      </xsl:when>
      
      <xsl:otherwise>
	<xsl:value-of select= "@type"/>
	<xsl:text> $</xsl:text>  
	<xsl:value-of select="@name"/>
	<xsl:text>$, </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
  
  
  
  <xsl:if test = "have/obtain_witness">
    <xsl:text> where </xsl:text>
  </xsl:if>

  <xsl:if test="have/variables">
    <xsl:text>such that </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/variables) and (have/dnf/conj/atom) and 
		  from">
    <xsl:text> it holds that </xsl:text>
  </xsl:if>
  
  <xsl:if test = "not(have/variables) and (have/dnf/conj/atom) and 
		  not(from)">
    <xsl:text>It holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "have">

    <xsl:for-each select="have/dnf/conj">
      <xsl:for-each select="atom">
        <xsl:text>$</xsl:text>
        <xsl:apply-templates select="."/>
        <xsl:text>$</xsl:text>
        <xsl:if test="position()!=last()">
          <xsl:text> and </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:if test= "position()!= last()">
        <xsl:text> or </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom)">
    <xsl:text> we have contradiction</xsl:text>
  </xsl:if>

  <xsl:text>.</xsl:text>
   
</xsl:template>

<xsl:template match="variables">
     <xsl:apply-templates />         
</xsl:template>

<xsl:template match="variable">
     <xsl:value-of select="@name"/>
</xsl:template>
<xsl:template match="witnes">
   <xsl:value-of select="."/>       
</xsl:template>



<xsl:template match="from">
    <xsl:apply-templates />         
</xsl:template>


<xsl:template match="have">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="dnf">

  <xsl:for-each select="conj">
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="." />
    <xsl:text>)</xsl:text>
    <xsl:if test="position()!=last()">
      <xsl:text> \; </xsl:text>
      <xsl:text> \vee </xsl:text>
      <xsl:text> \; </xsl:text>      
    </xsl:if>
  </xsl:for-each>

</xsl:template>

<xsl:template match="conj">

  <xsl:for-each select = "atom">
    <xsl:text>$</xsl:text>
    <xsl:apply-templates select = "."/>
    <xsl:text>$</xsl:text>
    <xsl:if test = "position()!=last()">
      <xsl:text> and </xsl:text>
    </xsl:if>
  </xsl:for-each>

</xsl:template>

<xsl:include href="layout.xsl" />

<xsl:template match="theorem_name">
    <font class="name"><xsl:value-of select="."/>.</font>
</xsl:template>


<xsl:template match="proof">
  <xsl:apply-templates />         
</xsl:template>

<xsl:template match="proof_step">
   <xsl:if test = "modus_ponens">     
     <xsl:if test = "indentation">
       <xsl:text>&#xa;\proofstep{</xsl:text>
       <xsl:value-of select = "indentation/@depth"/>
       <xsl:text>} </xsl:text>
       <xsl:text>{</xsl:text>
     </xsl:if>

     <xsl:apply-templates select = "modus_ponens"/>
   </xsl:if>
   
   <xsl:if test = "modus_ponens and indentation">
     <xsl:text>} </xsl:text>
   </xsl:if>
</xsl:template>

<xsl:template match="proof_closing">
   
   <xsl:if test = "from">     
     <xsl:if test = "indentation">
       <xsl:text>&#xa;&#xa;\proofstep{</xsl:text>
       <xsl:value-of select = "indentation/@depth"/>
       <xsl:text>} </xsl:text>
       <xsl:text>{</xsl:text>
     </xsl:if>

     <xsl:if test = "not(case_split) and count(from/conj/atom) = 1">
       <xsl:text>The conclusion follows from the fact </xsl:text>
     </xsl:if>

     <xsl:if test = "not(case_split) and count(from/conj/atom) > 1">
       <xsl:text>The conclusion follows from the facts </xsl:text>
     </xsl:if>

     <xsl:for-each select = "from/conj/atom">
       <xsl:text>$</xsl:text>
       <xsl:apply-templates select = "."/>
       <xsl:text>$</xsl:text>
       <xsl:if test = "position()!=last()">
	<xsl:text> and </xsl:text>
       </xsl:if>
     </xsl:for-each>

     <xsl:if test = "not(case_split)"> 
       <xsl:text>.</xsl:text>
     </xsl:if>
   </xsl:if>

   <xsl:apply-templates select="efq"/>

   <xsl:if test = "case_split">
     <xsl:apply-templates select = "case_split/assumption"/>     
     <xsl:apply-templates select = "proof"/>

     <xsl:apply-templates select = "case_split/disjunction_elimination"/>
   </xsl:if>
     
   <xsl:if test = "goal_reached_thesis">

     <xsl:if test = "not(case_split) and not(from)">
       <xsl:if test = "indentation">
	 <xsl:text> \proofstepnonum{</xsl:text>
	 <xsl:value-of select = "indentation/@depth"/>
	 <xsl:text>} </xsl:text>
	 <xsl:text>{ </xsl:text>
       </xsl:if>
       
       <xsl:text>This proves the conjecture.</xsl:text>
       
       <xsl:if test = "indentation">
	 <xsl:text>} </xsl:text>
       </xsl:if>
       
     </xsl:if>

     <!--
	<xsl:if test = "not(case_split) and (from)">
	  <xsl:text> we proved a conjecture. </xsl:text>
	</xsl:if>
	--> 
   </xsl:if>

   <xsl:if test = "indentation and from">
     <xsl:text>} </xsl:text>
   </xsl:if>
</xsl:template>

<xsl:template match="modus_ponens">

  <xsl:if test="from">
    <xsl:if test="count(from/conj/atom) = 1">
      <xsl:text>From the fact </xsl:text>
    </xsl:if>
    <xsl:if test="count(from/conj/atom) > 1">
      <xsl:text>From the facts </xsl:text>
    </xsl:if>
    <xsl:for-each select = "from/conj/atom">
      <xsl:text>$</xsl:text>
      <xsl:apply-templates select = "."/>
      <xsl:text>$</xsl:text>
      <xsl:if test = "position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:if>

  <xsl:if test="have/obtain_witness">

    <xsl:if test="from">
      <xsl:text> there exist </xsl:text>
    </xsl:if>
    <xsl:if test="not(from)">
      <xsl:text>There exist </xsl:text>
    </xsl:if>

    <xsl:for-each select="have/obtain_witness/constant">
      <xsl:text>a </xsl:text>

    <xsl:choose>
      <xsl:when test = "@type = 'plane'">
	<xsl:value-of select= "@type"/>
	<xsl:text> $\</xsl:text>  
	<xsl:value-of select="@name"/>
	<xsl:text>$, </xsl:text>
      </xsl:when>
      
      <xsl:otherwise>
	<xsl:value-of select= "@type"/>
	<xsl:text> $</xsl:text>  
	<xsl:value-of select="@name"/>
	<xsl:text>$</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

      <!--
      <xsl:value-of select="@type"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="@name"/>
      -->  
      <xsl:if test="position()!=last()">
	<xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:for-each>  
    
    <xsl:text> where </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/obtain_witness) and have/dnf/conj/atom and from">
    <xsl:text> it holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "not(have/obtain_witness) and have/dnf/conj/atom and 
		  not(from)">
    <xsl:text>It holds that </xsl:text>
  </xsl:if>

  <xsl:if test = "have">

    <xsl:for-each select="have/dnf/conj">                                    
      <xsl:for-each select="atom">
        <xsl:text>$</xsl:text>
        <xsl:apply-templates select="."/>
        <xsl:text>$</xsl:text>                                      
        <xsl:if test="position()!=last()"> 
          <xsl:text> and </xsl:text> 
        </xsl:if>                                                           
      </xsl:for-each>                                      
      <xsl:if test= "position()!= last()">
        <xsl:text> or </xsl:text> 
      </xsl:if>                                                        
    </xsl:for-each> 
  </xsl:if>

  <xsl:if test = "not(have/dnf/conj/atom)">
    <xsl:text> we get contradiction</xsl:text>
  </xsl:if>

  <xsl:if test = "@axiom_name">

    <xsl:variable name = "first_predicate" 
		  select = "have/dnf/conj[1]/atom/relation_symbol/@name"/>
    <xsl:variable name = "second_predicate" 
		  select = "have/dnf/conj[2]/atom/relation_symbol/@name"/>

    <xsl:choose>
      <xsl:when test = "not(have/dnf/conj/atom)">
	<xsl:text></xsl:text>
      </xsl:when>

      <xsl:when test = "not(count(have/dnf/conj) = 2 and
			((starts-with($first_predicate, 'not_') and 
			substring-after($first_predicate,'not_') =
			$second_predicate) or 
			(starts-with($second_predicate, 'not_') and 
			substring-after($second_predicate,'not_') =
			$first_predicate)))">

	<xsl:text> (using $</xsl:text>
	<xsl:value-of select = "@axiom_name"/>
	<xsl:text>$)</xsl:text>
      </xsl:when>

      <xsl:otherwise>
<!--	<xsl:text>(by excl uded middle)</xsl:text>-->
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>

  <xsl:text>.</xsl:text>
</xsl:template>

<xsl:template match="case_split">
  <xsl:text>Proof cases:</xsl:text>
  
  <saxon:assign name="counter" select="$counter+1"/> 
  <xsl:text> promenljiva: </xsl:text>
  <xsl:value-of select="$counter"/> 
  <xsl:apply-templates />         
</xsl:template>


<xsl:template match="assumption">
   
   <xsl:text> &#xa;&#xa;\proofstep{</xsl:text>
   <xsl:value-of select = "../../indentation/@depth"/>   
   <xsl:text>} </xsl:text>

   <xsl:text> {</xsl:text>
   <xsl:text>Assume that: </xsl:text>
   <xsl:apply-templates  select="conj"/> 
   <xsl:text>.} </xsl:text>
     
   <xsl:apply-templates  select="proof"/> 
   
</xsl:template>

<xsl:template match="disjunction_elimination">

     <xsl:if test = "../../indentation">
       <xsl:text>&#xa;\proofstep{</xsl:text>
       <xsl:value-of select = "../../indentation/@depth - 3"/>
       <xsl:text>} </xsl:text>
       <xsl:text>{The conjecture follows in all cases.}</xsl:text>
   </xsl:if>

<!--
    <xsl:text> $</xsl:text>
    
    <xsl:for-each select="dnf/conj">
      <xsl:text> (</xsl:text>
      <xsl:for-each select = "atom">
	<xsl:apply-templates select = "."/>
	<xsl:if test = "position()!=last()">
	  <xsl:text> \wedge </xsl:text> 
	</xsl:if>
      </xsl:for-each>
      <xsl:text>)</xsl:text>
      
      <xsl:if test="position()!=last()">
	<xsl:text> \; </xsl:text>
	<xsl:text> \vee </xsl:text>
	<xsl:text> \; </xsl:text>
	
      </xsl:if>
    </xsl:for-each>
    
 
    <xsl:text> $ </xsl:text>
-->
    
</xsl:template>

</xsl:stylesheet>
