<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:strip-space elements="*"/>

<xsl:template match="atom">

  <xsl:choose>

    <!-- equality of planes, we use \ infront of name of the plane -->
    <xsl:when test = "relation_symbol/@name = 'eq_plane'">
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> = </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>    

    <xsl:when test = "@type = 'equal'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> = </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>
    
    <!-- ako je u pitanju nejednakost ravni onda se ispisuju sa \ ispred -->
    <xsl:when test = "relation_symbol/@name = 'not_eq_plane'">
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \neq </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>    

    <xsl:when test = "@type = 'not_equal'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \neq </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'cong'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \cong </xsl:text>
      <xsl:value-of select="parameter[3]"/>
      <xsl:value-of select="parameter[4]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_cong'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text>\not \cong </xsl:text>
      <xsl:value-of select="parameter[3]"/>
      <xsl:value-of select="parameter[4]"/>
    </xsl:when>

    <!-- prvo navodimo predikate vezane za ravni da bi ih ispisali sa \
         ispred imena ravni -->

    <xsl:when test = "relation_symbol/@name = 'not_inc_po_pl'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \not \in </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'inc_po_pl'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \in </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_inc_l_pl'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \not \in </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'inc_l_pl'">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \in </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'int_l_l'">
      <xsl:text> \textrm{lines } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and } </xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ intersect} </xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_int_l_l'">
      <xsl:text> \textrm{lines } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and } </xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ don't intersect}  </xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'int_pl_pl'">
      <xsl:text> \textrm{planes } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ intersect} </xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_int_pl_pl'">
      <xsl:text> \textrm{planes } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ don't intersect} </xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'int_l_pl'">
      <xsl:text> \textrm{line } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and plane } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ intersect} </xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_int_l_pl'">
      <xsl:text> \textrm{line } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ and plane } </xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text> \textrm{ don't intersect}</xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'pash'">
      <xsl:text> \textrm{pash}( </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[3]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[4]"/>
      <xsl:text>,</xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[5]"/>
      <xsl:text>)</xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_pash'">
      <xsl:text> \neg \textrm{pash}( </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[3]"/>
      <xsl:text>,</xsl:text>
      <xsl:value-of select="parameter[4]"/>
      <xsl:text>,</xsl:text>
      <xsl:text>\</xsl:text>
      <xsl:value-of select="parameter[5]"/>
      <xsl:text>)</xsl:text>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'cut'">
      <xsl:text> \textrm{line } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ intersects segment }</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:value-of select="parameter[3]"/>
    </xsl:when>

    <xsl:when test = "relation_symbol/@name = 'not_cut'">
      <xsl:text> \textrm{line } </xsl:text>
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \textrm{ doesn't intersect segment }</xsl:text>
      <xsl:value-of select="parameter[2]"/>
      <xsl:value-of select="parameter[3]"/>
    </xsl:when>

    <xsl:when test = "starts-with(relation_symbol/@name, 'not_inc_')">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \not \in </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:when test = "starts-with(relation_symbol/@name, 'inc_')">
      <xsl:value-of select="parameter[1]"/>
      <xsl:text> \in </xsl:text>
      <xsl:value-of select="parameter[2]"/>
    </xsl:when>

    <xsl:otherwise>
      <!--<xsl:if test="@type = 'general'">-->      
      <xsl:choose>
	<xsl:when test = "starts-with(relation_symbol/@name, 'not_')">
	  <xsl:text>\neg </xsl:text>
	  <xsl:value-of 
	     select="substring-after(relation_symbol/@name,'not_')"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="relation_symbol/@name"/>
	</xsl:otherwise>
      </xsl:choose>
      
      <xsl:text>(</xsl:text>
      <xsl:for-each select="parameter">
	<xsl:value-of select = "."/>       
	<xsl:if test="position()!=last()">
	  <xsl:text>, </xsl:text>
	</xsl:if>
      </xsl:for-each>
      <xsl:text>)</xsl:text>
    </xsl:otherwise>
    
    </xsl:choose>
    
  </xsl:template>
  
</xsl:stylesheet>
