(*    Title:              MoreList.thy
      ID:                 $Id: MoreList.thy$
      Author:             Filip Maric
*)

theory MoreList
(* Theory contains some additional lemmas about the list datatype *)

imports Main
begin

(*********************************************************)
(*                      mem                              *)
(*********************************************************)
lemma nonEmptyList: 
  assumes "x mem list"
  shows "list ~= []"
using assms
by (induct list) auto

lemma lengthNonEmptyList:
  assumes "list ~= []"
  shows "length list > 0"
using assms
by auto

lemma memAppend: 
"x mem (list1 @ list2) = (x mem list1 | x mem list2)"
by (induct list1) auto


(*********************************************************)
(*               last & butlast                          *)
(*********************************************************)
lemma listEqualsButlastAppendLast: 
  assumes "list ~= []"
  shows "list = butlast list @ [last list]"
using assms
by (induct list) auto


lemma lastListMemList [simp]:
  assumes "list ~=[] "
  shows "last list mem list"
using assms
by (induct list) auto

lemma memButlastImpliesMemList: 
  assumes "x mem butlast list"
  shows "x mem list"
using assms
by (induct list) (auto split:split_if_asm)

lemma memListImpliesMemButlastOrLast:
  assumes "x mem list"
  shows "x mem butlast list | x = last list"
using assms
by(induct list) auto

lemma butlastAppend: 
"butlast (list1 @ list2) = (if list2=[] then butlast list1 else list1 @ butlast list2)"
by(induct list1) auto

(*********************************************************)
(*               head & tail                             *)
(*********************************************************)
lemma headNonEmptyListMemList:
  assumes "list ~= []"
  shows "hd list mem list"
using assms
by (induct list) auto

(*********************************************************)
(*                   remove                              *)
(*********************************************************)
consts
remove :: "'a => 'a list => 'a list"

primrec
"remove x [] = []"
"remove x (h#t) = (if x=h then remove x t else h # remove x t)"

lemma removeAppend [simp]: 
"remove x (list1 @ list2) = remove x list1 @ remove x list2"
by (induct list1) auto

lemma memRemoveImpliesMemList:
  assumes "x mem remove a list" 
  shows "x mem list"
using assms
by (induct list) (auto split: split_if_asm)

lemma memRemoveImpliesNotRemoved:
  assumes "x mem remove a list" 
  shows "x ~= a"
using assms
by (induct list) (auto split: split_if_asm)

lemma removedNotMemRemove: 
  shows "~x mem remove x list"
by (induct list) auto

lemma memListImpliesMemRemoveOrRemoved:
  assumes "x mem list"
  shows "x mem remove a list | x=a"
using assms
by (induct list) auto

lemma removeNonMember: 
  assumes "~a mem list"
  shows "remove a list = list"
using assms
by (induct list) auto

lemma lengthRemoveMember:
  assumes "a mem list"
  shows "length (remove a list) < length list"
using assms
proof (induct list)
  case (Cons x list')
  thus ?case
  proof (cases "a mem list'")
    case True
    with Cons
    show ?thesis
      by auto
  next
    case False
    from `~a mem list'` and removeNonMember[of "a" "list'"]
    have "remove a list' = list'"
      by simp
    moreover
    from `~a mem list'` and `a mem x # list'`
    have "a = x"
      by (simp add:mem_iff)
    ultimately
    show ?thesis
      by auto
  qed
qed simp

lemma lengthRemove:
  shows "length (remove x list) <= length list"
by (induct list) auto

(* TODO: remove - easy consequence of memRemoveImpliesMemList and memAppend *)
lemma memRemoveL1AppendL2: 
  "x mem remove a list1 @ list2 --> x mem list1 @ list2"
by (induct list1) auto


(*********************************************************)
(*                   uniq                                *)
(*********************************************************)

consts
(* (uniq list) iff there are no repeated elements        *)
uniq :: "'a list => bool"
primrec
"uniq [] = True"
"uniq (h#t) = (~h mem t & uniq t)"

lemma uniqAppend: 
  assumes "uniq (list1 @ list2)"
  shows "uniq list1" and "uniq list2"
using assms
by (induct list1) (auto simp add: memAppend)

lemma uniqAppendElement: 
  assumes "uniq list" 
  shows "~e mem list = uniq (list @ [e])"
using assms
by (induct list) (auto split: split_if_asm simp add: memAppend)

lemma uniqImpliesNotLastMemButlast:
  assumes "uniq list"
  shows "~last list mem butlast list"
proof (cases "list = []")
  case True
  thus ?thesis
    using assms
    by simp
next
  case False
  then have "list = (butlast list) @ [(last list)]"
    by (rule listEqualsButlastAppendLast)
  moreover
  with `uniq list` have "uniq (butlast list)"
    using uniqAppend[of "butlast list" "[(last list)]"]
    by simp
  ultimately
  show ?thesis
    using assms
    using uniqAppendElement[of "butlast list" "last list"]
    by simp
qed

lemma uniqButlastNotUniqListImpliesLastMemButlast: 
  assumes "uniq (butlast list)" "~uniq list" 
  shows "last list mem (butlast list)"
proof (cases "list = []")
  case True
  thus ?thesis
    using assms
    by auto
next
  case False
  then have "list = (butlast list) @ [(last list)]"
    by (rule listEqualsButlastAppendLast)
  thus ?thesis
    using assms
    using uniqAppendElement[of "butlast list" "last list"]
    by auto
qed

end