section{* Combinatorics *}

theory Combinatorics
imports Main
  "HOL-Library.Permutation"
  "HOL-Library.List_lexord"
  "More.MoreList"
begin

(* ************************************************************************** *)
subsection{* Generating all permutations *}
(* ************************************************************************** *)

primrec interleave :: "'a \<Rightarrow> 'a list \<Rightarrow> 'a list list" where
  "interleave x [] = [[x]]"
| "interleave x (h # t) = (x # (h # t)) # (map (\<lambda> l. h # l) (interleave x t))"

text{* For example, @{lemma "interleave (1::nat) [2, 3, 4] = [[1, 2, 3, 4], [2, 1, 3, 4], [2, 3, 1, 4], [2, 3, 4, 1]]" by simp}. *}

primrec permute :: "'a list \<Rightarrow> 'a list list" where
  "permute [] = [[]]"
| "permute (h # t) = concat (map (\<lambda> l. interleave h l) (permute t))"

text{* For example, @{lemma "permute [1::nat, 2, 3] = [[1, 2, 3], [2, 1, 3], [2, 3, 1], [1, 3, 2], [3, 1, 2], [3, 2, 1]]" by simp}. *}

lemma multiset_interleave: 
  shows "p \<in> set (interleave h a) \<Longrightarrow> mset p = mset a + {#h#}"
proof (induct a arbitrary: p) 
  case Nil
  thus ?case
    by simp
next
  case (Cons h' t')
  thus ?case
    using add.commute[of "{#h#}" "{#h'#}"]
    using add.assoc [of "mset t'" "{#h#}" "{#h'#}"]
    using add.assoc [of "mset t'" "{#h'#}" "{#h#}"]
    by auto
qed

lemma interleave_hd [simp]: "h # t \<in> set (interleave h t)"
by (cases "t") auto

lemma interleave_append [simp]: "t1 @ [h] @ t2 \<in> set (interleave h (t1 @ t2))"
by (induct t1) auto

lemma isPermutation_permute: 
  shows "p \<in> set (permute l) \<Longrightarrow> p <~~> l"
proof (induct l arbitrary: p)
  case Nil
  thus ?case
    by (simp add: mset_eq_perm)
next
  case (Cons h t)
  thus ?case
    unfolding mset_eq_perm[THEN sym]
    by (auto simp add: multiset_interleave)
qed

(* TODO: Move to MoreMultiset *)

lemma mset_append:
  assumes "mset p = mset t + {#h#}"
  shows "\<exists> t1 t2. p = t1 @ [h] @ t2 \<and> mset t = mset t1 + mset t2"
using assms
proof (induct p arbitrary: t)
  case Nil
  thus ?case
    by simp
next
  case (Cons a p')
  show ?case
  proof (cases "a = h")
    case True
    thus ?thesis
      using Cons(2)
      by (rule_tac x="[]" in exI) auto
  next
    case False
    hence "h \<in># mset p'"
      using Cons(2) insert_noteq_member[of a "mset p'"] 
      by auto
    hence "mset p' = mset p' - {#h#} + {#h#}"
      using insert_DiffM2[of h "mset p'"]
      by simp
    thus ?thesis
      using Cons(1)[of "remove1 h p'"] Cons(2)
      by (auto, rule_tac x="a#t1" in exI, auto) 
  qed
qed

lemma permute_isPermutation: 
  "p <~~> l \<Longrightarrow> p \<in> set (permute l)"
proof (induct l arbitrary: p)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  obtain t1 t2 where "p = t1 @ [h] @ t2" "mset t = mset t1 + mset t2"
    using Cons(2)
    unfolding mset_eq_perm[THEN sym]
    using mset_append[of p t h]
    by auto
  thus ?case
    using Cons(1)[of "t1 @ t2"] Cons(2)
    using add.assoc [of "mset t1" "mset t2" "{#h#}"]
    using interleave_append[of t1 h t2]
    unfolding mset_eq_perm[THEN sym]
    by auto
qed


lemma permute_bij:
  assumes "p \<in> set (permute l)"
  shows "\<exists> f. bij_betw f {..<length p} {..<length l} \<and>
       (\<forall> i<length p. p ! i = l ! (f i))"
  using assms
  using isPermutation_permute[of p l]
  using permutation_Ex_bij[of p l]
  by auto

(* ************************************************************************** *)
subsection{* Generating all combinations *}
(* ************************************************************************** *)

fun combine_aux :: "'a list \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> 'a list list" where
 "combine_aux l n k = 
     (if k = 0 then [[]] else 
      if k = n then [l] else
      (case l of 
          [] \<Rightarrow> []
      | (h # t) \<Rightarrow> 
             (map (\<lambda> l'. h # l') (combine_aux t (n-(1::nat)) (k-(1::nat)))) @ 
                   combine_aux t (n-(1::nat)) k))"
declare combine_aux.simps[simp del]

lemma combine_aux_induct:
  assumes 
  "\<And> l n. P [[]] l n 0"
  "\<And> l n. 0 < n \<Longrightarrow> P [l] l n n" 
  "\<And> k n. \<lbrakk>0 < k; k \<noteq> n\<rbrakk> \<Longrightarrow> P [] [] n k"
  "\<And> h t n k. \<lbrakk>
     P (combine_aux t (n-(1::nat)) (k-(1::nat))) t (n-(1::nat)) (k-(1::nat));
     P (combine_aux t (n-(1::nat)) k) t (n-(1::nat)) k\<rbrakk> \<Longrightarrow> 
     P (map (op # h) (combine_aux t (n-(1::nat)) (k-(1::nat))) @
          combine_aux t (n-(1::nat)) k) (h # t) n k"
  shows "P (combine_aux l n k) l n k"
using assms
proof (induct l n k rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k=0")
    case True
    thus ?thesis
      using 1(3)
      by (simp add: combine_aux.simps)
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0`
        using 1(4)
        by (simp add: combine_aux.simps)
    next
      case False
      show ?thesis
      proof (cases "l = []")
        case True
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(5)
          by (simp add: combine_aux.simps)
      next
        case False
        then obtain h t where "l = h # t" by (auto simp add: neq_Nil_conv)
        let ?l1 = "combine_aux t (n-(1::nat)) (k-(1::nat))"
        let ?l2 = "combine_aux t (n-(1::nat)) k"
        have "P ?l1 t (n-(1::nat)) (k-(1::nat))"
          using 1(1)[of h t] 1(3-6)  `k \<noteq> 0` `k \<noteq> n` `l = h # t`
          by auto
        moreover
        have "P ?l2 t (n-(1::nat)) k"
          using 1(2)[of h t] 1(3-6)  `k \<noteq> 0` `k \<noteq> n` `l = h # t`
          by auto
        ultimately
        show ?thesis
          using `l = h # t` `k \<noteq> 0` `k \<noteq> n`
          using combine_aux.simps[of l n k] 1(6)
          by simp
      qed
    qed
  qed
qed

definition combine :: "'a list \<Rightarrow> nat \<Rightarrow> 'a list list" where 
  "combine l k = combine_aux l (length l) k"

text{* For example, @{lemma "combine [1::nat, 2, 3] 2 = [[1, 2], [1, 3], [2, 3]]" by (simp add: combine_def combine_aux.simps)}. *}

lemma combine_aux_subset:
  shows "\<forall> A. A \<in> set (combine_aux l n k) \<longrightarrow> set A \<subseteq> set l"
by (rule combine_aux_induct) (auto, force)

lemma combine_subset:
  assumes "A \<in> set (combine l k)"
  shows "set A \<subseteq> set l"
using assms
using combine_aux_subset[rule_format, of A l "length l" k]
unfolding combine_def
by simp

lemma combine_aux_sublist:
  shows "\<forall> A. A \<subseteq> set L \<and> n = length L \<and> m = card A \<longrightarrow> (\<exists>x\<in>set (combine_aux L n m). A = set x)"
proof (rule combine_aux_induct[where P = "\<lambda> c l n m. (\<forall> A. A \<subseteq> set l \<and> n = length l \<and> m = card A \<longrightarrow> (\<exists>x \<in> set c. A = set x))"])
  fix l :: "'a list" and n :: nat
  show "\<forall>A. A \<subseteq> set l \<and> n = length l \<and> 0 = card A \<longrightarrow> (\<exists>x\<in>set [[]]. A = set x)"
    by (auto simp add: card_eq_0_iff finite_subset)
next
  fix l :: "'a list" and n :: nat
  assume "n > (0::nat)"
  thus "\<forall>A. A \<subseteq> set l \<and> n = length l \<and> n = card A \<longrightarrow> (\<exists>x\<in>set [l]. A = set x)"
    using subset_card_length
    by auto
next
  fix h :: "'a" and t :: "'a list" and n :: nat and k :: nat
  let ?l1 = "combine_aux t (n - 1) (k - 1)" and
      ?l2 = "(combine_aux t (n - 1) k)"
  assume *: "\<forall>A. A \<subseteq> set t \<and> n - 1 = length t \<and> k - 1 = card A \<longrightarrow> (\<exists>x\<in>set ?l1. A = set x)" and
    **: "\<forall>A. A \<subseteq> set t \<and> n - 1 = length t \<and> k = card A \<longrightarrow> (\<exists>x\<in>set ?l2. A = set x)"
  show "\<forall>A. A \<subseteq> set (h # t) \<and> n = length (h # t) \<and> k = card A \<longrightarrow>
              (\<exists>x\<in>set (map (op # h) (?l1) @ ?l2). A = set x)"
  proof (rule allI, rule impI, (erule conjE)+)
    fix A'
    assume "A' \<subseteq> set (h # t)" "n = length (h # t)" "k = card A'"
    show "\<exists>x\<in>set (map (op # h) (?l1) @ ?l2). A' = set x"
    proof (cases "h \<in> A'")
      case False
      hence "A' \<subseteq> set t"
        using `A' \<subseteq> set (h # t)`
        by auto
      thus ?thesis
        using **[rule_format, of A'] `n = length (h # t)` `k = card A'`
        by auto
    next
      case True
      hence "\<exists>x\<in>set ?l1. (A' - {h}) = set x"
        using *[rule_format, of "A' - {h}"]  `n = length (h # t)` `k = card A'` `A' \<subseteq> set (h # t)`
        using card_Diff_singleton[of A' h] finite_subset[of A' "set (h # t)"]
        by auto
      then obtain x where "x\<in>set ?l1" "(A' - {h}) = set x"
        by auto
      thus ?thesis
        using `h \<in> A'`
        by (rule_tac x="h # x" in bexI) auto
    qed
  qed
qed simp

lemma combine_sublist:
  assumes "A \<subseteq> set L"
  shows "\<exists>x\<in>set (combine L (card A)). A = set x"
using assms
using combine_aux_sublist[rule_format, of A L "length L" "card A"]
unfolding combine_def
by simp

lemma combine_aux_combines:
  assumes "sorted l" and "distinct l" and "n = length l"
  shows "A \<in> set (combine_aux l n k) \<longleftrightarrow> sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set l"
using assms 
proof (induct l n k  arbitrary: A rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by (auto simp add: combine_aux.simps)
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0` `sorted l` `distinct l` `n = length l`
        using distinct_card[of l] distinct_card[of A]
        using card_seteq[of "set l" "set A"]
        using sorted_distinct_set_unique[of A l]
        by (auto simp add: combine_aux.simps)
    next
      case False
      show ?thesis
      proof (cases "l = []")
        case True
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by (auto simp add: combine_aux.simps)
      next
        case False
        then obtain h t where "l = h # t" by (auto simp add: neq_Nil_conv)
        let ?l1 = "combine_aux t (n-(1::nat)) (k-(1::nat))"
        let ?l2 = "combine_aux t (n-(1::nat)) k"
        have "sorted t"
          using 1(3) `l = h # t`
          by (auto simp add: sorted_Cons)

        have "A \<in> set (combine_aux l n k) = (A \<in> set (map (\<lambda> l'. h # l') ?l1) \<or> A \<in> set ?l2)"
          using `k \<noteq> 0` `k \<noteq> n` `l = h # t`
          by (simp add: combine_aux.simps)
        moreover
        have "A \<in> set ?l2 = (sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set t)"
          using 1(2)[of h t A]   `k \<noteq> 0` `k \<noteq> n` `l = h # t` `sorted t` 1(4) 1(5)
          by simp
        moreover
        have "A \<in> set (map (\<lambda> l'. h # l') ?l1) = (sorted A \<and> distinct A \<and> length A = k \<and> \<not> set A \<subseteq> set t \<and> set A \<subseteq> set l)"
        proof-
          have "(tl A \<in> set ?l1) =
                (sorted (tl A) \<and> distinct (tl A) \<and> length (tl A) = k - 1 \<and> set (tl A) \<subseteq> set t)"
            using 1(1)[of h t "tl A"] `l = h # t` `sorted t` 1(4) 1(5) `k \<noteq> 0` `k \<noteq> n`
            by simp
          moreover
          have "A \<in> set (map (\<lambda> l'. h # l') ?l1) = (A = h # (tl A) \<and> (tl A \<in> set ?l1))"
            by auto
          moreover
          have "\<forall> x \<in> set t. h \<le> x" "h \<notin> set t"
            using `sorted l` `distinct l` `l = h # t`
            by (auto simp add: sorted_Cons)

          have "(A = h # tl A \<and> sorted (tl A) \<and> distinct (tl A) \<and> length A - 1 = k - 1 \<and> set (tl A) \<subseteq> set t) =
                (sorted A \<and> distinct A \<and> length A = k \<and> \<not> set A \<subseteq> set t \<and> set A \<subseteq> insert h (set t))" (is "?lhs = ?rhs")
          proof (rule iffI, (erule_tac[!] conjE)+)
            assume "A = h # tl A" "sorted (tl A)" "distinct (tl A)" "length A - 1 = k - 1" "set (tl A) \<subseteq> set t"
            show ?rhs
            proof (safe)
              show "length A = k"
              proof-
                have "length A \<noteq> 0"
                  using `A = h # tl A`
                  by auto
                show ?thesis
                  using `length A - 1 = k - 1` `k \<noteq> 0` `length A \<noteq> 0`
                  by arith
              qed
            next
              show "sorted A"
                apply (subst `A = h # tl A`, subst sorted_Cons)
                using `sorted (tl A)` `set (tl A) \<subseteq> set t` `\<forall> x \<in> set t. h \<le> x`
                by auto
            next
              show "distinct A"
                apply (subst `A = h # tl A`)
                using `distinct (tl A)` `h \<notin> set t` `set (tl A) \<subseteq> set t`
                by auto
            next
              assume "set A \<subseteq> set t"
              thus "False"
                apply (subst (asm) `A = h # tl A`) 
                using `h \<notin> set t`
                by auto
            next
              fix x
              assume "x \<in> set A" "x \<notin> set t"
              thus "x = h"
                apply (subst (asm) `A = h # tl A`)
                using `set (tl A) \<subseteq> (set t)`
                by auto
            qed
          next
            assume "sorted A" "distinct A" "length A = k" "\<not> set A \<subseteq> set t" "set A \<subseteq> insert h (set t)"
            show "?lhs"
            proof (safe)
              show "sorted (tl A)"
                using `sorted A`
                by (rule linorder_class.sorted_tl)
            next
              show "distinct (tl A)"
                using `distinct A`
                by (rule distinct_tl)
            next
              show "A = h # tl A"
              proof-
                have "h \<in> set A" "A \<noteq> []"
                  using `\<not> set A \<subseteq> set t` `set A \<subseteq> insert h (set t)`
                  by auto
                have "A = hd A # tl A"
                  using `A \<noteq> []`
                  by simp
                show ?thesis
                proof (cases "hd A = h")
                  case True
                  thus ?thesis
                    using `A \<noteq> []`
                    by auto
                next
                  case False
                  from `h \<in> set A` have "h = hd A \<or> h \<in> set (tl A)"
                    by (subst (asm) `A = hd A # tl A`) auto
                  hence "h \<in> set (tl A)"
                    using `hd A \<noteq> h`
                    by auto
                  have "hd A < h"
                    using `sorted A`
                    apply (subst (asm) `A = hd A # tl A`)
                    using `h \<in> set (tl A)` `hd A \<noteq> h`
                    by (auto simp add: sorted_Cons)
                  moreover
                  have "hd A \<in> set t"
                    using `set A \<subseteq> insert h (set t)` 
                    apply (subst (asm) `A = hd A # tl A`)
                    using `hd A \<noteq> h`
                    by simp
                  hence "h \<le> hd A"
                    using `\<forall> x \<in> set t. h \<le> x`
                    by simp
                  ultimately
                  show ?thesis
                    by simp
                qed
              qed

              fix x
              assume "x \<in> set (tl A)"
              show "x \<in> set t"
              proof-
                have "x \<in> set A"
                  using `x \<in> set (tl A)`
                  by (subst `A = h # tl A`) simp
                hence "x \<in> insert h (set t)"
                  using `set A \<subseteq> insert h (set t)`
                  by auto
                have "x \<noteq> h"
                  using `distinct A`
                  apply (subst (asm) `A = h # tl A`) 
                  using  `x \<in> set (tl A)`
                  by auto
                show "x \<in> set t"
                  using `x \<in> insert h (set t)` `x \<noteq> h`
                  by auto
              qed
            next
              show "length A - 1 = k - 1"
                using `length A = k`
                by simp
            qed
          qed
          ultimately
          show ?thesis
            using `l = h # t`
            by simp
        qed
        ultimately
        show ?thesis
          using `l = h # t`
          by auto
      qed
    qed
  qed
qed

lemma combine_combines:
  assumes 
  "sorted l" and "distinct l"
  shows
  "A \<in> set (combine l k)  \<longleftrightarrow> (sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set l)"
using assms
unfolding combine_def
using combine_aux_combines[of l "length l" A k]
by simp

lemma combine_aux_length:
  assumes "A \<in> set (combine_aux l n k)" and "length l = n"
  shows "length A = k"
using assms
proof (induct l n k arbitrary: A rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      using 1(3)
      by (simp add: combine_aux.simps)
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0` 1(3) 1(4)
        by (simp add: combine_aux.simps)
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3)
          by (simp add: combine_aux.simps)
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3) 1(4)
          using combine_aux.simps[of l n k]
          using 1(1)[of h t "tl A"] 1(2)[of h t A]
          by auto
      qed
    qed
  qed
qed

lemma combine_length:
  assumes "A \<in> set (combine l k)"
  shows "length A = k"
using assms
using combine_aux_length[of A l "length l" k]
unfolding combine_def
by simp
  
lemma distinct_combine_aux: 
  assumes "n = length l" and "distinct l"
  shows "distinct (combine_aux l n k)"
using assms
proof (induct l n k rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by (simp add: combine_aux.simps)
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        by (simp add: combine_aux.simps)
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by (simp add: combine_aux.simps)
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          using combine_aux.simps[of l n k]
          using 1(1)[of h t] 1(2)[of h t] 1(3) 1(4)
          apply (auto simp add: distinct_map inj_on_def)
          using combine_aux_subset[rule_format, of _ t "length t" k]
          by force
      qed
    qed
  qed
qed

lemma distinct_combine:
  assumes "distinct l"
  shows "distinct (combine l k)"
using assms
using distinct_combine_aux[of "length l" l k]
unfolding combine_def
by simp

lemma sorted_prepend: "sorted l = sorted (map (op # h) l)"
by (induct l) (auto simp add: sorted_Cons)

lemma sorted_combine_aux_lemma:
  fixes h :: "'a::linorder"
  assumes "\<forall>x\<in>set t. h \<le> x" and "h \<notin> set t" and "set l' \<subseteq> set t" and "l' \<noteq> []"
  shows "h # l \<le> l'"
proof-
  have "hd l' \<in> set t"
    using `l' \<noteq> []` `set l' \<subseteq> set t`
    by auto
  hence "h < hd l'"
    using `\<forall>x\<in>set t. h \<le> x` `h \<notin> set t`
    by (cases "h = hd l'") auto
  thus ?thesis
    using `l' \<noteq> []` Cons_le_Cons[of h l "hd l'" "tl l'"]
    by simp
qed

lemma sorted_combine_aux: 
  assumes "n = length l" and "sorted l" and "distinct l"
  shows "sorted (combine_aux l n k)"
using assms
proof (induct l n k rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by (simp add: combine_aux.simps)
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        by (simp add: combine_aux.simps)
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by (simp add: combine_aux.simps)
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          using combine_aux.simps[of l n k]
          using 1(1)[of h t] 1(2)[of h t] 1(3) 1(4) 1(5)
          apply (auto simp add: distinct_map inj_on_def sorted_Cons sorted_append)
          apply (subst sorted_prepend[THEN sym], simp)
          apply (rule sorted_combine_aux_lemma[of t])
          apply (simp add: combine_aux_subset)+
          apply (subst length_0_conv[THEN sym])
          using combine_aux_length
          by force
      qed
    qed
  qed
qed

lemma sorted_combine:
  assumes "sorted l" and "distinct l"
  shows "sorted (combine l k)"
using assms
using sorted_combine_aux[of "length l" l k]
unfolding combine_def
by simp
                                                         
(* ************************************************************************** *)
subsection{* Generating all nonempty subsets *}
(* ************************************************************************** *)

definition all_nonempty_subsets where 
  "all_nonempty_subsets F = concat (map (\<lambda> k. combine F k) [1..<length F + 1])"

lemma all_subs_set: "set (all_nonempty_subsets l) \<subseteq> {A. set A \<subseteq> set l \<and> length A \<ge> 1}"
unfolding all_nonempty_subsets_def
using combine_subset combine_length
by force

(* ************************************************************************** *)
subsection{* Generating all m-elements subsets of n-element set*}
(* ************************************************************************** *)

definition all_mn_subsets where
  "all_mn_subsets n m = combine [0..<n] m"

lemma all_mn_subsets:
  "set (map set (all_mn_subsets n m)) = {A. card A = m \<and> A \<subseteq> {0..<n}}" (is "?lhs = ?rhs")
unfolding all_mn_subsets_def
using combine_combines[of "[0..<n]" _ m]
by (auto simp add: distinct_card) (metis distinct_card finite_atLeastLessThan finite_sorted_distinct_unique image_iff rev_finite_subset)

lemma all_mn_subsets_completeness:
  assumes "card A = m" "A \<subseteq> {0..<n}"
  shows "\<exists> Al \<in> set (all_mn_subsets n m). set Al = A"
proof-
  from assms have "A \<in> set (map set (all_mn_subsets n m))"
    using all_mn_subsets[of n m]
    by auto
  thus ?thesis
    by auto
qed

lemma all_mn_subsets_sorted_distinct:
  assumes "A \<in> set (all_mn_subsets n m)"
  shows "sorted A \<and> distinct A"
using assms
unfolding all_mn_subsets_def
by (metis combine_combines distinct_upt sorted_upt)

lemma [simp]: "A \<in> set (all_mn_subsets n m) \<Longrightarrow> set A \<subseteq> {0..<n}"
using all_mn_subsets[of n m]
by auto

end
