section{* Covering *}

theory Covering
imports UnionClosed Frankl IsomorphicFamilies IrreducibleFamilies
begin

subsection{* Definition of Covering *}

definition FC_covered where
 "FC_covered Fc F \<equiv> \<exists> Fc'. iso Fc' Fc \<and> Fc' \<subseteq> closure F"

definition nonFC_covered where
 "nonFC_covered Nc F \<equiv> \<exists> Nc'. iso Nc Nc' \<and> closure F \<subseteq> closure Nc' \<union> {{}}"

abbreviation FCs_covered where
  "FCs_covered \<F> F \<equiv> \<exists> Fc \<in> \<F>. FC_covered Fc F"

abbreviation nonFCs_covered where
  "nonFCs_covered \<N> F \<equiv> \<exists> Nc \<in> \<N>. nonFC_covered Nc F"

definition covered where
 "covered \<F> \<N> F \<equiv> FCs_covered \<F> F \<or> nonFCs_covered \<N> F"

lemma FC_covered_sound:
  fixes Fc :: "nat set set"
  assumes "finite F" and "FC_covered Fc F" and "FC_family Fc"
  shows "FC_family F"
proof-
  from `FC_covered Fc F` obtain Fc' where "iso Fc' Fc" "Fc' \<subseteq> closure F"
    unfolding FC_covered_def
    by auto
  thus ?thesis
    using `finite F` `FC_family Fc`
    using FC_family_closure[of F]
    using FC_family_mono[of Fc' "closure F"]
    using FC_family_iso[of _ Fc']
    unfolding iso_def bij_betw_def
    by auto
qed

lemma nonFC_covered_sound:
  fixes F :: "nat set set"
  assumes "finite F'" and "nonFC_covered F' F" and "\<not> FC_family F'"
  shows "\<not> FC_family F"
proof (rule ccontr)
  assume "\<not> ?thesis"
  from `nonFC_covered F' F`
  obtain F'' where "iso F' F''" "closure F \<subseteq> closure F'' \<union> {{}}" "finite F''"
    using `finite F'`
    by (auto simp add: nonFC_covered_def finite_iso)
  hence "FC_family F''"
    using closure_subset[of "F"] FC_family_empty_set_insert
    using FC_family_mono[of F "closure F'' \<union> {{}}"] `\<not> \<not> FC_family F`
    using assms FC_family_closure[of F'']
    by auto
  thus False
    using `\<not> FC_family F'`
    using `iso F' F''`
    using FC_family_iso[of _ F']
    unfolding iso_def bij_betw_def
    by auto
qed

lemma FC_covered_mono:
  assumes "F \<subseteq> F'" "FC_covered \<F> F"
  shows "FC_covered \<F> F'"
using assms closure_mono[of F F']
unfolding FC_covered_def
by auto

lemma nonFC_covered_mono:
  assumes "F \<supseteq> F'" "nonFC_covered \<F> F"
  shows "nonFC_covered \<F> F'"
using assms closure_mono[of F' F]
unfolding nonFC_covered_def
by auto

subsection{* Covering and empty set *}

lemma FC_covered_remove_empty:
  assumes "finite F"
  shows "FC_covered Fc (F - {{}}) \<longrightarrow> FC_covered Fc F"
unfolding FC_covered_def
using closure_remove_empty[of F] assms
by auto

lemma nonFC_covered_remove_empty:
  assumes "finite F"
  shows "nonFC_covered Nc (F - {{}}) \<longrightarrow> nonFC_covered Nc F"
unfolding nonFC_covered_def
using closure_remove_empty[of F] assms
by auto

lemma covered_remove_empty:
  assumes "finite F"
  shows "covered \<F> \<N> (F - {{}}) \<longrightarrow> covered \<F> \<N> F"
using assms
using FC_covered_remove_empty[of F] nonFC_covered_remove_empty[of F]
unfolding covered_def
by auto

(* -------------------------------------------------------------------------- *)
subsection{* Covering and isomorphic families *}

lemma FC_covered_iso:
  assumes "iso F F'" and "FC_covered Fc F"
  shows "FC_covered Fc F'"
using assms
unfolding FC_covered_def
proof (safe)
  fix Fc'
  assume "iso F F'" "iso Fc' Fc" "Fc' \<subseteq> closure F"
  then obtain f g where *: "Fc' = op ` f ` Fc" "bij_betw f (\<Union> Fc) (\<Union> Fc')" "F' = op ` g ` F" "bij_betw g (\<Union> F) (\<Union> F')"
    using iso_sym[of Fc' Fc]
    unfolding iso_def
    by metis
  hence "inj_on g (\<Union> F)"
    by (simp add: bij_betw_def)

  have "\<Union>Fc' \<subseteq> \<Union>F"
    using Union_mono[OF `Fc' \<subseteq> closure F`]
    by simp
  have "inj_on g (\<Union>Fc')"
    by (rule subset_inj_on[of _ "\<Union> F"], fact+)

  let ?Fc'' = "op ` g ` Fc'"
  show "\<exists> Fc''. iso Fc'' Fc \<and> Fc'' \<subseteq> closure F'"
  proof (rule_tac x="?Fc''" in exI, safe)
    show "iso ?Fc'' Fc"
    proof-
      have "iso Fc' ?Fc''"
        unfolding iso_def
        apply (rule_tac x=g in exI)
        using `inj_on g (\<Union>Fc')`
        by (auto simp add: bij_betw_def)
      hence "iso ?Fc'' Fc'"
        by (rule iso_sym)
      thus ?thesis
        using `iso Fc' Fc`
        by (rule iso_trans)
    qed
  next
    fix x
    assume "x \<in> Fc'"
    hence "x \<in> closure F"
      using `Fc' \<subseteq> closure F`
      by auto
    thus "g ` x \<in> closure F'"
      using * closure_iso
      by auto
  qed
qed

lemma nonFC_covered_iso:
  fixes F F' :: "nat set set"
  assumes "iso F F'" and "nonFC_covered Nc F" and
          "finite (\<Union> F')" and "finite (\<Union> Nc)"
  shows "nonFC_covered Nc F'"
using assms
unfolding nonFC_covered_def
proof (safe)
  fix Nc'
  assume "iso F F'" "iso Nc Nc'" "closure F \<subseteq> closure Nc' \<union> {{}}"
  then obtain f g where *: "Nc' = op ` f ` Nc" "bij_betw f (\<Union> Nc) (\<Union> Nc')" "F' = op ` g ` F" "bij_betw g (\<Union> F) (\<Union> F')"
    using iso_sym[of Nc' Nc]
    unfolding iso_def
    by force

  have "finite (\<Union> Nc')"
    using `finite (\<Union> Nc)` `bij_betw f (\<Union> Nc) (\<Union> Nc')`
    by (metis bij_betw_finite)
  moreover
  have "\<Union> F \<subseteq> \<Union> Nc'"
    using Union_mono[OF `closure F \<subseteq> closure Nc' \<union> {{}}`]
    by simp
  ultimately
  obtain g' where "inj_on g' (\<Union> Nc')" "\<forall> x \<in> (\<Union> F). g' x = g x"
    using `bij_betw g (\<Union> F) (\<Union> F')` `finite (\<Union> F')`
    using bij_betw_inj_extend[of g "\<Union> F" "\<Union> F'" "\<Union> Nc' - \<Union> F"]
    using finite_subset[of "\<Union> Nc' - \<Union> F" "\<Union> Nc'"]
    by (auto, metis sup_absorb2)
  
  let ?Nc'' = "op ` g' ` Nc'"
  show "\<exists>Nc'. iso Nc Nc' \<and> closure F' \<subseteq> closure Nc' \<union> {{}}"
  proof (rule_tac x="?Nc''" in exI, rule conjI)
    show "iso Nc ?Nc''"
    proof-
      have "iso Nc' ?Nc''"
        using `inj_on g' (\<Union> Nc')`
        unfolding iso_def
        by (rule_tac x=g' in exI) (auto simp add: bij_betw_def)
      thus ?thesis
        using `iso Nc Nc'`iso_trans
        by blast
    qed
  next
    show "closure F' \<subseteq> closure (op ` g' ` Nc') \<union> {{}}"
    proof
      fix x
      assume "x \<in> closure F'"
      hence "x \<in> op ` g ` closure F"
        using * 
        by (simp add: closure_iso)
      moreover
      have "op ` g ` closure F = op ` g' ` closure F"
        using `\<forall> x \<in> (\<Union> F). g' x = g x`
        using map_fam_cong[of "closure F" g' g]
        by simp
      moreover
      have "op ` g' ` closure F \<subseteq> op ` g' ` (closure Nc' \<union> {{}})"
        using `closure F \<subseteq> closure Nc' \<union> {{}}`
        by auto
      moreover
      have "op ` g' ` (closure Nc' \<union> {{}}) = closure (op ` g' ` Nc') \<union> {{}}"
        using closure_iso[of g' Nc']
        by auto
      ultimately
      show "x \<in> closure (op ` g' ` Nc') \<union> {{}}"
        by auto
    qed
  qed
qed

lemma covered_iso:
  fixes F F' :: "nat set set"
  assumes "finite (\<Union> F')" and
          "\<forall> Fc \<in> \<F>. finite (\<Union> Fc)" and "\<forall> Nc \<in> \<N>. finite (\<Union> Nc)"
  assumes "iso F F'" 
  shows "covered \<F> \<N> F \<Longrightarrow> covered \<F> \<N> F'"
using assms
unfolding covered_def
using FC_covered_iso[of F F'] nonFC_covered_iso[of F F']
by blast

lemma iso_represents_FCs_covered:
  fixes FF FFb ::"nat set set set"
  assumes "iso_represents FFb FF" and "\<forall> F \<in> FFb. FCs_covered \<F> F"
  shows "\<forall> F \<in> FF. FCs_covered \<F> F"
proof
  fix F
  assume "F \<in> FF"
  then obtain F' where "F' \<in> FFb" "iso F' F"
    using `iso_represents FFb FF` iso_sym
    unfolding iso_represents_def
    by blast
  then obtain Fc where "Fc \<in> \<F>" "FC_covered Fc F'"
    using `\<forall> F \<in> FFb. FCs_covered \<F> F` 
    by auto
  hence "FC_covered Fc F"
    using `F \<in> FF` FC_covered_iso[of F' F Fc] `iso F' F`
    by auto
  thus "FCs_covered \<F> F"
    using `Fc \<in> \<F>`
    by auto
qed

lemma iso_represents_nonFCs_covered:
  fixes FF FFb ::"nat set set set"
  assumes "\<forall> F \<in> FF. finite (\<Union> F)" "\<forall> F \<in> \<N>. finite (\<Union> F)"
  assumes "iso_represents FFb FF" "\<forall> F \<in> FFb. nonFCs_covered \<N> F" 
  shows "\<forall> F \<in> FF. nonFCs_covered \<N> F"
proof
  fix F::"nat set set"
  assume "F \<in> FF"
  then obtain F' where "F' \<in> FFb" "iso F' F"
    using `iso_represents FFb FF` iso_sym
    unfolding iso_represents_def
    by blast
  then obtain N where "N \<in> \<N>" "nonFC_covered N F'"
    using `\<forall> F \<in> FFb. nonFCs_covered \<N> F` 
    by auto
  hence "nonFC_covered N F"
    using `F \<in> FF` nonFC_covered_iso[of F' F N] `\<forall> F \<in> FF. finite (\<Union> F)` `\<forall> F \<in> \<N>. finite (\<Union> F)` `iso F' F`
    by auto
  thus "nonFCs_covered \<N> F"
    using `N \<in> \<N>`
    by auto
qed

(* -------------------------------------------------------------------------- *)
subsection{* Covering, closure and irreducible families *}

lemma closure_covered:
  assumes "closure F = closure F'"
  shows "covered \<F> \<N> F \<longleftrightarrow> covered \<F> \<N> F'"
using assms
unfolding covered_def FC_covered_def nonFC_covered_def
by auto

lemma ex_irreducible_covered:
  fixes F
  assumes "finite (\<Union> F)"
  shows "\<exists> F' \<subseteq> F. irreducible F' \<and> (covered \<F> \<N> F \<longleftrightarrow> covered \<F> \<N> F')"
proof-
  from assms
  have "finite F"
    by (auto simp add: finiteUn_iff)
  hence "\<exists> F' \<subseteq> F. irreducible F' \<and> (closure F = closure F')"
    using ex_irreducible_closure[of F]
    by auto
  thus ?thesis
    using closure_covered
    by metis
qed

lemma all_irreducible_covered_all_covered:
  assumes "\<forall> F. irreducible F \<and> \<Union> F \<subseteq> {0..<n::nat} \<longrightarrow> covered \<F> \<N> F"
  shows "\<forall> F. \<Union> F \<subseteq> {0..<n} \<longrightarrow> covered \<F> \<N> F"
proof (safe)
  fix F
  assume "\<Union> F \<subseteq> {0..<n}" 
  then obtain F' where "F'\<subseteq>F" "irreducible F'" "covered \<F> \<N> F \<longleftrightarrow> covered \<F> \<N> F'"
    using finite_subset[of "\<Union> F" "{0..<n}"]
    using ex_irreducible_covered[of F \<F> \<N>]
    by auto
  have "irreducible F' \<and> \<Union>F' \<subseteq> {0..<n}"
    using `F'\<subseteq>F` `irreducible F'` `\<Union> F \<subseteq> {0..<n}`
    by blast
  hence "covered \<F> \<N> F'"
    by (rule assms[rule_format])
  thus "covered \<F> \<N> F"
    using `covered \<F> \<N> F \<longleftrightarrow> covered \<F> \<N> F'`
    by simp
qed

end
