subsubsection{* FC and nonFC covering implementation *}

theory CoveringImpl
  imports
   Covering
   FamilyImpl UnionClosedImpl NonIsomorphicFamiliesImpl
   More.MoreBinomial
begin


definition FC_covered_l :: "nat list list \<Rightarrow> nat list list \<Rightarrow> nat list list \<Rightarrow> bool" where
  "FC_covered_l Fc F perms \<longleftrightarrow> list_ex (\<lambda> Fc'. set Fc' \<subseteq> set (close_l F)) (map (\<lambda> p. permute_family_l p Fc) perms)"

lemma FC_covered_l_soundness:
  assumes "\<forall> p \<in> set perms. p <~~> [0..<n]" "dm Fc n"
  assumes "FC_covered_l Fc F perms" 
  shows "FC_covered (f_to_set_l Fc) (f_to_set_l F)"
proof-
  obtain p where "p \<in> set perms" "set (permute_family_l p Fc) \<subseteq> set (close_l F)"
    using assms
    unfolding FC_covered_l_def
    by (auto simp add: list_ex_iff)
  show ?thesis
    unfolding FC_covered_def
  proof (rule_tac x="f_to_set_l (permute_family_l p Fc)" in exI, rule)
    show "iso (f_to_set_l (permute_family_l p Fc)) (f_to_set_l Fc) "
    proof-
      have "inj_on (list_to_fun p) (\<Union> f_to_set_l Fc)"
        using perm_distinct_iff[of p "[0..<n]"] perm_length[of p "[0..<n]"]
          `p \<in> set perms` assms(1) assms(2)
        using nat_list_to_fun_inj_on'[of p n "\<Union> f_to_set_l Fc"]
        by simp
      thus ?thesis
        using SetPermutations_lists.permute_family_inj_embed[of p Fc] inj_embed_iso[of "f_to_set_l Fc" "f_to_set_l (permute_family_l p Fc)"] iso_sym
        by blast
    qed
  next
    show "f_to_set_l (permute_family_l p Fc) \<subseteq> closure (f_to_set_l F)"
      using `set (permute_family_l p Fc) \<subseteq> set (close_l F)`
      using SetUnionImpl_lists.close_set[of F]
      by auto
  qed
qed


lemma FC_covered_l_completeness:
  assumes "sdf F" "sdf Fc" "dm Fc n" "dm F n" "perms = permute [0..<n]"
  assumes "FC_covered (f_to_set_l Fc) (f_to_set_l F)" 
  shows "FC_covered_l Fc F perms"
proof-
  from assms
  obtain Fc' where "iso Fc' (f_to_set_l Fc)"  "Fc' \<subseteq> closure (f_to_set_l F)"
    unfolding FC_covered_def
    by auto
  have "\<Union> Fc' \<subseteq> \<Union> closure (f_to_set_l F)"
    using `Fc' \<subseteq> closure (f_to_set_l F)`
    by (metis Union_mono)
  hence "\<Union> Fc' \<subseteq> {0..<n}"
    using `dm F n`
    by auto
  have "finite (\<Union> Fc')"
    using `iso Fc' (f_to_set_l Fc)` bij_betw_finite
    unfolding iso_def
    by auto
  then obtain Fc'l where "Fc' = f_to_set_l Fc'l" "sdf Fc'l"
    using SetImpl_lists.f_to_set_ex[of Fc']
    by auto
  then obtain p where "p\<in>set perms" "set Fc'l = set (permute_family_l p Fc)"
    using `iso Fc' (f_to_set_l Fc)` iso_permute_family_l[of Fc Fc'l n perms]
    using `dm Fc n` `\<Union> Fc' \<subseteq> {0..<n}`  `perms = permute [0..<n]` `sdf Fc`
    using iso_sym[of "f_to_set_l Fc'l" "f_to_set_l Fc"]
    by auto
  show ?thesis
    unfolding FC_covered_l_def
  proof (subst list_ex_iff, rule_tac x="permute_family_l p Fc" in bexI)
    show "permute_family_l p Fc \<in> set (FamilyImpl.map (\<lambda>p. permute_family_l p Fc) perms)"
      using `p \<in> set perms`
      by auto
  next
    show "set (permute_family_l p Fc) \<subseteq> set (close_l F)"
    proof-
      have "set Fc'l \<subseteq> set (close_l F)"
      proof
        fix A
        assume "A \<in> set Fc'l"
        show "A \<in> set (close_l F)"
        proof (rule SetUnionImpl_lists.close_completeness)
          show "sorted A \<and> distinct A"
            using `\<forall> A \<in> set Fc'l. sorted A \<and> distinct A` `A \<in> set Fc'l`
            by auto
        next
          show "\<forall>a\<in>set F. sorted a \<and> distinct a"
            by fact
        next
          show "set A \<in> closure (f_to_set_l F)"
            using `A \<in> set Fc'l` `Fc' = f_to_set_l Fc'l` `Fc' \<subseteq> closure (f_to_set_l F)`
            by auto
        qed
      qed
      thus ?thesis
        using `set Fc'l = set (permute_family_l p Fc)`
        by auto
    qed
  qed
qed

definition FCs_covered_l where
  "FCs_covered_l \<F> F perms \<longleftrightarrow> list_ex (\<lambda> Fc. FC_covered_l Fc F perms) \<F>"

(* ---- *)

definition nonFC_covered_l where
  "nonFC_covered_l Nc F perms \<longleftrightarrow> 
    list_ex (\<lambda> Nc'. set (close_l F) \<subseteq> set Nc') 
            (map (\<lambda> p. (close_insert_empty_l (permute_family_l p Nc))) perms)"

lemma nonFC_covered_l_soundness:
  assumes "\<forall> p \<in> set perms. p <~~> [0..<n]" "dm Nc n"
  assumes "nonFC_covered_l Nc F perms" 
  shows "nonFC_covered (f_to_set_l Nc) (f_to_set_l F)"
proof-
  obtain p where "p \<in> set perms" "set (close_insert_empty_l (permute_family_l p Nc)) \<supseteq> set (close_l F)"
    using assms
    unfolding nonFC_covered_l_def
    by (auto simp add: list_ex_iff)
  show ?thesis
    unfolding nonFC_covered_def
  proof (rule_tac x="f_to_set_l (permute_family_l p Nc)" in exI, rule)
    show "iso (f_to_set_l Nc) (f_to_set_l (permute_family_l p Nc))"
    proof-
      have "inj_on (list_to_fun p) (\<Union> f_to_set_l Nc)"
        using perm_distinct_iff[of p "[0..<n]"] perm_length[of p "[0..<n]"]
          `p \<in> set perms` assms(1) assms(2)
        using nat_list_to_fun_inj_on'[of p n "\<Union> f_to_set_l Nc"]
        by simp
      thus ?thesis
        using SetPermutations_lists.permute_family_inj_embed[of p Nc] inj_embed_iso[of "f_to_set_l Nc" "f_to_set_l (permute_family_l p Nc)"] iso_sym
        by blast
    qed
  next
    show "closure (f_to_set_l F) \<subseteq> closure (f_to_set_l (permute_family_l p Nc)) \<union> {{}}"
      using `set (close_insert_empty_l (permute_family_l p Nc)) \<supseteq> set (close_l F)`
      using SetUnionImpl_lists.close_set[of F, symmetric] SetUnionImpl_lists.close_and_insert_empty_set[symmetric]
      by auto
  qed
qed

(*
lemma nonFC_covered_l_completeness:
  assumes "sdf F" "dm F n" "dm Nc n" "perms = permute [0..<n]"
  assumes "nonFC_covered (f_to_set_l Nc) (f_to_set_l F)"
  shows "nonFC_covered_l Nc F perms"
proof-
  from assms
  obtain Nc' where "iso (f_to_set_l Nc) Nc'"  "closure (f_to_set_l F) \<subseteq> closure Nc' \<union> {{}}"
    unfolding nonFC_covered_def
    by auto
  have "finite (\<Union> Nc')"
    using `iso (f_to_set_l Nc) Nc'` bij_betw_finite
    unfolding iso_def
    by auto
  then obtain Nc'l where "Nc' = f_to_set_l Nc'l" "sdf Nc'l"
    using SetImpl'_lists.f_to_set_ex[of Nc']
    by auto
  then obtain p where "p\<in>set perms" "Nc'l = permute_family_l p Nc"
    using `iso (f_to_set_l Nc) Nc'` iso_permute_family_l[of Nc Nc'l n perms] `dm Nc n`
    using `perms = permute [0..<n]`
      (* by auto *)sorry
  show ?thesis
    unfolding nonFC_covered_l_def
  proof (subst list_ex_iff, rule_tac x="close_insert_empty_l Nc'l" in bexI)
    show "close_insert_empty_l Nc'l \<in> set (map (\<lambda> p. close_insert_empty_l (permute_family_l p Nc)) perms)"
      using `p \<in> set perms`  `Nc'l = permute_family_l p Nc`
      by auto
  next
    show "set (close_l F) \<subseteq> set (close_insert_empty_l Nc'l)"
    proof
      fix A
      assume "A \<in> set (close_l F)"
      hence "set A \<in> closure Nc' \<or> set A = {}"
        using `closure (f_to_set_l F) \<subseteq> closure Nc' \<union> {{}}` `Nc' = f_to_set_l Nc'l`
        using SetImpl_lists.close_set [of F]
        by auto
      thus "A \<in> set (close_insert_empty_l Nc'l)"
      proof
        assume "set A \<in> closure Nc'"
        have "A \<in> set (close_l Nc'l)"
        proof (rule SetImpl_lists.close_completeness)
          show "sd A"
            using `A \<in> set (close_l F)` `sdf F`
            by (metis SetImpl_lists.close_inv)
        next
          show "sdf Nc'l"
            by fact
        next
          show "set A \<in> closure (f_to_set_l Nc'l)"
            using `set A \<in> closure Nc'` `Nc' = f_to_set_l Nc'l`
            by simp
        qed
        thus "A \<in> set (close_insert_empty_l Nc'l)"
          by (subst SetImpl_lists.close_insert_empty_set) simp
      next
        assume "set A = {}"
        hence "A = []"
          by auto
        thus "A \<in> set (close_insert_empty_l Nc'l)"
          by (subst SetImpl_lists.close_insert_empty_set) simp
      qed
    qed
  qed
qed
*)

definition nonFCs_covered_l where
  "nonFCs_covered_l \<N> F perms \<longleftrightarrow> 
    list_ex (\<lambda> Nc. nonFC_covered_l Nc F perms) \<N>"

lemma nonFCs_covered_l_soundness:
  assumes "\<forall>p\<in>set perms. p <~~> [0..<n]"  "dmf \<N> n"
  assumes "nonFCs_covered_l \<N> F perms"
  shows "nonFCs_covered (fs_to_set_l \<N>) (f_to_set_l F)"
using assms
unfolding nonFCs_covered_l_def
using nonFC_covered_l_soundness[of perms n]
by (auto simp add: list_ex_iff) (rule_tac x="Nc" in bexI, auto)


definition nonFC_covered_l_opt :: "nat list list list \<Rightarrow> nat list list \<Rightarrow> bool" where
  "nonFC_covered_l_opt Nc_perms F \<longleftrightarrow> 
    list_ex (\<lambda> Nc'. set (close_l F) \<subseteq> set Nc') Nc_perms"
definition nonFCs_covered_l_opt where
  "nonFCs_covered_l_opt \<N>_perms F \<longleftrightarrow> 
    list_ex (\<lambda> Nc. nonFC_covered_l_opt Nc F) \<N>_perms"

lemma nonFCs_covered_l_opt:
  assumes "\<N>_perms = (map (\<lambda> Nc. (map (\<lambda> p. close_insert_empty_l (permute_family_l p Nc)) perms)) \<N>)"
  shows "nonFCs_covered_l_opt \<N>_perms F \<longleftrightarrow> nonFCs_covered_l \<N> F perms"
using assms
unfolding nonFCs_covered_l_def nonFCs_covered_l_opt_def
unfolding nonFC_covered_l_def nonFC_covered_l_opt_def
by (auto simp add: list_ex_iff)

end
