section{* Proof that all families are covered *}
theory FC6
imports FC6_Data LPartitioningIrreducibleNonFCsCoveredImpl
begin

definition FC6_perms where
  "FC6_perms = map (\<lambda> F. map (\<lambda> p. permute_family_l p F) (permute [0..<6])) FC6"

definition nonFC6_perms where
  "nonFC6_perms = map (\<lambda> Nc. map (\<lambda> p. close_insert_empty_l (permute_family_l p Nc)) (permute [0..<6])) nonFC6"

(* -------------------------------------------------------------------------- *)
lemma L_part_6:
  assumes "\<Union> F \<subseteq> {0..<6::nat}"
  shows "\<exists> n0 n1 n2 n3 n4 n5 n6. 
    is_L_part 6 [n0, n1, n2, n3, n4, n5, n6] F \<and> 
    n0 \<le> 1 \<and> n1 \<le> 6 \<and> n2 \<le> 15 \<and> n3 \<le> 20 \<and> n4 \<le> 15 \<and> n5 \<le> 6 \<and> n6 \<le> 1"
using assms
proof-
  {
    fix A
    assume "A \<in> F"
    hence "card A \<le> card (\<Union> F)"
      using card_mono[of "\<Union> F" A] finite_subset[of "\<Union> F" "{0..<6::nat}"] assms
      by (smt Union_upper card_atLeastLessThan card_mono finite_atLeastLessThan)
    hence "card A < 7"
      using assms card_mono[of "{0..<6::nat}" "\<Union> F"]
      by auto
  }
  moreover
  have "6 choose 2 = 15" "6 choose 3 = 20" "6 choose 4 = 15"  "6 choose 5 = 6"
    by eval+
  ultimately
  show ?thesis
    unfolding is_L_part_def
    apply (rule_tac x="card {A \<in> F. card A = 0}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 1}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 2}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 3}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 4}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 5}" in exI)
    apply (rule_tac x="card {A \<in> F. card A = 6}" in exI)
    using assms
    apply auto
    apply (subgoal_tac "Suc (Suc (Suc (Suc (Suc (Suc (Suc 0)))))) = 7")
    apply metis
    apply simp
    apply (case_tac "n=0", simp)
    apply (case_tac "n=1", simp)
    apply (case_tac "n=2", simp)
    apply (case_tac "n=3", simp)
    apply (case_tac "n=4", simp)
    apply (case_tac "n=5", simp)
    apply (case_tac "n=6", simp)
    apply simp
    using n_subsets_ub[of "F" 6 0]
    apply simp
    using n_subsets_ub[of "F" 6 1]
    apply simp
    using n_subsets_ub[of "F" 6 2]
    apply simp
    using n_subsets_ub[of "F" 6 3]
    apply simp
    using n_subsets_ub[of "F" 6 4]
    apply simp
    using n_subsets_ub[of "F" 6 5]
    apply simp
    using n_subsets_ub[of "F" 6 6]
    apply simp
    done
qed

(* ----------------------------------------------------------------------- *)
theorem enum_rec_notFCs_covered_l:
  assumes "enum_rec_notFCs_covered_l FC6_perms [0, n1, n2, n3, n4, n5, n6] 6 (permute [0..<6]) = []"
  shows "\<forall> F \<in> L_part 6 [0, n1, n2, n3, n4, n5, n6]. FCs_covered (fs_to_set_l FC6) F"
(* ----------------------------------------------------------------------- *)
proof-
  have "[] \<notin> set FC6" "dmf FC6 6" "sdff FC6"
    by eval+
  thus ?thesis
    using assms
    using enum_rec_notFCs_covered_l_iso_representing_subset[of FC6_perms 6 FC6 "[0, n1, n2, n3, n4, n5, n6]"]
    unfolding FC6_perms_def iso_represents_def
    by simp
qed

lemma FC_0000560:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 0, 5, 6, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 0, 5, 6, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0000700:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 0, 7, 0, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 0, 7, 0, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0001650:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 1, 6, 5, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 1, 6, 5, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0002060:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 2, 0, 6, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 2, 0, 6, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0003040:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 3, 0, 4, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 3, 0, 4, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0003230:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 3, 2, 3, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 3, 2, 3, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0003300:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 3, 3, 0, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 3, 3, 0, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0004000:
  shows "\<forall> F \<in> L_part 6 [0, 0, 0, 4, 0, 0, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 0, 4, 0, 0, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0010000:
  shows "\<forall> F \<in> L_part 6 [0, 0, 1, 0, 0, 0, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 0, 1, 0, 0, 0, 0] 6 (permute [0..<6]) = []"
    by eval
qed

lemma FC_0100000:
  shows "\<forall> F \<in> L_part 6 [0, 1, 0, 0, 0, 0, 0]. FCs_covered (fs_to_set_l FC6) F"
proof (rule enum_rec_notFCs_covered_l)
  show "enum_rec_notFCs_covered_l FC6_perms [0, 1, 0, 0, 0, 0, 0] 6 (permute [0..<6]) = []"
    by eval
qed


definition all_FC_partitions :: "nat list list" where
  "all_FC_partitions = 
[
  [0, 0, 0, 0, 5, 6, 0],
  [0, 0, 0, 0, 7, 0, 0],
  [0, 0, 0, 1, 6, 5, 0], 
  [0, 0, 0, 2, 0, 6, 0],
  [0, 0, 0, 3, 0, 4, 0],
  [0, 0, 0, 3, 2, 3, 0],
  [0, 0, 0, 3, 3, 0, 0],
  [0, 0, 0, 4, 0, 0, 0],
  [0, 1, 0, 0, 0, 0, 0],
  [0, 0, 1, 0, 0, 0, 0] 
]"

(* --------------------------------------------------------------- *)

definition notAllFC_partitions where
"notAllFC_partitions = {L'. [1, 6, 15, 20, 15, 6, 1] \<succeq> L' \<and> \<not> (\<exists> S \<in> set all_FC_partitions. L' \<succeq> S)}"

lemma notAllFC_partitions_remove_empty:
  assumes "[1, n1, n2, n3, n4, n5, n6] \<in> notAllFC_partitions" (is "?L \<in> _")
  shows "[0, n1, n2, n3, n4, n5, n6] \<in>  notAllFC_partitions" (is "?L' \<in> _")
using assms
unfolding notAllFC_partitions_def all_FC_partitions_def
by (auto simp add: pwge_Cons pwge_Nil)

(* ----------------------------------------------------------------------- *)
theorem notAllFC_partitions:
  assumes "\<forall> L F. L \<in> notAllFC_partitions \<and> hd L = 0 \<and> F \<in> L_part_irreducible 6 L \<longrightarrow> covered \<F> \<N> F"
  "\<F> = fs_to_set_l FC6" 
  shows "\<forall> F. \<Union> F \<subseteq> {0..<6::nat} \<longrightarrow> covered \<F> \<N> F"
(* ----------------------------------------------------------------------- *)
proof(rule all_irreducible_covered_all_covered)
  show "\<forall> F. irreducible F \<and> \<Union> F \<subseteq> {0..<6::nat} \<longrightarrow> covered \<F> \<N> F"
  proof (safe)
    fix F
    assume "\<Union> F \<subseteq> {0..<6::nat}" "irreducible F"
    then obtain n0 n1 n2 n3 n4 n5 n6 where "is_L_part 6 [n0, n1, n2, n3, n4, n5, n6] F" and *:  "n0 \<le> 1" "n1 \<le> 6" "n2 \<le> 15" "n3 \<le> 20" "n4 \<le> 15" "n5 \<le> 6" "n6 \<le> 1"
      using L_part_6[of F]
      by auto
    let ?L = "[n0, n1, n2, n3, n4, n5, n6]"
    have **: "[1, 6, 15, 20, 15, 6, 1] \<succeq> [n0, n1, n2, n3, n4, n5, n6]"
      using *
      by (simp add: pwge_Cons)
    show "covered \<F> \<N> F"
    proof (cases "\<exists> L' \<in> set all_FC_partitions. ?L \<succeq> L'")
      case False
      show ?thesis
      proof (cases "n0 = 0")
        case True
        thus ?thesis
          using assms(1)[rule_format, of ?L F] `irreducible F` `is_L_part 6 ?L F` `\<not> (\<exists> L' \<in> set all_FC_partitions. ?L \<succeq> L')` **
          unfolding notAllFC_partitions_def
          by auto
      next
        case False
        hence "n0 = 1"
          using `n0 \<le> 1`
          by auto
        show ?thesis
        proof (subst covered_remove_empty)
          show "finite F"
            using `is_L_part 6 ?L F`
            by (simp add: is_L_part_finite)
        next
          let ?L' = "[0, n1, n2, n3, n4, n5, n6]"
          have "?L \<in> notAllFC_partitions"
            using **  `\<not> (\<exists> L' \<in> set all_FC_partitions. ?L \<succeq> L')` `n0 = 1`
            unfolding notAllFC_partitions_def
            by simp
          hence "?L' \<in> notAllFC_partitions"
            by (subst (asm) `n0 = 1`) (rule notAllFC_partitions_remove_empty)
          moreover
          have "hd ?L' = 0" 
            by simp
          moreover
          have "is_L_part 6 ?L' (F - {{}})"
            using `is_L_part 6 ?L F`
            using is_L_part_remove[of "{}" F 6 ?L] `n0 = 1`
            using is_L_part_empty_mem[of 6 ?L F]
            by auto
          moreover
          have "irreducible (F - {{}})"
            using `irreducible F`
            by (auto simp add: reducible_def)
          ultimately
          show "covered \<F> \<N> (F - {{}})"
            using assms(1)[rule_format, of ?L']
            by simp
        qed simp
      qed
    next
      case True
      then obtain L where "L \<in> set all_FC_partitions" "?L \<succeq> L"
        unfolding all_FC_partitions_def
        by auto
      show ?thesis
      proof-
        {
          assume "?L \<succeq> [0, 0, 0, 0, 5, 6, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0000560
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 0, 7, 0, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0000700
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 1, 6, 5, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0001650
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 2, 0, 6, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0002060
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 3, 0, 4, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0003040
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 3, 2, 3, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0003230
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 3, 3, 0, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0003300
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 0, 4, 0, 0, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0004000
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 1, 0, 0, 0, 0, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0100000
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        moreover
        {
          assume "?L \<succeq> [0, 0, 1, 0, 0, 0, 0]"
          hence "covered \<F> \<N> F"
            using  `is_L_part 6 ?L F` assms(2)
            unfolding covered_def
            using FC_0010000
            using pwge_FCs_covered[of 6 _ \<F> ?L]
            by auto
        }
        ultimately
        show ?thesis
          using `L \<in> set all_FC_partitions` `?L \<succeq> L`
          unfolding all_FC_partitions_def
          by auto
      qed
    qed
  qed
qed

(* ----------------------------------------------------------- *)
theorem
  shows "\<forall> F. \<Union> F \<subseteq> {0..<6::nat} \<longrightarrow> covered (fs_to_set_l FC6) (fs_to_set_l nonFC6) F"
(* ----------------------------------------------------------- *)
proof (rule notAllFC_partitions)
  show "\<forall>L F. L \<in> notAllFC_partitions \<and>
          hd L = 0 \<and> F \<in> L_part_irreducible 6 L \<longrightarrow>
          covered (fs_to_set_l FC6) (fs_to_set_l nonFC6) F"
  proof (safe)
    fix L and F::"nat set set"
    assume "L \<in> notAllFC_partitions" "hd L = 0" "irreducible F" "is_L_part 6 L F"

    let ?maxL = "[0, 6, 15, 20, 15, 6, 1]"
    let ?stops = "all_FC_partitions"
    let ?X = "{L'. ?maxL \<succeq> L' \<and> \<not> (\<exists> S \<in> set ?stops. L' \<succeq> S)}"
    let ?perms = "permute [0..<6]"
    from `L \<in> notAllFC_partitions` `hd L = 0`
    have "L \<in> ?X"
      unfolding notAllFC_partitions_def
      by (cases L) (simp add: pwge_def, auto simp add: pwge_Cons)
    moreover
    have "\<forall>S\<in>set all_FC_partitions. length S = 7" "[] \<notin> set FC6" "dmf FC6 6" "sdff FC6"
      unfolding all_FC_partitions_def 
      by eval+
    ultimately
    obtain B where
      "B \<in> set (enum_dp_irreducible_notFCs_covered_l FC6_perms 6 ?perms ?stops ?maxL)"
      "iso_representing_subset (fs_to_set_l B) (L_part_irreducible_notFCs_covered (fs_to_set_l FC6) 6 L)"
      using enum_dp_irreducible_notFCs_covered_l_iso_representing_subsets[of FC6_perms "permute [0..<6]" FC6 ?X ?maxL ?stops 6]
      by (auto simp add: FC6_perms_def)
    
    show "covered (fs_to_set_l FC6) (fs_to_set_l nonFC6) F"
    proof (rule iso_represents_L_part_irreducible_notFCs_covered[rule_format])
      show "F \<in> L_part_irreducible 6 L"
        using `is_L_part 6 L F` `irreducible F`
        by simp
    next
      fix N
      assume "N \<in> fs_to_set_l nonFC6"
      thus "finite (\<Union>N)"
        by auto
    next
      show "iso_representing_subset (fs_to_set_l B) (L_part_irreducible_notFCs_covered (fs_to_set_l FC6) 6 L)"
        by fact
    next
      fix F
      assume "F \<in> fs_to_set_l B"
      moreover
      have *: "\<forall> B \<in> set (enum_dp_irreducible_notFCs_covered_l FC6_perms 6 (permute [0..<6]) all_FC_partitions [0, 6, 15, 20, 15, 6, 1]). \<forall> F \<in> set B. nonFCs_covered_l_opt nonFC6_perms F"
        by eval
      have "dmf nonFC6 6"
        by eval
      hence "\<forall> B \<in> set (enum_dp_irreducible_notFCs_covered_l FC6_perms 6 (permute [0..<6]) all_FC_partitions [0, 6, 15, 20, 15, 6, 1]). \<forall> F \<in> fs_to_set_l B. nonFCs_covered (fs_to_set_l nonFC6) F"
        using *
        using nonFCs_covered_l_soundness[of "permute [0..<6]" 6 ]
        by (subst (asm) nonFCs_covered_l_opt[of nonFC6_perms "permute [0..<6]" nonFC6]) (auto simp add: list_ex_iff isPermutation_permute nonFC6_perms_def)
      ultimately 
      show "nonFCs_covered (fs_to_set_l nonFC6) F"
        using `B \<in> set (enum_dp_irreducible_notFCs_covered_l FC6_perms 6 ?perms ?stops ?maxL)`
        by auto
    qed
  qed
qed simp

(* ---------------------------------------------------------------------- *)

definition all_nonFC_partitions where
 "all_nonFC_partitions = 
[
 [0, 0, 0, 0, 3, 6, 1],
 [0, 0, 0, 0, 4, 1, 1],
 [0, 0, 0, 1, 1, 6, 1],
 [0, 0, 0, 1, 2, 1, 1],
 [0, 0, 0, 2, 0, 1, 1]
]"

end
