section{* Minimal FC(6) families and maximal nonFC(6) families *}
theory FC6_Data
imports Main
begin

definition FC6 :: "nat list list list" where
  "FC6 = [
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,3,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[1,2,3,4]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[1,2,3,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,2,3,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,3,5],[0,1,2,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,2,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[2,3,4,5],[0,1,2,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[2,3,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,4,5],[2,3,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[1,3,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,5],[0,1,3,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,5],[0,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,2,3,5],[1,2,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,1,4,5],[0,2,3,4,5]],
     [[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,2,3,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,5],[0,1,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,5],[0,1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[1,2,3,4]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[1,2,3,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,5],[1,2,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,5],[1,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[1,3,4,5],[0,1,2,3,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,1,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[0,1,2,3,4],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,1,3,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,1,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[1,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,2,4,5],[1,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,2,3,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,2,3,4],[0,3,4,5],[1,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,1,4,5],[0,3,4,5]],
     [[0,1,2],[0,1,3,4],[0,1,3,5],[0,3,4,5],[1,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[1,3,4,5],[0,1,2,3,4]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[2,3,4,5],[0,1,2,3,4]],
     [[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,1,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,3,4,5],[0,1,2,3,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,3,4,5],[1,3,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[1,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[0,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,3,4]],
     [[0,1,2],[0,3,4],[1,2,3,4]],
     [[0,1,2],[0,1,3],[0,1,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3],[2,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,3,4],[0,1,3,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[1,2,3,5],[0,1,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[1,2,3,5],[0,1,2,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[0,1,2,3,5],[0,1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,4,5],[0,2,4,5]],
     [[0,1,2],[0,1,3],[0,1,4,5],[2,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[1,2,4,5]],
     [[0,1,2],[0,1,3],[0,2,4,5],[1,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[1,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,2,4,5],[0,1,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[2,3,4,5],[0,1,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[1,2,4,5],[0,1,2,3,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,4],[0,1,2,3,5]],
     [[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,4],[1,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,1,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,4],[0,2,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,4],[2,3,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,1,2,5],[0,2,4,5]],
     [[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,5],[2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[1,2,3,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,3,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,1,3,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[1,2,3,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,5],[0,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[1,2,3,5],[0,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[1,2,4,5],[0,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[0,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,2,3,4]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,1,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[0,2,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,3,4,5],[1,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,2,5],[0,1,2,4,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5]],
     [[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[0,1,3,4,5],[0,2,3,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,1,2,4,5]],
     [[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[0,2,3]],
     [[0,1,2],[0,1,3],[0,1,4]],
     [[0,1,2],[0,1,3],[0,2,4]],
     [[0,1,2],[0,1,3],[2,3,4]],
     [[0,1,2],[0,1,3],[0,4,5]],
     [[0,1,2],[0,3,4],[1,3,5]],
     [[0,1,2],[0,1,3],[2,4,5],[0,2,3,4,5]],
     [[0,1,2],[0,1,3],[2,4,5],[0,1,2,3,4],[0,1,3,4,5]],
     [[0,1,2],[0,1,3],[2,4,5],[0,2,4,5]],
     [[0,1,2],[0,1,3],[2,4,5],[0,1,2,4],[0,1,2,3,5]],
     [[0,1,2],[0,1,3],[2,4,5],[2,3,4,5],[0,1,2,3,4]],
     [[0,1,2],[0,1,3],[2,4,5],[2,3,4,5],[0,1,3,4,5]],
     [[0,1]],
     [[0]]
]"

(* ------------------------------------------------------------------------ *)

definition nonFC6 :: "nat list list list" where 
"nonFC6 = [
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,3,4],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,2,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,2,3,5],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,2,4,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,2,3,4],[0,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,2,3,4],[1,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,4],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,3,5],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,5],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,2,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[1,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[2,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,4,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,4,5],[0,2,4,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,4,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,2,3,4],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[1,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[2,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[1,2,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,5],[1,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,1,2,3,4],[0,1,2,3,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[1,2,3,5],[0,1,2,3,4],[0,1,2,3,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,5],[0,1,3,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,1,3,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[1,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,1,3,5],[0,1,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,1,3,4],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[2,4,5],[0,1,2,3],[0,1,2,4,5],[0,1,3,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[2,4,5],[0,1,2,3],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[2,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,3,4],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[2,4,5],[0,1,2,3],[0,1,3,4],[0,1,2,3,4],[0,1,2,4,5],[0,1,2,3,4,5]],
[[],[0,1,2],[0,1,3],[2,4,5],[0,1,2,3],[2,3,4,5],[0,1,2,4,5],[0,1,2,3,4,5]]
]"

end
