section{* FC status proofs *}
theory FC6_Status
imports FC6_Data SomeShareNegativeImpl WeightsShares_NotFCFamily FCTactics
begin

(* nonFC families *)

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[29, 29, 29, 29, 37, 4] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"                             
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by  (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[21, 37, 37, 30, 21, 1, 12] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[11, 19, 19, 11, 11, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[11, 19, 15, 15, 11, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[20, 57, 45, 45, 46, 33] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[5, 7, 7, 7, 7, 5] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[3, 4, 4, 4, 4, 3] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[8, 17, 17, 17, 18, 18] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{1,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[8, 8, 8, 8, 3, 2, 2] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[23, 23, 24, 17, 18, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{0,1,4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[1, 1, 1, 1, 3] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[13, 18, 18, 13, 13, 13] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[37, 52, 56, 37, 53, 24] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{1,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[14, 29, 31, 31, 22, 22] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,2,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[44, 16, 32, 23, 15, 15] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,2,3,5},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[704124, 378530, 378530, 368378, 247096, 247096] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,2,4,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[143, 75, 52, 52, 75, 75] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[32, 19, 38, 32, 11, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[58, 47, 47, 60, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[32, 27, 18, 21, 16, 10] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[14, 32, 32, 26, 14, 7] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[46, 45, 30, 44, 27, 17] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[27, 64, 64, 52, 27, 16] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,2,3,4},{0,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{3,5},{0,3,5},{0,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs8 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7, ?Fs8]"
  let ?c = "[61, 1, 44, 34, 27, 2, 5, 16] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs8  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,2,3,4},{1,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[35, 32, 44, 26, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[29, 21, 20, 21, 12, 2, 17] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[32, 58, 49, 38, 28, 16] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[26, 22, 8, 17, 27] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3,4},{0,1,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[79636, 57824, 31844, 22436, 22436, 34534] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[30252, 74746, 74746, 61390, 31264, 14168] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[9240, 22078, 22078, 17794, 9240, 4172] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[57, 145, 145, 120, 61, 32] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[8, 36, 36, 29, 16, 14] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[37, 24, 38, 38, 20, 4, 8] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[12, 19, 19, 18, 11, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{0,1,2,3},{0,1,2,3,4},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[1, 29, 50, 50, 49, 27, 18] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[17, 17, 6, 16, 20] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[33, 101, 114, 59, 55, 107] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[20, 20, 41, 36, 13, 38] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[17, 17, 27, 27, 22, 16] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,3,5},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[12100, 9034, 6824, 2830, 3222, 2830] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[18, 15, 53, 8, 8] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,5},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[932597, 693189, 527149, 236278, 219240, 231261] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,4,5},{0,2,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[37927, 27507, 20582, 15435, 9416, 4017] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{2,3,5},{0,1,2,3,5},{4,5},{0,1,4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[17, 11, 22, 65, 10] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[27, 40, 29, 31, 1, 23, 14] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{1,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[14, 14, 6, 16, 5, 4, 4] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{2,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[22, 16, 9, 27, 17] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[78355, 295203, 264999, 147297, 196138, 128904] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{1,4,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{0,1},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{0,1,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs8 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7, ?Fs8]"
  let ?c = "[28, 1, 11, 20, 13, 1, 7, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs8  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[117, 68, 68, 50, 29, 29] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,4,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[165436, 122596, 67260, 41682, 45304, 71336] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,4,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[50, 29, 29, 21, 14, 2, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[22, 24, 48, 43, 45, 1, 13] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{0,1},{2},{0,2},{0,1,2},{0,1,2,3},{4},{0,4},{0,1,4},{2,4},{0,2,4},{0,1,2,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[19, 65, 73, 39, 66, 1, 34] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[10, 10, 16, 16, 13, 9] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,4,5},{0,2,4,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[98, 56, 56, 42, 8, 42, 3] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[73763, 73763, 138832, 153866, 144226, 38988] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[214769, 223347, 447215, 395473, 419030, 113672] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[11, 27, 23, 23, 11, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[27, 29, 29, 54, 51, 42] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[57, 33, 24, 33, 13, 14] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{1},{0,1,2},{3},{1,3},{0,1,2,3},{4},{1,4},{0,1,2,4},{3,4},{1,3,4},{0,1,2,3,4},{5},{1,5},{0,1,2,5},{3,5},{1,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[32, 19, 62, 32, 32, 86] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,4,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[204402, 158745, 86596, 82121, 52537, 52479] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[256637, 76996, 189326, 145602, 81687, 50367] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[3, 10, 5, 5, 23] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[459409, 352236, 190460, 188023, 101088, 108864] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{1,2,3,4},{0,1,2,3,4},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[1, 17, 12, 12, 6, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[34, 25, 24, 13, 7, 1, 6] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[62, 38, 38, 35, 35, 8] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{1,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[137, 84, 213, 63, 1, 27] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,2,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[97755, 76615, 44765, 30765, 12600, 13440] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,2,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,2,4,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[99652, 47993, 31140, 75844, 14050, 13168] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{2,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4]"
  let ?c = "[13, 13, 8, 50] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[42, 44, 163, 12, 1, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[15, 8, 8, 19, 2] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[12, 12, 12, 12, 12, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{0,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[39709, 5528, 4837, 12536, 31167, 18165] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[69366, 37435, 36332, 25335, 6449, 22026] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{1,2,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{1,2,4,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{1},{0,1},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{1,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7]"
  let ?c = "[13, 25, 11, 10, 9, 47, 37] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,5},{1,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[34, 23, 1, 50, 16, 7] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,2,4,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[73661, 57777, 35199, 8792, 22307, 9420] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[39, 37, 144, 10, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{1},{0,1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{0,1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,4,5},{2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[42, 39, 147, 14, 12, 8] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,5},{0,1,2,3,4},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[5950, 3438, 7803, 2511, 984] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{1,2,3,5},{0,1,2,3,4},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{1,2,3,5},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{1,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[56, 32, 23, 24, 146, 146] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[50, 30, 61, 26, 5] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[3, 20, 12, 24, 11] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{0,1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[30, 21, 36, 28, 33, 24] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[178250, 81120, 80616, 86520, 86394, 5796] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,5},{0,1,3,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[46080, 23864, 23864, 16168, 5904, 16168] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[22, 52, 13, 12, 13] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[16266, 16266, 21609, 19355, 14455, 9636] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[8, 12, 22, 10, 7] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{0,1},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{0,1,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[197232, 224123, 125619, 172578, 112046, 156791] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{2,3,5},{0,1,2,3,5},{4,5},{0,1,4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[28, 20, 21, 58, 26] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[337, 167, 167, 149, 149, 13] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[77671, 77671, 46046, 65159, 65159, 46046] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[41997, 19668, 18337, 20271, 17963, 4377] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[14, 15, 16, 16, 13, 15] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[15, 15, 15, 14, 14, 13] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[20851, 9303, 9303, 10251, 789, 10251] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{2},{0,1,2},{3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[3, 5, 5, 15, 5] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[212, 212, 264, 231, 31, 205] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,1,3,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[8420, 7380, 3448, 3448, 662, 662] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{0,1,2},{3},{0,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[3, 3, 4, 3, 8] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{0,1,2,3,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[44, 49, 50, 50, 70] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[18, 18, 27, 18, 22, 22] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,1,3,5},{0,1,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{0,1,4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{0,1,2},{3},{0,3},{0,1,3},{0,1,2,3},{4},{0,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{1},{0,1},{0,2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{0,1,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[118, 6, 1, 6, 15, 16] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,1,3,4},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{2,3,4},{0,2,3,4},{0,1,2,3,4},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,3,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{0,1,2,4,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[65, 1, 34, 29, 29, 30] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{2,4,5},{0,1,2,3},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4]"
  let ?c = "[8, 22, 7, 4] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{2,4,5},{0,1,2,3},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{0,1,2,3,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{1},{2},{1,2},{0,1,2},{3},{1,3},{0,1,3},{2,3},{1,2,3},{0,1,2,3},{4},{1,4},{2,4},{1,2,4},{0,1,2,4},{3,4},{1,3,4},{0,1,3,4},{2,3,4},{1,2,3,4},{0,1,2,3,4},{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{3,5},{1,3,5},{0,1,3,5},{2,3,5},{1,2,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs7 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs8 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6, ?Fs7, ?Fs8]"
  let ?c = "[34, 77, 13, 13, 8, 1, 7, 17] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs7  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs8  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{2,4,5},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,2,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{2},{0,2},{0,1,2},{3},{0,3},{0,1,3},{2,3},{0,2,3},{0,1,2,3},{4},{0,4},{2,4},{0,2,4},{0,1,2,4},{3,4},{0,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{0,1,2,3,4},{5},{0,5},{2,5},{0,2,5},{0,1,2,5},{3,5},{0,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{0,1,2,3,5},{4,5},{0,4,5},{2,4,5},{0,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs6 = "{{5},{1,5},{2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{1,4,5},{2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5, ?Fs6]"
  let ?c = "[59, 151, 25, 1, 39, 4] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs6  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{2,4,5},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{2,3,5},{0,2,3,5},{1,2,3,5},{0,1,2,3,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{3},{0,3},{1,3},{0,1,3},{2,3},{0,2,3},{1,2,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{2,3,4},{0,2,3,4},{1,2,3,4},{0,1,2,3,4},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[37, 16, 110, 14, 21] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed

lemma [simp]: "\<not> FC_family ({{},{0,1,2},{0,1,3},{2,4,5},{0,1,2,3},{2,3,4,5},{0,1,2,4,5},{0,1,2,3,4,5}}::nat set set)" (is "\<not> FC_family ?Fc")
proof-
  let ?Fs1 = "{{},{0},{1},{0,1},{0,1,2},{3},{0,3},{1,3},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{0,1,2,4},{3,4},{0,3,4},{1,3,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{0,1,2,5},{3,5},{0,3,5},{1,3,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{3,4,5},{0,3,4,5},{1,3,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs2 = "{{},{0},{1},{0,1},{2},{0,2},{1,2},{0,1,2},{0,1,3},{0,1,2,3},{4},{0,4},{1,4},{0,1,4},{2,4},{0,2,4},{1,2,4},{0,1,2,4},{0,1,3,4},{0,1,2,3,4},{5},{0,5},{1,5},{0,1,5},{2,5},{0,2,5},{1,2,5},{0,1,2,5},{0,1,3,5},{0,1,2,3,5},{4,5},{0,4,5},{1,4,5},{0,1,4,5},{2,4,5},{0,2,4,5},{1,2,4,5},{0,1,2,4,5},{0,1,3,4,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs3 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{4},{2,4},{0,1,2,4},{3,4},{0,1,3,4},{2,3,4},{0,1,2,3,4},{5},{2,5},{0,1,2,5},{3,5},{0,1,3,5},{2,3,5},{0,1,2,3,5},{4,5},{2,4,5},{0,1,2,4,5},{3,4,5},{0,1,3,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs4 = "{{},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{2,4,5},{0,1,2,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs5 = "{{},{0,1},{2},{0,1,2},{3},{0,1,3},{2,3},{0,1,2,3},{2,4,5},{0,1,2,4,5},{2,3,4,5},{0,1,2,3,4,5}}::nat set set"
  let ?Fs = "[?Fs1, ?Fs2, ?Fs3, ?Fs4, ?Fs5]"
  let ?c = "[16, 7, 36, 2, 28] :: nat list"
  show ?thesis
  proof (rule nonFC[where Fs = ?Fs and c = ?c])
    show "\<forall> F \<in> set ?Fs. F \<in> \<lbrace>?Fc\<rbrace>"
    proof-
      have "?Fs1  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs2  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs3  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs4  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      moreover
      have "?Fs5  \<in> \<lbrace>?Fc\<rbrace>"
        by (tactic {* union_closed_extension_tac @{context} *})
      ultimately
      show ?thesis
        by (simp del: union_closed_extensions_def)
    qed
  next
    show "let Fs = ?Fs in \<forall> a \<in> \<Union> ?Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip ?c (map (frankl_fun a) Fs))) < 0"
       by (tactic {* nonFC_is_system_solution_tac @{context} @{term "[0..<6]::nat list"} 1 *}) 
  next
    show "\<exists>wj\<in>List.set ?c. 0 < wj"
       by auto
  next
    show "length ?c = length ?Fs"
       by auto
  next
     show "finite (\<Union> ?Fc)"
       by auto
  next
     show "union_closed ?Fc"
       by (tactic {* union_closed_tac @{context} 1 *})
  qed
qed


(* FC families *)

(*
lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[12, 11, 11, 11, 11, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[14, 14, 13, 12, 12, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[1,2,3,4]]::nat list list"
  let ?wl = "[1, 1, 1, 1, 1, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[1,2,3,5]]::nat list list"
  let ?wl = "[5, 5, 5, 5, 4, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[11, 11, 11, 10, 8, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[14, 13, 10, 12, 12, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[68, 68, 69, 69, 42, 51]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[8, 7, 7, 7, 7, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{1,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[1,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[67, 68, 67, 54, 63, 49]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{2,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[2,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[154, 126, 153, 153, 142, 114]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[28, 27, 28, 28, 26, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[15, 15, 12, 14, 14, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,1,4,5},{2,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,1,4,5],[2,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[16, 14, 15, 15, 15, 15]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,4,5},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[1, 1, 1, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,4,5},{1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[15, 15, 12, 14, 14, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{2,3,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[14, 12, 14, 13, 13, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 10, 9, 9, 9, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,5},{0,1,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,5],[0,1,3,5]]::nat list list"
  let ?wl = "[19, 16, 15, 15, 14, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,1,2,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,1,2,5],[0,3,4,5]]::nat list list"
  let ?wl = "[5, 4, 4, 4, 4, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,1,3,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[2,3,4,5]]::nat list list"
  let ?wl = "[1, 1, 1, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,2,3,5},{1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,2,3,5],[1,2,4,5]]::nat list list"
  let ?wl = "[3, 3, 3, 2, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,1,3,5},{0,1,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,1,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[7, 6, 5, 5, 5, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,1,3,5},{0,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[14, 12, 11, 10, 10, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[13, 12, 12, 9, 8, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[7, 7, 6, 5, 3, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,5},{0,1,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,5],[0,1,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[12, 11, 11, 9, 7, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,5},{0,1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,5],[0,1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[34, 32, 32, 25, 16, 19]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,3,4,5},{0,1,2,3,5},{0,1,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[3945, 3737, 3058, 3119, 3119, 2852]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{2,3,4,5},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[23, 23, 22, 18, 18, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[46, 46, 43, 38, 35, 32]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4,5},{1,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4,5],[1,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[17, 17, 16, 14, 14, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[1,2,3,4]]::nat list list"
  let ?wl = "[2, 2, 2, 1, 1, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[1,2,3,5]]::nat list list"
  let ?wl = "[3, 3, 3, 2, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,5},{1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,5],[1,2,4,5]]::nat list list"
  let ?wl = "[2, 2, 2, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,5],[1,3,4,5]]::nat list list"
  let ?wl = "[79, 77, 67, 62, 41, 49]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,4},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 9, 9, 8, 6, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[15, 14, 14, 12, 7, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[15, 14, 14, 9, 11, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[34, 32, 32, 16, 21, 21]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[35, 30, 28, 24, 22, 16]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 9, 9, 6, 6, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{1,3,4,5},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[1,3,4,5],[0,1,2,3,5]]::nat list list"
  let ?wl = "[18, 17, 15, 14, 12, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[22, 21, 20, 14, 14, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,1,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,1,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[11, 10, 8, 7, 7, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[51, 44, 41, 32, 32, 32]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[8, 8, 6, 6, 5, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{2,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[81, 81, 86, 78, 73, 73]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{2,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[2,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[19, 17, 17, 15, 12, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{0,1,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[197, 187, 152, 169, 155, 118]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[6, 6, 4, 5, 5, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[27, 27, 21, 22, 19, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[11, 9, 10, 9, 9, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[23, 22, 21, 18, 15, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[25, 24, 22, 21, 16, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[21, 21, 20, 18, 16, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{0,1,2,3,4},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[0,1,2,3,4],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[17, 16, 15, 13, 13, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[25, 25, 23, 21, 21, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[25, 25, 23, 21, 21, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[61, 61, 59, 53, 41, 37]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[39, 39, 38, 31, 31, 26]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,4},{0,1,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,1,3,5]]::nat list list"
  let ?wl = "[29, 25, 23, 22, 15, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,4},{0,1,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,1,4,5]]::nat list list"
  let ?wl = "[21, 18, 17, 15, 14, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,4},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[1,3,4,5]]::nat list list"
  let ?wl = "[7, 7, 6, 6, 5, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,2,4,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,2,4,5],[1,3,4,5]]::nat list list"
  let ?wl = "[50, 49, 42, 32, 34, 34]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,3,5},{0,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,2,3,5]]::nat list list"
  let ?wl = "[5, 4, 4, 3, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,1,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,1,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[12, 10, 9, 8, 6, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,2,3,4},{0,3,4,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,2,3,4],[0,3,4,5],[1,3,4,5]]::nat list list"
  let ?wl = "[13, 12, 10, 9, 9, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,1,4,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,1,4,5],[0,3,4,5]]::nat list list"
  let ?wl = "[6, 5, 3, 4, 4, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3,4},{0,1,3,5},{0,3,4,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3,4],[0,1,3,5],[0,3,4,5],[1,3,4,5]]::nat list list"
  let ?wl = "[3, 3, 2, 2, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[43, 41, 33, 37, 37, 21]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,2,3,4},{0,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,2,3,4],[0,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[26, 21, 21, 20, 18, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,4,5},{0,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[60, 52, 48, 38, 41, 31]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5]]::nat list list"
  let ?wl = "[12, 12, 8, 11, 9, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{1,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[6, 6, 4, 5, 5, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[21, 21, 16, 19, 15, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,3,5]]::nat list list"
  let ?wl = "[27, 23, 25, 24, 19, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{2,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[11, 9, 10, 10, 9, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,3,4,5},{2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,3,4,5],[2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[16, 15, 14, 14, 11, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{1,3,4,5},{0,1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[1,3,4,5],[0,1,2,3,4]]::nat list list"
  let ?wl = "[12, 12, 8, 10, 10, 9]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[24, 24, 19, 20, 17, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{2,3,4,5},{0,1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[2,3,4,5],[0,1,2,3,4]]::nat list list"
  let ?wl = "[17, 14, 16, 14, 14, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,4,5},{0,3,4,5},{2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,4,5],[0,3,4,5],[2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[15, 14, 14, 12, 10, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[14, 14, 13, 12, 12, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[24, 24, 23, 21, 16, 16]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,3,5},{0,3,4,5},{0,1,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,1,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[22, 19, 16, 17, 14, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,3,4},{0,1,4,5},{0,3,4,5},{0,1,2,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,3,4],[0,1,4,5],[0,3,4,5],[0,1,2,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[140, 121, 104, 98, 98, 89]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,3,4,5},{1,3,4,5},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,3,4,5],[1,3,4,5],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5]]::nat list list"
  let ?wl = "[9, 9, 9, 8, 7, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[53, 47, 53, 48, 45, 45]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[19, 19, 18, 17, 17, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[24, 21, 24, 22, 22, 19]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4],[0,3,4,5]]::nat list list"
  let ?wl = "[9, 7, 7, 7, 7, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,2,4,5]]::nat list list"
  let ?wl = "[35, 30, 28, 21, 24, 22]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[2,3,4,5]]::nat list list"
  let ?wl = "[21, 21, 22, 22, 20, 16]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,2,4,5]]::nat list list"
  let ?wl = "[21, 17, 18, 15, 15, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,3,4,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[1,3,4,5]]::nat list list"
  let ?wl = "[9, 9, 6, 8, 8, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,3,4,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,3,4,5],[2,3,4,5]]::nat list list"
  let ?wl = "[10, 8, 9, 9, 9, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,4,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,4,5],[0,3,4,5]]::nat list list"
  let ?wl = "[459, 368, 368, 326, 326, 323]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[2,3,4,5]]::nat list list"
  let ?wl = "[9, 9, 9, 8, 8, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{2,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[2,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[53, 47, 52, 48, 48, 38]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,3,5},{0,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,3,5],[0,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[83, 72, 61, 64, 59, 43]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,5},{0,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,5],[0,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[30, 24, 24, 23, 21, 19]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,1,2,5},{0,1,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,1,2,5],[0,1,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[81, 69, 50, 64, 58, 58]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[4, 4, 3, 3, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[9, 7, 6, 7, 7, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[1, 1, 1, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,3,4]]::nat list list"
  let ?wl = "[8, 7, 6, 6, 2, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[1,2,3,4]]::nat list list"
  let ?wl = "[4, 3, 3, 3, 3, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[10, 9, 7, 7, 4, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[4, 4, 3, 3, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[29, 27, 24, 24, 8, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[103, 74, 59, 77, 71, 45]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[5, 4, 3, 4, 3, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{1,2,3,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[1,2,3,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[20, 17, 15, 16, 12, 8]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[30, 27, 23, 22, 12, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[39, 25, 25, 35, 32, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[18, 14, 12, 16, 13, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{1,2,3,5},{0,1,2,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[1,2,3,5],[0,1,2,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 7, 7, 8, 8, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[24, 21, 19, 14, 13, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[26, 23, 20, 19, 11, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,3,4,5},{0,1,2,3,4},{0,1,2,4,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,3,4,5],[0,1,2,3,4],[0,1,2,4,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[8, 8, 8, 8, 6, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{0,1,2,3,5},{0,1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[0,1,2,3,5],[0,1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 8, 7, 8, 7, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[6, 5, 5, 4, 4, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[13, 11, 10, 15, 15, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,4,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,4,5],[0,2,4,5]]::nat list list"
  let ?wl = "[7, 6, 5, 4, 3, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,4,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,4,5],[2,3,4,5]]::nat list list"
  let ?wl = "[3, 3, 3, 3, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[1,2,4,5]]::nat list list"
  let ?wl = "[2, 2, 2, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4,5},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4,5],[1,3,4,5]]::nat list list"
  let ?wl = "[3, 3, 2, 2, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,4,5]]::nat list list"
  let ?wl = "[20, 14, 11, 15, 15, 7]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[1,3,4,5]]::nat list list"
  let ?wl = "[9, 7, 5, 8, 7, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,3,4},{0,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,5]]::nat list list"
  let ?wl = "[5, 4, 4, 5, 4, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,2,4,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,2,4,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[32, 28, 25, 20, 19, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[29, 26, 22, 21, 14, 9]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,3,4,5},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,1,2,3,5]]::nat list list"
  let ?wl = "[32, 28, 20, 25, 19, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[32, 28, 20, 25, 19, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[9, 8, 6, 7, 5, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{2,3,4,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[2,3,4,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[6, 6, 6, 6, 5, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[1,2,3,4,5]]::nat list list"
  let ?wl = "[10, 6, 6, 9, 9, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[1,2,3,4,5]]::nat list list"
  let ?wl = "[6, 5, 4, 5, 4, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[10, 7, 7, 9, 7, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{1,2,4,5},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[1,2,4,5],[0,1,2,3,5]]::nat list list"
  let ?wl = "[10, 7, 7, 8, 8, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[32, 23, 23, 27, 23, 15]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{1,2,3,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[110, 79, 79, 93, 79, 52]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[7, 6, 5, 5, 5, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[7, 6, 5, 5, 5, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,3,4},{0,2,3,4},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,4],[0,1,2,3,5]]::nat list list"
  let ?wl = "[7, 6, 6, 7, 6, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,3,4},{0,2,3,4},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,3,4],[0,2,3,4],[1,2,3,4,5]]::nat list list"
  let ?wl = "[4, 4, 4, 3, 3, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{2,3,4,5},{0,1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[2,3,4,5],[0,1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[14, 14, 14, 14, 10, 9]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,1,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,1,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[49, 43, 39, 57, 54, 44]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[21, 21, 19, 20, 16, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[13, 13, 12, 12, 10, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[14, 11, 10, 11, 10, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,2,3,5},{0,1,3,4,5},{0,2,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,2,3,5],[0,1,3,4,5],[0,2,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[14, 14, 14, 15, 15, 12]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,3,4,5},{0,1,2,3,4},{0,1,2,3,5},{0,1,2,4,5},{0,1,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,3,4,5],[0,1,2,3,4],[0,1,2,3,5],[0,1,2,4,5],[0,1,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[53, 49, 42, 55, 52, 52]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,1,3,4},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,4],[0,2,4,5]]::nat list list"
  let ?wl = "[32, 28, 25, 20, 22, 11]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,1,3,4},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,4],[2,3,4,5]]::nat list list"
  let ?wl = "[12, 12, 12, 12, 11, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,1,2,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,1,2,5],[0,2,4,5]]::nat list list"
  let ?wl = "[33, 29, 26, 20, 17, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,2,4},{0,1,3,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,2,4],[0,1,3,5],[2,3,4,5]]::nat list list"
  let ?wl = "[3, 3, 3, 3, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[1,2,3,5]]::nat list list"
  let ?wl = "[11, 7, 7, 10, 9, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4},{0,1,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,3,5]]::nat list list"
  let ?wl = "[5, 4, 3, 4, 3, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,5},{0,1,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,1,3,5]]::nat list list"
  let ?wl = "[26, 19, 15, 21, 15, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,5},{1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[1,2,3,5]]::nat list list"
  let ?wl = "[11, 8, 8, 10, 7, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[26, 19, 15, 21, 15, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{1,2,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[1,2,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[11, 8, 8, 10, 7, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{1,2,4,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[1,2,4,5],[0,3,4,5]]::nat list list"
  let ?wl = "[7, 5, 5, 5, 6, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,5},{1,2,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,5],[1,2,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[13, 10, 10, 11, 8, 10]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,2,3,4]]::nat list list"
  let ?wl = "[5, 4, 4, 5, 4, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,1,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,1,4,5]]::nat list list"
  let ?wl = "[17, 17, 11, 23, 24, 20]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,4,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[0,2,4,5]]::nat list list"
  let ?wl = "[6, 5, 5, 5, 5, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4,5]]::nat list list"
  let ?wl = "[9, 7, 6, 7, 7, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,5},{0,3,4,5},{1,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,5],[0,3,4,5],[1,2,3,4,5]]::nat list list"
  let ?wl = "[64, 43, 43, 58, 48, 48]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[38, 33, 30, 45, 42, 38]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{0,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[0,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[52, 42, 31, 56, 53, 43]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[13, 13, 15, 17, 16, 13]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,3,4},{0,1,2,5},{0,1,2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,3,4],[0,1,2,5],[0,1,2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[14, 11, 10, 11, 10, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,3,4},{2,3,4,5},{0,1,2,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,3,4],[2,3,4,5],[0,1,2,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[19, 17, 19, 20, 16, 15]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,4,5},{2,3,4,5},{0,1,2,3,4},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,4,5],[2,3,4,5],[0,1,2,3,4],[0,2,3,4,5]]::nat list list"
  let ?wl = "[6, 5, 6, 6, 6, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,1,3,4},{0,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,3,4],[0,2,3,4]]::nat list list"
  let ?wl = "[4, 3, 3, 3, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,4},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,4],[2,3,4,5]]::nat list list"
  let ?wl = "[7, 7, 8, 9, 9, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,5},{0,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[0,3,4,5]]::nat list list"
  let ?wl = "[25, 20, 15, 27, 25, 23]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,1,3,5},{2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,1,3,5],[2,3,4,5]]::nat list list"
  let ?wl = "[15, 15, 18, 20, 19, 17]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{0,1,2,3},{0,1,2,4},{0,1,2,5},{0,3,4,5},{0,1,3,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[0,1,2,3],[0,1,2,4],[0,1,2,5],[0,3,4,5],[0,1,3,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[10, 7, 7, 8, 8, 6]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5},{0,1,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,1,2,4,5]]::nat list list"
  let ?wl = "[15, 15, 10, 16, 16, 15]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{3,4,5},{0,1,2,3},{0,1,2,4},{0,3,4,5},{1,3,4,5},{0,1,2,3,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[3,4,5],[0,1,2,3],[0,1,2,4],[0,3,4,5],[1,3,4,5],[0,1,2,3,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[5, 5, 4, 5, 5, 4]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,3}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,3]]::nat list list"
  let ?wl = "[1, 1, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,1,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,1,4]]::nat list list"
  let ?wl = "[3, 3, 2, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,2,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,2,4]]::nat list list"
  let ?wl = "[4, 3, 3, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,3,4]]::nat list list"
  let ?wl = "[2, 2, 2, 2, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{0,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[0,4,5]]::nat list list"
  let ?wl = "[10, 8, 4, 6, 5, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,3,4},{1,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,3,4],[1,3,5]]::nat list list"
  let ?wl = "[2, 2, 1, 2, 1, 1]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{0,2,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[0,2,3,4,5]]::nat list list"
  let ?wl = "[11, 10, 10, 8, 5, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{0,1,2,3,4},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[0,1,2,3,4],[0,1,3,4,5]]::nat list list"
  let ?wl = "[15, 15, 20, 10, 16, 14]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{0,2,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[0,2,4,5]]::nat list list"
  let ?wl = "[8, 7, 7, 5, 3, 3]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{0,1,2,4},{0,1,2,3,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[0,1,2,4],[0,1,2,3,5]]::nat list list"
  let ?wl = "[21, 21, 28, 14, 22, 20]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{2,3,4,5},{0,1,2,3,4}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[2,3,4,5],[0,1,2,3,4]]::nat list list"
  let ?wl = "[8, 8, 9, 7, 6, 5]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0,1,2},{0,1,3},{2,4,5},{2,3,4,5},{0,1,3,4,5}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0,1,2],[0,1,3],[2,4,5],[2,3,4,5],[0,1,3,4,5]]::nat list list"
  let ?wl = "[3, 3, 3, 3, 2, 2]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0, 1}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0, 1]]::nat list list"
  let ?wl = "[1, 1, 0, 0, 0, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed

lemma [simp]:
shows "FC_family ({{0}}::nat set set)" (is "FC_family ?A")
proof-
  let ?Al = "[[0]]::nat list list"
  let ?wl = "[1, 0, 0, 0, 0, 0]::nat list"
  show ?thesis
    by (tactic {* fc_family_tac @{context} @{term ?A} @{term ?Al} @{term ?wl} 1 *}) eval
qed
*)

(*
theorem "\<forall> F \<in> set FC6. FC_family (f_to_set_l F)"
unfolding FC6_def
by (simp del: One_nat_def)
*)

theorem "\<forall> F \<in> set nonFC6. \<not> FC_family (f_to_set_l F)"
unfolding nonFC6_def
by (simp del: One_nat_def)

end
