section{* Tactics *}

theory FCTactics
imports FranklImpl SomeShareNegativeImpl
begin

ML_file "eval_tac.ML"

subsection{* Tactics for verifying FC families *}

text{* Tactic relies on applying the @{term "some_share_negative"} function. *}

ML{*
fun FC_family_uce_shares_nonneg_inst w =
 Thm.instantiate' 
     [SOME @{ctyp "nat"}]
     [SOME (Thm.cterm_of @{context} w)]
     @{thm FC_family_uce_shares_nonneg};

fun SomeShareNegativeSound_nats_inst A A' w w' =
 Thm.instantiate' 
    []
    (map (fn x => SOME (Thm.cterm_of @{context} x)) [A, A', w', w]) @{thm some_share_negative_soundness_nats};

fun fc_family_tac ctx A Al wl  = 
  let
    val term_zip = @{term "(zip::(nat list \<Rightarrow> nat list \<Rightarrow> (nat \<times> nat) list)) [0..<6::nat]"}
    val term_weights2map = @{term "weights2map::(nat \<times> nat) list \<Rightarrow> nat \<Rightarrow> nat"};
    val term_sls = @{term "sorted_list_of_set::nat set\<Rightarrow>nat list"};
    val term_tabulate = @{term "Mapping.tabulate::nat list \<Rightarrow> (nat \<Rightarrow> nat) \<Rightarrow> (nat, nat) mapping"};
    val term_sup = @{term "Sup::(nat set set\<Rightarrow>nat set)"};

    val w =  term_weights2map $ (term_zip $ wl);
    val w' = list_comb (term_tabulate, [term_sls $ (term_sup $ A), w]);
  in
          resolve_tac ctx [FC_family_uce_shares_nonneg_inst w]
    THEN' asm_full_simp_tac (ctx addsimps [@{thm weight_fun_def}, @{thm weights2map_def}, @{thm upt_def}])
    THEN' resolve_tac ctx [SomeShareNegativeSound_nats_inst A Al w w']
    THEN' asm_full_simp_tac ctx
    THEN' asm_full_simp_tac ctx
    THEN' asm_full_simp_tac ctx
    THEN' asm_full_simp_tac ctx
    THEN' asm_full_simp_tac ctx
  end
*}

subsection{* Tactics for verifying nonFC families *}

text{* Tactic for checking if a family belongs to the union-closed extension of a given family *}

thm SetUnionImpl_nats.union_closed_additional_set

ML{*

(*
fun union_closed_additional_tac' ctx F I i = 
  EqSubst.eqsubst_tac ctx [0] [f_to_set_l_thm F] i THEN
  EqSubst.eqsubst_tac ctx [0] [f_to_set_l_thm I] i  THEN
  resolve_tac ctx [@{thm SetUnionImpl_lists.union_closed_additional_set}] i THEN
  eval_tac ctx i 
*)

fun union_closed_additional_tac' ctx F I i = 
  EqSubst.eqsubst_tac ctx [0] [f_to_set_n_thm F] i THEN
  EqSubst.eqsubst_tac ctx [0] [f_to_set_n_thm I] i  THEN
  resolve_tac ctx [@{thm SetUnionImpl_nats.union_closed_additional_set}] i THEN
  eval_tac ctx i


fun union_closed_tac' ctx F i =
  EqSubst.eqsubst_tac ctx [0] [f_to_set_l_thm F] i THEN
  resolve_tac ctx [@{thm SetUnionImpl_lists.union_closed_set}] i THEN
  eval_tac ctx i

fun union_closed_additional_select_tac ctx (t, i) =
  case t of
    @{term "Trueprop"} $ t' => union_closed_additional_select_tac ctx (t', i)
  | @{term "UnionClosed.union_closed_additional::nat set set \<Rightarrow> nat set set \<Rightarrow> bool"} $ F $ I => union_closed_additional_tac' ctx F I i
  | _ => raise Fail ("select_tac: pattern not matched")

fun union_closed_additional_tac ctx i = 
  SUBGOAL (union_closed_additional_select_tac ctx) i

fun union_closed_select_tac ctx (t, i) =
  case t of
    @{term "Trueprop"} $ t' => union_closed_select_tac ctx (t', i)
  | @{term "UnionClosed.union_closed::nat set set \<Rightarrow> bool"} $ F => union_closed_tac' ctx F i
  | _ => raise Fail ("select_tac: pattern not matched")

fun union_closed_tac ctx i = 
  SUBGOAL (union_closed_select_tac ctx) i

fun union_closed_extension_tac ctx = 
  rewrite_goals_tac ctx [@{thm union_closed_extensions_def}] THEN
  EqSubst.eqsubst_tac ctx [0] [@{thm mem_Collect_eq}] 1 THEN 
  resolve_tac ctx [@{thm conjI}] 1 THEN 
  union_closed_additional_tac ctx 2 THEN
  auto_tac ctx
*}

text{* Tactic for checking if the given coefficients c satisfy the given system of 
   inequalities determined by the given families Fs *}

text{* Lemma that allows to reformulate the statement as a problem over lists and gain faster 
   executability. *}
lemma nonFC_is_system_solution_lists:
  assumes "Fs = map f_to_set_l Fs_l" "set Fc_l = \<Union> Fc"  "\<forall> F \<in> set Fs_l. distinct F" "\<forall> F \<in> set Fs_l. \<forall> A \<in> set F. sorted A \<and> distinct A"
  shows "(let Fs' = Fs in \<forall> a \<in> \<Union> Fc. sum_list (map (\<lambda> (x, y). int x * y) (zip c (map (Frankl.frankl_fun a) Fs'))) < 0) \<longleftrightarrow>
         (list_all (\<lambda> a. sum_list (map (\<lambda> (x, y). int x * y) (zip c (map (frankl_fun_l a) Fs_l))) < 0) Fc_l)"
proof-
  have "\<forall> a. map (Frankl.frankl_fun a) Fs = map (frankl_fun_l a) Fs_l"
    using assms SetImpl_lists.frankl_fun_set
    by (simp add: count_l_def)
  thus ?thesis
    using assms(2)
    unfolding list_all_iff
    by auto
qed

ML{*

fun nonFC_is_system_solution_tac' ctx FF Fc_l i =
let
   val thm = @{thm nonFC_is_system_solution_lists} OF [list_f_to_set_l_thm FF]
   val thm = Thm.instantiate' [] [SOME (Thm.cterm_of @{context} Fc_l)] thm
in
  EqSubst.eqsubst_tac ctx [0] [thm] i
end

fun nonFC_is_system_solution_tac_select ctx Fc_l (t, i) = 
  case t of
     @{term "Trueprop"} $ t =>
           nonFC_is_system_solution_tac_select ctx Fc_l (t, i)
   | @{term "HOL.Let :: nat set set list \<Rightarrow> (nat set set list \<Rightarrow> bool) \<Rightarrow> bool"} $ FF $ _ =>
           nonFC_is_system_solution_tac' ctx FF Fc_l i
   | _ $ t => nonFC_is_system_solution_tac_select ctx Fc_l (t, i)
   | _ => no_tac

fun nonFC_is_system_solution_tac ctx Fc_l i = 
  SUBGOAL (nonFC_is_system_solution_tac_select ctx Fc_l) i THEN
  eval_tac ctx i THEN
  eval_tac ctx i THEN
  eval_tac ctx i THEN
  eval_tac ctx i
*}

end
