section{* Families of sets *}
theory Family
imports Main
begin

definition count :: "'a \<Rightarrow> 'a set set \<Rightarrow> nat" where 
  "count a F \<equiv> card {S \<in> F. a \<in> S}"

lemma count_Un_disjoint:
  assumes "A \<inter> B = {}" and "finite A" and "finite B"
  shows "count a (A \<union> B) = count a A + count a B"
proof-
  have "{S \<in> A. a \<in> S} \<inter> {S \<in> B. a \<in> S} = {}"
    "{S \<in> A \<union> B. a \<in> S} = {S \<in> A. a \<in> S} \<union> {S \<in> B. a \<in> S}"
    using assms
    by auto
  thus ?thesis
    unfolding count_def
    using assms card_Un_disjoint[of "{S \<in> A. a \<in> S}" "{S \<in> B. a \<in> S}"]
    by auto
qed

end