section{* Frankl's condition *}

theory Frankl
imports Family UnionClosed More.MoreSet
begin

(* ************************************************************************** *)
subsection{* Frankl's condition *}
(* ************************************************************************** *)

text{* Note that, in order to avoid using rational numbers, the
following condition is not formulated as @{text "count x F \<ge> (card F)
/ 2"}, what would be more expected. *}

abbreviation frankl_element :: "'a \<Rightarrow> 'a set set \<Rightarrow> bool" where
  "frankl_element x F \<equiv> x \<in> \<Union> F \<and> 2 * count x F \<ge> card F"

definition frankl :: "'a set set \<Rightarrow> bool" where
  "frankl F \<equiv> (\<exists> x. frankl_element x F)"

lemma obtain_frankl_element:
  assumes "frankl F"
  obtains x where "x \<in> \<Union> F" and " 2 * count x F \<ge> card F"
using assms
unfolding frankl_def
by auto

(* -------------------------------------------------------------------------- *)
subsubsection{* Frankl's function *}
(* -------------------------------------------------------------------------- *)

abbreviation frankl_fun :: "'a \<Rightarrow> 'a set set \<Rightarrow> int" where 
  "frankl_fun x F \<equiv> 2 * int (count x F) - int (card F)"

lemma 
  shows "frankl_element x F \<longleftrightarrow> (x \<in> \<Union> F \<and> frankl_fun x F \<ge> 0)"
by auto

lemma frankl_fun_Un_disjoint:
  assumes "A \<inter> B = {}" and "finite A" and "finite B"
  shows "frankl_fun a (A \<union> B) = frankl_fun a A + frankl_fun a B"
proof-
  let ?A = "{S. S \<in> A \<and> a \<in> S}" and ?B = "{S. S \<in> B \<and> a \<in> S}"
  have *: "{S. (S \<in> A \<union> B) \<and> a \<in> S} = ?A \<union> ?B" "?A \<inter> ?B = {}"
    using assms
    by auto
  hence "card {S. (S \<in> A \<union> B) \<and> a \<in> S} = card ?A + card ?B"
    using assms
    using card_Un_disjoint[of ?A ?B] 
    by auto
  thus ?thesis
    using assms
    unfolding count_def
    by (auto simp add: card_Un_disjoint)
qed

lemma frankl_fun_Un_disjoint_3:
  assumes "finite A" and "finite B" and "finite C" 
          "A \<inter> B = {}" and "A \<inter> C = {}" and "B \<inter> C = {}"
  shows "frankl_fun i (A \<union> B \<union> C) =
         frankl_fun i A + frankl_fun i B + frankl_fun i C"
using assms frankl_fun_Un_disjoint[of "A \<union> B" "C" i]
using assms frankl_fun_Un_disjoint[of "A" "B" i]
by auto

lemma frankl_fun_UN_disjoint:
  assumes "finite (\<Union> set l)" and
          "\<forall> i j. i < length l \<and> j < length l \<and> i \<noteq> j \<longrightarrow> l ! i \<inter> l ! j = {}"
  shows "frankl_fun i (\<Union> set l) = sum_list (map (frankl_fun i)  l)"
using assms
proof (induct l)
  case Nil
  thus ?case
    by (simp add: count_def)
next
  case (Cons a l')
  have *: "\<forall>i j. i < length l' \<and> j < length l' \<and> i \<noteq> j \<longrightarrow> l' ! i \<inter> l' ! j = {}"
    using Cons(3)
    by force
  show ?case
  proof-
    have "frankl_fun i (\<Union> set (a # l')) = frankl_fun i (a \<union> (\<Union> set l'))"
      by simp
    also have "... = frankl_fun i a + frankl_fun i (\<Union> set l')"
    proof (subst frankl_fun_Un_disjoint[of a "\<Union> (set l')" i])
      show "a \<inter> \<Union> set l' = {}"
        using Cons(3)
        by (auto simp add: nth_Cons) (metis Suc_less_eq Zero_not_Suc disjoint_iff_not_equal in_set_conv_nth nth.simps nth_Cons_0 nth_Cons_Suc zero_less_Suc)
    qed (insert Cons(2), auto)
    finally
    show ?thesis
      using Cons(1,2) *
      by simp
  qed
qed

lemma frankl_fun_Pow:
  assumes "finite A" and "a \<in> A" 
  shows "frankl_fun a (Pow A) = 0"
proof-
  have "\<exists> A'. A = A' \<union> {a} \<and> a \<notin> A' \<and> finite A'"
    using assms
    by (rule_tac x="A - {a}" in exI) auto
  then obtain A' where "A = A' \<union> {a}" "a \<notin> A'"  "finite A'"
    by auto
  let ?PA' = "Pow A'" and ?aPA' = "((op \<union> {a}) ` Pow A')"
  have "Pow A = ?PA' \<union> ?aPA'"
    using Pow_insert[of a A'] `A = A' \<union> {a}`
    by (simp add: image_def)
  moreover
  have "?PA' \<inter> ?aPA' = {}"
    using `a \<notin> A'`
    by auto
  ultimately
  have "count a (Pow A) = count a ?PA' + count a ?aPA'"
    using `finite A'`
    by (subst count_Un_disjoint[symmetric]) simp_all
  moreover
  have "{S. S \<subseteq> A' \<and> a \<in> S} = {}"
    using `a \<notin> A'`
    by auto
  hence "count a ?PA' = 0"
    using `finite A'`
    unfolding count_def
    by auto
  moreover
  have "count a ?aPA' = card ?PA'"
  proof-
    have "{S \<in> op \<union> {a} ` Pow A'. a \<in> S} = op \<union> {a} ` Pow A'"
      by auto
    hence "count a (op \<union> {a} ` Pow A') = card (op \<union> {a} ` Pow A')"
      unfolding count_def
      by simp
    also have "... = card (Pow A')"
      using `a \<notin> A'`
      by (subst card_image) (auto simp add: inj_on_def)
    finally 
    show ?thesis
      .
  qed
  ultimately
  show ?thesis
    using `A = A' \<union> {a}` `a \<notin> A'`
    using `finite A'`
    by (auto simp add: card_Pow)
qed

(* ************************************************************************** *)
subsection{* FC Families *}
(* ************************************************************************** *)

definition FC_family where
 "FC_family Fc \<equiv> 
    \<forall> F. F \<supseteq> Fc \<and> finite_union_closed F \<longrightarrow>
         (\<exists> a \<in> \<Union> Fc. 2 * count a F \<ge> card F)"

lemma FC_family_frankl: 
  assumes "FC_family Fc" and "Fc \<subseteq> F" and "finite_union_closed F"
  shows "frankl F"
proof-
  have "\<Union> Fc \<subseteq> \<Union> F"
    using `Fc \<subseteq> F`
    by auto
  thus ?thesis
    using assms
    unfolding FC_family_def frankl_def
    by blast
qed

lemma FC_family_mono: 
  assumes "Fc \<subseteq> Fc'" and "FC_family Fc"
  shows "FC_family Fc'"
unfolding FC_family_def
proof (safe)
  fix F
  assume "Fc' \<subseteq> F" "union_closed F" "finite (\<Union> F)"
  hence "Fc \<subseteq> F"
    using  `Fc \<subseteq> Fc'`
    by auto
  then obtain a where "a \<in> \<Union> Fc" "card F \<le> 2 * count a F"
    using `FC_family Fc` `union_closed F` `finite (\<Union> F)`
    unfolding FC_family_def
    by blast
  thus "\<exists>a\<in>\<Union>Fc'. card F \<le> 2 * count a F"
    using `Fc \<subseteq> Fc'` `Fc' \<subseteq> F`
    by blast
qed

lemma FC_family_empty_set_remove:
  shows "FC_family Fc \<longleftrightarrow> FC_family (Fc - {{}})"
proof
  assume "FC_family Fc"
  show "FC_family (Fc - {{}})"
    unfolding FC_family_def
  proof (safe)
    fix F
    assume "Fc - {{}} \<subseteq> F" "union_closed F" "finite (\<Union> F)"
    hence "Fc \<subseteq> F \<union> {{}}" "finite_union_closed (F \<union> {{}})"
      by (auto simp add: union_closed_def)
    then obtain a where "a\<in>\<Union>Fc" "card (F \<union> {{}}) \<le> 2 * count a (F \<union> {{}})"
      using `FC_family Fc`
      unfolding FC_family_def
      by blast
    moreover
    have "card F \<le> card (F \<union> {{}})"
      using `finite (\<Union>F)`
      by (auto simp add: finiteUn_iff card_insert_le)
    moreover
    have "{A. (A = {} \<or> A \<in> F) \<and> a \<in> A} = {A \<in> F. a \<in> A}"
      by auto
    hence "2 * count a (F \<union> {{}}) = 2 * count a F"
      by (auto simp add: count_def)
    ultimately
    have "card F \<le> 2 * count a F" "a \<in> \<Union>(Fc - {{}})"
      by auto
    thus "\<exists>a\<in>\<Union>(Fc - {{}}). card F \<le> 2 * count a F"
      by blast
  qed
next
  assume "FC_family (Fc - {{}})"
  thus "FC_family Fc"
    unfolding FC_family_def
    by auto
qed

lemma FC_family_empty_set_insert:
  shows "FC_family (Fc \<union> {{}}) \<longleftrightarrow> FC_family Fc"
by (metis FC_family_empty_set_remove Diff_insert_absorb Un_empty_right Un_insert_right insert_absorb)

lemma FC_family_closure:
  assumes "finite Fc"
  shows "FC_family Fc \<longleftrightarrow> FC_family (closure Fc)"
proof
  assume "FC_family Fc"
  moreover
  have "Fc \<subseteq> closure Fc"
    by (auto simp add: closure_def)
  ultimately
  show "FC_family (closure Fc)"
    unfolding FC_family_def
    by auto
next
  assume "FC_family (closure Fc)"
  thus "FC_family Fc"
    unfolding FC_family_def
    using closure_min_closed[of Fc] `finite Fc`
    by auto
qed

end
