section{* Expressible sets and irrreducible families *}
theory IrreducibleFamilies
imports UnionClosed 
begin

definition expressible where
"expressible A F \<longleftrightarrow> (\<exists> F'. F' \<subseteq> F \<and> F' \<noteq> {} \<and> A = \<Union> F')"

lemma "expressible A F \<longleftrightarrow> (\<exists> F' \<subseteq> F. F' \<noteq> {} \<and> (\<forall> A' \<in> F'. A' \<subseteq> A) \<and> \<Union> F' = A)"
unfolding expressible_def
by auto

lemma expressible_closure1:
  assumes "expressible A F"
  shows "A \<in> closure F"
using assms
unfolding expressible_def closure_def
by auto

lemma expressible_closure2:
  assumes "expressible A F"
  shows "(op \<union> A) ` (closure F) \<subseteq> closure F"
proof(safe)
  fix x
  from `expressible A F` obtain F' where *: "F' \<in> Pow F" "A = \<Union> F'"
    by (auto simp add: expressible_def)
  assume "x \<in> closure F"
  then obtain F'' where "F'' \<in> Pow F - {{}}" "x = \<Union> F''"
    unfolding closure_def
    by auto
  have "F'' \<union> F' \<in> Pow F - {{}}"
    using `F' \<in> Pow F` `F'' \<in> Pow F - {{}}`
    by auto
  moreover
  have "A \<union> x = \<Union> (F'' \<union> F')"
    using `A = \<Union> F'` `x = \<Union> F''`
    by auto
  ultimately
  show "A \<union> x \<in> closure F"
    unfolding closure_def
    by (metis image_iff) 
qed

lemma expressible_closure:
  assumes "expressible A F" "finite F" 
  shows "closure (F \<union> {A}) = closure F"
using assms
using closure_insert[of F A]
using expressible_closure1[of A F]
using expressible_closure2[of A F]
by auto

(* -------------------------------------------------------------------------- *)
subsection{* Irreducible families *}

definition reducible :: "'a set set \<Rightarrow> bool" where
  "reducible F \<longleftrightarrow>
   (\<exists> A F'. A \<in> F \<and> F' \<subseteq> F \<and> F' \<noteq> {} \<and> A \<notin> F' \<and> A = \<Union> F')"

abbreviation irreducible :: "'a set set \<Rightarrow> bool" where
  "irreducible F \<equiv> \<not> reducible F"

lemma "reducible F \<longleftrightarrow> (\<exists> A \<in> F. expressible A (F - {A}))"
unfolding reducible_def expressible_def
by auto


(* -------------------------------------------------------------------------- *)
subsection{* Removing all expressible sets *}

function (domintros) remove_expressible where
 "remove_expressible F = 
    (if (\<exists> A \<in> F. expressible A (F - {A})) then 
       let A = SOME A. A \<in> F \<and> expressible A (F - {A})
       in remove_expressible (F - {A})
    else
       F)"
by pat_completeness auto

lemma remove_expressible_dom:
  assumes "finite F"
  shows "remove_expressible_dom F"
using assms
proof (induct F rule: wf_induct[of "measure card"])
  show "wf (measure card)"
    by auto
next
  fix x::"'a set set"
  assume "finite x" and *: "\<forall>y. (y, x) \<in> measure card \<longrightarrow> finite y \<longrightarrow> remove_expressible_dom y"
  show "remove_expressible_dom x"
  proof (rule remove_expressible.domintros)
    fix A
    assume ++: "A \<in> x" "expressible A (x - {A})"
    let ?A = "SOME A. A \<in> x \<and> expressible A (x - {A})"
    let ?y = "x - {?A}"
    show "remove_expressible_dom ?y"
    proof (rule *[rule_format])
      show "(x - {?A}, x) \<in> measure card"
      proof (simp, rule card_Diff1_less)
        show "finite x" by fact
      next
        show "?A \<in> x"
          using ++
          by (metis (lifting) someI_ex)
      qed
    next
      show "finite (x - {?A})"
        using `finite x`
        by auto
    qed
  qed
qed

lemma remove_expressible_subset:
  assumes "finite F"
  shows "remove_expressible F \<subseteq> F"
proof-
  have "remove_expressible_dom F"
    using `finite F`
    by (rule remove_expressible_dom)
  thus ?thesis
    using assms
  proof (induct F rule: remove_expressible.pinduct)
    case (1 F)
    show ?case
    proof (cases "\<exists> A \<in> F. expressible A (F - {A})")
      case False
      thus ?thesis
        using `remove_expressible_dom F` remove_expressible.psimps[of F]
        by simp
    next
      case True
      thus ?thesis
        using `remove_expressible_dom F` remove_expressible.psimps[of F]
        using 1
        unfolding Let_def
        by auto
    qed
  qed
qed


lemma remove_expressible_closure:
  assumes "finite F"
  shows "closure F = closure (remove_expressible F)"
proof-
  have "remove_expressible_dom F"
    using `finite F`
    by (rule remove_expressible_dom)
  thus ?thesis
    using assms
  proof (induct F rule: remove_expressible.pinduct)
    case (1 F)
    show ?case
    proof (cases "\<exists> A \<in> F. expressible A (F - {A})")
      case False
      thus ?thesis
        using `remove_expressible_dom F` remove_expressible.psimps[of F]
        by simp
    next
      case True
      let ?A = "SOME A. A \<in> F \<and> expressible A (F - {A})"
      have *: "closure (F - {?A}) = closure (remove_expressible (F - {?A}))"
        using 1(2)[of ?A] 1(3) True
        by simp
      moreover
      have "closure F = closure (F - {SOME A. A \<in> F \<and> expressible A (F - {A})})"
      proof-
        have "?A \<in> F \<and> expressible ?A (F - {?A})"
          using True
          by (metis (lifting) someI_ex)
        thus ?thesis
          using expressible_closure[of ?A "F - {?A}"] 1(3)
          by simp (metis (lifting) insert_absorb)
      qed
      thus ?thesis
        using `remove_expressible_dom F` remove_expressible.psimps[of F] True *
        by simp
    qed
  qed
qed

lemma remove_expressible_irreducible:
  assumes "finite F"
  shows "irreducible (remove_expressible F)"
proof-
  have "let F' = remove_expressible F in
         \<not> (\<exists> A \<in> F'. expressible A (F' - {A}))"
  proof-
    have "remove_expressible_dom F"
      using `finite F`
      by (rule remove_expressible_dom)
    thus ?thesis
      using assms
    proof (induct F rule: remove_expressible.pinduct)
      case (1 F)
      show ?case
      proof (cases "\<exists> A \<in> F. expressible A (F - {A})")
        case False
        thus ?thesis
          using `remove_expressible_dom F` remove_expressible.psimps[of F]
          by simp
      next
        case True
        thus ?thesis
          using `remove_expressible_dom F` remove_expressible.psimps[of F]
          using 1
          unfolding Let_def
          by simp
      qed
    qed
  qed
  thus ?thesis
    using assms
    unfolding Let_def
    unfolding expressible_def reducible_def
    by auto
qed

lemma ex_irreducible_closure:
  fixes F
  assumes "finite F"
  shows "\<exists> F' \<subseteq> F. irreducible F' \<and> closure F' = closure F"
  using assms
  using remove_expressible_closure[OF assms]
  using remove_expressible_subset[OF assms]
  using remove_expressible_irreducible[OF assms]
  by auto

subsection{* Uniqueness of irreducible subfamily for the given closure *}

lemma irreducible_closure':
  assumes "irreducible F'" and "closure F = closure F'"
  shows "F' \<subseteq> F"
proof (rule ccontr)
  assume "\<not> ?thesis"
  then obtain A where "A \<in> F'" "A \<notin> F"
    by auto
  have "A \<in> closure F"
    using `closure F = closure F'` `A \<in> F'`
    unfolding closure_def
    by auto
  then obtain Fa where "Fa \<subseteq> F" "Fa \<noteq> {}" "\<Union> Fa = A"
    by (auto simp add: closure_def)
  let ?F1 = "Fa - F'" and ?F2 = "Fa \<inter> F'"
  have "?F1 \<subseteq> closure F"
    using `Fa \<subseteq> F`
    by (auto simp add: closure_def)
  hence "\<forall> A' \<in> ?F1. A' \<in> closure F'"
    using `closure F = closure F'` `A \<notin> F` `Fa \<subseteq> F`
    by (auto simp add: closure_def)

  let ?f = "\<lambda> A' F''. F'' \<subseteq> F' \<and> F'' \<noteq> {} \<and> A' = \<Union> F''"

  have *: "\<forall> A' \<in> ?F1. \<exists> F''. ?f A' F''"
  proof
    fix A'
    assume "A' \<in> ?F1"
    then obtain F'' where "F'' \<in> Pow F' - {{}}" " A' = Union F''"
      using `\<forall> A' \<in> ?F1. A' \<in> closure F'`
      unfolding closure_def
      by (metis image_iff)
    thus "\<exists>F''. ?f A' F''" 
      by auto
  qed

  let ?fs = "\<lambda> A'. SOME F''. ?f A' F''"
  let ?F'' = "?F2 \<union> \<Union> (?fs ` ?F1) "

  have "?F'' \<subseteq> F'"
  proof (safe)
    fix x A'
    assume "A' \<in> Fa" "A' \<notin> F'"
    hence "\<exists> F''. ?f A' F''"
      using *
      by auto
    assume "x \<in> ?fs A'"
    thus "x \<in> F'"
      using someI_ex[of "?f A'", OF `\<exists> F''. ?f A' F''`]
      by auto
  qed
  moreover
  have "\<Union>\<Union> (?fs ` ?F1) = \<Union> ?F1"
  proof
    show "\<Union>\<Union> (?fs ` ?F1) \<subseteq> \<Union> ?F1"
    proof
      fix x
      assume "x \<in> \<Union>\<Union> (?fs ` ?F1)"
      then obtain A' where "x \<in> \<Union> ?fs A'" "A' \<in> ?F1"
        by auto
      thus "x \<in> \<Union> ?F1"
        using * someI_ex[of "?f A'"]
        by auto
    qed
  next
    show "\<Union> ?F1 \<subseteq> \<Union>\<Union> (?fs ` ?F1)"
    proof
      fix x
      assume "x \<in> \<Union> ?F1"
      then obtain A' where "x \<in> A'" "A' \<in> ?F1"
        by auto
      hence "\<exists> F''. ?f A' F''"
        using *
        by auto
      show "x \<in> \<Union>\<Union> (?fs ` ?F1) "
        using `x \<in> A'` `A' \<in> ?F1`
        using someI_ex[of "?f A'", OF `\<exists> F''. ?f A' F''`]
        by auto
    qed
  qed
  hence "\<Union> ?F'' = A"
    using `\<Union> Fa = A`
    by auto
  moreover
  have "A \<notin> ?F''"
  proof (rule ccontr)
    assume "\<not> ?thesis"
    hence "A \<in> ?F''"
      by simp
    hence "A \<in> \<Union> (?fs ` ?F1)"
      using `A \<notin> F` `Fa \<subseteq> F`
      by auto
    then obtain A' where "A' \<in> ?F1" "A \<in> ?fs A'"
      by auto
    have "A' \<subseteq> A"
      using `\<Union> Fa = A` `A' \<in> ?F1`
      by auto
    moreover
    have "\<exists> F''. ?f A' F''"
      using * `A' \<in> ?F1`
      by auto
    have "A \<subseteq> A'"
      using `A \<in> ?fs A'` `A' \<in> ?F1`
      using someI_ex[of "?f A'", OF `\<exists> F''. ?f A' F''`]
      by auto
    ultimately
    have "A \<in> ?F1"
      using `A' \<in> ?F1`
      by auto
    thus False
      using `A \<notin> F` `Fa \<subseteq> F`
      by auto
  qed
  moreover
  have "?F'' \<noteq> {}"
  proof-
    from `Fa \<noteq> {}`
    obtain A' where "A' \<in> Fa"
      by auto
    show ?thesis
    proof (cases "A' \<in> F'")
      case True
      thus ?thesis
        using `A' \<in> Fa`
        by auto
    next
      case False
      hence "A' \<in> Fa - F'"
        using `A' \<in> Fa`
        by auto
      hence "\<exists> F''. ?f A' F''"
        using *
        by auto
      have "\<Union> (?fs ` ?F1) \<noteq> {}"
        using someI_ex[of "?f A'", OF `\<exists> F''. ?f A' F''`] `A' \<in> Fa - F'`
        by auto
      thus ?thesis
        by simp
    qed
  qed
  ultimately
  have "expressible A (F' - {A})"
    unfolding expressible_def
    by (rule_tac x="?F''" in exI) auto
  thus False
    using `irreducible F'` `A \<in> F'`
    unfolding reducible_def expressible_def
    by auto
qed

lemma irreducible_closure:
  assumes "irreducible F" and "irreducible F'" and "closure F = closure F'"
  shows "F = F'"
using assms
using irreducible_closure'
by auto

end
