subsubsection{* Implementation by sorted and distinct lists *}

theory IrreducibleFamiliesImpl
imports IrreducibleFamilies UnionClosedImpl Combinatorics
begin

definition expressible_l where
"expressible_l A F \<equiv> A \<in> set (map Union_l (all_nonempty_subsets F))"

lemma expressible_l_soundness:
  assumes "expressible_l A F"
  shows "expressible (set A) (f_to_set_l F)"
proof-
  from assms obtain X' where "X' \<in> set (all_nonempty_subsets F)" "A = Union_l X'"
    unfolding expressible_l_def
    by auto
  then obtain X where "set X \<subseteq> set F" "1 \<le> length X" "set A = \<Union> (f_to_set_l X)"
    using SetUnionImpl_lists.Union_set[of X'] all_subs_set[of F]
    by auto
  thus ?thesis
    unfolding expressible_def
    by (rule_tac x="f_to_set_l X" in exI) auto
qed

lemma f_to_set_l_subset_ex:
  fixes F'::"nat set set"
  assumes "F' \<subseteq> f_to_set_l Fl"
  shows "\<exists> F'l. set F'l \<subseteq> set Fl  \<and> f_to_set_l F'l = F' \<and> distinct F'l \<and> length F'l \<le> length Fl"
using assms
using assms
proof (induct Fl arbitrary: F')
  case Nil
  thus ?case
    by auto
next
  case (Cons a Fl)
  show ?case
  proof (cases "F' \<subseteq> f_to_set_l Fl")
    case True
    thus ?thesis
      using Cons(1)[of F']
      by auto
  next
    case False
    hence "F' - {set a} \<subseteq> f_to_set_l Fl" "a \<notin> set Fl" "set a \<in> F'"
      using Cons(2)
      by auto
    then obtain F'l where
      "set F'l \<subseteq> set Fl" "distinct F'l" "f_to_set_l F'l = F' - {set a}" "length F'l \<le> length Fl"
      using Cons(1)[of "F' - {set a}"]
      by auto
    thus ?thesis
      using `a \<notin> set Fl` `set a \<in> F'`
      by (rule_tac x="F'l @ [a]" in exI) auto
  qed
qed
  
lemma expressible_l_completeness_lemma: 
  assumes "F' \<subseteq> f_to_set_l Fl" "F' \<noteq> {}"
  shows "\<Union> F' \<in> set (map set (map Union_l (all_nonempty_subsets Fl)))"
proof-
  obtain F'l where "set F'l \<subseteq> set Fl" "distinct F'l" "f_to_set_l F'l = F'" "length F'l \<le> length Fl"
    using f_to_set_l_subset_ex[OF assms(1)]
    by auto
  have "length F'l \<ge> 1"
    using `f_to_set_l F'l = F'` `F' \<noteq> {}`
    by (auto simp add: not_less_eq_eq)
  have "length F'l \<in> set [1..<length Fl + 1]"
    using `length F'l \<ge> 1` `length F'l \<le> length Fl`
    by auto
  moreover
  have "set (Union_l F'l) \<in> (set \<circ> Union_l) ` set (Combinatorics.combine Fl (length F'l))"
    using combine_sublist[of "set F'l" Fl] `set F'l \<subseteq> set Fl` `distinct F'l` `length F'l \<le> length Fl` distinct_card[of F'l]
    by (auto simp add: SetUnionImpl_lists.Union_set)
  ultimately
  show ?thesis
    using `f_to_set_l F'l = F'`[symmetric]
    unfolding all_nonempty_subsets_def
    by (simp add: SetUnionImpl_lists.Union_set, auto, force)
qed

lemma expressible_l_completeness:
  assumes "sd A" "sdf F"
  assumes 
  "expressible (set A) (f_to_set_l F)"
  shows "expressible_l A F"
proof-
  have "sdff (all_nonempty_subsets F)"
    unfolding all_nonempty_subsets_def
    using `sdf F`
    using combine_subset[of _ F _]
    by auto
  hence "sdf (map Union_l (all_nonempty_subsets F))"
    using SetUnionImpl_lists.Union_inv
    by force
  from `expressible (set A) (f_to_set_l F)`
  obtain F' where "F' \<subseteq> f_to_set_l F" "F' \<noteq> {}" "set A = \<Union>F'"
    unfolding expressible_def
    by auto
  hence "set A \<in> set ` set (map Union_l (all_nonempty_subsets F))"
    unfolding expressible_l_def
    using expressible_l_completeness_lemma[of F' F]
    by auto
  thus ?thesis
    unfolding expressible_l_def
    using `sd A` `sdf (map Union_l (all_nonempty_subsets F))`
    using SetImpl_lists.set_set[of "map Union_l (all_nonempty_subsets F)" A]
    by auto
qed

(*
definition 
"expressible_l' A F \<equiv> 
   (let F' = filter (\<lambda> A'. set A' \<subseteq> set A) F
     in F' \<noteq> [] \<and> Union_l F' = A)"

lemma [simp]:
  assumes "sd A" "sdf F"
  shows "expressible_l' A F = expressible_l A F"
  unfolding expressible_l'_def expressible_l_def Let_def
  sorry
*)

end