(* ************************************************************************** *)
section{* Isomorphisms of set families *}
(* ************************************************************************** *)

theory IsomorphicFamilies
imports Main
  "More/MoreSet" "More/MoreFun"
  UnionClosed Frankl
begin


text{* Each injective function @{text "f"} on the domain @{text "\<Union> F"}
maps the set family @{text "F"} to its isomorphic image @{text "op ` f
` F"}. Elements of @{text "\<Union> F"} are mapped using @{text "f"}, while
elements of @{text "F"} are mapped using @{text "op ` f"}. *}

subsection{* Properites preserved by injective functions *}

lemma empty_iso:
  shows "F = {} \<longleftrightarrow> (op ` f ` F) = {}"
by auto

lemma inj_on_iso:
  assumes "inj_on f (\<Union> F)"
  shows "inj_on (op ` f) F"
using assms
unfolding inj_on_def
by blast

lemma inj_on_iso_strong:
  assumes "inj_on f (\<Union> F)"
  shows "inj_on (op ` f) (Pow (\<Union> F))"
using assms
unfolding inj_on_def
by blast

lemma finite_iso:
  assumes "inj_on f (\<Union> F)"
  shows "finite F \<longleftrightarrow> finite (op ` f ` F)"
using assms
using inj_on_iso[of f F]
by (auto dest: finite_imageD)

lemma card_iso:
  assumes "inj_on f (\<Union> F)"
  shows "card (op ` f ` F) = card F"
proof (subst card_image)
  let ?f = "op ` f"
  show "inj_on ?f F"
    using assms
    by (simp add: inj_on_iso)
qed simp

lemma finite_elems_iso:
  assumes "inj_on f (\<Union> F)"
  shows "(\<forall>S\<in>F. finite S) \<longleftrightarrow> (\<forall>S\<in>(op ` f ` F). finite S)"
proof (safe)
  let ?F = "op ` f ` F"
  fix S
  assume "\<forall> S \<in> ?F. finite S" "S \<in> F"
  
  show "finite S"
  proof (rule finite_imageD)
    show "finite (f ` S)"
      using `\<forall> S \<in> ?F. finite S` `S \<in> F`
      by simp
  next
    show "inj_on f S"
    proof (rule subset_inj_on)
      show "S \<subseteq> \<Union> F"
        using `S \<in> F`
        by auto
    qed (simp add: assms)
  qed
qed auto

lemma card_elem_iso:
  assumes "inj_on f (\<Union> F)" "A \<in> F" "card A > 0"
  shows "card (f ` A) = card A"
using assms
using inj_on_iff_eq_card[of A f]
using subset_inj_on[of f "\<Union> F" A]
using card_ge_0_finite[of A]
by blast

lemma finite_Union_iso:
  assumes "inj_on f (\<Union> F)"
  shows "finite (\<Union> F) = finite (\<Union> (op ` f ` F))"
using assms
by ((subst finiteUn_iff)+, simp add: finite_iso finite_elems_iso)

lemma union_closed_iso:
  assumes "inj_on f (\<Union> F)"
  shows "union_closed F \<longleftrightarrow> union_closed (op ` f ` F)"
proof
  assume "union_closed F"
  show "union_closed (op ` f ` F)"
    unfolding union_closed_def
  proof (safe)
    fix A B x y
    assume *: "x \<in> F" "y \<in> F"
    show "f ` x \<union> f ` y \<in> op ` f ` F"
    proof (rule rev_image_eqI[of "x \<union> y"])
      show "x \<union> y \<in> F"
        using `union_closed F` `x \<in> F` `y \<in> F`
        unfolding union_closed_def
        by simp
    qed auto
  qed
next
  assume *: "union_closed (op ` f ` F)"
  show "union_closed F"
    unfolding union_closed_def
  proof (safe)
    fix A B
    assume "A \<in> F" "B \<in> F"
    hence "f ` A \<union> f ` B \<in> op ` f ` F"
      using *
      unfolding union_closed_def
      by auto
    then obtain X where "f ` X = f ` A \<union> f ` B" "X \<in> F"
      by auto
    hence "f ` X = f ` (A \<union> B)"
      by auto
    hence "X = A \<union> B"
      using assms `X \<in> F` `A \<in> F` `B \<in> F`
      using inj_on_iso_strong[of f F]
      unfolding inj_on_def
      by blast
    thus "A \<union> B \<in> F"
      using `X \<in> F`
      by simp
  qed
qed

lemma finite_union_closed_iso:
  assumes "inj_on f (\<Union> F)"
  shows "finite_union_closed F \<longleftrightarrow> finite_union_closed (op ` f ` F)"
using assms
using finite_Union_iso[of f F] union_closed_iso[of f F]
by (simp add: finiteUn_iff)

lemma count_iso:
  assumes "inj_on f (\<Union> F)" and "a \<in> \<Union> F"
  shows "count a F = count (f a) (op ` f ` F)"
using assms
unfolding count_def
proof (subst card_image[THEN sym])
  let ?f = "op ` f"
  let ?aF = "{S \<in> F. a \<in> S}" 
  let ?fafF = "{S \<in> op ` f ` F. f a \<in> S}"
  show "inj_on ?f ?aF"
    using assms 
    using inj_on_iso[of f F]
    using subset_inj_on[of "op ` f" F ?aF]
    by auto

  show "card (?f ` ?aF) = card ?fafF"
  proof-
    have "?f ` ?aF = ?fafF"
    proof (auto)
      fix A a'
      assume "A \<in> F" "a' \<in> A" "f a = f a'"
      hence "a = a'" using assms
        unfolding inj_on_def
        by auto
      thus "f ` A \<in> ?f ` ?aF"
        using rev_image_eqI[of A ?aF "f ` A" "op ` f"] `A \<in> F` `a' \<in> A`
        by simp
    qed
    thus ?thesis
      by simp
  qed
qed

lemma Frankl_iso:
  assumes "inj_on f (\<Union> F)"
  shows "frankl F \<longleftrightarrow> frankl (op ` f ` F)"
proof-
  let ?F = "op ` f ` F"
  show ?thesis
    unfolding frankl_def
  proof (safe)
    fix X x
    assume *: "X \<in> F" "x \<in> X" "card F \<le> 2 * count x F"
    show "\<exists>x. x \<in> \<Union> (op ` f ` F) \<and> card (op ` f ` F) \<le> 2 * count x (op ` f ` F)"
      apply (rule_tac x="f x" in exI)
      using * `inj_on f (\<Union> F)`
      by (subst count_iso[THEN sym]) (auto simp add: card_iso)
  next
    fix X x
    assume *: "card ?F \<le> 2 * count (f x) ?F" "X \<in> F" "x \<in> X"
    show "\<exists>x. x \<in> \<Union>F \<and> card F \<le> 2 * count x F"
      apply (rule_tac x="x" in exI)
      using *  `inj_on f (\<Union> F)`
      by (subst count_iso) (auto simp add: card_iso)
  qed
qed

lemma closure_iso:
  shows "closure (op ` g ` F) = op ` g ` (closure F)"
proof (safe)
  fix x
  assume "x \<in> closure (op ` g ` F)"
  then obtain F' where "\<Union> F' = x" "F' \<noteq> {}" and *: "F' \<subseteq> op ` g ` F"
    unfolding closure_def
    by auto
  from * obtain F'' where "F'' \<subseteq> F" "F' = op ` g ` F''"
    by (metis subset_image_iff)
  moreover
  hence "F'' \<noteq> {}" "g ` (\<Union> F'') = x"
    using `F' \<noteq> {}` `\<Union> F' = x`
    by auto
  ultimately
  have "\<Union> F'' \<in> closure F" "g ` (\<Union> F'') = x"
    by (auto simp add: closure_def)
  thus "x \<in> op ` g ` closure F"
    by auto
next
  fix x
  assume "x \<in> closure F"
  then obtain F' where "F' \<subseteq> F" "F' \<noteq> {}" "x = \<Union> F'"
    by (auto simp add: closure_def)
  hence "op ` g ` F' \<subseteq> (op ` g ` F)" "op ` g ` F' \<noteq> {}" "g ` x = \<Union> (op ` g ` F')"
    by auto
  thus "g ` x \<in> closure (op ` g ` F)"
    unfolding closure_def
    by blast
qed


lemma FC_family_iso:
  fixes f :: "'a \<Rightarrow> nat"
  assumes "inj_on f (\<Union> Fc)" "FC_family (op ` f ` Fc)"
  shows "FC_family Fc"
using assms
unfolding FC_family_def
proof (safe)
  fix F
  assume *: "\<forall>F. op ` f ` Fc \<subseteq> F \<and> finite_union_closed F \<longrightarrow> (\<exists> a \<in> (\<Union> (op ` f ` Fc)). card F \<le> 2 * count a F)"
  assume "inj_on f (\<Union>Fc)" "Fc \<subseteq> F" "union_closed F" "finite (\<Union>F)"
  have "\<Union>Fc \<subseteq> \<Union>F" "finite (\<Union> Fc)" "\<Union>Fc \<union> \<Union>F = \<Union> F"
    using `Fc \<subseteq> F` `finite (\<Union> F)` finite_subset[of "\<Union> Fc" "\<Union> F"]
    by auto
  then obtain f' where "\<forall> x \<in> \<Union> Fc. f' x = f x" "inj_on f' (\<Union> F)"
    using bij_betw_inj_extend[of f "\<Union> Fc" "f ` (\<Union> Fc)" "\<Union> F - \<Union> Fc"]
    using `inj_on f (\<Union>Fc)` `finite (\<Union> F)` `Fc \<subseteq> F`
    unfolding bij_betw_def
    by auto
  let ?F' = "op ` f' ` F"
  have "op ` f ` Fc \<subseteq> ?F'"
  proof (safe)
    fix x
    assume "x \<in> Fc"
    show "f ` x \<in> op ` f' ` F"
    proof (rule rev_image_eqI)
      show "x \<in> F" using `x \<in> Fc` `Fc \<subseteq> F`
        by auto
    next
      show "f ` x = f' ` x"
        using `x \<in> Fc` `\<forall> x \<in> \<Union> Fc. f' x = f x`
        by force
    qed
  qed
  moreover
  have "finite_union_closed ?F'"
    using finite_union_closed_iso
    using `inj_on f' (\<Union> F)` `finite (\<Union> F)` `union_closed F`
    by auto
  ultimately
  have "\<exists> a \<in> (\<Union> (op ` f ` Fc)). card ?F' \<le> 2 * count a ?F'"
    using *
    by blast
  then obtain a where "a \<in> \<Union> Fc" "a \<in> \<Union> F" "card ?F' \<le> 2 * count (f a) ?F'"
    using `\<Union> Fc \<subseteq> \<Union> F`
    by blast
  moreover 
  have "f a = f' a"
    using `a \<in> \<Union> Fc` `\<forall> x \<in> \<Union> Fc. f' x = f x`
    by auto
  ultimately
  show "\<exists>a\<in>\<Union>Fc. card F \<le> 2 * count a F"
    using count_iso[of f' F a] card_iso[of f' F]  `inj_on f' (\<Union> F)`
    by (rule_tac x="a" in bexI) auto
qed

subsection{* Injective embedding *}

(* ---------------------------------------------------------------------------- *)
definition inj_embed where
  [simp]: "inj_embed F F' \<longleftrightarrow> (\<exists> f. inj_on f (\<Union> F) \<and> F' = (op ` f) ` F)"

lemma inj_embed_refl [simp]: 
  shows "inj_embed F F"
unfolding inj_embed_def
by (rule_tac x="id" in exI) auto

lemma inj_embed_sym: 
  assumes "inj_embed F F'"
  shows "inj_embed F' F"
proof-
  obtain f where *: "inj_on f (\<Union> F)" "F' = (op ` f) ` F"
    using assms
    by auto
  let ?f' = "inv_into (\<Union> F) f"
  show ?thesis
    unfolding inj_embed_def
  proof (rule_tac x="?f'" in exI, rule conjI)
    show "inj_on ?f' (\<Union> F')"
      apply (rule inj_on_inv_into) 
      using *(2) 
      by auto
  next
    show "F = op ` ?f' ` F'"
    proof (safe)
      fix x
      assume "x \<in> F"
      hence "x \<subseteq> \<Union> F"
        by auto
      show "x \<in> op ` ?f' ` F'"
      proof (rule_tac rev_image_eqI[of "f ` x"])
        show "f ` x \<in> F'"
          using *(2) `x \<in> F`
          by simp
      next
        show "x = inv_into (\<Union> F) f ` f ` x"
          using inv_into_image_cancel[of f "\<Union> F" x]
          using *(1) `x \<subseteq> \<Union> F`
          by auto
      qed
    next
      fix x
      assume "x \<in> F'"
      then obtain y where "x = f ` y" "y \<in> F" "y \<subseteq> \<Union> F"
        using *(2)
        by auto
      thus "?f' ` x \<in> F"
          using inv_into_image_cancel[of f "\<Union> F" y] *(1)
          by auto
    qed
  qed
qed

lemma inj_embed_trans: 
  assumes "inj_embed F F'" and "inj_embed F' F''"
  shows "inj_embed F F''"
proof-
  from assms
  obtain f g where "inj_on f (\<Union>F)" "F' = op ` f ` F" "inj_on g (\<Union>F')" "F'' = op ` g ` F'"
    unfolding inj_embed_def
    by auto
  thus ?thesis
    unfolding inj_embed_def
    by (rule_tac x="g \<circ> f" in exI) (auto simp add: comp_def inj_on_def)
qed

subsection{* Isomoprhism definition *}

text{* There is a bijective mapping between equivalent families. *}
definition iso where
  [simp]: "iso F F' \<longleftrightarrow> (\<exists> h. bij_betw h (\<Union> F) (\<Union> F') \<and> F' = (op ` h) ` F)"

lemma inj_embed_iso:
  shows "inj_embed F F' \<longleftrightarrow> iso F F'"
proof
  assume "inj_embed F F'"
  then obtain f where *: "inj_on f (\<Union> F)"  "F' = (op ` f) ` F"
    by auto
  show "iso F F'"
    unfolding iso_def bij_betw_def
    apply (rule_tac x="f" in exI, rule conjI)
    using *
    by auto
next
  assume "iso F F'"
  thus "inj_embed F F'"
    unfolding iso_def inj_embed_def bij_betw_def
    by auto
qed

lemma iso_refl:
  shows "iso F F"
using inj_embed_iso[of F F] inj_embed_refl
by blast

lemma iso_sym:
  assumes "iso F F'"
  shows "iso F' F"
using assms
using inj_embed_iso[of F F']  inj_embed_iso[of F' F] inj_embed_sym
by blast

lemma iso_trans:
  assumes "iso F F'" and "iso F' F''"
  shows "iso F F''"
using assms
using inj_embed_iso[of F F']  inj_embed_iso[of F' F''] inj_embed_iso[of F F''] inj_embed_trans[of F F' F'']
by blast

lemma iso_finite:
  assumes "iso F F'"
  shows "finite F \<longleftrightarrow> finite F'"
using assms
unfolding iso_def
by (metis bij_betw_imp_inj_on finite_iso)

lemma iso_insert:
  assumes "inj_on f (\<Union>F \<union> A)"
  shows "iso (F \<union> {A}) ((op ` f ` F) \<union> {f ` A})" 
        "card (f ` A) = card A" 
        "f ` A \<subseteq> f ` (\<Union>F \<union> A)"
        "A \<notin> F \<Longrightarrow> f ` A \<notin> op ` f ` F"  
proof-
  show "iso (F \<union> {A}) ((op ` f ` F) \<union> {f ` A})"
    unfolding iso_def
  proof (rule_tac x="f" in exI, rule conjI)
    show "bij_betw f (\<Union> (F \<union> {A})) (\<Union> ((op ` f ` F) \<union> {f ` A}))"
      using assms(1)
      unfolding bij_betw_def
      by (auto simp add: Un_commute)
  next
    show "op ` f ` F \<union> {f ` A} = op ` f ` (F \<union> {A})"
      by simp
  qed
next
  show "card (f ` A) = card A"
    using assms(1)
    using card_image[of f A]
    by (auto simp add: inj_on_def)
next
  show "f ` A \<subseteq> f ` (\<Union>F \<union> A)"
    by auto
next
  assume "A \<notin> F"
  show "f ` A \<notin> op ` f ` F" 
  proof (rule ccontr)
    assume "\<not> ?thesis"
    then obtain A' where "f ` A = f ` A'" "A' \<in> F"
      by auto
    moreover
    have "inj_on f (A \<union> A')"
      using assms(1) `A' \<in> F`
      unfolding inj_on_def
      by auto
    ultimately
    have "A = A'"
      using inj_on_Un_image_eq_iff[of f A A']
      by simp
    thus False
      using `A \<notin> F` `A' \<in> F`
      by simp
  qed
qed

subsection{* Iso-representing collections of families *}

text{* FF' iso-represents FF if an isomporphic image of each element of FF is in FF' *}

definition iso_represents where
  "iso_represents FF' FF \<longleftrightarrow> (\<forall> F \<in> FF. \<exists> F' \<in> FF'. iso F F')"

abbreviation iso_representing_subset where
 "iso_representing_subset FF' FF \<equiv> iso_represents FF' FF \<and> FF' \<subseteq> FF"

end
