section{* L-partitioned families *}

theory LPartitioning
imports Main More.MoreSet IsomorphicFamilies
begin

definition is_L_part where
 "is_L_part n L F \<longleftrightarrow> 
     \<Union> F \<subseteq> {0..<n::nat} \<and>
     (\<forall> A \<in> F. card A < length L) \<and>
     (\<forall> n < length L. card {A \<in> F. card A = n} = L ! n)"

abbreviation L_part where
 "L_part n L \<equiv> {F. is_L_part n L F}"

lemma is_L_part_finite:
  assumes "is_L_part n L F"
  shows "finite F" "\<forall> A \<in> F. finite A"
using assms
unfolding is_L_part_def
using finite_subset[of "\<Union> F" "{0..<n}"]
by (auto simp add: finiteUn_iff)

lemma is_L_part_zero:
  shows "is_L_part n L F \<longleftrightarrow> is_L_part n (L @ [0]) F"
proof-
  have *: "finite (\<Union> F) \<Longrightarrow> (\<forall> A \<in> F. card A < length L) \<longleftrightarrow> ((\<forall> A \<in> F. card A < length L + 1) \<and> card {A \<in> F. card A = length L} = 0)"
    by (auto simp add: finiteUn_iff) fastforce
  show ?thesis
    using *
    unfolding is_L_part_def
    by (auto simp add: nth_append finite_subset[of "\<Union> F" "{0..<n}"]) (subgoal_tac "na = length L", simp+)
qed

lemma is_L_part_zeros:
  assumes "\<forall> k'. k' > k \<and> k' < length L \<longrightarrow> L ! k' = 0"
  shows "is_L_part n L F \<longleftrightarrow> is_L_part n (take (k+1) L) F"
proof (cases "k < length L")
  case False
  thus ?thesis
    by simp
next
  case True
  thus ?thesis
    using assms
  proof (induct L rule: rev_induct)
    case Nil
    thus ?case
      by simp
  next
    case (snoc a L)
    show ?case
    proof (cases "k = length L")
      case True
      thus ?thesis
        by auto
    next
      case False
      hence "k < length L"
        using `k < length (L @ [a])`
        by simp
      moreover
      hence "a = 0"
        using `\<forall>k'. k < k' \<and> k' < length (L @ [a]) \<longrightarrow> (L @ [a]) ! k' = 0`[rule_format, of "length L"]
        by simp
      moreover
      have "\<forall>k'. k < k' \<and> k' < length L \<longrightarrow> L ! k' = 0"
        using `\<forall>k'. k < k' \<and> k' < length (L @ [a]) \<longrightarrow> (L @ [a]) ! k' = 0`
        by (auto simp add: nth_append)
      ultimately
      show ?thesis
        using snoc(1)
        using is_L_part_zero[of n L F]
        by simp
    qed
  qed
qed

lemma is_L_part_zeros_replicate: 
  "is_L_part n (replicate k 0) F \<longleftrightarrow>  is_L_part n [] F"
proof (induct k)
  case 0
  thus ?case
    by simp
next
  case (Suc k)
  thus ?case
    using replicate_add[of k 1 "0::nat"] is_L_part_zero[of n "replicate k 0" F]
    by simp
qed

lemma is_L_part_mem:
  assumes "is_L_part n L F" "A \<in> F"
  shows "card A < length L \<and> L ! card A > 0"
proof-
  let ?X = "{A' \<in> F. card A' = card A}"
  have "A \<in> ?X"
    using `A \<in> F`
    by simp
  moreover
  have "?X \<subseteq> F"
    by auto
  moreover
  have "finite F"
    using `is_L_part n L F`
    by (simp add: is_L_part_finite)
  ultimately
  have "card ?X > 0"
    using finite_subset[of ?X F]
    using card_eq_0_iff[of ?X]
    by blast
  thus "card A < length L \<and> L ! card A > 0"
    using assms `A \<in> F`
    unfolding is_L_part_def
    by auto
qed

lemma is_L_part_empty_mem:
  assumes 
  "is_L_part n L F" "hd L > 0" "length L > 0"
  shows "{} \<in> F"
proof-
  let ?A0 = "{A' \<in> F. card A' = 0} "
  have "card ?A0 > 0"
    using assms
    unfolding is_L_part_def
    by (auto simp add: hd_conv_nth)
  moreover
  have "\<forall> A' \<in> F. card A' = 0 \<longrightarrow> A' = {}"
    using `is_L_part n L F`
    using card_eq_0_iff
    by (auto simp add: is_L_part_finite)
  ultimately
  show ?thesis
    using card_gt_0_iff[of "{A' \<in> F. card A' = 0}"]
    by auto
qed
    
lemma is_L_part_remove:
  assumes "A \<in> F" "is_L_part n L F"
  shows "is_L_part n (L[card A := (L ! card A) - 1]) (F - {A})"
proof-
  let ?F = "F - {A}"
  let ?X = "{A' \<in> F. card A' = card A}"
  let ?XA = "?X - {A}"
  let ?L' = "L[card A := (L ! card A) - 1]"
  have *: "\<forall> n. n \<noteq> card A \<longrightarrow> {A' \<in> ?F. card A' = n} = {A' \<in> F. card A' = n}" "{A' \<in> ?F. card A' = card A} = ?XA"
    by auto
  
  have "card A < length L" "L ! card A > 0"
    using assms is_L_part_mem[of n L F A]
    by auto
    
  have "card ?X = L ! card A"
    using assms `card A < length L`
    unfolding is_L_part_def
    by auto

  have "L ! card A = Suc ((L ! card A) - 1)"
    using is_L_part_mem[of n L F A] `L ! card A > 0`
    by auto
  hence "card ?XA = (L ! card A) - 1"
    using `card ?X = L ! card A`
    using card_Suc'[of ?X "(L ! card A) - 1" A] `A \<in> F`
    by simp

  have "\<Union> ?F \<subseteq> {0..<n}"
    using `is_L_part n L F`
    unfolding is_L_part_def Let_def
    by auto
  moreover
  {
    fix A'
    assume "A' \<in> ?F"
    hence "card A' < length L"
      using `is_L_part n L F`
      unfolding is_L_part_def Let_def
      by auto
  }
  moreover
  have "(\<forall>n < length ?L'. card {A' \<in> ?F. card A' = n} = ?L' ! n)"
  proof(safe)
    fix n'
    assume "n' < length ?L'"
    show "card {A' \<in> ?F. card A' = n'} = ?L' ! n'"
    proof (cases "n' \<noteq> card A")
      case True
      thus ?thesis
        using *(1) `is_L_part n L F` `n' < length ?L'`
        unfolding is_L_part_def Let_def
        by (auto simp add: nth_list_update)
    next
      case False
      thus ?thesis
        using *(2) `card ?XA = (L ! card A) - 1` `card A < length L`
        by (simp add: nth_list_update)
    qed
  qed
  ultimately
  show ?thesis
    unfolding is_L_part_def Let_def
    by simp
qed

  
lemma is_L_part_remove_last:
  assumes "is_L_part n (L @ [k + 1]) F"  "card A = length L" "A \<in> F"
  shows  "is_L_part n (L @ [k]) (F - {A})"
using assms
using is_L_part_remove[of A F n "L @ [k + 1]"]
by auto

lemma is_L_part_insert_last:
  assumes "is_L_part n (L @ [k]) F" "A \<notin> F" "A \<subseteq> {0..<n}" "card A = length L"
  shows "is_L_part n (L @ [k + 1]) (F \<union> {A})"
proof-
  have "finite F"
    using `is_L_part n (L @ [k]) F`
    by (simp add: is_L_part_finite)

  have *: "\<forall> n < length L. {X \<in> F \<union> {A}. card X = n} = {X \<in> F. card X = n}" "{X \<in> F \<union> {A}. card X = length L} = {X \<in> F. card X = length L} \<union> {A}"
      using `card A = length L` `A \<notin> F`
      by auto

  have "\<Union>(F \<union> {A}) \<subseteq> {0..<n}"
    using `A \<subseteq> {0..<n}`
    using `is_L_part n (L @ [k]) F`
    by (auto simp add: is_L_part_def)
  moreover
  have "\<forall>X\<in>F \<union> {A}. card X < length (L @ [k + 1])"
    using `is_L_part n (L @ [k]) F` `card A = length L`
    by (auto simp add: is_L_part_def)
  moreover
  {
    fix n'
    assume "n' < length (L @ [k + 1])"
    have "card {X \<in> F \<union> {A}. card X = n'} = (L @ [k + 1]) ! n'"
    proof (cases "n' < length L")
      case True
      thus ?thesis
        using *(1) `is_L_part n (L @ [k]) F`
        by (auto simp add: is_L_part_def nth_append)
    next
      case False
      hence "n' = length L"
        using `n' < length (L @ [k + 1])`
        by simp
      thus ?thesis
        using *(2) `card A = length L` `is_L_part n (L @ [k]) F` `A \<notin> F`
        using card_insert_disjoint[of "{A \<in> F. card A = length L}"] `finite F`
        by (auto simp add: is_L_part_def nth_append finite_subset)
    qed
  }
  ultimately
  show ?thesis
    by (simp add: is_L_part_def)
qed

subsection{* Ordering of L-partitions *}

definition pwge (infixl "\<succeq>" 100) where
  "L' \<succeq> L \<longleftrightarrow> (length L' = length L) \<and> (\<forall> i. i < length L \<longrightarrow> L' ! i \<ge> L ! i)"

lemma pwge_Cons:
 "(a # L) \<succeq> (b # L') \<longleftrightarrow> (a \<ge> b \<and> L \<succeq> L')"
unfolding pwge_def
by (auto simp add: nth_Cons) (metis Suc_eq_plus1_left diff_is_0_eq le_add_diff_inverse le_cases less_antisym less_imp_diff_less nth_Cons nth_Cons') 

lemma pwge_Nil:
  "[] \<succeq> []"
unfolding pwge_def
by simp

lemma pwge_refl:
fixes L::"'a::linorder list"
shows [simp]: "L \<succeq> L"
unfolding pwge_def
by auto

lemma pwge_trans [trans]:
  fixes L::"'a::linorder list"
  assumes "L \<succeq> L'" "L' \<succeq> L''"
  shows "L \<succeq> L''"
using assms
proof (induct L arbitrary: L' L'')
  case Nil
  thus ?case
    unfolding pwge_def
    by simp
next
  case (Cons a l)
  obtain b l' c l'' where "L' = b # l'" "L'' = c # l''"
    using `(a # l) \<succeq> L'` `L' \<succeq> L''`
    unfolding pwge_def
    by auto (metis Suc_length_conv) 
  thus ?case
    using Cons
    by (auto simp add: pwge_Cons)
qed

lemma pwge_replicate_0:
  assumes "length X = n"
  shows "X \<succeq> replicate n (0::nat)"
using assms
proof (induct n arbitrary: X)
  case 0
  thus ?case
    by simp
next
  case (Suc n)
  thus ?case
    by (cases X) (auto simp add: pwge_Cons)
qed

lemma pwge_list_update:
  fixes L::"nat list"
  assumes "n < length L" "nk \<le> L ! n" 
  shows "L \<succeq> L [n := nk]"
using assms
unfolding pwge_def
by (auto simp add: nth_list_update)

lemma is_L_part_subset:
  assumes "L' \<succeq> L"  "is_L_part n L' F'"
  shows "\<exists> F. F \<subseteq> F' \<and>  is_L_part n L F"
proof-
  let ?F'k = "\<lambda> k. {A. A \<in> F' \<and> card A = k}"
  let ?Fk = "\<lambda> k. SOME S. S \<subseteq> ?F'k k \<and> card S = L ! k"
  have "\<forall> k. k < length L \<longrightarrow> (\<exists> S. S \<subseteq> ?F'k k \<and> card S = L ! k)"
  proof (safe)
    fix k
    assume "k < length L"
    show "\<exists> S. S \<subseteq> ?F'k k \<and> card S = L ! k"
    proof (rule card_le)
      show "L ! k \<le> L' ! k"
        using assms `k < length L`
        unfolding pwge_def
        by simp
    next
      show "card (?F'k k) = L' ! k"
        using assms `k < length L`
        unfolding is_L_part_def pwge_def
        by simp
    qed
  qed
  have *: "\<forall> k < length L. ?Fk k \<subseteq> ?F'k k \<and> card (?Fk k) = L ! k "
  proof (safe)
    fix k x
    assume "k < length L" 
    thus "x \<in> ?Fk k \<Longrightarrow> x \<in> F'" "x \<in> ?Fk k \<Longrightarrow> card x = k"
         "card (?Fk k) = L ! k"
      using `\<forall> k. k < length L \<longrightarrow> (\<exists> S. S \<subseteq> ?F'k k \<and> card S = L ! k)`
      using tfl_some[rule_format, where P="\<lambda> S. S \<subseteq> {A \<in> F'. card A = k} \<and> card S = L ! k"]
      by auto
  qed

  let ?F = "\<Union> {?Fk k | k . k < length L}"
  show ?thesis
  proof (rule_tac x="?F" in exI, rule conjI)
    show "?F \<subseteq> F'"
      using *
      by auto
  next
    have "\<Union> ?F \<subseteq> {0..<n}"
      using * `is_L_part n L' F'`
      unfolding is_L_part_def
      by auto
    moreover
    have "\<forall>A\<in>?F. card A < length L"
      using *
      by auto
    moreover
    have "\<forall>k<length L. {A \<in> ?F. card A = k} = ?Fk k"
      using *
      by auto
    hence "\<forall>k<length L. card {A \<in> ?F. card A = k} = L ! k"
      using *
      by auto
    ultimately
    show "is_L_part n L ?F"
      unfolding is_L_part_def
      by simp
  qed
qed

lemma is_L_part_subset':
  assumes "F' \<subseteq> F" "is_L_part n L F" 
  shows "\<exists> L'. L \<succeq> L' \<and>  is_L_part n L' F'"
proof-
  have "finite (F - F')"
    using `is_L_part n L F`
    using is_L_part_def  finite_subset[of "\<Union> F" "{0..<n}"] finite_subset[of "F - F'" "F"] finiteUn_iff[of F]
    by auto
  thus ?thesis
    using assms
  proof (induct "F - F'" arbitrary: F F' L rule: finite_induct)
    case empty
    hence "F = F'"
      by auto
    thus ?case
      using `is_L_part n L F`
      by (rule_tac x="L" in exI) (auto simp add: pwge_def)
  next
    case (insert X Y)
    have "X \<in> F"
      using `insert X Y = F - F'`
      by auto
    then obtain L'' where "L \<succeq> L''" "is_L_part n L'' (F - {X})"
      using is_L_part_remove[of X F n L] `is_L_part n L F`
      using pwge_list_update[of "card X" L "(L ! card X) - 1"]
      using is_L_part_mem
      by auto
    have "\<exists> L'. L'' \<succeq> L' \<and> is_L_part n L' F'"
    proof (rule insert(3))
      show "Y = (F - {X}) - F'"
        using `insert X Y = F - F'` `X \<notin> Y`
        by auto
    next
      show "F' \<subseteq> F - {X}"
        using `F' \<subseteq> F` `insert X Y = F - F'`
        by auto
    next
      show "is_L_part n L'' (F - {X})"
        by fact
    qed
    thus ?case
      using `L \<succeq> L''`
      using pwge_trans[of L L'']
      by auto
  qed
qed


section{* Generating all L-partitioned families with some given properties *}

abbreviation L_part_P where
 "L_part_P P n L \<equiv> {F \<in> L_part n L. P F}"
abbreviation mult_P where
 "mult_P P F A \<equiv> {f \<union> {A} | f. f \<in> F \<and> A \<notin> f \<and> P A f}"
abbreviation
 "mult_all_P P F n m \<equiv> \<Union> {mult_P P F A | A. card A = m \<and> A \<subseteq> {0..<n}}"

abbreviation incrementally_checks where
 "incrementally_checks Pinc P \<equiv>
      (\<forall> A F. (finite (\<Union> F \<union> A) \<and> (\<forall> A' \<in> F. card A \<ge> card A') \<and> A \<notin> F) \<longrightarrow> 
              (P (F \<union> {A}) \<longleftrightarrow> P F \<and> Pinc A F))"

lemma L_part_mult_P:
  assumes "incrementally_checks Pinc P"
  shows "L_part_P P n (L @ [k + 1]) = mult_all_P Pinc (L_part_P P n (L @ [k])) n (length L)" 
        (is "?lhs = ?rhs")
proof
  show "?lhs \<subseteq> ?rhs"
  proof(safe)
    fix F'
    assume "is_L_part n (L @ [k + 1]) F'" "P F'"
    hence "\<Union> F' \<subseteq> {0..<n}" "card {A \<in> F'. card A = length L} = k + 1"
      unfolding is_L_part_def
      by auto
    then obtain A where "card A = length L" "A \<in> F'"
      using card_eq_0_iff[of "{A \<in> F'. card A = length L}"]
      by auto

    let ?F = "F' - {A}"
    have "F' \<in> {f \<union> {A} |f.
          f \<in> L_part n (L @ [k]) \<and> P f \<and> A \<notin> f \<and> Pinc A f}"
    proof (rule, rule_tac x="?F" in exI, safe)
      show "is_L_part n (L @ [k]) ?F"
        using `is_L_part n (L @ [k + 1]) F'`
        using `card A = length L` `A \<in> F'` is_L_part_remove_last
        by auto
    next
      show "A \<in> F'"
        by fact
    next
      have "finite (\<Union>(F' - {A}))" "finite A"
        using `\<Union> F' \<subseteq> {0..<n}` finite_subset[of "\<Union> F'" "{0..<n}"] `A \<in> F'`
          finite_subset[of "\<Union> (F' - {A})" "\<Union> F'"] finiteUn_iff[of F']
        by auto
      moreover
      have "(\<forall>A'\<in>F' - {A}. card A' \<le> card A)"
        using `card A = length L` `is_L_part n (L @ [k + 1]) F'`
        unfolding is_L_part_def
        by auto
      ultimately
      show "Pinc A ?F" "P (F' - {A})"
        using `P F'` `A \<in> F'`
        using assms(1)[rule_format, of "F' - {A}" A]
        by (auto simp add: insert_absorb)
    qed
    thus "F' \<in> ?rhs"
      using `card A = length L` `A \<in> F'` `\<Union> F' \<subseteq> {0..<n}`
      by blast
  qed
next
  show "?rhs \<subseteq> ?lhs"
  proof
    let ?F = "L_part_P P n (L @ [k])"
    fix F'
    assume "F' \<in> ?rhs"
    then obtain A where "card A = length L" "A \<subseteq> {0..<n}" "F' \<in> mult_P Pinc (L_part_P P n (L @ [k])) A"
      by auto
    then obtain F where "is_L_part n (L @ [k]) F" "P F" "A \<notin> F" "Pinc A F" "F' = F \<union> {A}"
      by auto
    hence "is_L_part n (L @ [k + 1]) F'"
      using is_L_part_insert_last `card A = length L` `A \<subseteq> {0..<n}`
      by auto
    moreover
    have "P F'"
      using `F' = F \<union> {A}` `Pinc A F` `P F` `card A = length L` `is_L_part n (L @ [k]) F`
      using assms[rule_format, of F A] `A \<notin> F`
      using `A \<subseteq> {0..<n}` finite_subset[of "\<Union> F \<union> A" "{0..<n}"]
      unfolding is_L_part_def
      by force
    ultimately
    show "F' \<in> ?lhs"
      by simp
  qed
qed

abbreviation inj_preserved where
  "inj_preserved P \<equiv> \<forall> A F f. (inj_on f (\<Union> F \<union> A) \<and> P A F) \<longrightarrow> P (f ` A) (op ` f ` F)"

lemma L_part_mult_iso_representing_subset:
  assumes 
  "incrementally_checks Pinc P" "inj_preserved Pinc"
  "iso_representing_subset FFb (L_part_P P n (L @ [k]))" (is "iso_representing_subset _ ?FFk")
  "length L \<le> n"
  "FFb' = mult_all_P Pinc FFb n (length L)"
shows "iso_representing_subset FFb' (L_part_P P n (L @ [k + 1]))" (is "iso_representing_subset ?FFb' ?FFk1")
proof
  have "FFb \<subseteq> ?FFk"
    using assms(3)
    by auto
  thus "?FFb' \<subseteq> ?FFk1"
    using L_part_mult_P[of P Pinc, OF assms(1)]
    using assms(5)
    by auto
next
  have "iso_represents FFb ?FFk" "FFb \<subseteq> ?FFk"
    using assms(3)
    by auto
  show "iso_represents ?FFb' ?FFk1"
    unfolding iso_represents_def
  proof
    fix F'
    assume "F' \<in> ?FFk1"
    then obtain A where "card A = length L" "A \<subseteq> {0..<n}" 
      "F' \<in> mult_P Pinc ?FFk A"
      by (subst (asm) L_part_mult_P[of P Pinc n L k, OF assms(1)]) auto
    then obtain F where "is_L_part n (L @ [k]) F" "P F" "F' = F \<union> {A}" "A \<notin> F" "Pinc A F"
      by auto
    then obtain Fb where "Fb \<in> FFb" "iso F Fb"
      using `iso_represents FFb ?FFk`
      unfolding iso_represents_def
      by auto metis
    then obtain f where *: "Fb = op ` f ` F" and "bij_betw f (\<Union>F) (\<Union>Fb)"
      unfolding iso_def
      by auto

    have "\<Union> F \<subseteq> {0..<n}" "\<Union> Fb \<subseteq> {0..<n}"
      using `is_L_part n (L @ [k]) F` `Fb \<in> FFb` `FFb \<subseteq> ?FFk`
      unfolding is_L_part_def
      by blast+

    have "\<exists> f'. inj_on f' (\<Union> F \<union> A) \<and> f' ` (\<Union> F \<union> A) \<subseteq> {0..<n} \<and> (\<forall>x\<in>\<Union>F. f x = f' x)"
    proof-
      obtain Bb where "card (A - \<Union> F) = card (Bb - \<Union> Fb)" "Bb \<subseteq> {0..<n}"
        using bij_betw_complement[of "\<Union> F" "{0..<n}" "\<Union> Fb" A f]
        using `\<Union> F \<subseteq> {0..<n}` `\<Union> Fb \<subseteq> {0..<n}`  `A \<subseteq> {0..<n}` `bij_betw f (\<Union>F) (\<Union>Fb)` `card A = length L` `length L \<le> n`
        by auto
      moreover
      have "finite A"
        using `A \<subseteq> {0..<n}`
        by (auto simp add: finite_subset)
      ultimately
      show ?thesis
        using bij_betw_extend[of f "\<Union> F" "\<Union> Fb" "A - \<Union> F" "Bb - \<Union> Fb"]
        using `bij_betw f (\<Union> F) (\<Union> Fb)`
        using  `Bb \<subseteq> {0..<n}` `\<Union> Fb \<subseteq> {0..<n}`
        by (auto simp add: finite_subset bij_betw_def) (metis Un_least)
    qed
    then obtain f' where **: "inj_on f' (\<Union> F \<union> A)" "f' ` (\<Union> F \<union> A) \<subseteq> {0..<n}"  "Fb = op ` f' ` F"
      using *
      by auto (metis (lifting) image_cong)

    show "\<exists> Fb' \<in> ?FFb'. iso F' Fb'"
    proof
      show "iso F' (Fb \<union> {f' ` A})"
        using iso_insert(1)[of f' F A]
        using **(1) **(3) `F' = F \<union> {A}`
        by simp
    next
      show "Fb \<union> {f' ` A} \<in> ?FFb'"
      proof-
        have "Pinc (f' ` A) Fb"
          using **(1) **(3)
          using `Pinc A F` assms(2)[rule_format, of f' F A]
          unfolding bij_betw_def
          by simp
        moreover
        have "Fb \<in> FFb" "f' ` A \<notin> Fb " "card (f' ` A) = length L" and "f' ` A \<subseteq>  {0..<n}"
          using iso_insert[of f' F A]
          using **
          using `card A = length L` `A \<notin> F` `Fb \<in> FFb`
          unfolding bij_betw_def
          by auto
        ultimately
        show ?thesis
          using assms(5)
          by blast
      qed
    qed
  qed
qed

end
