subsection{* Implementation by sorted and distinct lists *}

theory LPartitioningImpl
imports LPartitioning FamilyImpl NonIsomorphicFamiliesImpl
begin

definition mult_P_l where
  "mult_P_l P F A = 
          (let F' = [f \<leftarrow> F. A \<notin> set f \<and> P A f] in
                map (\<lambda> x. A # x) F')"

lemma mult_P_l_sorted_distinct:
  assumes "sdff F" "sd A"
  shows "sdff (mult_P_l P F A)"
using assms
unfolding mult_P_l_def
by auto

lemma mult_P_l_domain:
  assumes "dmf FFb n" "set A \<subseteq> {0..<n::nat}"
  shows "dmf (mult_P_l P FFb A) n"
using assms
unfolding mult_P_l_def
by auto

lemma mult_P_l_correctness:
  fixes FFb :: "nat list list list"
  assumes "sdff FFb" "sd A" "dmf FFb n" "set A \<subseteq> {0..<n}"
  assumes "\<And> A F. \<lbrakk>sd A; sdf F; dm (A # F) n\<rbrakk> \<Longrightarrow> P A F \<longleftrightarrow> P' (set A) (f_to_set_l F)"
  shows "fs_to_set_l (mult_P_l P FFb A) = mult_P P' (fs_to_set_l FFb) (set A)" (is "?lhs = ?rhs")
proof
  show "?lhs \<subseteq> ?rhs"
  proof
    fix x
    assume "x \<in> ?lhs"
    then obtain F where "F \<in> set FFb" "A \<notin> set F" "P A F" "x = f_to_set_l (A # F)"
      unfolding mult_P_l_def Let_def
      by auto
    have "x = insert (set A) (f_to_set_l F)"
      using `x = f_to_set_l (A # F)`
      by auto
    moreover
    have "f_to_set_l F \<in> f_to_set_l ` set FFb" 
      using `F \<in> set FFb`
      by simp
    moreover
    have "set A \<notin> f_to_set_l F" 
      using `F \<in> set FFb` `A \<notin> set F` SetImpl_lists.set_set[of F A] assms(1) assms(2)
      by auto
    moreover
    have "P' (set A) (f_to_set_l F) "
      using `sd A` `sdff FFb` `F \<in> set FFb` `set A \<subseteq> {0..<n}` `dmf FFb n`
      using `P A F` assms(5)[of A F]
      by simp
    ultimately
    show "x \<in> ?rhs"
      by auto
  qed
next
  show "?rhs \<subseteq> ?lhs"
  proof
    fix x
    assume "x \<in> ?rhs"
    then obtain F where "F \<in> set FFb" "set A \<notin> f_to_set_l F" "P' (set A) (f_to_set_l F)" "x = f_to_set_l F \<union> {set A}"
      by auto
    thus "x \<in> ?lhs"
      using assms(5)[of A F] `sdff FFb` `sd A` `dmf FFb n` `set A \<subseteq> {0..<n}`
      unfolding mult_P_l_def
      apply auto
      apply (rule image_eqI[where x= "F"])
      by auto
  qed
qed


definition mult_all_P_l where
  "mult_all_P_l P F n m = concat (map (\<lambda> A. mult_P_l P F A) (all_mn_subsets n m))"

lemma mult_all_P_l_sorted_distinct:
  assumes "sdff F"
  shows "sdff (mult_all_P_l P F n m)"
unfolding mult_all_P_l_def
proof (simp)
  show "\<forall> A \<in> set (all_mn_subsets n m). sdff (mult_P_l P F A)"
  proof
    fix A
    assume "A \<in> set (all_mn_subsets n m)"
    hence "sd A"
      by (rule all_mn_subsets_sorted_distinct) 
    thus "sdff (mult_P_l P F A)"
      using assms mult_P_l_sorted_distinct[of F A P]
      by blast
  qed
qed

lemma  mult_all_P_l_domain:
  assumes "dmf FFb n"
  shows "dmf (mult_all_P_l P FFb n m) n"
unfolding mult_all_P_l_def
proof(simp del: SetImpl_lists.f_to_set_def, rule ballI, rule ballI)
  fix A F
  assume "A \<in> set (all_mn_subsets n m)" "F \<in> set (mult_P_l P FFb A)" 
  thus "dm F n"
    using mult_P_l_domain[OF assms, of A P]
    using all_mn_subsets[of n m]
    by auto
qed

lemma mult_all_P_correctness:
  fixes FFb :: "nat list list list"
  assumes "sdff FFb" "dmf FFb n"
    "\<And> A F. \<lbrakk>sd A; sdf F; dm (A # F) n\<rbrakk> \<Longrightarrow> P A F \<longleftrightarrow> P' (set A) (f_to_set_l F)"
  shows "fs_to_set_l (mult_all_P_l P FFb n m) = mult_all_P P' (fs_to_set_l FFb) n m" (is "?lhs = ?rhs")
proof
  show "?lhs \<subseteq> ?rhs"
  proof
    fix x
    assume "x \<in> ?lhs"
    then obtain A where "A \<in> set (all_mn_subsets n m)" "x \<in> fs_to_set_l (mult_P_l P FFb A)"
      unfolding mult_all_P_l_def
      by auto
    moreover
    have "sd A"
      using `A \<in> set (all_mn_subsets n m)`
      by (rule all_mn_subsets_sorted_distinct)
    ultimately
    show "x \<in> ?rhs"
      using all_mn_subsets[of n m] assms(1) assms(2)
      by (subst (asm) mult_P_l_correctness[where P=P and P'=P', OF _ _ _ _ assms(3)]) auto
  qed
next
  show "?rhs \<subseteq> ?lhs"
  proof
    fix x
    assume "x \<in> ?rhs"
    then obtain A where "card A = m" "A \<subseteq> {0..<n}" "x \<in> mult_P P' (fs_to_set_l FFb) A"
      by auto
    obtain Al where "Al \<in> set (all_mn_subsets n m)" "set Al = A" "sorted Al \<and> distinct Al"
      using `card A = m` `A \<subseteq> {0..<n}`
      using all_mn_subsets_completeness [of A m n] all_mn_subsets_sorted_distinct
      by auto
    hence "x \<in> mult_P P' (fs_to_set_l FFb) (set Al)"
      using `x \<in> mult_P P' (fs_to_set_l FFb) A`
      by simp
    thus "x \<in> ?lhs"
      using `Al \<in> set (all_mn_subsets n m)` assms(1) `sd Al` assms(2)
      unfolding mult_all_P_l_def
      by (subst (asm) mult_P_l_correctness[symmetric, of FFb Al n P P', OF _ _ _ _ assms(3)]) auto
  qed
qed


definition mult_all_base_P_l where 
  "mult_all_base_P_l P F n m perms = non_isomorphic_families_l perms (mult_all_P_l P F n m)"

lemma mult_all_base_P_l_sorted_distinct:
  assumes "sdff F"
  shows "sdff (mult_all_base_P_l P F n m perms)"
proof-
  have "sdff (mult_all_P_l P F n m)"
    using assms
    by (rule mult_all_P_l_sorted_distinct)
  thus ?thesis
    unfolding mult_all_base_P_l_def
    using SetPermutations_lists.non_isomorphic_families_subset[of perms "mult_all_P_l P F n m"]
    by auto
qed

lemma mult_all_base_P_l_domain:
  assumes "dmf F n"
  shows "dmf (mult_all_base_P_l P F n m perms) n"
proof-
  have "dmf (mult_all_P_l P F n m) n"
    using assms
    by (rule mult_all_P_l_domain)
  thus ?thesis
    unfolding mult_all_base_P_l_def
    using SetPermutations_lists.non_isomorphic_families_subset[of perms "mult_all_P_l P F n m"]
    by auto
qed

lemma mult_all_base_P_l_correctness:
  assumes  "\<And> A F. \<lbrakk>sd A; sdf F; dm (A # F) n\<rbrakk> \<Longrightarrow> Pinc' A F \<longleftrightarrow> Pinc (set A) (f_to_set_l F)"
          "incrementally_checks Pinc P " "inj_preserved Pinc"
  assumes  "sdff FFb" "dmf FFb n" "\<forall>p\<in>set perms. p <~~> [0..<n]"
  assumes "iso_representing_subset (fs_to_set_l FFb) (L_part_P P n (L @ [k]))"
  "length L \<le> n"
  "FFb' = fs_to_set_l (mult_all_base_P_l Pinc' FFb n (length L) perms)"
  shows "iso_representing_subset FFb' (L_part_P P n (L @ [k+1]))"
proof-
  have "iso_representing_subset (fs_to_set_l (mult_all_P_l Pinc' FFb n (length L))) (L_part_P P n (L @ [k+1]))"
  proof (rule L_part_mult_iso_representing_subset[where FFb'="fs_to_set_l (mult_all_P_l Pinc' FFb n (length L))" and n=n and L=L and k=k and P=P and FFb="fs_to_set_l FFb" and Pinc="Pinc", OF assms(2)])
    show "iso_representing_subset (fs_to_set_l FFb) (L_part_P P n (L @ [k]))" "length L \<le> n"
      by fact+
  next
    show "fs_to_set_l (mult_all_P_l Pinc' FFb n (length L)) = mult_all_P Pinc (fs_to_set_l FFb) n (length L)"
      by (rule mult_all_P_correctness[of FFb n Pinc' Pinc, OF assms(4) assms(5) assms(1)])
  next 
    show "inj_preserved Pinc"
      by fact
  qed
  thus ?thesis
    apply (subst assms(9))+
    unfolding mult_all_base_P_l_def 
    using iso_representing_subset_non_isomorphic_families_l[OF assms(6), of "mult_all_P_l Pinc' FFb n (length L)"]
    using mult_all_P_l_domain[OF assms(5), of Pinc' "length L"]
    by auto
qed

subsection{* Recursive enumeration procedure *}

(* ----------------------------------------------------------- *) 
text{* For a given list L, find an iso-representing collection of all L-paritioned families that
satisfy some predicate P. *} 
(* ----------------------------------------------------------- *)

abbreviation dec_last where
 "dec_last L \<equiv> butlast L @ [last L - (1::nat)]"

function enum_rec where
 "enum_rec L v0 f = 
      (if L = [] then v0 
       else if last L = 0 then enum_rec (butlast L) v0 f 
       else f (enum_rec (dec_last L) v0 f) L)"
by pat_completeness auto
termination
proof-
  let ?R = "measure (\<lambda> (L, _, _). length L + sum_list L)"
  show ?thesis
  proof(relation "?R")
    fix L :: "nat list" and v0 :: "'a" and f :: "'a \<Rightarrow> nat list \<Rightarrow> 'a"
    assume "L \<noteq> []" "last L = 0"
    hence "sum_list L = sum_list (butlast L)"
      by (subst append_butlast_last_id[of L, symmetric]) auto
    thus "((butlast L, v0, f), L, v0, f)  \<in> ?R"
      using `L \<noteq> []`
      by simp
  next
    fix L::"nat list" and v0 :: "'a" and f :: "'a \<Rightarrow> nat list \<Rightarrow> 'a"
    assume "L \<noteq> []" "last L \<noteq> 0"
    hence "sum_list L = sum_list (butlast L) + last L"
      using sum_list_append[of "butlast L" "[last L]"]
      by (subst append_butlast_last_id[of L, symmetric]) auto
    thus "((butlast L @ [last L - 1], v0, f), L, v0, f) \<in> ?R"
      using `L \<noteq> []` `last L \<noteq> 0`
      by simp
  qed simp
qed
declare enum_rec.simps[simp del]

lemma enum_rec:
  assumes "P v0 []"
  assumes "\<And> v L. P v L \<Longrightarrow> P v (L @ [0])"
          "\<And> v L'::(nat list). \<lbrakk>L' \<noteq> []; last L' > 0; length L' \<le> length L; P v (dec_last L')\<rbrakk> \<Longrightarrow> P (f v L') L'"
  shows "P (enum_rec L v0 f) L"
using assms
proof (induct L v0 f rule: enum_rec.induct)
  case (1 L v0 f)
  show ?case
  proof (cases "L = []")
    case True
    thus ?thesis
      using 1(3)
      by (simp add: enum_rec.simps)
  next
    case False
    show ?thesis
    proof (cases "last L = 0")
      case True
      thus ?thesis
        using `L \<noteq> []`
        using enum_rec.simps[of L v0 f]
        using 1(1)[OF `L \<noteq> []` `last L = 0` 1(3) 1(4) 1(5)] 1(4)[of "enum_rec (butlast L) v0 f" "butlast L"]
        using append_butlast_last_id[of L]
        by auto
    next
      case False
      thus ?thesis
        using `L \<noteq> []`
        using enum_rec.simps[of L v0 f]
        using 1(2)[OF `L \<noteq> []` `last L \<noteq> 0` 1(3) 1(4) 1(5)]
        using 1(5)
        by (smt append_butlast_last_id length_append_singleton neq0_conv order_refl)
    qed
  qed
qed

lemma enum_rec_iso_representing_subset:
  assumes  "\<And> A F. \<lbrakk>sd A; sdf F; dm (A # F) n\<rbrakk> \<Longrightarrow> Pinc' A F \<longleftrightarrow> Pinc (set A) (f_to_set_l F)" and
  "incrementally_checks Pinc P" and "inj_preserved Pinc" and
  "\<forall>p\<in>set perms. p <~~> [0..<n]" and "length L - 1 \<le> n"
  assumes "P {}" "Mult = (\<lambda> F L. mult_all_base_P_l Pinc' F n (length L - 1) perms)"
  shows "iso_representing_subset (fs_to_set_l(enum_rec L [[]] Mult)) (L_part_P P n L)"
proof(rule enum_rec[of "\<lambda> X L. iso_representing_subset (fs_to_set_l X) (L_part_P P n L) \<and> sdff X \<and> dmf X n", THEN conjunct1])
  show "iso_representing_subset (fs_to_set_l [[]]) (L_part_P P n []) \<and> sdff [[]] \<and> dmf [[]] n" (is "iso_representing_subset ?X ?Y \<and> _")
  proof-
    have "?Y = {{}}"
      using is_L_part_zero[of 6 "[]", symmetric] `P {}`
      unfolding is_L_part_def
      by auto
    thus ?thesis
      by (auto simp add: iso_represents_def)
  qed
next
  fix v L
  assume "iso_representing_subset (fs_to_set_l v) (L_part_P P n L) \<and> sdff v \<and> dmf v n"
  thus "iso_representing_subset (fs_to_set_l v) (L_part_P P n (L @ [0])) \<and> sdff v \<and> dmf v n"
    using is_L_part_zero
    by auto
next
  fix v and L'::"nat list"
  assume "L' \<noteq> []" "last L' > 0" "length L' \<le> length L" 
  hence **: "length (butlast L') \<le> n"
    using `length L - 1 \<le> n`
    by auto
  assume "iso_representing_subset (fs_to_set_l v) (L_part_P P n (dec_last L')) \<and> sdff v \<and> dmf v n"
  hence *: "sdff v" "dmf v n" "iso_representing_subset (fs_to_set_l v) (L_part_P P n (dec_last L'))"
    by auto
  have "iso_representing_subset (fs_to_set_l (Mult v L')) (L_part_P P n (butlast L' @ [last L' - 1 + 1]))"
    using `L' \<noteq> []`
    by (subst assms(7))+ (rule mult_all_base_P_l_correctness[OF assms(1-3) *(1-2) assms(4) *(3) **(1)], auto)
  hence "iso_representing_subset (fs_to_set_l (Mult v L')) (L_part_P P n L')" (is "?T1")
    using `L' \<noteq> []` `last L' > 0`
    by simp
  moreover
  have "sdff (Mult v L') \<and> dmf (Mult v L') n"
    using *(1) *(2)
    using mult_all_base_P_l_sorted_distinct[of v Pinc' n "length L' - 1" perms]
    using mult_all_base_P_l_domain[of v n Pinc' "length L' - 1" perms]
    by (subst assms(7))+ blast
  ultimately
  show "iso_representing_subset (fs_to_set_l (Mult v L')) (L_part_P P n L') \<and>
          sdff (Mult v L') \<and> dmf (Mult v L') n"
    by simp
qed

subsection{* Dynamic programming enumeration procedure *}

definition pwge_impl where
 "pwge_impl L L' \<longleftrightarrow> list_all (\<lambda> (x, y). x \<ge> y) (zip L L')"

lemma pwge_impl:
  assumes "length L = length L'"
  shows "pwge_impl L L' \<longleftrightarrow> L \<succeq> L'"
using assms
unfolding pwge_impl_def pwge_def
by (auto simp add: list_all_iff set_zip)

function enum_dp where 
 "enum_dp val res k L g stop maxL = foldl
      (\<lambda> r n. let l = inc_nth L n
               in if length l \<noteq> length maxL \<or> stop l \<or> \<not> pwge_impl maxL l then 
                     r 
                  else 
                     enum_dp (g val n) r n l g stop maxL
      )
      (val # res)
      [k..<length L]"
by pat_completeness auto

abbreviation enum_dp_step where
 "enum_dp_step val res k g stop maxL L \<equiv> let l = inc_nth L k
                    in if length l \<noteq> length maxL \<or>
                          stop l \<or>
                          \<not> pwge_impl maxL l
                       then res else enum_dp (g val k) res k l g stop maxL"

definition listdiff where
 "listdiff xs ys = sum_list (map (\<lambda> (a, b). a - b) (zip xs ys))"

termination
proof (relation "measure (\<lambda> (val, res, k, L, g, stop, maxL). listdiff (map (op+1) maxL) L)") 
  fix val res k L g stop maxL r n l
  assume "l = inc_nth L n" "n \<in> set [k..<length L]"
    and *: "\<not> (length l \<noteq> length maxL \<or> stop l \<or> \<not> pwge_impl maxL l)"
  have **: "\<forall> x. x < length maxL \<longrightarrow> l ! x \<le> maxL ! x" "length l = length maxL" "n < length L"
    using * `n \<in> set [k..<length L]`
    by (auto simp add: pwge_impl_def list_all_iff set_zip)
  have "\<forall>x\<in>{0..<length maxL}.
          Suc (maxL ! x) - inc_nth L n ! x \<le> Suc (maxL ! x) - L ! x"
    using `n <length L`
    by (auto simp add: nth_list_update)
  moreover
  have "Suc (maxL ! n) - inc_nth L n ! n < Suc (maxL ! n) - L ! n"
    using `n <length L` `l = inc_nth L n` **
    by (auto simp add: nth_list_update split: if_split_asm)
  ultimately
  have "listdiff (map (op+1) maxL) l < listdiff (map (op+1) maxL) L"
    using `l = inc_nth L n` `length l = length maxL` `n < length L`
    unfolding listdiff_def
    by (auto simp add: list_ex_iff sum_list_sum_nth nth_list_update)
     (rule sum_strict_mono_ex1, auto)
  thus "((g val n, r, n, l, g, stop, maxL), (val, res, k, L, g, stop, maxL))
          \<in> measure (\<lambda>(val, res, k, L, g, stop, maxL). listdiff (map (op+1) maxL) L)"
    by simp
qed simp
declare enum_dp.simps[simp del]

lemma enum_dp_mono:
assumes "length L = length maxL"
shows  "set (val # res) \<subseteq> set (enum_dp val res k L g stop maxL)"
using assms
proof (induct val res k L g stop maxL rule: enum_dp.induct)
  case (1 val res k L g stop maxL)
  show ?case
  proof (subst enum_dp.simps, subst foldl_conv_fold, rule fold_invariant[where Q="\<lambda> x. x \<in> set [k..<length L]"])
    fix x s
    assume "x \<in> set [k..<length L]" "set (val # res) \<subseteq> set s"
    thus "set (val # res) \<subseteq> set (enum_dp_step val s x g stop maxL L)"
      unfolding Let_def
      using 1(1)[of x "inc_nth L x" s]
      by auto
  qed auto
qed

lemma enum_dp_mono':
assumes "length L = length maxL"
shows "set res \<subseteq> set (foldl (\<lambda> r n. enum_dp_step val r n g stop maxL L) res [k..<length L])"
proof (subst foldl_conv_fold, rule fold_invariant[where Q="\<lambda> x. x \<in> set [k..<length L]"])
  fix x s
  assume "x \<in> set [k..<length L]" "set res \<subseteq> set s"
  thus "set res \<subseteq> set (enum_dp_step val s x g stop maxL L)"
    unfolding Let_def
    using assms
    using enum_dp_mono[where val = "g val x" and res=s and k=x and L="inc_nth L x" and g=g and stop=stop and maxL=maxL]
    by auto
qed auto

lemma enum_dp_lemma:
  assumes 
    "length L = length maxL" and
    "\<forall> k''. k'' > k \<and> k'' < length L \<longrightarrow> L ! k'' = 0" and
    "X = {L'. L' \<succeq> L \<and> maxL \<succeq> L' \<and> take k L' = take k L \<and> \<not> (\<exists> Ls. Ls \<succeq> L \<and> take k L = take k Ls \<and> L' \<succeq> Ls \<and> stop Ls)}" and
    "P val L" and 
    "k < length L" and 
    "\<And> val L k'. \<lbrakk>P val L;  k' < length L; k' < length maxL; \<forall> k''. k'' > k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0\<rbrakk> \<Longrightarrow> 
        P (g val k') (inc_nth L k')"
  shows "\<forall> L' \<in> X. \<exists> B \<in> set (enum_dp val res k L g stop maxL). P B L'"
using assms
proof (induct val res k L g stop maxL arbitrary: X rule: enum_dp.induct)
  case (1 val res k L g stop maxL)
  show ?case
  proof
    fix L'
    assume "L' \<in> X"
    hence *: "L' \<succeq> L" "maxL \<succeq> L'" "take k L' = take k L" "\<not> (\<exists> Ls. Ls \<succeq> L \<and> take k L = take k Ls \<and> L' \<succeq> Ls \<and> stop Ls)"
      using 1(4)
      by auto
    show "\<exists>B\<in>set (enum_dp val res k L g stop maxL). P B L'"
    proof (cases "L = L'")
      case True
      thus ?thesis
        using 1(2) 1(5)
        using enum_dp_mono[of L maxL val res k g stop]
        by auto
    next
      case False

      have "\<exists> k'. k' \<ge> k \<and> k' < length L \<and> take k' L' = take k' L \<and> L' \<succeq> (inc_nth L k') \<and> (\<forall> k''. k'' > k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0)"
        using `take k L' = take k L`
        using 1(3) 1(6) 
      proof (induct "length L - k" arbitrary: k)
        case 0
        thus ?case
          by simp
      next
        case (Suc p)
        show ?case
        proof (cases "L' \<succeq> inc_nth L k")
          case True
          thus ?thesis
            using Suc(3) Suc(4) Suc(5)
            by (rule_tac x="k" in exI) simp
        next
          case False
          hence "L' ! k = L ! k" "length L = length L'"
            using Suc(3) `L' \<succeq> L`
            unfolding pwge_def
            by auto (metis Suc_diff_Suc Suc_leI Suc_neq_Zero diff_is_0_eq linorder_cases nth_list_update_eq nth_list_update_neq) 
          moreover
          hence "Suc k < length L"
            using `k < length L`
            using `L \<noteq> L'` Suc(3) list_eq_iff_nth_eq[of L L']
            by auto (metis less_linear less_trans_Suc nth_take)
          ultimately
          have "take (Suc k) L' = take (Suc k) L"
            using Suc(3)
            using take_Suc_conv_app_nth[of k L]
            using take_Suc_conv_app_nth[of k L']
            by auto
          moreover
          have "p = length L - Suc k"
            using Suc(2) `Suc k < length L`
            by auto
          moreover
          have "\<forall>k''. k''>Suc k \<and> k'' < length L \<longrightarrow> L ! k'' = 0"
            using Suc(4)
            by simp
          ultimately
          obtain k' where "k' \<ge> Suc k" "k' < length L" "take k' L' = take k' L" "L' \<succeq> inc_nth L k'" "\<forall> k''. k'' > k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0"
            using `Suc k < length L`
            using Suc(1)[of "Suc k"]
            by auto
          thus ?thesis
            by (rule_tac x="k'" in exI) simp
        qed
      qed

      then obtain k' where **: "k' \<ge> k" "k' < length L" "take k' L' = take k' L" "L' \<succeq> (inc_nth L k')" "\<forall> k''. k'' > k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0"
        by auto
      let ?l = "inc_nth L k'"
      let ?X'= "{L'. L' \<succeq> ?l \<and> maxL \<succeq> L' \<and> take k' L' = take k' ?l \<and> \<not> (\<exists> Ls. Ls \<succeq> ?l \<and> take k' ?l = take k' Ls \<and> L' \<succeq> Ls \<and> stop Ls)}"

      have "?l \<succeq> L"
        using `k' < length L`
        unfolding pwge_def
        by (auto simp add: nth_list_update)
      have "take k L = take k ?l"
        using `k' < length L ``k \<le> k'`
        by simp
        
      have "\<not> stop ?l"
        using * `k' \<ge> k` `?l \<succeq> L` `take k L = take k ?l` `L' \<succeq> (inc_nth L k')`
        by metis

      let ?a = "foldl (\<lambda>r n. enum_dp_step val r n g stop maxL L) (val # res) [k..<k']"

      have "\<exists> B \<in> set (enum_dp (g val k') ?a k' (inc_nth L k') g stop maxL). P B L'"
      proof (rule 1(1)[rule_format])
        show "L' \<in> ?X'"
        proof-
          have "\<not> (\<exists>Ls. Ls \<succeq> inc_nth L k' \<and> take k' (inc_nth L k') = take k' Ls \<and> L' \<succeq> Ls \<and> stop Ls)"
          proof (rule ccontr)
            assume "\<not> ?thesis"
            then obtain Ls where "Ls \<succeq> ?l" "take k' ?l = take k' Ls" "L' \<succeq> Ls" "stop Ls"
              by auto
            hence "Ls \<succeq> L \<and> take k L = take k Ls \<and> L' \<succeq> Ls \<and> stop Ls"
              using `?l \<succeq> L` pwge_trans[of Ls ?l L] `k' \<ge> k` `k' < length L`
              using take_prefix[of k k' L Ls]
              by simp
            thus False
              using *(4)
              by auto
          qed
          thus ?thesis
            using * **
            by auto
        qed
      next
        show "k' \<in> set [k..<length L]"
          using **
          by simp
      next
        show "\<not> (length (inc_nth L k') \<noteq> length maxL \<or>
                stop (inc_nth L k') \<or>
                \<not> pwge_impl maxL (inc_nth L k'))"
          using 1(2) * `\<not> stop ?l`
          using **(4)
          using pwge_trans[of maxL L' ?l]
          by (auto simp add: pwge_impl)
      next
        show "P (g val k') (inc_nth L k')"
          using 1(5) 1(7) **(5) `k' < length L` `length L = length maxL`
          by simp
      next
        show "length (inc_nth L k') = length maxL"
          using 1(2)
          by simp
      next
        show "k' < length ?l"
          using `k' < length L`
          by simp
      next
        fix val L k'
        assume "P val L" "\<And> k''. k' < k'' \<and> k'' < length L \<Longrightarrow> L ! k'' = 0" " k' < length L" "k' < length maxL"
        thus "P (g val k') (inc_nth L k')"
          using 1(7)
          by simp
      next
        fix k''
        assume "k' < k'' \<and> k'' < length (inc_nth L k')"
        thus "inc_nth L k' ! k'' = 0"
          using **(5)
          by auto
      qed simp_all
      hence ++: "\<exists> B \<in> set (enum_dp_step val ?a k' g stop maxL L). P B L'"
        using `length L = length maxL` `\<not> stop ?l`
        using `maxL \<succeq> L'` `L' \<succeq> ?l`
        using pwge_trans[of maxL L' ?l]
        by (auto simp add: Let_def pwge_impl)

      have "[k..<length L] = [k..<k'] @ (k' # [Suc k'..<length L])"
        using upt_add_eq_append[of k k' "length L - k'"]
        using upt_conv_Cons[of k' "length L"]
        using `k \<le> k'` `k' < length L`
        by auto
      hence "enum_dp val res k L g stop maxL = 
        foldl (\<lambda>r n. enum_dp_step val r n g stop maxL L) ?a (k' # [Suc k'..<length L])"
        by (subst enum_dp.simps)simp
      hence "enum_dp val res k L g stop maxL = 
        foldl (\<lambda>r n. enum_dp_step val r n g stop maxL L) (enum_dp_step val ?a k' g stop maxL L) [Suc k'..<length L]"
        by (subst (asm) foldl.simps) simp
      thus ?thesis
        using ++ `length L = length maxL`
        using enum_dp_mono'[where res="enum_dp_step val ?a k' g stop maxL L" and val=val and g=g and stop=stop and maxL=maxL and k="Suc k'" and L=L]
        by auto
    qed
  qed
qed

(* ----------------------------------------------------------------------- *)
text{* Incrementally build all generating subsets for L-partitioned lists upto
 the given bounds *}
(* ----------------------------------------------------------------------- *)

definition enum_dp_mult_P where
 "enum_dp_mult_P P n perms stops maxL = 
   enum_dp [[]] [] 0 (replicate (n+1) (0::nat)) 
         (\<lambda> FFb m. mult_all_base_P_l P FFb n m perms)
         (\<lambda> L. list_ex (\<lambda> L'. pwge_impl L L') stops)
         maxL"

lemma enum_dp_mult_P_correct:
assumes  "\<And> A F. \<lbrakk>sd A; sdf F; dm (A # F) n\<rbrakk> \<Longrightarrow> Pinc' A F \<longleftrightarrow> Pinc (set A) (f_to_set_l F)"
   "incrementally_checks Pinc P" "inj_preserved Pinc"
assumes
  "X = {L'. maxL \<succeq> L' \<and> \<not> (\<exists> S \<in> set stops. L' \<succeq> S)}" (is "_ = ?lhs") and
  "P {}" and
  "length maxL = n+1" and
  "\<forall> S \<in> set stops. length S = n+1" and
  "\<forall> p \<in> set perms. p <~~> [0..<n]"
shows  "\<forall> L' \<in> X. \<exists> B \<in> set (enum_dp_mult_P Pinc' n perms stops maxL). 
          iso_representing_subset (fs_to_set_l B) (L_part_P P n L')"
proof-
  have "\<forall> L' \<in> X. \<exists> B \<in> set (enum_dp_mult_P Pinc' n perms stops maxL). 
          iso_representing_subset (fs_to_set_l B) (L_part_P P n L') \<and> sdff B \<and> dmf B n"
    unfolding enum_dp_mult_P_def
  proof (rule enum_dp_lemma)
    show "length (replicate (n+1) (0::nat)) = length maxL"
      using `length maxL = n+1`
      by simp
  next
    show "\<forall>k''. 0 < k'' \<and> k'' < length (replicate (n+1) (0::nat)) \<longrightarrow>
          replicate (n+1) (0::nat) ! k'' = 0"
      by auto
  next
    show "0 < length (replicate (n+1) (0::nat))"
      by simp
  next
    show "iso_representing_subset (fs_to_set_l [[]]) (L_part_P P n (replicate (n+1) 0)) \<and> sdff [[]] \<and> dmf [[]] n"
    proof-
      have *: "L_part_P P n (replicate (n+1) 0) = {{}}"
      proof-
        have *: "L_part_P P n (replicate (n+1) 0) = L_part_P P n []"
          using is_L_part_zeros_replicate[of n "n+1"]
          by simp
        show ?thesis
        proof (subst *, rule)
          show "L_part_P P n [] \<subseteq> {{}}"
            unfolding is_L_part_def
            by auto
        next
          show "{{}} \<subseteq> L_part_P P n []"
            using `P {}`
            by (simp add: is_L_part_def)
        qed
      qed
      show ?thesis
        by (subst *)+ (auto simp add: iso_represents_def)
    qed
  next
    fix val L k'
    assume *: "iso_representing_subset (fs_to_set_l val) (L_part_P P n L) \<and> sdff val \<and> dmf val n" and
      "k' < length L" "\<forall> k''. k''>k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0" "k' < length maxL"
    moreover
    have "take (k'+1) L = take k' L @ [L ! k']"
      using `k' < length L` take_Suc_conv_app_nth[of k' L]
      by simp
    ultimately
    have "iso_representing_subset (fs_to_set_l val) (L_part_P P n (take k' L @ [L ! k']))"
      using is_L_part_zeros[of k' L n]
      by auto
    have "iso_representing_subset (fs_to_set_l (mult_all_base_P_l Pinc' val n k' perms)) (L_part_P P n (take k' L @ [(L ! k') + 1]))"
    proof (rule mult_all_base_P_l_correctness[OF assms(1-2)])
      show "iso_representing_subset (fs_to_set_l val) (L_part_P P n (take k' L @ [L ! k']))"
        by fact
    next
      show "fs_to_set_l (mult_all_base_P_l Pinc' val n k' perms) =
            fs_to_set_l (mult_all_base_P_l Pinc' val n (length (take k' L)) perms)"
        using `k' < length L`
        by (simp add: min_def)
    next
      show "length (take k' L) \<le> n"
        using `length maxL = n + 1` `k' < length maxL`
        by simp
    next
      show "sdff val" "dmf val n"
        using *
        by simp_all
    next
      show "\<forall> p \<in> set perms. p <~~> [0..<n]"
        by fact
    next
      show "inj_preserved Pinc"
        by fact
    qed simp_all
    moreover
    have "take (k'+1) (inc_nth L k') = take k' L @ [Suc (L ! k')]"
      using `k' < length L` take_Suc_conv_app_nth[of k' "inc_nth L k'"]
      by auto
    ultimately
    have "iso_representing_subset (fs_to_set_l (mult_all_base_P_l Pinc' val n k' perms)) (L_part_P P n (take (k'+1) (inc_nth L k')))"
      by simp
    hence "iso_representing_subset (fs_to_set_l (mult_all_base_P_l Pinc' val n k' perms)) (L_part_P P n (inc_nth L k'))" (is "?T1")
      using is_L_part_zeros[of k' "inc_nth L k'" n] `\<forall> k''. k''>k' \<and> k'' < length L \<longrightarrow> L ! k'' = 0`
      by auto
    moreover
    have "sdff (mult_all_base_P_l Pinc' val n k' perms)" (is "?T2")
      using *[THEN conjunct2, THEN conjunct1] 
      by (rule mult_all_base_P_l_sorted_distinct)
    moreover
    have "dmf (mult_all_base_P_l Pinc' val n k' perms) n" (is "?T3")
      using *[THEN conjunct2, THEN conjunct2] 
      by (rule mult_all_base_P_l_domain)
    ultimately
    show "?T1 \<and> ?T2 \<and> ?T3"
      by simp
  next
    show "X =
      {L'.
       L' \<succeq> replicate (n+1) 0 \<and>  maxL \<succeq> L' \<and> take 0 L' = take 0 (replicate (n+1) 0) \<and>
     \<not> (\<exists>Ls. Ls \<succeq> replicate (n+1) 0 \<and>
             take 0 (replicate (n+1) 0) = take 0 Ls \<and>
             L' \<succeq> Ls \<and> list_ex (pwge_impl Ls) stops)}" (is "_ = ?rhs")
    proof (subst assms(4), rule)
      show "?lhs \<subseteq> ?rhs"
      proof
        fix L'
        assume "L' \<in> ?lhs"
        hence "maxL \<succeq> L'" "\<not> (\<exists>S\<in>set stops. L' \<succeq> S)"
          by auto
        hence "length L' = n + 1"
          using `length maxL = n + 1`
          by (simp add: pwge_def)
        show "L' \<in> ?rhs"
        proof-
          have "L' \<succeq> replicate (n+1) 0"
            using `length L' = n+1`
            by (rule pwge_replicate_0)
          moreover
          have "\<not> (\<exists>Ls. Ls \<succeq> replicate (n+1) 0 \<and> take 0 (replicate (n+1) 0) = take 0 Ls \<and> L' \<succeq> Ls \<and> list_ex (pwge_impl Ls) stops)"
          proof (rule ccontr)
            assume "\<not> ?thesis"
            then obtain Ls where "L' \<succeq> Ls" "list_ex (pwge_impl Ls) stops"
              by auto
            moreover
            hence "length Ls = n + 1"
              using `length L' = n + 1`
              unfolding pwge_def
              by simp
            ultimately
            obtain S where "S \<in> set stops" "Ls \<succeq> S"
              using pwge_impl[of Ls] `\<forall> S \<in> set stops. length S = n + 1`
              by (auto simp add: list_ex_iff)
            thus False
              using `\<not> (\<exists>S\<in>set stops. L' \<succeq> S)` `L' \<succeq> Ls` pwge_trans[of L' Ls S]
              by auto
          qed
          ultimately
          show ?thesis
            using `maxL \<succeq> L'`
            by auto
        qed
      qed
    next
      show "?rhs \<subseteq> ?lhs"
      proof
        fix L'
        assume "L' \<in> ?rhs"
        hence "maxL \<succeq> L'" "\<not> (\<exists>Ls. L' \<succeq> Ls \<and> Ls \<succeq> replicate (n+1) 0 \<and> list_ex (pwge_impl Ls) stops)"
          by auto
        have "\<not> (\<exists>S\<in>set stops. L' \<succeq> S)"
        proof (rule ccontr)
          assume "\<not> ?thesis"
          then obtain S where "S \<in> set stops" "L' \<succeq> S"
            by auto
          moreover
          hence "length L' = n+1" "length S = n+1"
            using `maxL \<succeq> L'` `length maxL = n+1`
            by (auto simp add: pwge_def)
          ultimately
          have "L' \<succeq> S \<and> S \<succeq> replicate (n+1) 0 \<and> list_ex (pwge_impl S) stops"
            using pwge_refl[of S] pwge_impl[of S S] pwge_replicate_0[of S "n+1"]
            by (auto simp add: list_ex_iff)
          thus False
            using `\<not> (\<exists>Ls. L' \<succeq> Ls \<and> Ls \<succeq> replicate (n+1) 0 \<and> list_ex (pwge_impl Ls) stops)`
            by auto
        qed
        thus "L' \<in> ?lhs"
          using `maxL \<succeq> L'`
          by simp
      qed
    qed
  qed
  thus ?thesis
    by auto
qed

end
