subsection{* Generating all irreducible families *}

theory LPartitioningIrreducible
imports LPartitioning IrreducibleFamilies
begin

lemma irreducible_expressible:
  "incrementally_checks (\<lambda> A F. \<not> expressible A F) irreducible"
proof (safe)
  fix A :: "'a set" and  F :: "'a set set"
  assume "\<not> expressible A F" "irreducible F" "finite (\<Union> F)" "finite A"
  "\<forall> A' \<in> F. card A \<ge> card A'" "reducible (F \<union> {A})"
  obtain A' Fb where "A' \<in> F \<union> {A}" "Fb \<noteq> {}" "Fb \<subseteq> F \<union> {A}" "A' \<notin> Fb" "A' = \<Union> Fb" 
    using `reducible (F \<union> {A})`
    unfolding reducible_def
    by auto
  have "finite A'"
    using `A' \<in> F \<union> {A}` `finite (\<Union> F)` `finite A`
    by (auto simp add: finiteUn_iff)
  show False
  proof (cases "A' = A")
    case True
    thus ?thesis
      using `\<not> expressible A F`
      unfolding expressible_def
      using `A' = \<Union> Fb` `Fb \<subseteq> F \<union> {A}` `A' \<notin> Fb` `Fb \<noteq> {}`
      by auto
  next
    case False
    hence "A' \<in> F"
      using `A' \<in> F \<union> {A}`
      by simp
    have "A \<in> Fb"
      using `Fb \<subseteq> F \<union> {A}` `A' \<notin> Fb` `A' = \<Union> Fb` `A' \<in> F` `Fb \<noteq> {}`
      using `irreducible F`
      unfolding reducible_def
      by blast
    hence "A \<subseteq> A'"
      using `A' = \<Union> Fb`
      by auto
    hence "card A' > card A"
      using `A' \<noteq> A`
      using card_mono[of A' A] card_seteq[of A' A]  `finite A'`
      by auto
    thus False
      using `A' \<in> F` `\<forall> A' \<in> F. card A \<ge> card A'`
      by auto
  qed
qed (auto simp add: reducible_def expressible_def)

lemma not_expressible_iso:
assumes  "\<not> expressible A F" and "inj_on f (\<Union> F \<union> A)"
shows "\<not> expressible (f ` A) (op ` f ` F)" 
proof (rule ccontr)
  assume "\<not> ?thesis"
  then obtain Fb' where "Fb' \<subseteq> op ` f ` F" "f ` A = \<Union>Fb'" "Fb' \<noteq> {}"
    unfolding expressible_def
    by auto
  then obtain F' where "F' \<subseteq> F" and ++: "op ` f ` F' = Fb'"
    by (metis (no_types) subset_image_iff)
  have "A = \<Union> F'"
  proof
    show "A \<subseteq> \<Union> F'"
    proof
      fix x
      assume "x \<in> A"
      then obtain y where "y \<in> Fb'" "f x \<in> y"
        using `image f A = \<Union>Fb'`
        by auto
      then obtain x' y' where "y' \<in> F'" "x' \<in> y'" "f x' = f x"
        using ++
        by auto
      hence "x' = x"
        using `inj_on f (\<Union> F \<union> A)` `x \<in> A` `y' \<in> F'` `F' \<subseteq> F`
        unfolding inj_on_def
        by auto
      thus "x \<in> \<Union> F'"
        using `x' \<in> y'` `y' \<in> F'`
        by auto
    qed
  next
    show "\<Union> F' \<subseteq> A"
    proof
      fix x
      assume "x \<in> \<Union> F'"
      hence "f x \<in> f ` A"
        using ++
        using `image f A = \<Union>Fb'`
        by auto
      then obtain x' where "x' \<in> A" "f x = f x'"
        by auto
      thus "x \<in> A"
        using `x \<in> \<Union> F'` `F' \<subseteq> F`
        using `inj_on f (\<Union> F \<union> A)`
        unfolding inj_on_def
        by auto
    qed
  qed
  moreover
  have "F' \<noteq> {}"
    using ++ `Fb' \<noteq> {}`
    by auto
  ultimately
  show False
    using `\<not> expressible A F` `F' \<subseteq> F` 
    unfolding expressible_def
    by auto
qed

lemma inj_preserved_not_expressible:
  shows "inj_preserved (\<lambda> A F. \<not> expressible A F)"
  using not_expressible_iso
  by auto

abbreviation L_part_irreducible where
  "L_part_irreducible \<equiv> L_part_P irreducible"
abbreviation mult_irreducible where
  "mult_irreducible \<equiv> mult_P (\<lambda> A F. \<not> expressible A F)"
abbreviation mult_all_irreducible where
  "mult_all_irreducible \<equiv> mult_all_P (\<lambda> A F. \<not> expressible A F)"

lemma L_part_irreducible_mult_irreducible:
  "L_part_irreducible n (L @ [k+1]) = mult_all_irreducible (L_part_irreducible n (L @ [k])) n (length L)"
using L_part_mult_P[of irreducible "\<lambda> A f. \<not> expressible A f" n L k, OF irreducible_expressible]
by auto

lemmas L_part_irreducible_mult_irreducible_iso_representing_subset =
   L_part_mult_iso_representing_subset[of irreducible "\<lambda> A F. \<not> expressible A F", 
                                       OF irreducible_expressible inj_preserved_not_expressible]

end
