subsection{* Generating all irreducible families that are not FCs covered by the given collection *}

theory LPartitioningIrreducibleNonFCsCovered
imports LPartitioningIrreducible LPartitioningNonFCsCovered IrreducibleFamilies
begin

(* ---------------------------------------------------------------- *)

lemma irreducible_expressible_notFCs_covered:
  "incrementally_checks
         (\<lambda> A F. \<not> expressible A F \<and> \<not> FCs_covered \<F> (F \<union> {A}))
         (\<lambda> F. irreducible F \<and> \<not> FCs_covered \<F> F)"
using irreducible_expressible
using notFCs_covered[of \<F>]
by metis

lemma irreducible_expressible_notFCs_covered_iso:
assumes "\<not> expressible A F" "\<not> FCs_covered \<F> (F \<union> {A})" "inj_on f (\<Union>F \<union> A)"
  shows "\<not> expressible (f ` A) (op ` f ` F) \<and> \<not> FCs_covered \<F> (op ` f ` F \<union> {f ` A})"
using assms
using not_expressible_iso[of A F f] notFCs_covered_iso[of \<F> F A f]
by auto

lemma inj_preserved_not_expressible_notFCs_covered:
  "inj_preserved (\<lambda> A F. \<not> expressible A F \<and> \<not> FCs_covered \<F> (F \<union> {A}))"
using inj_preserved_not_expressible inj_preserved_not_FCs_covered
by blast

abbreviation L_part_irreducible_notFCs_covered where
 "L_part_irreducible_notFCs_covered \<F> \<equiv> L_part_P (\<lambda> F. irreducible F \<and> \<not> FCs_covered \<F> F)"
abbreviation mult_all_irreducible_notFCs_covered where
 "mult_all_irreducible_notFCs_covered \<F> \<equiv> mult_all_P (\<lambda> A f. \<not> expressible A f \<and> \<not> FCs_covered \<F> (f \<union> {A}))"

lemma L_part_mult_iso_representing_subset_irreducible_notFC_covered:
  assumes 
    "iso_representing_subset FFb (L_part_irreducible_notFCs_covered \<F> n (L @ [k]))"
    "length L \<le> n"
    "FFb' = mult_all_irreducible_notFCs_covered \<F> FFb n (length L)"
  shows "iso_representing_subset FFb' (L_part_irreducible_notFCs_covered \<F> n (L @ [k + 1]))"
using assms
using L_part_mult_iso_representing_subset[of "\<lambda> F. irreducible F \<and> \<not> FCs_covered \<F> F" "\<lambda> A f. \<not> expressible A f \<and> \<not> FCs_covered \<F> (f \<union> {A})" FFb, OF irreducible_expressible_notFCs_covered inj_preserved_not_expressible_notFCs_covered]
by auto

lemma iso_represents_L_part_irreducible_notFCs_covered:
  fixes \<F> \<N> FFb :: "nat set set set"
  assumes "iso_representing_subset FFb (L_part_irreducible_notFCs_covered \<F> n L)"
          "\<forall> F \<in> FFb. nonFCs_covered \<N> F"
          "\<forall> N \<in> \<N>. finite (\<Union> N)"
  shows "\<forall> F \<in> L_part_irreducible n L. covered \<F> \<N> F"
using assms
using iso_represents_nonFCs_covered[of "{F \<in> L_part n L. irreducible F \<and> \<not> FCs_covered \<F> F}" \<N> FFb]
using is_L_part_finite[of n L]
unfolding covered_def
by auto blast

end
