subsubsection{* Implementation *}

theory LPartitioningIrreducibleNonFCsCoveredImpl
imports LPartitioningIrreducibleNonFCsCovered IrreducibleFamiliesImpl CoveringImpl LPartitioningNonFCsCoveredImpl
begin

(* ----------------------------------------------------------------------- *)
text{*  *}
(* ----------------------------------------------------------------------- *)

lemma irreducible_expressible_notFCs_covered_l:
  assumes  "perms = permute [0..<n]" "dmf \<F> n" "sdff \<F>"
  "sd A" "sdf F" "dm (A # F) n"
  shows "\<not> expressible_l A F \<and> \<not> FCs_covered_l \<F> (A # F) perms \<longleftrightarrow> \<not> expressible (set A) (f_to_set_l F) \<and> \<not> FCs_covered (fs_to_set_l \<F>) (f_to_set_l F \<union> {set A})"
using assms
using expressible_l_soundness[of A F]
using expressible_l_completeness[OF assms(4-5)]
using notFCs_covered_l[OF assms(1-3) assms(6)]
by auto
  

definition mult_irreducible_notFCs_covered_l where 
  "mult_irreducible_notFCs_covered_l \<F> F A perms = 
      (let F' = filter (\<lambda> f. A \<notin> set f \<and> \<not> expressible_l A f) F; 
           F'' = map (\<lambda> x. A # x) F' 
        in filter (\<lambda> X. \<not> FCs_covered_l \<F> X perms) F'')"

definition mult_all_irreducible_notFCs_covered_l where
  "mult_all_irreducible_notFCs_covered_l \<F> F n m perms = 
     concat (map (\<lambda> A. mult_irreducible_notFCs_covered_l \<F> F A perms) (all_mn_subsets n m))"

definition mult_all_base_irreducible_notFCs_covered_l where 
  "mult_all_base_irreducible_notFCs_covered_l \<F> F n m perms =
     non_isomorphic_families_l perms (mult_all_irreducible_notFCs_covered_l \<F> F n m perms)"

lemma mult_all_base_irreducible_notFCs_covered: 
  "mult_all_base_irreducible_notFCs_covered_l \<F> F n m perms =
   mult_all_base_P_l (\<lambda> A F. \<not> expressible_l A F \<and> \<not> FCs_covered_l \<F> (A # F) perms) F n m perms"
unfolding mult_all_base_irreducible_notFCs_covered_l_def mult_all_base_P_l_def mult_all_irreducible_notFCs_covered_l_def mult_all_P_l_def mult_irreducible_notFCs_covered_l_def mult_P_l_def
  by (simp add: filter_map Let_def)

definition mult_irreducible_notFCs_covered_l_opt where 
  "mult_irreducible_notFCs_covered_l_opt \<F>_perms F A = 
      (let F' = filter (\<lambda> f. A \<notin> set f \<and> \<not> expressible_l A f) F; 
           F'' = map (\<lambda> x. A # x) F' 
        in filter (\<lambda> X. \<not> FCs_covered_l_opt' \<F>_perms X) F'')"
definition mult_all_irreducible_notFCs_covered_l_opt where
  "mult_all_irreducible_notFCs_covered_l_opt \<F>_perms F n m = 
   concat (map (\<lambda> A. mult_irreducible_notFCs_covered_l_opt \<F>_perms F A) (all_mn_subsets n m))"
definition mult_all_base_irreducible_notFCs_covered_l_opt where 
  "mult_all_base_irreducible_notFCs_covered_l_opt \<F>_perms F n m perms =
   non_isomorphic_families_l perms (mult_all_irreducible_notFCs_covered_l_opt \<F>_perms F n m)"

lemma mult_all_base_irreducible_notFCs_covered_opt:
  assumes "\<F>_perms = map (\<lambda> F. map (\<lambda> p. permute_family_l p F) perms) \<F>"
  shows "mult_all_base_irreducible_notFCs_covered_l_opt \<F>_perms F n m perms = 
         mult_all_base_irreducible_notFCs_covered_l \<F> F n m perms"
using assms
by (auto simp add: list_ex_iff  mult_all_base_irreducible_notFCs_covered_l_def mult_all_base_irreducible_notFCs_covered_l_opt_def mult_all_irreducible_notFCs_covered_l_def mult_all_irreducible_notFCs_covered_l_opt_def mult_irreducible_notFCs_covered_l_def mult_irreducible_notFCs_covered_l_opt_def FCs_covered_l_opt_def FCs_covered_l_def FC_covered_l_opt_def FC_covered_l_def)

abbreviation enum_rec_irreducible_notFCs_covered_l where
 "enum_rec_irreducible_notFCs_covered_l \<F>_perms L n perms \<equiv> 
  enum_rec L [[]] (\<lambda> F L. mult_all_base_irreducible_notFCs_covered_l_opt \<F>_perms F n (length L - 1) perms)"

abbreviation enum_dp_irreducible_notFCs_covered_l where
"enum_dp_irreducible_notFCs_covered_l \<F>_perms n perms stops maxL \<equiv> 
   enum_dp [[]] [] 0 (replicate (n+1) (0::nat)) 
         (\<lambda> FFb m. mult_all_base_irreducible_notFCs_covered_l_opt \<F>_perms FFb n m perms)
         (\<lambda> L. list_ex (\<lambda> L'. pwge_impl L L') stops)
         maxL"

lemma enum_dp_irreducible_notFCs_covered_l:
  assumes "\<F>_perms = map (\<lambda>F. map (\<lambda>p. permute_family_l p F) perms) \<F>"
  shows 
    "enum_dp_irreducible_notFCs_covered_l \<F>_perms n perms stops maxL = 
     enum_dp_mult_P (\<lambda> A F. \<not> expressible_l A F \<and> \<not> FCs_covered_l \<F> (A # F) perms) n perms stops maxL"
unfolding enum_dp_mult_P_def
by (subst mult_all_base_irreducible_notFCs_covered_opt[OF assms], subst mult_all_base_irreducible_notFCs_covered, simp)

lemma enum_dp_irreducible_notFCs_covered_l_iso_representing_subsets:
assumes
  "\<F>_perms = map (\<lambda>F. map (\<lambda>p. permute_family_l p F) perms) \<F>"
  "X = {L'. maxL \<succeq> L' \<and> \<not> (\<exists> S \<in> set stops. L' \<succeq> S)}" (is "_ = ?lhs")
  "length maxL = n + 1" "\<forall> S \<in> set stops. length S = n + 1"                              
  "[] \<notin> set \<F>" "perms = permute [0..<n]" "dmf \<F> n" "sdff \<F>"
shows  "\<forall> L' \<in> X. \<exists> B \<in> set (enum_dp_irreducible_notFCs_covered_l \<F>_perms n perms stops maxL). 
          iso_representing_subset (fs_to_set_l B) (L_part_irreducible_notFCs_covered (fs_to_set_l \<F>) n L')"
proof-
  have "irreducible {} \<and> \<not> FCs_covered (fs_to_set_l \<F>) {}"
    using `[] \<notin> set \<F>`
    unfolding FC_covered_def
    by (auto  simp add: closure_def reducible_def)
  thus ?thesis
    using assms
    by (subst enum_dp_irreducible_notFCs_covered_l[OF assms(1)]) 
       (rule enum_dp_mult_P_correct [where Pinc'="\<lambda> A F. \<not> expressible_l A F \<and> \<not> FCs_covered_l \<F> (A # F) perms", OF irreducible_expressible_notFCs_covered_l[OF assms(6) assms(7)] irreducible_expressible_notFCs_covered inj_preserved_not_expressible_notFCs_covered], auto simp add: isPermutation_permute)
qed

end
