subsection{* Generating all families that are not FCs covered by the given collection *}

theory LPartitioningNonFCsCovered
imports LPartitioning  Covering
begin

lemma pwge_FCs_covered:
  assumes "\<forall> F \<in> L_part n L. FCs_covered \<F> F" "L' \<succeq> L"
  shows "\<forall> F \<in> L_part n L'. FCs_covered \<F> F"
proof (safe)
  fix F'
  assume "is_L_part n L' F'"
  then obtain F where "F \<subseteq> F'" "is_L_part n L F"
    using `L' \<succeq> L` is_L_part_subset[of L' L n F']
    by auto
  then obtain Fc where "FC_covered Fc F" "Fc \<in> \<F>"
    using assms(1)[rule_format,of F]                     
    by auto
  thus "FCs_covered \<F> F'"
    using FC_covered_mono[of F F' Fc] `F \<subseteq> F'`
    by auto
qed

lemma notFCs_covered:
  "incrementally_checks (\<lambda> A F. \<not> FCs_covered \<F> (F \<union> {A})) (\<lambda> F. \<not> FCs_covered \<F> F)"
using FC_covered_mono
by blast

lemma notFCs_covered_iso:
  assumes  "\<not> FCs_covered \<F> (F \<union> {A})" and "inj_on f (\<Union> F \<union> A)"
  shows "\<not> FCs_covered \<F> ((op ` f ` F) \<union> {f ` A})"
proof-
  have "iso (F \<union> {A}) ((op ` f ` F) \<union> {f ` A})"
    unfolding iso_def
    unfolding bij_betw_def
    using `inj_on f (\<Union> F \<union> A)`
    by (rule_tac x="f" in exI) (auto simp add: Un_commute)
  thus ?thesis
    using assms
    using FC_covered_iso[of "(op ` f ` F) \<union> {f ` A}" "F \<union> {A}"] iso_sym
    by blast
qed

lemma inj_preserved_not_FCs_covered:
  "inj_preserved (\<lambda> A F. \<not> FCs_covered \<F> (F \<union> {A}))"
using notFCs_covered_iso
by blast

abbreviation L_part_notFCs_covered where
 "L_part_notFCs_covered \<F> \<equiv> L_part_P (\<lambda> F. \<not> FCs_covered \<F> F)"
abbreviation mult_all_notFCs_covered where
 "mult_all_notFCs_covered \<F> \<equiv> mult_all_P (\<lambda> A f. \<not> FCs_covered \<F> (f \<union> {A}))"

lemma L_part_mult_iso_representing_subset_notFC_covered:
  assumes 
    "iso_representing_subset FFb (L_part_notFCs_covered \<F> n (L @ [k]))"
    "FFb' = mult_all_notFCs_covered \<F> FFb n (length L)"
    "length L \<le> n"
  shows "iso_representing_subset FFb' (L_part_notFCs_covered \<F> n (L @ [k + 1]))"
using assms
using L_part_mult_iso_representing_subset[of "\<lambda> F. \<not> FCs_covered \<F> F" "\<lambda> A f. \<not> FCs_covered \<F> (f \<union> {A})" FFb n L k, OF notFCs_covered inj_preserved_not_FCs_covered]
by auto

end
