subsubsection{* Implementation *}

theory LPartitioningNonFCsCoveredImpl
imports LPartitioningNonFCsCovered CoveringImpl LPartitioningImpl
begin

lemma notFCs_covered_l:
  assumes  "perms = permute [0..<n]" "dmf \<F> n" "sdff \<F>"  "dm (A # F) n"
  "sd A" "sdf F"
  shows 
     "\<not> FCs_covered_l \<F> (A # F) perms \<longleftrightarrow> 
      \<not> FCs_covered (fs_to_set_l \<F>) (f_to_set_l F \<union> {set A})"
      using FC_covered_l_soundness[of perms n _ "A # F"]
      using FC_covered_l_completeness[of "A # F" _ n perms]
      using assms
      unfolding FCs_covered_l_def
      by (auto simp add: list_ex_iff isPermutation_permute)

definition mult_notFCs_covered_l where 
  "mult_notFCs_covered_l \<F> F A perms = 
      (let F' = filter (\<lambda> f. A \<notin> set f) F; 
           F'' = map (\<lambda> x. A # x) F' 
        in filter (\<lambda> X. \<not> FCs_covered_l \<F> X perms) F'')"

definition mult_all_notFCs_covered_l where
  "mult_all_notFCs_covered_l \<F> F n m perms = concat (map (\<lambda> A. mult_notFCs_covered_l \<F> F A perms) (all_mn_subsets n m))"

definition mult_all_base_notFCs_covered_l where
  "mult_all_base_notFCs_covered_l \<F> F n m perms = non_isomorphic_families_l perms (mult_all_notFCs_covered_l \<F> F n m perms)"

lemma mult_all_base_notFCs_covered_l:
  "mult_all_base_notFCs_covered_l \<F> F n m perms = mult_all_base_P_l (\<lambda> A F. \<not> FCs_covered_l \<F> (A # F) perms) F n m perms"
by (simp add: mult_all_base_P_l_def mult_all_base_notFCs_covered_l_def mult_all_P_l_def mult_all_notFCs_covered_l_def mult_P_l_def mult_notFCs_covered_l_def filter_map)

(* Optimize: Fc_perms - all permutations of Fc *)
definition FC_covered_l_opt :: "nat list list list \<Rightarrow> nat list list \<Rightarrow> bool" where
  "FC_covered_l_opt Fc_perms F \<longleftrightarrow> list_ex (\<lambda> Fc'. set Fc' \<subseteq> set (close_l F)) Fc_perms"
definition FCs_covered_l_opt where
  "FCs_covered_l_opt \<F>_perms F \<longleftrightarrow> list_ex (\<lambda> Fc. FC_covered_l_opt Fc F) \<F>_perms"
  
definition FCs_covered_l_opt' where
  "FCs_covered_l_opt' \<F>_perms F \<longleftrightarrow> 
      (let clF = set (close_l F) 
        in list_ex (list_ex (\<lambda> Fc'. set Fc' \<subseteq> clF)) \<F>_perms)"

lemma [simp]: "FCs_covered_l_opt' = FCs_covered_l_opt"
by (rule ext)+ (simp add: FCs_covered_l_opt'_def FCs_covered_l_opt_def FC_covered_l_opt_def)
  
definition mult_notFCs_covered_l_opt where 
  "mult_notFCs_covered_l_opt \<F>_perms F A = 
      (let F' = filter (\<lambda> f. A \<notin> set f) F; 
           F'' = map (\<lambda> x. A # x) F' 
        in filter (\<lambda> X. \<not> FCs_covered_l_opt' \<F>_perms X) F'')"
definition mult_all_notFCs_covered_l_opt where
  "mult_all_notFCs_covered_l_opt \<F>_perms F n m = concat (map (\<lambda> A. mult_notFCs_covered_l_opt \<F>_perms F A) (all_mn_subsets n m))"
definition mult_all_base_notFCs_covered_l_opt where 
  "mult_all_base_notFCs_covered_l_opt \<F>_perms F n m perms = non_isomorphic_families_l perms (mult_all_notFCs_covered_l_opt \<F>_perms F n m)"

lemma mult_all_base_notFCs_covered_opt:
  assumes "\<F>_perms = map (\<lambda> F. map (\<lambda> p. permute_family_l p F) perms) \<F>"                                              
  shows "mult_all_base_notFCs_covered_l_opt \<F>_perms F n m perms = 
         mult_all_base_notFCs_covered_l \<F> F n m perms"
using assms
by (auto simp add: list_ex_iff mult_all_base_notFCs_covered_l_def mult_all_base_notFCs_covered_l_opt_def mult_all_notFCs_covered_l_def mult_all_notFCs_covered_l_opt_def mult_notFCs_covered_l_def mult_notFCs_covered_l_opt_def FCs_covered_l_opt_def FCs_covered_l_def  FC_covered_l_opt_def FC_covered_l_def)

abbreviation enum_rec_notFCs_covered_l where
 "enum_rec_notFCs_covered_l \<F>_perms L n perms \<equiv> 
  enum_rec L [[]] (\<lambda> F L. mult_all_base_notFCs_covered_l_opt \<F>_perms F n (length L - 1) perms)"
  
lemma enum_rec_notFCs_covered_l_iso_representing_subset: 
  assumes "\<F>_perms = map (\<lambda> F. map (\<lambda> p. permute_family_l p F) (permute [0..<n])) \<F>" "[] \<notin> set \<F>" 
  "dmf \<F> n" "sdff \<F>" "length L - 1 \<le> n"
  shows "iso_representing_subset (fs_to_set_l (enum_rec_notFCs_covered_l \<F>_perms L n (permute [0..<n]))) (L_part_notFCs_covered (fs_to_set_l \<F>) n L)"
using assms
proof-
  have "\<forall>Fc\<in>set \<F>. \<not> FC_covered (f_to_set_l Fc) {}"
    using `[] \<notin> set \<F>`
    unfolding FC_covered_def
    by (auto  simp add: closure_def)
  thus ?thesis
    using `sdff \<F>`
    by (subst mult_all_base_notFCs_covered_opt[OF assms(1)])+
       (rule enum_rec_iso_representing_subset[where n="n" and perms="permute [0..<n]", OF notFCs_covered_l[of "permute [0..<n]", OF _ assms(3)] notFCs_covered inj_preserved_not_FCs_covered _ `length L - 1 \<le> n`], simp_all add: isPermutation_permute mult_all_base_notFCs_covered_l)
qed

end
