section{* Representing lists of natural numbers by natural numbers *}

theory ListNat
imports Main "More.MoreNat" "More.MoreBigOperators" "More.MoreList"
begin

text{* In this section, we define of representation of sets of natural
numbers by single natural numbers. The set $\{a_0, a_1, \ldots, a_n\}$
is represented by $2^{a_0} + 2^{a_1} + \ldots + 2^{a_n}$. *}

(* -------------------------------------------------------------------------- *)
subsection{* sumpows *}
(* -------------------------------------------------------------------------- *)

text{* If the set is stored in a distinct list, the function @{text
"sumpows2"} returns the natural number that represents it. *}

abbreviation sumpows2 where
  "sumpows2 l \<equiv> sum_list (map (op ^ (2::nat)) l) "

lemma sumpows2_mod:
  assumes "finite X"
  shows "(sum (op ^ 2) X) mod 2 \<noteq> (0::nat) \<longleftrightarrow> 0 \<in> X"
proof
  assume "0 \<in> X"
  hence "X = (X - {0}) \<union> {0}"
    by auto
  hence "sum (op ^ (2::nat)) X = sum (op ^ 2) (insert 0 (X - {0}))"
    by simp
  also have "... = sum (op ^ 2) (X - {0}) + 1"
    by (subst sum.insert, simp_all add: `finite X`)
  finally have "sum (op ^ (2::nat)) X = ..."
    .
  moreover
  have "sum (op ^ 2) (X - {0}) mod 2 = (0::nat)"
    by (subst sum_mod, auto simp add: `finite X` power_mod)
  ultimately
  show "sum (op ^ 2) X mod 2 \<noteq> (0::nat)"
    by auto
next
  assume "sum (op ^ 2) X mod 2 \<noteq> (0::nat)"
  show "0 \<in> X"
  proof (rule ccontr)
    assume "0 \<notin> X"
    have "sum (op ^ 2) X mod 2 = (0::nat)"
    proof (subst sum_mod, auto simp add: `finite X`)
      fix x
      assume "x \<in> X"
      with `0 \<notin> X` have "x \<noteq> 0"
        by simp (rule ccontr, simp)
      thus "2 ^ x mod 2 = (0::nat)"
        using power_mod
        by simp
    qed
    thus False
      using `sum (op ^ 2) X mod 2 \<noteq> (0::nat)`
      by simp
  qed
qed

lemma unique_sumpows2:
  fixes n::nat
  shows "\<exists>!X. finite X \<and> sum (op ^ 2) X = n"
proof (induct n rule: nat_less_induct)
  fix n::nat
  assume hyp: "\<forall>m<n. \<exists>!X. finite X \<and> sum (op ^ 2) X = m"
  show "\<exists>!X. finite X \<and> sum (op ^ 2) X = n"
  proof (cases "n = 0")
    case True
    show ?thesis
    proof
      show "finite {} \<and> sum (op ^ 2) {} = n"
        using `n = 0`
        by simp
    next
      fix X
      assume "finite X \<and> sum (op ^ 2) X = n"
      hence "finite X" "sum (op ^ 2) X = (0::nat)"
        using `n = 0`
        by simp_all
      hence "\<forall> a \<in> X. 2 ^ a = (0::nat)"
        apply (subst sum_eq_0_iff[THEN sym])
        by simp
      thus "X = {}"
        by auto
    qed
  next
    case False
    hence "n div 2 < n"
      by auto
    show ?thesis
    proof-
      obtain X' where "finite X'" "sum (op ^ 2)  X' = n div 2" 
        "\<forall> X''. finite X'' \<and> sum (op ^ 2) X'' = n div 2 \<longrightarrow> X'' = X'"
        using hyp `n div 2 < n`
        apply (erule_tac x="n div 2" in allE)
        by auto
      show ?thesis
      proof (cases "n mod 2 = 0")
        case True
        let ?X' = "(op + 1) ` X'"
        show ?thesis
        proof (rule, rule conjI)
          show "finite ?X'"
            using `finite X'`
            by simp
        next
          show "sum (op ^ 2) ?X' = n"
          proof (subst sum.reindex, simp_all)
            show "sum (\<lambda> x. 2 * 2 ^ x) X' = n"
              using `sum (op ^ 2)  X' = n div 2`
              apply (subst sum_distrib_left[THEN sym])
              using `n mod 2 = 0`
              by auto
          qed
        next
          fix X
          assume "finite X \<and> sum (op ^ 2) X = n"
          hence "finite X" "sum (op ^ 2) X = n"
            by simp_all
          hence "0 \<notin> X"
            using sumpows2_mod[of X] `n mod 2 = 0`
            by simp
          
          let ?X = "(\<lambda> x. x - 1) ` X"
          have "?X = X'"
          proof (rule `\<forall> X''. finite X'' \<and> sum (op ^ 2) X'' = n div 2 \<longrightarrow> X'' = X'`[rule_format], rule conjI)
            show "finite ?X"
              using `finite X`
              by simp
          next
            show "sum (op ^ 2) ?X = n div 2"
            proof (subst sum.reindex, simp_all)
              show "inj_on (\<lambda>x. x - Suc 0) X"
                unfolding inj_on_def
              proof (safe)
                fix x y
                assume "x \<in> X" "y \<in> X"
                hence "x \<noteq> 0" "y \<noteq> 0" using `0 \<notin> X`
                  by - (rule ccontr, auto)+
                assume "x - Suc 0 = y - Suc 0"
                thus "x = y"
                  using `x \<noteq> 0` `y \<noteq> 0`
                  by auto
              qed
            next
              have "(2::nat) * sum (\<lambda> x. 2 ^ (x - Suc 0)) X = sum (op ^ 2) X"
              proof (subst sum_distrib_left, rule sum.cong, simp_all)
                fix x::nat
                assume "x \<in> X"
                have "x \<noteq> 0"
                  apply (rule ccontr)
                  using `0 \<notin> X` `x \<in> X`
                  by auto
                thus "(2::nat) * 2 ^ (x - Suc 0) = 2 ^ x"
                  by (simp add: power_eq_if)
              qed
              thus "sum (\<lambda> x. 2 ^ (x - Suc 0)) X = n div 2"
                using `sum (op ^ 2) X = n`
                using `n mod 2 = 0`
                by auto
            qed
          qed

          show "X = op + 1 ` X'"
          proof (safe)
            fix x
            assume "x \<in> X" 
            hence "x \<noteq> 0" "x - 1 \<in> X'"
              using `0 \<notin> X` `image (\<lambda>x. x - 1) X = X'`
              by auto (rule ccontr, simp)
            thus "x \<in> op + 1 ` X'"
              by (rule_tac x="x - 1" in rev_image_eqI) auto
          next
            fix x'::nat
            assume "x' \<in> X'"
            then obtain x where "x \<in> X" "x' = x - 1" "x \<noteq> 0"
              using `image (\<lambda>x. x - 1) X = X'` `0 \<notin> X`
              by auto
            thus "1 + x' \<in> X"
              by simp
          qed
        qed
      next
        case False
        let ?X' = "(op + 1) ` X' \<union> {0}"
        show ?thesis
        proof (rule, rule conjI)
          show "finite ?X'"
            using `finite X'`
            by simp
        next
          show "sum (op ^ 2) ?X' = n"
          proof (simp, subst sum.insert)
            show "finite (op + (Suc 0) ` X')"
              using `finite X'`
              by simp
          next
            show "0 \<notin> op + (Suc 0) ` X'"
              by auto
          next
            show "2 ^ 0 + sum (op ^ 2) (op + (Suc 0) ` X') = n"
            proof-
              have "sum (op ^ 2) (op + (Suc 0) ` X') = n - 1"
              proof (subst sum.reindex, simp_all)
                show "(\<Sum>x\<in>X'. 2 * 2 ^ x) = n - Suc 0"
                  apply (subst sum_distrib_left[THEN sym])
                  using `sum (op ^ 2) X' = n div 2` `n mod 2 \<noteq> 0`
                  using div_mult_mod_eq[of n 2]
                  by auto
              qed
              thus ?thesis
                using `n \<noteq> 0`
                by simp
            qed
          qed
        next
          fix X
          assume "finite X \<and> sum (op ^ 2) X = n"
          hence "finite X" "sum (op ^ 2) X = n"
            by simp_all
          hence "0 \<in> X"
            using sumpows2_mod[of X] `n mod 2 \<noteq> 0`
            by simp
          
          let ?X = "(\<lambda> x. x - 1) ` (X - {0})"
          have "?X = X'"
          proof (rule `\<forall> X''. finite X'' \<and> sum (op ^ 2) X'' = n div 2 \<longrightarrow> X'' = X'`[rule_format], rule conjI)
            show "finite ?X"
              using `finite X`
              by simp
          next
            show "sum (op ^ 2) ?X = n div 2"
            proof (subst sum.reindex, simp_all)
              show "inj_on (\<lambda>x. x - Suc 0) (X - {0})"
                unfolding inj_on_def
                by auto
            next
              have "(2::nat) * sum (\<lambda> x. 2 ^ (x - Suc 0)) (X - {0}) = sum (op ^ 2) (X - {0})"
              proof (subst sum_distrib_left, rule sum.cong, simp_all)
                fix x::nat
                assume "x \<in> X \<and> 0 < x"
                thus "(2::nat) * 2 ^ (x - Suc 0) = 2 ^ x"
                  by (simp add: power_eq_if)
              qed
              moreover
              have "sum (op ^ 2) (X - {0}) = sum (op ^ 2) X - (1::nat)"
                apply (subst sum_diff1_nat)
                using `0 \<in> X`
                by simp
              ultimately
              show "sum (\<lambda> x. 2 ^ (x - Suc 0)) (X - {0}) = n div 2"
                using `sum (op ^ 2) X = n`
                using `n mod 2 \<noteq> 0`
                by auto
            qed
          qed

          show "X = ?X'"
          proof (safe)
            fix x
            assume "x \<in> X" "x \<notin> op + 1 ` X'"
            show "x = 0"
            proof (rule ccontr)
              assume "x \<noteq> 0"
              hence "x - 1 \<in> X'"
                using `x \<in> X` `?X = X'`
                by auto
              hence "x \<in> op + 1 ` X'"
                using `x \<noteq> 0`
                by (rule_tac x="x - 1" in rev_image_eqI) auto
              thus False
                using `x \<notin> image (op + 1) X'`
                by simp
            qed
          next
            fix x'::nat
            assume "x' \<in> X'"
            then obtain x where "x \<in> X" "x' = x - 1" "x \<noteq> 0"
              using `?X = X'` `0 \<in> X`
              by auto
            thus "1 + x' \<in> X"
              by simp
          next
            show "0 \<in> X"
              using `0 \<in> X`
              by simp
          qed
        qed
      qed
    qed
  qed
qed

lemma sumpows2_inj:
assumes "sorted l" and "distinct l" and "sorted l'" and "distinct l'"
  "sumpows2 l = sumpows2 l'"
shows "l = l'"
proof-
  have "sumpows2 l = Sum ((op ^ (2::nat)) ` set l)"
    apply (subst distinct_sum_list_conv_Sum)
    using `distinct l`
    by (auto simp add: distinct_map inj_on_def)
  moreover
  have "sumpows2 l' = Sum ((op ^ (2::nat)) ` set l')"
    apply (subst distinct_sum_list_conv_Sum)
    using `distinct l'`
    by (auto simp add: distinct_map inj_on_def)
  ultimately
  have "\<Sum>(op ^ (2::nat) ` set l) = \<Sum>(op ^ (2::nat) ` set l')"
    using `sumpows2 l = sumpows2 l'`
    by simp
  hence "sum (op ^ (2::nat)) (set l) = sum (op ^ 2) (set l')"
    by (subst (asm) sum.reindex, simp_all add: inj_on_def)+
  hence "set l = set l'"
    using unique_sumpows2[of "sum (op ^ (2::nat)) (set l)"]
    by auto
  thus ?thesis
    using `distinct l` `sorted l` `distinct l'` `sorted l'`
    using sorted_distinct_set_unique
    by auto
qed

lemma sumpows2_shift:
  shows "2 * sumpows2 l = sumpows2 (map (op + 1) l)"
by (induct l) auto

(* -------------------------------------------------------------------------- *)
subsection{* nat2list *}
(* -------------------------------------------------------------------------- *)

text{* The function @{text "nat2list"} deconstructs the natural number
back to the set it represents (for executability, given by a sorted,
distinct list). *}

fun nat2list_aux :: "nat \<Rightarrow> nat \<Rightarrow> nat list" where
"nat2list_aux n k = 
    (if n = 0 then 
         [] 
     else if n mod 2 = 0 then 
         nat2list_aux (n div 2) (k + 1)
     else 
         k # nat2list_aux (n div 2) (k + 1))"

definition nat2list where
  "nat2list n \<equiv> nat2list_aux n 0"

lemma sumpows2_nat2list_aux:
  "sumpows2 (nat2list_aux n k) = n * 2^k"
proof (induct n k rule: nat2list_aux.induct)
  case (1 n k)
  show ?case
  proof (cases "n = 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "n mod 2 = 0")
      case True
      thus ?thesis
        using `n \<noteq> 0`
        using nat2list_aux.simps[of n k]
        using 1(1)
        by (auto simp del: nat2list_aux.simps)
    next
      case False
      thus ?thesis
        using `n mod 2 \<noteq> 0``n \<noteq> 0`
        using mult_eq_if[of n "2 ^ k"]
        using mod_mult_div_eq[of n 2, THEN sym]
        using nat2list_aux.simps[of n k]
        using 1(2)
        by (auto simp del: nat2list_aux.simps)
    qed
  qed
qed

lemma sumpows2_nat2list:
  "sumpows2 (nat2list n) = n"
unfolding nat2list_def
using sumpows2_nat2list_aux[of n 0]
by auto

lemma nat2list_aux_empty:
  "(nat2list_aux x k = []) = (x = 0)"
by (induct x k rule: nat2list_aux.induct) auto

lemma nat2list_aux_shift:
  "nat2list_aux n (k + 1) = map (op + 1) (nat2list_aux n k)"
by (induct n k rule: nat2list_aux.induct) auto

lemma sorted_distinct_nat2list_aux:
 "sorted (nat2list_aux n k) \<and>
  distinct (nat2list_aux n k) \<and>
  (\<forall> a \<in> List.set (nat2list_aux n k). a \<ge> k)"
proof (induct rule: nat2list_aux.induct)
  case (1 n k)
  show ?case
  proof (cases "n = 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "n mod 2 = 0")
      case True
      thus ?thesis
        using `n \<noteq> 0`
        using nat2list_aux.simps[of n k]
        using 1(1)
        by (auto simp del: nat2list_aux.simps)
    next
      case False
      thus ?thesis
        using `n \<noteq> 0`
        using nat2list_aux.simps[of n k]
        using 1(2)
        by (auto simp del: nat2list_aux.simps intro!: sorted.Cons)
    qed
  qed
qed

lemma 
  sorted_nat2list: "sorted (nat2list n)" and 
  distinct_nat2list: "distinct (nat2list n)"
using sorted_distinct_nat2list_aux[of n 0]
unfolding nat2list_def
by auto

lemma sumpows2_nat2list_unique:
  assumes "sumpows2 l = n" and "sorted l" and "distinct l"
  shows "l = nat2list n"
using assms
using sumpows2_nat2list[of n]
using sumpows2_inj[of "nat2list n" l]
using sorted_nat2list distinct_nat2list
by simp

lemma inj_nat2list_aux':
  assumes "nat2list_aux x k = nat2list_aux y k"
  shows "x = y"
using assms
proof (induct x k arbitrary: y rule: nat2list_aux.induct)
  case (1 x k)
  show ?case
  proof (cases "x = 0")
    case True
    thus ?thesis
      using 1(3)
      using nat2list_aux_empty[of y k]
      by simp
  next
    case False
    show ?thesis
    proof (cases "x mod 2 = 0")
      case True
      hence "nat2list_aux (x div 2) (Suc k) = nat2list_aux y k"
        using `x \<noteq> 0` 1(3)
        using nat2list_aux.simps[of x k]
        by simp
      show ?thesis
      proof (cases "y = 0")
        case True
        hence "nat2list_aux (x div 2) (Suc k) = []"
          using `nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
          using nat2list_aux.simps[of y k]
          by (simp del: nat2list_aux.simps)
        hence "x div 2 = 0"
          using nat2list_aux_empty[of "x div 2" "Suc k"]
          by simp
        thus ?thesis
          using `x mod 2 = 0`
          using `y = 0`
          by auto
      next
        case False
        show ?thesis
        proof (cases "y mod 2 = 0")
          case True
          hence "nat2list_aux (x div 2) (Suc k) = nat2list_aux (y div 2) (Suc k)"
            using `y \<noteq> 0`
            using `nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
            using nat2list_aux.simps[of y k]
            by (simp del: nat2list_aux.simps)
          hence "x div 2 = y div 2"
            using `x \<noteq> 0` `x mod 2 = 0` 1(1)[of "y div 2"]
            by simp
          thus ?thesis
            using `x mod 2 = 0` `y mod 2 = 0`
            by auto
        next
          case False
          hence "nat2list_aux (x div 2) (Suc k) = k # nat2list_aux (y div 2) (Suc k)"
            using `y \<noteq> 0`
            using `nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
            using nat2list_aux.simps[of y k]
            by (simp del: nat2list_aux.simps)
          thus ?thesis
            using sorted_distinct_nat2list_aux[of "x div 2" "Suc k"]
            by auto
        qed
      qed
    next
      case False
      hence "k # nat2list_aux (x div 2) (Suc k) = nat2list_aux y k"
        using `x \<noteq> 0` 1(3)
        using nat2list_aux.simps[of x k]
        by simp
      show ?thesis
      proof (cases "y = 0")
        case True
        thus ?thesis
          using `k # nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
          by simp
      next
        case False
        show ?thesis
        proof (cases "y mod 2 = 0")
          case True
          hence "k # nat2list_aux (x div 2) (Suc k) = nat2list_aux (y div 2) (Suc k)"
            using `y \<noteq> 0`
            using `k # nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
            using nat2list_aux.simps[of y k]
            by (simp del: nat2list_aux.simps)
          have "k \<in> set (nat2list_aux (y div 2) (Suc k))"
            using `k # nat2list_aux (x div 2) (Suc k) = nat2list_aux (y div 2) (Suc k)`[THEN sym]
            by simp
          thus ?thesis
            using sorted_distinct_nat2list_aux[of "y div 2" "Suc k"]
            by auto
        next
          case False
          hence "nat2list_aux (x div 2) (Suc k) = nat2list_aux (y div 2) (Suc k)"
            using `y \<noteq> 0`
            using `k # nat2list_aux (x div 2) (Suc k) = nat2list_aux y k`
            using nat2list_aux.simps[of y k]
            by (simp del: nat2list_aux.simps)
          hence "x div 2 = y div 2"
            using 1(2)[of "y div 2"] `x \<noteq> 0` `x mod 2 \<noteq> 0`
            by simp
          thus ?thesis
            using `x mod 2 \<noteq> 0` `y mod 2 \<noteq> 0`
            using mod_mult_div_eq[of x 2, THEN sym]
            using mod_mult_div_eq[of y 2, THEN sym]
            by simp
        qed
      qed
    qed
  qed
qed

lemma inj_nat2list:
  "inj nat2list"
unfolding inj_on_def
proof (auto)
  fix x y
  assume "nat2list x = nat2list y"
  thus "x = y"
    unfolding nat2list_def
    using inj_nat2list_aux'[of x 0 y]
    by simp
qed

lemma nat2list_even:
  "nat2list (2*n) = map (op +1) (nat2list n)"
using sumpows2_nat2list_unique[of "map (op + 1) (nat2list n)" "2*n"]
using sumpows2_nat2list[of "n"]
using sumpows2_shift[of "nat2list n"]
by (auto simp add: sorted_nat2list sorted_map distinct_nat2list distinct_map inj_on_def)

lemma nat2list_odd:
  "nat2list (2*n + 1) = 0 # map (op +1) (nat2list n)"
proof-
  have "Suc (2 * n) div 2 = n"
    by auto
  thus ?thesis
    unfolding nat2list_def
    using nat2list_aux_shift
    by auto
qed

(* -------------------------------------------------------------------------- *)
subsection{* list2nat *}
(* -------------------------------------------------------------------------- *)

text{* Although the function @{text "sumpows2"} converts a set (given
by a distinct list) to its representing natural number, we define the
function @{text "list2nat"} that does the same, but is somewhat more
efficient. *}

fun list2nat_aux_measure where
"list2nat_aux_measure (l, i, s, r) =
    (case l of 
         [] \<Rightarrow> 0
       | (h # t) \<Rightarrow> if i > h then 0 else Max (set l) - i + 1)"

function list2nat_aux :: "nat list \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat" where
  "list2nat_aux [] i s r = r"
| "list2nat_aux (h # t) i s r = 
        (if i = h then 
            list2nat_aux t (i+1) (2*s) (s + r) 
         else if i < h then
            list2nat_aux (h # t) (i+1) (2*s) r
         else r)"
by pat_completeness auto
termination
proof (relation "measure list2nat_aux_measure")
  show "wf (measure list2nat_aux_measure)"
    by simp
next
  fix h i s r :: nat and t
  assume "i = h"
  have "list2nat_aux_measure (t, i + 1, 2 * s, s + r) < 
        list2nat_aux_measure (h # t, i, s, r)"
  proof (cases t)
    case Nil
    thus ?thesis
      using `i = h`
      by simp
  next
    case (Cons h' t')
    thus ?thesis
      using `i = h`
      using Max_insert[of "set t'" h']
      by (cases "t' \<noteq> []") auto
  qed
  thus "((t, i + 1, 2 * s, s + r), (h # t, i, s, r)) \<in> measure list2nat_aux_measure"
    by simp
next
  fix h i s r::nat and t
  assume "i \<noteq> h" "i < h"
  thus "((h # t, i + 1, 2 * s, r), (h # t, i, s, r)) \<in> measure list2nat_aux_measure"
    using Max_insert[of "set t" h]
    by (cases "t = []") auto
qed

definition list2nat where
 "list2nat l = list2nat_aux l 0 1 0"

lemma list2nat_aux_sumpows2:
  assumes "s = 2 ^ i" and "sorted l" and "distinct l" and 
          "l \<noteq> [] \<longrightarrow> i \<le> hd l"
  shows "list2nat_aux l i s r = r + sumpows2 l"
using assms
proof (induct l i s r rule: list2nat_aux.induct)
  case (1 i s r)
  thus ?case
    by simp
next
  case (2 h t i s r)
  show ?case
  proof (cases "h = i")
    case True
    have "t \<noteq> [] \<longrightarrow> i + 1 \<le> hd t"
      using 2(4) 2(5) 2(6)
      by (cases t) auto
    thus ?thesis
      using `h = i`
      using 2(1) 2(2) 2(3) 2(4) 2(5)
      by (simp add: sorted_Cons)
  next
    case False
    show ?thesis
    proof (cases "i < h")
      case True
      thus ?thesis
        using 2(2) 2(3) 2(4) 2(5) `h \<noteq> i`
        by (simp add: sorted_Cons)
    next
      case False
      thus ?thesis
        using `h \<noteq> i` 2(6)
        by simp
    qed
  qed
qed

lemma list2nat_sumpows2:
  assumes "sorted l" and "distinct l"
  shows "list2nat l = sumpows2 l"
unfolding list2nat_def
using assms
using list2nat_aux_sumpows2[of 1 0 l 0]
by simp

lemma nat2list_list2nat:
  assumes "distinct l" and "sorted l"
  shows "nat2list (list2nat l) = l"
using assms
using list2nat_sumpows2[of l]
using sumpows2_nat2list_unique[of l "list2nat l"]
by simp

lemma inj_list2nat:
  assumes "sorted l1" and "distinct l1" and "sorted l2" and "distinct l2"
  assumes "list2nat l1 = list2nat l2"
  shows "l1 = l2"
proof-
  have "sumpows2 l1 = sumpows2 l2"
    using assms
    by (auto simp add: list2nat_sumpows2[THEN sym])
  thus ?thesis
    using assms
    by (simp add: sumpows2_inj)
qed

end
