section{* Auxiliary lemmas about sum of set operator *}

theory MoreBigOperators
imports Main Rat
begin

lemma sum_mono_single_lt:
  assumes "finite K" and
          "\<And>i. i\<in>K \<Longrightarrow> f (i::'a) \<le> ((g i)::rat)" and
          "a \<in> K" and "f a < g a"
  shows "(\<Sum>x\<in>K. f x) < (\<Sum>x\<in>K. g x)"
proof-
  have "(\<Sum>x\<in>K. f x) = (\<Sum>x\<in>(K - {a}). f x) + f a"
    using `a \<in> K` `finite K`
    by (auto simp add: sum_diff1_ring)
  also have "... \<le> (\<Sum>x\<in>(K - {a}). g x) + f a"
    using assms(2)
    by (simp, rule sum_mono, simp)
  also have "... < (\<Sum>x\<in>(K - {a}). g x) + g a"
    using `a \<in> K` `f a < g a`
    by simp
  finally show ?thesis
    using assms
    by (auto simp add: sum_diff1_ring)
qed

lemma sum_mono_single_lt_nat:
  assumes "finite K" and
          "\<And>i. i\<in>K \<Longrightarrow> f (i::'a) \<le> ((g i)::nat)" and
          "a \<in> K" and "f a < g a"
  shows "(\<Sum>x\<in>K. f x) < (\<Sum>x\<in>K. g x)"
proof-
  have "(\<Sum>x\<in>K. f x) = (\<Sum>x\<in>(K - {a}). f x) + f a"
    using `a \<in> K` `finite K`
    by (auto simp add: sum.remove)
  also have "... \<le> (\<Sum>x\<in>(K - {a}). g x) + f a"
    using assms(2)
    by (simp, rule sum_mono, simp)
  also have "... < (\<Sum>x\<in>(K - {a}). g x) + g a"
    using `a \<in> K` `f a < g a`
    by simp
  finally show ?thesis
    using assms
    by (auto simp add: sum.remove)
qed

lemma sum_mod:
  assumes "finite X" and "\<forall> x \<in> X. f x mod k = 0"
  shows "(\<Sum>x\<in>X. f x) mod k = (0::nat)"
using assms
by (induct rule: finite_induct) auto

end
