theory MoreBinomial
imports Binomial
begin
lemma choose_mono_Suc:
  shows "Suc n choose k \<ge> n choose k"
  using binomial_Suc_Suc[of n "k-1"]
  by (cases "k=0") auto

lemma choose_mono:
  assumes "m \<ge> n"
  shows "m choose k \<ge> n choose k"
using assms
proof (induct "m-n" arbitrary: m n) 
  case 0
  thus ?case
    by auto
next
  case (Suc r)
  show ?case
    using Suc(1)[of m "Suc n"] Suc(2) Suc(3)
    using choose_mono_Suc[of n k]
    by force
qed

lemma n_subsets_ub:
  assumes "\<Union>F \<subseteq> {0..<n}" 
  shows "card {A \<in> F. card A = k} \<le> n choose k"
proof-
  have "{A \<in> F. card A = k} \<subseteq> {B. B \<subseteq> \<Union>F \<and> card B = k}"
    by auto
  hence "card {A \<in> F. card A = k} \<le> card {B. B \<subseteq> \<Union>F \<and> card B = k}"
    using card_mono[of "{B. B \<subseteq> \<Union>F \<and> card B = k}" "{A \<in> F. card A = k}"] assms
    by (auto simp add: finite_subset)
  moreover 
  have "card (\<Union>F) choose k \<le> n choose k"
    using assms choose_mono card_mono[of "{0..<n}" "\<Union> F"]
    by simp
  ultimately
  show ?thesis
    using assms
    using n_subsets[of "\<Union> F" k]
    by (auto simp add: finite_subset)
qed

end
