section{* Auxiliary lemmas about mappings *}

theory MoreMap
imports "HOL-Library.Mapping"
begin

definition tabulate  :: "('a \<times> 'b) list \<Rightarrow> ('a, 'b) mapping" where
  "tabulate l = foldl (\<lambda> m a. Mapping.update (fst a) (snd a) m) Mapping.empty l"

lemma tabulate_map_of:
  "distinct (map fst l) \<Longrightarrow> tabulate l = Mapping.Mapping (map_of l)"
unfolding tabulate_def
apply (induct l rule: rev_induct)
apply (auto simp add: Mapping.empty_def Mapping.update_def)
by (metis dom_map_of_conv_image_fst empty_map_add lookup.abs_eq lookup.rep_eq map_add_upd_left)

find_theorems Mapping.lookup Mapping.tabulate

(* Missing from Mapping.thy in Isabelle2013 *)
lemma lookup_tabulate [simp]:
  "Mapping.lookup (Mapping.tabulate ks f) = (Some o f) |` set ks"
  by (induct ks) (auto simp add: Mapping.tabulate.abs_eq Mapping.lookup.abs_eq restrict_map_def fun_eq_iff)

end
