section{* Auxiliary lemmas about (finite) sets *}

theory MoreSet
imports Main MoreList
begin

lemma finiteUn_iff: 
  shows "finite (\<Union> F) \<longleftrightarrow> finite F \<and> (\<forall> S \<in> F. finite S)"
proof (auto dest: finite_UnionD)
  fix S
  assume "finite (\<Union> F)" "S \<in> F"
  hence "S \<subseteq> \<Union> F"
    by auto
  thus "finite S"
    using `finite (\<Union> F)`
    by (auto simp add: finite_subset)
qed

lemma card_1_iff_singleton: 
  shows "card A = 1 \<longleftrightarrow> (\<exists> a. A = {a})"
proof
  assume "card A = 1"
  hence "A \<noteq> {}"
    by auto
  then obtain a where "a \<in> A"
    by auto
  hence "A = {a}"
    using card_Diff_singleton[of A a] `card A = 1`
    using card_0_eq[of "A - {a}"]
    by (auto simp add: card_ge_0_finite)
  thus "\<exists> a. A = {a}"
    by simp
qed auto

lemma card_2_iff_dubleton: 
  shows "card A = 2 \<longleftrightarrow> (\<exists> a b. A = {a, b} \<and> a \<noteq> b)"
proof
  assume "card A = 2"
  hence "A \<noteq> {}"
    by auto
  then obtain a where "a \<in> A"
    by auto
  hence "card (A - {a}) = 1"
    using `card A = 2`
    using card_Diff_singleton[of A a]
    by (auto simp add: card_ge_0_finite)
  then obtain b where "A - {a} = {b}"
    using card_1_iff_singleton[of "A - {a}"]
    by auto
  hence "a \<noteq> b"
    by auto
  moreover
  hence "A = {a, b}"
    using `a \<in> A` `A - {a} = {b}`
    by auto
  ultimately
  show "(\<exists> a b. A = {a, b} \<and> a \<noteq> b)"
    by auto
qed auto

lemma subset_eq_card:
  assumes  "finite F" and "card F \<ge> n"
  shows "\<exists> F'. F' \<subseteq> F \<and> card F' = n"
using assms
proof (induct F rule: finite_induct)
  case empty
  thus ?case
    by simp
next
  case (insert a F)
  thus ?case
  proof (cases "n \<le> card F")
    case True
    thus ?thesis
      using insert(3)
      by auto
  next
    case False
    hence "n = card (insert a F)"
      using insert
      by auto
    thus ?thesis
      by auto
  qed
qed

lemma card_le:
  assumes "m \<le> n" "card A = n"
  shows "\<exists> B. B \<subseteq> A \<and> card B = m"
using card_eq_0_iff[of A]
using subset_eq_card[of A m]
using assms
by (cases "n = 0") auto
  
lemma card_Suc:
  assumes "card A = n + 1"
  shows "\<exists> A' a. A = A' \<union> {a} \<and> a \<notin> A' \<and> card A' = n"
using assms
by auto (metis card_eq_SucD)

lemma card_Suc':
  assumes "card A = k + 1" "a \<in> A"
  shows "card (A - {a}) = k"
using assms
using card.insert[of "A - {a}" "a"] card_eq_0_iff[of A]
by auto

lemma subset_card_eq:
  assumes "A \<subseteq> B" and "card A = card B" and "finite B"
  shows "A = B"
proof-
  obtain h where "bij_betw h B A"
    using finite_same_card_bij[of B A] assms
    by (auto simp add: finite_subset)
  thus ?thesis
    unfolding bij_betw_def
    using endo_inj_surj[of B h]
    using `A \<subseteq> B` `finite B`
    by auto
qed

lemma card_n_n_aux:
  assumes "A \<noteq> B" and "card A = card B" and "finite A" and "finite B"
  shows "card (A \<union> B) \<noteq> card A"
apply (rule ccontr)
using assms
using subset_card_eq[of A "A \<union> B"]
using subset_card_eq[of B A]
by auto

lemma card_n_n:
  assumes "card A = n" and "card B = n" and "n > 0" and "A \<noteq> B"
  shows "n < card (A \<union> B) \<and> card (A \<union> B) \<le> 2*n"
using assms
using card_mono[of A "A \<inter> B"]
using card_Un_Int[of A B]
using card_gt_0_iff[of A]  card_gt_0_iff[of B]
using card_n_n_aux[of A B]
by auto

text{* This should hold for every infinite type --- for our
applications, it suffices to consider only @{typ "nat"}. *}
lemma finite_disjoint_set:
  fixes X :: "nat set"
  assumes "finite X"
  shows "\<exists> Y. finite Y \<and> card Y = d \<and> X \<inter> Y = {}"
using assms
proof (induct d)
  case 0
  thus ?case
    by force
next
  case (Suc d)
  then obtain Y where "card Y = d" "X \<inter> Y = {}" "finite Y"
    by auto
  moreover
  obtain a where "a \<notin> X \<union> Y"
    using finite_nat_set_iff_bounded[of "X \<union> Y"]
    using `finite X` `finite Y`
    by auto
  ultimately
  show ?case
    by (rule_tac x="Y \<union> {a}" in exI) auto
qed

lemma map_fam_cong:
  assumes "\<forall> x \<in> (\<Union> F). g' x = g x"
  shows "op ` g ` F = op ` g' ` F"
using assms
by auto (metis (lifting) image_cong image_iff)+


(* -------------------------------------------------------------------------- *)

text{* Remove n-th element of an ordered set *}
definition set_drop_nth :: "nat \<Rightarrow> 'a::linorder set \<Rightarrow> 'a set" where
  "set_drop_nth n s = set (drop_nth n (sorted_list_of_set s))"

lemma set_drop_nth_subset: 
  assumes "finite X"
  shows "set_drop_nth s X \<subseteq> X"
unfolding set_drop_nth_def drop_nth_def
using assms
using sorted_list_of_set[of X]
by (auto dest: in_set_takeD in_set_dropD)

lemma card_set_drop_nth:
  assumes "i < card S" "finite S"
  shows "card (set_drop_nth i S) = card S - 1"
using assms
using distinct_card[of "drop_nth i (sorted_list_of_set S)"]
using distinct_card[of "sorted_list_of_set S"]
using distinct_drop_nth[of "sorted_list_of_set S" i]
using sorted_list_of_set[of S] length_drop_nth[of i "sorted_list_of_set S"]
unfolding set_drop_nth_def
by auto

lemma set_drop_nth_drops:
  assumes "i < card S" "finite S"
  shows "\<exists> x \<in> S. x \<notin> set_drop_nth i S"
using assms
unfolding set_drop_nth_def
using sorted_list_of_set[of S] length_sorted_list_of_set[of S] `finite S`
using set_drop_nth_distinct[of i "sorted_list_of_set S"]
using in_set_conv_nth[of "sorted_list_of_set S ! i" "sorted_list_of_set S"]
by (rule_tac x="sorted_list_of_set S ! i" in bexI, simp_all) force

lemma set_drop_nth_inj:
  assumes "finite A" "i < card A" "j < card A" "set_drop_nth i A = set_drop_nth j A"
  shows "i = j"
  using assms
  unfolding set_drop_nth_def
  using set_drop_nth_distinct[of _ "sorted_list_of_set A"]
  using distinct_sorted_list_of_set[of A]
  using nth_eq_iff_index_eq[of "sorted_list_of_set A"]
  using length_sorted_list_of_set[of A]
  by (metis insertE insert_Diff nth_mem set_drop_nth_def set_drop_nth_drops sorted_list_of_set)

end
