subsection{* Non-isomorphic families of sets *}

theory NonIsomorphicFamilies
imports Main 
  IsomorphicFamilies
  FamilyImpl 
begin

text{* In this section we define a combinatorial algorithm
(implemented by a function @{text "non_isomorphic_families"}) that
computes non isomorphic families of sets. Two uniform families (over
the same domain) are called isomorphic if one can be obtained from the
other by permuting elements of the domain. This function is used to
remove symmetric cases in verification of FC families. *}


locale Mapping = 
  fixes to_fun :: "'m \<Rightarrow> ('a \<Rightarrow> 'a)"

locale SetPermutations = SetImpl to_set inv + Mapping to_fun for
  inv :: "'s::linorder \<Rightarrow> bool" and to_set :: "'s::linorder \<Rightarrow> 'a set" and to_fun :: "'m \<Rightarrow> ('a \<Rightarrow> 'a)" +
  fixes permute_set :: "'m \<Rightarrow> 's \<Rightarrow> 's"
  assumes permute_set_set: "to_set (permute_set p s) = (to_fun p) ` (to_set s)"
  assumes permute_set_inv: "\<lbrakk>inj_on (to_fun p) (to_set s); inv s\<rbrakk> \<Longrightarrow> inv (permute_set p s)"
begin

definition permute_family :: "'m \<Rightarrow> 's list \<Rightarrow> 's list" where
  "permute_family p F = map (permute_set p) F"

lemma permute_family_set:
  shows "f_to_set (permute_family p F) = op ` (to_fun p) ` f_to_set F"
unfolding permute_family_def
using permute_set_set
by force

lemma permute_family_inj_embed:
  assumes "inj_on (to_fun p) (\<Union>f_to_set F)"
  shows "inj_embed (f_to_set F) (f_to_set (permute_family p F))"
using assms permute_family_set
unfolding inj_embed_def
by (rule_tac x="to_fun p" in exI) auto

function non_isomorphic_families_aux where
 "non_isomorphic_families_aux perms fams res =
  (case fams of 
    [] \<Rightarrow> res
  | h # t \<Rightarrow> 
    let hp = remdups (h # map (\<lambda> p. permute_family p h) perms) in
    non_isomorphic_families_aux perms (filter (\<lambda> l. sort l \<notin> set (map sort hp)) fams) (h # res))"
by pat_completeness auto
termination
by (relation "measure (\<lambda> (p, f, r). length f)") auto
declare non_isomorphic_families_aux.simps [simp del]

definition non_isomorphic_families where
  [simp]: "non_isomorphic_families perms fams = non_isomorphic_families_aux perms fams []"

lemma non_isomorphic_families_aux_res_mono: 
  shows "set res \<subseteq> set (non_isomorphic_families_aux perms fams res)"
proof (induct perms fams res rule: non_isomorphic_families_aux.induct)
  case (1 perms fams res)
  show ?case
  proof (cases fams)
    case Nil
    thus ?thesis
      by (simp add: non_isomorphic_families_aux.simps)
  next
    case (Cons a fams')
    thus ?thesis
      using non_isomorphic_families_aux.simps[of perms fams res]
      using 1[of a fams' "remdups (a # FamilyImpl.map (\<lambda>p. permute_family p a) perms)"]
      by (auto simp add: Let_def)
  qed
qed

lemma non_isomorphic_families_aux_subset:
  assumes "F \<supseteq> set res" "F \<supseteq> set fams"
  shows "F \<supseteq> set (non_isomorphic_families_aux perms fams res)"
using assms
proof (induct perms fams res rule: non_isomorphic_families_aux.induct)
  case (1 perms fams res)
  show ?case
  proof (cases fams)
    case Nil
    thus ?thesis
      using 1(2)
      by (simp add: non_isomorphic_families_aux.simps)
  next
    case (Cons a fams')
    let ?hp = "remdups (a # FamilyImpl.map (\<lambda>p. permute_family p a) perms)"
    have "set (let hp = ?hp
             in non_isomorphic_families_aux perms [l\<leftarrow>fams . sort l \<notin> set (map sort hp)]
                 (a # res)) \<subseteq> F"
      unfolding Let_def
      apply (rule 1(1)[of a fams'])
      using 1(2) 1(3) Cons
      by auto
    thus ?thesis
      apply (subst non_isomorphic_families_aux.simps[of perms fams res])
      using Cons
      by simp
  qed
qed

lemma non_isomorphic_families_subset:
  shows "set (non_isomorphic_families perms F) \<subseteq> set F"
unfolding non_isomorphic_families_def
by (simp add: non_isomorphic_families_aux_subset)

lemma non_isomorphic_families_aux:
  assumes "\<forall> p \<in> set perms. \<forall> F \<in> set fams. inj_on (to_fun p) (\<Union> f_to_set F)"
  shows "\<forall> F \<in> set fams. \<exists> F' \<in> set (non_isomorphic_families_aux perms fams res). inj_embed (f_to_set F) (f_to_set F')"
using assms
proof (induct perms fams res rule: non_isomorphic_families_aux.induct)
  case (1 perms fams res)
  show ?case
  proof (cases "fams")
    case Nil
    thus ?thesis
      by simp
  next
    case (Cons F fams')

    let ?nefams = "non_isomorphic_families_aux perms fams res"
    let ?hp = "remdups (F # (map (\<lambda> p. permute_family p F) perms))"
    let ?filt = "filter (\<lambda> l. sort l \<notin> set (map sort ?hp)) fams"
    let ?nef = "non_isomorphic_families_aux perms ?filt (F # res)"

    have "?nefams = ?nef"
      using Cons
      using non_isomorphic_families_aux.simps[of perms fams res]
      by simp

    show ?thesis
    proof (rule ballI)
      fix Fa
      assume "Fa \<in> set fams"
      show "\<exists>a\<in>set ?nefams. inj_embed (f_to_set Fa) (f_to_set a)"
      proof (cases "sort Fa = sort F")
        case True
        show ?thesis
        proof (rule_tac x=F in bexI)
          show "F \<in> set (non_isomorphic_families_aux perms fams res)"
            using `?nefams = ?nef`
            using non_isomorphic_families_aux_res_mono[of "F # res" perms ?filt]
            by auto
        next
          show "inj_embed (f_to_set Fa) (f_to_set F)"
            using `sort Fa = sort F`
            by (metis f_to_set_def image_set inj_embed_refl set_sort)
        qed
      next
        case False
        hence "Fa \<in> set fams'"
          using Cons `Fa \<in> set fams`
          by auto
        show ?thesis
        proof (cases "sort Fa \<in> set (map sort ?hp)")
          case False
          thus ?thesis
            using Cons `Fa \<in> set fams'`
            using 1(1)[of F fams' ?hp] 1(2)
            using `?nefams = ?nef`
            by auto
        next
          case True
          then obtain p where "p \<in> set (perms)" "sort Fa = sort (permute_family p F)" "inj_on (to_fun p) (\<Union>f_to_set F)"
            using `sort Fa \<noteq> sort F` 1(2) Cons
            by (auto split: if_split_asm)
          hence "inj_embed (f_to_set F) (f_to_set Fa)"
            using permute_family_inj_embed[of p F]
            by (metis f_to_set_def image_set set_sort)
          moreover
          have "F \<in> set ?nefams"
            using `?nefams = ?nef`
            using non_isomorphic_families_aux_res_mono[of "F # res" perms ?filt]
            by simp
          ultimately
          show ?thesis
            using inj_embed_sym[of "f_to_set F" "f_to_set Fa"]
            by auto
        qed
      qed
    qed
  qed
qed

lemma non_isomorphic_families':
  assumes "\<forall> p \<in> set perms. \<forall> F \<in> set fams. inj_on (to_fun p) (\<Union> f_to_set F)"
  shows "\<forall> F \<in> set fams. \<exists> F' \<in> set (non_isomorphic_families perms fams). inj_embed (f_to_set F) (f_to_set F')"
using assms
unfolding non_isomorphic_families_def
using non_isomorphic_families_aux
by simp

lemma generating_subset_non_isomorphic_families:
  assumes "\<forall>p\<in>set perms. \<forall>F\<in>set FF. inj_on (to_fun p) (\<Union>f_to_set F)"
          "iso_representing_subset (\<circle>FF) FF'"
  shows "iso_representing_subset (\<circle>(non_isomorphic_families perms FF)) FF'"
proof
  show "\<circle> (non_isomorphic_families perms FF) \<subseteq> FF'"
    using `iso_representing_subset (\<circle>FF) FF'` non_isomorphic_families_subset[of perms]
    by auto
next
  show "iso_represents (\<circle> (non_isomorphic_families perms FF)) FF'"
    unfolding iso_represents_def
  proof
    fix F'
    assume "F' \<in> FF'"
    then obtain F where "F \<in> (\<circle>FF)" "iso F' F" 
      using `iso_representing_subset (\<circle>FF) FF'`
      unfolding iso_represents_def
      by blast
    then obtain Fl where "Fl \<in> set FF" "F = f_to_set Fl"
      by auto
    then obtain F'' where "F'' \<in>\<circle>(non_isomorphic_families perms FF)" "inj_embed F F''"
      using non_isomorphic_families'[of perms FF, OF assms(1)]
      by auto (metis f_to_set_def imageI image_set) 
    thus "Bex (\<circle> (non_isomorphic_families perms FF)) (iso F')"
      using `iso F' F` iso_trans inj_embed_iso
      by blast
  qed
qed

end (* Locale *)

(* TODO: Missing completeness proof *)
end
