(* ----------------------------------------------------------------------- *)
subsubsection{* Implementation by sets represented by (sorted and distinct) lists *}
(* ----------------------------------------------------------------------- *)

theory NonIsomorphicFamiliesImpl
imports NonIsomorphicFamilies
        Combinatorics
        "HOL-Library.List_lexord"
begin

definition list_to_fun :: "nat list \<Rightarrow> (nat \<Rightarrow> nat)" where
  "list_to_fun l = (\<lambda> n. l ! n)"

definition permute_set_l :: "nat list \<Rightarrow> nat list \<Rightarrow> nat list" where
 "permute_set_l p A = sort (map (list_to_fun p) A)"

global_interpretation SetPermutations_lists: SetPermutations sd set list_to_fun permute_set_l
  defines
  non_isomorphic_families_aux_l = "SetPermutations_lists.non_isomorphic_families_aux" and
  permute_family_l = "SetPermutations_lists.permute_family" and
  non_isomorphic_families_l = "SetPermutations_lists.non_isomorphic_families"
proof (unfold_locales)
  fix p s
  show "set (permute_set_l p s) = list_to_fun p ` set s"
    unfolding permute_set_l_def
    by simp
next
  fix s::"nat list" and p
  assume "sorted s \<and> distinct s" "inj_on (list_to_fun p) (set s)"
  thus "sorted (permute_set_l p s) \<and> distinct (permute_set_l p s)"
    by (auto simp add: permute_set_l_def list_to_fun_def distinct_map)
qed


lemma nat_list_to_fun_inj_on':
  assumes "distinct p" "p <~~> [0..<n]" "X \<subseteq> {0..<length p}"
  shows "inj_on (list_to_fun p) X"
  using assms
  using distinct_conv_nth[of p]
  apply (auto simp add: list_to_fun_def inj_on_def)
  apply (rule ccontr)
  apply (erule_tac x=x in allE, drule mp, force)
  apply (erule_tac x=y in allE, drule mp, force)
  by simp

lemma nat_list_to_fun_inj_on:
  assumes 
  "\<forall> p \<in> set perms. p <~~> [0..<n]" and
  "\<forall> F \<in> set fams. \<Union> f_to_set_l F \<subseteq> {0..<n}"
  shows "\<forall>p\<in>set perms. \<forall>F\<in>set fams. inj_on (list_to_fun p) (\<Union>f_to_set_l F)"
unfolding inj_on_def list_to_fun_def SetImpl_lists.f_to_set_def
proof (auto)
  fix p F x y Ax Ay
  assume "p \<in> set perms" and
    *: "F \<in> set fams" "Ax \<in> set F" "x \<in> set Ax" "Ay \<in> set F" "y \<in> set Ay" and
    "p ! x = p ! y"
  have "distinct p"  "length p = n"
    using `p \<in> set perms` assms(1)
    using perm_distinct_iff[of p "[0..<n]"] perm_length[of p "[0..<n]"]
    by auto
  moreover
  have "x < n" "y < n" 
    using * assms(2)
    unfolding  SetImpl_lists.f_to_set_def
    by force+
  ultimately
  show "x = y"
    using `p ! x = p ! y`
    using nth_eq_iff_index_eq [of p x y] assms(2) *
    by simp
qed

lemma iso_permute_family_l:
  assumes "iso (f_to_set_l F) (f_to_set_l F')" "sdf F'" "sdf F" (* only distinct is enough *)
  assumes "dm F n" "dm F' n" "perms = permute [0..<n]"
  shows "\<exists> p \<in> set perms. set F' = set (permute_family_l p F)"
using assms
proof-
  from assms obtain f where bij: "bij_betw f (\<Union> f_to_set_l F) (\<Union> f_to_set_l F')" and
    *: "f_to_set_l F' = op ` f ` f_to_set_l F"
    unfolding iso_def
    by auto
  have "card ({0..<n} - (\<Union> f_to_set_l F)) = card ({0..<n} - (\<Union> f_to_set_l F'))"
    using bij `dm F n` `dm F' n`
    by (metis bij_betw_same_card card_Diff_subset finite_atLeastLessThan finite_subset)
  then obtain f' where bij: "bij_betw f' {0..<n} {0..<n}" "\<forall> x \<in> \<Union> f_to_set_l F. f' x = f x"
    using bij_betw_extend[OF bij, of "{0..<n} - (\<Union> f_to_set_l F)" "{0..<n} - (\<Union> f_to_set_l F')"]
    using `dm F' n` `dm F n`
    by auto (metis subset_Un_eq)
  have *: "f_to_set_l F' = op ` f' ` f_to_set_l F"
    using `\<forall> x \<in> \<Union> f_to_set_l F. f' x = f x` *
    by (metis map_fam_cong)
  let ?perm = "map f' [0..<n]"
  have "?perm <~~> [0..<n]"
    unfolding mset_eq_perm[symmetric]
  proof (subst set_eq_iff_mset_eq_distinct[symmetric])
    show "distinct (map f' [0..<n])"
      using distinct_map[of f' "[0..<n]"]
      using bij
      by (auto simp add: bij_betw_def)
  next
    show "distinct [0..<n]"
      by simp
  next
    show "set (map f' [0..<n]) = set [0..<n]"
      using bij
      unfolding bij_betw_def
      by auto
  qed
  show ?thesis
  proof (rule_tac x="?perm" in bexI)
    show "?perm \<in> set perms"
      using `perms = permute [0..<n]` `?perm <~~> [0..<n]`
      using permute_isPermutation[of ?perm "[0..<n]"]
      by simp
  next
    show "set F' = set (permute_family_l ?perm F)"
    proof (safe)
      fix x
      assume "x \<in> set F'"
      then obtain y where "y \<in> set F" and **: "set x = f' ` set y"
        using *
        by (auto, smt image_eqI image_iff)
      have "set y \<subseteq> {0..<n}"
        using `y \<in> set F` `dm F n`
        by auto
      have "x = permute_set_l ?perm y"
      proof-
        have "map (op ! (FamilyImpl.map f' [0..<n])) y = map f' y"
          using `y \<in> set F` `dm F n`
          by auto
        moreover
        have "sd x" "distinct y"
          using `y \<in> set F` `sdf F` `x \<in> set F'` `sdf F'`
          by auto
        hence "x = sort (map f' y)"
          using ** `set y \<subseteq> {0..<n}`
          using sorted_distinct_set_unique[of x "sort (map f' y)"]
          using bij distinct_map[of f' y]
          using subset_inj_on[of f' "{0..<n}" "set y"]
          unfolding bij_betw_def 
          by simp
        ultimately
        show ?thesis
          unfolding permute_set_l_def list_to_fun_def
          by metis
      qed
      thus "x \<in> set (permute_family_l ?perm F)"
        using `y \<in> set F`
        unfolding SetPermutations_lists.permute_family_def
        by auto
    next
      fix x
      assume "x \<in> set (permute_family_l ?perm F)"
      then obtain y where "x = permute_set_l ?perm y" "y \<in> set F"
        unfolding SetPermutations_lists.permute_family_def
        by auto
      hence "x = sort (map f' y)"
      proof-
        have "map (op ! (FamilyImpl.map f' [0..<n])) y = map f' y"
          using `y \<in> set F` `dm F n`
          by auto
        thus ?thesis
          using `x = permute_set_l ?perm y`
          unfolding permute_set_l_def list_to_fun_def
          by metis
      qed
      hence "set x \<in> set (map set F')"
        using `y \<in> set F` *
        by auto
      moreover
      have "distinct y" "set y \<subseteq> {0..<n}"
        using `y \<in> set F` `sdf F` `dm F n`
        by auto
      hence "sd x"
        using `x = sort (map f' y)` `y \<in> set F` distinct_map[of f' y]
        using subset_inj_on[of f' "{0..<n}" "set y"]
        using bij
        unfolding bij_betw_def 
        by auto
      ultimately
      show "x \<in> set F'"
        using `sdf F'`
        by (metis SetImpl_lists.f_to_set_def SetImpl_lists.set_set)
    qed
  qed
qed


lemmas non_isomorphic_families_soundness = SetPermutations_lists.non_isomorphic_families'[OF nat_list_to_fun_inj_on]
lemmas permute_set_inv_l = SetPermutations_lists.permute_set_inv[OF nat_list_to_fun_inj_on']
lemmas iso_representing_subset_non_isomorphic_families_l = SetPermutations_lists.generating_subset_non_isomorphic_families[OF nat_list_to_fun_inj_on]

end