section{* SomeShareNegative --- combinatorial search for union-closed extension with a negative share *}
theory SomeShareNegative
imports Main WeightsShares_FCFamily
begin

text{* 
According to the theorem

@{thm [display] FC_family_uce_shares_nonneg[no_vars]}

to show that a family is an FC family, it suffices to show that there
is no member of union closed extension of a given family with a
negative share. The function @{text "some_share_negative"} performs a
combinatorial enumeration of union closed extensions of a given family
and checks whether it contains a family with a negative share with
respect to the given weight function. We give a rather abstract
(nonexecutable) definition of this function and prove its main
properties. This function will be later refined and a more efficient,
executable implementation will be given. *}

primrec some_share_negative_aux :: "'a set list \<Rightarrow> 'a set set  \<Rightarrow> 'a set set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> bool" where
  "some_share_negative_aux [] Ft Fc w X = ((w \<bowtie>\<^sub>f Ft X) < 0)"
| "some_share_negative_aux (h # t) Ft Fc w X = 
    (if (w \<bowtie>\<^sub>f Ft X) + sum_list (map (\<lambda> A. (w \<bowtie>\<^sub>s A X)) (h # t)) \<ge> 0 then
        False
     else if some_share_negative_aux t Ft Fc w X then
        True
     else if h \<in> Ft then
        False
     else
        some_share_negative_aux t (insert_and_close_additional h Ft Fc) Fc w X
    )
"

lemma some_share_negative_aux_soundness:
  assumes "some_share_negative_aux L Ft Fc w X = False" and
          "\<forall> A \<in> set L. (w \<bowtie>\<^sub>s A X) < 0" and
          "distinct L" and
          "finite F" and "F \<supseteq> Ft" and
          "union_closed_additional F Fc" and
          "\<forall> A \<in> F - Ft. (w \<bowtie>\<^sub>s A X) < 0 \<longrightarrow> A \<in> List.set L"
  shows "(w \<bowtie>\<^sub>f F X) \<ge> 0"
using assms
proof (induct L arbitrary: Ft)
  case Nil
  show ?case
  proof-
    let ?ss = "\<lambda> A. (w \<bowtie>\<^sub>s A X)"
    have "sum ?ss F = sum ?ss (Ft \<union> (F - Ft))"
      apply (subst sum.cong[of F "Ft \<union> (F - Ft)" ?ss ?ss])
      using `F \<supseteq> Ft`
      by auto
    also have "... = sum ?ss Ft + sum ?ss (F - Ft)"
      apply (rule sum.union_disjoint)
      using `finite F` `F \<supseteq> Ft`
      by (auto simp add: finite_subset)
    finally have "sum ?ss F = sum ?ss Ft + sum ?ss (F - Ft)"
      .
    moreover
    have "sum ?ss (F - Ft) \<ge> 0"
      apply (rule sum_nonneg)
      using `\<forall>A\<in>F - Ft. set_share A w X < 0 \<longrightarrow> A \<in> set []`
      by force
    moreover
    have "sum ?ss Ft \<ge> 0"
      using `some_share_negative_aux [] Ft Fc w X = False`
      by (simp add: family_share_def)
    ultimately
    show ?thesis
      by (simp add: family_share_def)
  qed
next
  case (Cons h t)
  let ?ss = "\<lambda> A. (w \<bowtie>\<^sub>s A X)"
  show ?case
  proof (cases "family_share Ft w X + sum_list (map ?ss (h # t)) \<ge> 0")
    case True
    let ?Fp = "{A. A \<in> F - Ft \<and> ?ss A \<ge> 0}"
    let ?Fn = "{A. A \<in> F - Ft \<and> ?ss A < 0}"
    
    have "(\<Sum>A\<in>F. ?ss A) =  (\<Sum>A\<in>(F - Ft) \<union> Ft. ?ss A)"
      apply (rule sum.cong)
      using `Ft \<subseteq> F`
      by auto
    also have "... = (\<Sum>A\<in>(F - Ft). ?ss A) + (\<Sum>A\<in>Ft. ?ss A)"
      apply (rule sum.union_disjoint)
      using `finite F` `F \<supseteq> Ft`
      by (auto simp add: finite_subset)
    finally have *: "(\<Sum>A\<in>F. ?ss A) = (\<Sum>A\<in>(F - Ft). ?ss A) + (\<Sum>A\<in>Ft. ?ss A)"
      .
    
    have "(\<Sum>A\<in>(F - Ft). ?ss A) = (\<Sum>A\<in>?Fp \<union> ?Fn. ?ss A)"
      by (rule sum.cong) auto
    also have "... = (\<Sum>A\<in>?Fp. ?ss A) + (\<Sum>A\<in>?Fn. ?ss A)"
      apply (rule sum.union_disjoint)
      using `finite F`
      by auto
    finally have **: "(\<Sum>A\<in>(F - Ft). ?ss A) = (\<Sum>A\<in>?Fp. ?ss A) + (\<Sum>A\<in>?Fn. ?ss A)"
      by auto
    
    have "(\<Sum>A\<in>?Fp. ?ss A) \<ge> 0"
      by (rule sum_nonneg) auto
    hence "(\<Sum>A\<in>F. ?ss A) \<ge> (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>Ft. ?ss A)"
      using * **
      by simp
    
    let ?L = "set (h # t)"
    have "sum_list (map ?ss (h # t)) = (\<Sum>A\<in>?L. ?ss A)"
      using `distinct (h # t)`
      by (simp add: sum_list_distinct_conv_sum_set)
    moreover
    have "(\<Sum>A\<in>?L. ?ss A) = (\<Sum>A\<in>(?Fn \<union> (?L - ?Fn)). ?ss A)"
      apply (rule sum.cong)
      using `\<forall>A\<in>F -  Ft. ?ss A < 0 \<longrightarrow> A \<in> List.set (h # t)`
      by force auto
    also have "... = (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>(?L - ?Fn). ?ss A)"
      apply (rule sum.union_disjoint)
      using `finite F`
      by auto
    also have "... \<le> (\<Sum>A\<in>?Fn. ?ss A)"
    proof-
      have "(\<Sum>A\<in>(?L - ?Fn). ?ss A) \<le> 0"
        apply (rule sum_nonpos)
        using `\<forall> A \<in> set (h # t). ?ss A < 0`
        by auto
      thus ?thesis
        by simp
    qed
    finally
    have "(w \<bowtie>\<^sub>f F X) \<ge> 0"
      using `(\<Sum>A\<in>F. ?ss A) \<ge> (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>Ft. ?ss A)`
      using `(w \<bowtie>\<^sub>f Ft X) + sum_list (map ?ss (h # t)) \<ge> 0`
      unfolding family_share_def
      by simp
    thus ?thesis
      by simp
  next
    case False
    note * = this
    have "\<not> some_share_negative_aux t Ft Fc w X"
      using `some_share_negative_aux (h # t) Ft Fc w X = False` *
      by auto
    note * = * this
    note * = * `finite F` `Ft \<subseteq> F` `union_closed_additional F Fc`
    have "\<forall>A\<in>set t. ?ss A < 0" "distinct t"
      using `\<forall>A\<in>set (h # t). ?ss A < 0` `distinct (h # t)`
      by auto
    note * = * this
    
    show ?thesis
    proof (cases "h \<in> Ft")
      case True
      thus ?thesis
        using * Cons
        by auto
    next
      case False
      let ?Ft' = "insert_and_close_additional h Ft Fc"
      let ?s' = "family_share ?Ft' w X"
      show ?thesis
      proof (cases "h \<in> F")
        case True
        show ?thesis
        proof (rule Cons(1))
          show "some_share_negative_aux t ?Ft' Fc w X = False"
            using `some_share_negative_aux (h # t) Ft Fc w X = False` * `h \<notin> Ft`
            by auto
        next
          show "\<forall> A \<in> F - ?Ft'. ?ss A < 0 \<longrightarrow> A \<in> set t"
            using `\<forall> A \<in> F - Ft. ?ss A < 0 \<longrightarrow> A \<in> set (h # t)`
            using `h \<notin> Ft`
            by auto
        next
          show "?Ft' \<subseteq> F"
            using `Ft \<subseteq> F` `h \<in> F` `union_closed_additional F Fc`
            by (auto simp add: union_closed_def)
        next
          show "union_closed_additional F Fc"
            using *
            by auto
        qed (auto simp add: *)
      next
        case False
        thus ?thesis
          using Cons(1) `\<forall>A\<in>F - Ft. ?ss A < 0 \<longrightarrow>  A \<in> set (h # t)` *
          by auto
      qed
    qed
  qed
qed

definition some_share_negative :: "'a set set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> bool" where
"some_share_negative Fc w \<equiv>
  let X = (\<Union> Fc);
      P = Pow X;
      Fc = closure Fc;
      N = {x. x \<in> P \<and> (w \<bowtie>\<^sub>s x X) < 0}; 
      L = (SOME L. distinct L \<and> set L = N) in
      some_share_negative_aux L {} Fc w X"

lemma some_share_negative_soundness':
  assumes "some_share_negative Fc w = False" and
          "finite (\<Union> Fc)" and "F \<in> \<lbrace> Fc \<rbrace>"
  shows   "(w \<bowtie>\<^sub>f F (\<Union> Fc)) \<ge> 0"
proof (rule some_share_negative_aux_soundness)
  let ?X = "\<Union> Fc"
  let ?P = "Pow ?X"
  let ?Fc = "closure Fc"
  let ?N = "{x. x \<in> ?P \<and> set_share x w ?X < 0}"
  let ?L = "SOME L. distinct L \<and> set L = ?N"

  have *: "distinct ?L \<and> set ?L = ?N"
  proof (rule someI_ex)
    have "finite ?N"
      using `finite (\<Union> Fc)`
      by simp
    thus "\<exists> L. distinct L \<and> set L = ?N"
      by (rule ex_list_of_set)
  qed

  show "some_share_negative_aux ?L {} ?Fc w (\<Union> Fc) = False"
    using assms
    unfolding some_share_negative_def Let_def
    by simp

  show "\<forall> a \<in> set ?L. (w \<bowtie>\<^sub>s a (\<Union> Fc)) < 0" "distinct ?L"
    using *
    by simp_all

  show "\<forall> a \<in> F - {}. (w \<bowtie>\<^sub>s a (\<Union> Fc)) < 0 \<longrightarrow> a \<in> set ?L"
    using `F \<in> \<lbrace> Fc \<rbrace>` *
    by auto

  show "finite F"
    using `F \<in> \<lbrace> Fc \<rbrace>` `finite (\<Union> Fc)` 
    by (auto simp add: finite_subset)
next
  show "union_closed_additional F (closure Fc)"
    using `F \<in> \<lbrace> Fc \<rbrace>` `finite (\<Union> Fc)` union_closed_additional_closure[of Fc F]
    by (auto simp add: finiteUn_iff)
qed (auto simp add: assms)

theorem some_share_negative_soundness:
  assumes "finite (\<Union> Fc)"
  shows "some_share_negative Fc w = False \<Longrightarrow> uce_shares_nonneg Fc w"
using assms
using some_share_negative_soundness'
by auto

end
