section{* SomeShareNegative -- executable implementation *}

theory SomeShareNegativeImpl
imports Main
  "HOL-Library.List_lexord"
  "More.MoreMap"
  SomeShareNegative UnionClosedImpl WeightsSharesImpl
begin

text{* In this section we define a refinement of the @{text
"some_share_negative"} function in several steps in order to obtain a
more efficient, executable implementation. Optimizations are
introduced gradually, through separate refinement steps. *}


(* ************************************************************************ *)

subsection{* Refinement of SomeShareNegativeFunction *}

locale SomeShareNegativeImpl = 
  SetWeightsSharesMapImpl inv to_set set_weight set_weight_map +
  SetUnionImpl inv to_set empty union pow
  for inv :: "'s \<Rightarrow> bool" and to_set :: "'s \<Rightarrow> 'a set" and set_weight :: "('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> nat" and set_weight_map :: "('a, nat) mapping \<Rightarrow> 's \<Rightarrow> nat" and
      empty :: "'s" and union :: "'s \<Rightarrow> 's \<Rightarrow> 's" and pow :: "'s \<Rightarrow> 's list"
begin

subsubsection{* Initial version *}

fun some_share_negative_aux_1 :: "'s list \<Rightarrow> 's list  \<Rightarrow> 's list \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> bool" where
  "some_share_negative_aux_1 [] F Init w X = (family_share F w X < 0)"
| "some_share_negative_aux_1 (h # t) F Init w X = 
    (if family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0 then
        False
     else if some_share_negative_aux_1 t F Init w X then
        True
     else if h \<in> set F then
        False
     else
        some_share_negative_aux_1 t (insert_and_close_additional h F Init) Init w X
     )
"

lemma some_share_negative_aux_1_some_share_negative_aux:
  assumes "distinct F" 
          "\<forall> l \<in> set F. inv l"
          "\<forall> l \<in> set L. inv l"
          "\<forall> l \<in> set Init. inv l"
          "inv X"
  shows "some_share_negative_aux_1 L F Init w X = some_share_negative_aux (map to_set L) (f_to_set F) (f_to_set Init) w (to_set X)"
using assms
proof (induct L arbitrary: F)
  case Nil
  thus ?case
    using family_share_set[of F X w]
    by simp
next
  case (Cons h t)
  have *: "family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) = 
            (w \<bowtie>\<^sub>f (f_to_set F) (to_set X)) + sum_list (map (\<lambda> A. (w \<bowtie>\<^sub>s A (to_set X))) (map to_set (h # t)))"
  proof-
    have "sum_list (map (\<lambda> A. set_share A w X) (h # t)) = sum_list (map (\<lambda> A. (w \<bowtie>\<^sub>s A (to_set X))) (map to_set (h # t)))"
    proof-
      have "map (\<lambda> A. set_share A w X) t = map (\<lambda> x. (w \<bowtie>\<^sub>s (to_set x) (to_set X))) t"
        using `\<forall>a\<in>set (h # t). inv a` `inv X`
        using set_share_set
        by auto
      hence "(\<Sum>A\<leftarrow>t. set_share A w X) = (\<Sum>x\<leftarrow>t. (w \<bowtie>\<^sub>s (to_set x) (to_set X)))"
        by metis
      thus ?thesis
        using `\<forall>a\<in>set (h # t). inv a` `inv X`
        by (auto simp add: set_share_set comp_def)
    qed
    thus ?thesis
      using family_share_set[of F X w]
      using `distinct F` `\<forall>a\<in>set F. inv a` `inv X`
      by simp
  qed
    
  show ?case
  proof (cases "family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0")
    case True
    thus ?thesis
      using *
      by simp
  next
    case False
    have **: "some_share_negative_aux_1 t F Init w X = some_share_negative_aux (map to_set t) (f_to_set F) (f_to_set Init) w (to_set X)"
      using Cons
      by auto
      
    show ?thesis
    proof (cases "some_share_negative_aux_1 t F Init w X")
      case True
      show ?thesis
        using `\<not> family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
        using `some_share_negative_aux_1 t F Init w X` **
        by auto
    next
      case False
      have ***: "(h \<in> set F) = (to_set h \<in> f_to_set F)"
        apply (rule set_set[of F h])
        using `\<forall>a\<in>set F. inv a` `\<forall>a\<in>set (h # t). inv a`
        by auto
      show ?thesis
      proof (cases "h \<in> set F")
        case True
        show ?thesis
          using `\<not> family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
          using `\<not> some_share_negative_aux_1 t F Init w X` **
          using `h \<in> set F` ***
          by simp
      next
        case False
        let ?F' = "insert_and_close_additional h F Init"

        have "some_share_negative_aux_1 t (insert_and_close_additional h F Init) Init w X =
              some_share_negative_aux (map to_set t) (UnionClosed.insert_and_close_additional (to_set h) (f_to_set F) (f_to_set Init)) (f_to_set Init) w (to_set X)"
        proof (subst Cons(1))
          show "distinct ?F'"
            using `distinct F`
            by (simp add: insert_sets_distinct)
        next
          show "inv X" "\<forall> l \<in> set t. inv l" "\<forall> l \<in> set Init. inv l"
            using `inv X` `\<forall> l \<in> set (h # t). inv l` `\<forall> l \<in> set Init. inv l`
            by simp_all
        next
          show "\<forall> l \<in> (set ?F'). inv l"
            using `\<forall>a\<in>set F. inv a` `\<forall>a\<in>set (h # t). inv a` `\<forall>a\<in>set Init. inv a`
            using `distinct F`
            by (auto simp add: insert_sets_remdups union_inv)
        next
          show "some_share_negative_aux (map to_set t) (f_to_set (insert_and_close_additional h F Init)) (f_to_set Init) w (to_set X) =
                some_share_negative_aux (map to_set t) (UnionClosed.insert_and_close_additional (to_set h) (f_to_set F) (f_to_set Init)) (f_to_set Init) w
     (to_set X)"
            using `distinct F`
            using insert_and_close_additional_set
            by simp
        qed
        thus ?thesis
          using `\<not> family_share F w X + sum_list (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
          using `\<not> some_share_negative_aux_1 t F Init w X` **
          using `\<not> h \<in> set F` ***
          by simp
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)
subsubsection{* Passing current family share as a parameter *}

fun some_share_negative_aux_2 :: "('s \<times> int) list \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> bool" where
  "some_share_negative_aux_2 [] (F, s) Init w X = (s < 0)"
| "some_share_negative_aux_2 (h # t) (F, s) Init w X = 
    (if s + sum_list (map snd (h # t)) \<ge> 0 then
        False
     else if some_share_negative_aux_2 t (F, s) Init w X then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = family_share F' w X in
        some_share_negative_aux_2 t (F', s') Init w X
    )
"

lemma some_share_negative_aux_2_some_share_negative_aux_1:
  assumes "L = zip l (map (\<lambda> F. set_share F w X) l)" "c = family_share F w X"
  shows "some_share_negative_aux_2  L (F, c) Init w X = some_share_negative_aux_1 l F Init w X"
using assms
by (induct l arbitrary: F L c) (auto simp add: Let_def)

(* -------------------------------------------------------------------------- *)

subsubsection{* Caching set shares *}

text{* Instead of calculating set share every time from scratch when
calculating, family shares, we shall maintain a mapping from sets to
their shares. *}

abbreviation family_share_cached :: "'s list \<Rightarrow> ('s, int) mapping \<Rightarrow> int" where
  "family_share_cached F shares \<equiv> sum_list (map (the \<circ> (\<lambda> A. Mapping.lookup shares A)) F)"

lemma family_share_cached_family_share:
  assumes "\<forall> A. inv A \<and> to_set A \<subseteq> S \<longrightarrow> Mapping.lookup shares A = Some (set_share A w X)"
          "\<forall> A \<in> set F. inv A \<and> to_set A \<subseteq> S"
  shows "family_share_cached F shares = family_share F w X"
proof-
  have "map (\<lambda> x. the (Mapping.lookup shares x)) F = map (\<lambda> A. local.set_share A w X) F"
    using assms
    by auto
  thus ?thesis
    unfolding family_share_def comp_def
    by metis
qed

lemma family_share_cached_cong:
  assumes "set F = set F'" "distinct F" "distinct F'"
  shows "family_share_cached F shares = family_share_cached F' shares"
using assms
using sum_list_distinct_conv_sum_set[of F "the \<circ> (\<lambda> A. Mapping.lookup shares A)"]
using sum_list_distinct_conv_sum_set[of F' "the \<circ> (\<lambda> A. Mapping.lookup shares A)"]
by simp

fun some_share_negative_aux_3 :: "('s \<times> int) list \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "some_share_negative_aux_3 [] (F, s) Init shares = (s < 0)"
| "some_share_negative_aux_3 (h # t) (F, s) Init shares = 
    (if s + sum_list (map snd (h # t)) \<ge> 0 then
        False
     else if some_share_negative_aux_3 t (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = family_share_cached F' shares in
        some_share_negative_aux_3 t (F', s') Init shares
    )
"
lemma some_share_negative_aux_3_some_share_negative_aux_2:
  assumes "\<forall> A. inv A \<and> to_set A \<subseteq> S \<longrightarrow> Mapping.lookup shares A = Some (set_share A w X)"
          "\<forall> A \<in> set F. inv A \<and> to_set A \<subseteq> S"
          "\<forall> A \<in> set Init. inv A \<and> to_set A \<subseteq> S"
          "\<forall> A \<in> set (map fst l). inv A \<and> to_set A \<subseteq> S"
          "distinct F"
  shows "some_share_negative_aux_3 l (F, s) Init shares = some_share_negative_aux_2 l (F, s) Init w X"
using assms
proof (induct l arbitrary: F s)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "s + sum_list (map snd (h # t)) \<ge> 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "fst h \<in> set F")
      case True
      thus ?thesis
        using `\<not> s + sum_list (map snd (h # t)) \<ge> 0` Cons
        by simp
    next
      case False
      let ?F' = "insert_and_close_additional (fst h) F Init"
      let ?s' = "family_share_cached ?F' shares"
      let ?s'' = "family_share ?F' w X"

      have "\<forall>A\<in>set ?F'. to_set A \<subseteq> S"
        apply (rule insert_and_close_additional_subset)
        using  Cons(3) Cons(4) Cons(5)
        using `distinct F` 
        by simp_all
      
      have "\<forall>A\<in>set ?F'. inv A"
        apply (rule insert_and_close_additional_inv)
        using  Cons(3) Cons(4) Cons(5)
        using `distinct F` 
        by simp_all

      have "distinct ?F'"
        using `distinct F`
        by (simp add: insert_sets_distinct)

      have "?s' = ?s''"
        apply (rule family_share_cached_family_share[of S shares w X ?F'])
        using `\<forall>A\<in>set ?F'. to_set A \<subseteq> S` `\<forall>A\<in>set ?F'. inv A` Cons(2)
        by simp_all
        
      hence "some_share_negative_aux_3 t (?F', ?s') Init shares = some_share_negative_aux_2 t (?F', ?s'') Init w X"
        using Cons(1)[of ?F' ?s'] Cons(2) Cons(3) Cons(4) Cons(5)
        using `\<forall>A\<in>set ?F'. to_set A \<subseteq> S` `\<forall>A\<in>set ?F'. inv A`
        using `distinct ?F'` 
        by auto
      thus ?thesis
        using `\<not> s + sum_list (map snd (h # t)) \<ge> 0` `fst h \<notin> set F` Cons
        by auto
    qed
  qed
qed

lemma some_share_negative_aux_3_correct: 
  assumes "some_share_negative_aux_3 L (F, c) Init shares = False"
  "\<forall> (x, y) \<in> set L. y = set_share x w X"
  "c = family_share F w X"
  "\<forall>A. inv A \<and> to_set A \<subseteq> S \<longrightarrow> Mapping.lookup shares A = Some (set_share A w X)"
  "\<forall>A\<in>set F. inv A \<and> to_set A \<subseteq> S"
  "\<forall>A\<in>set Init. inv A \<and> to_set A \<subseteq> S"
  "\<forall>A\<in>set (map fst L). inv A \<and> to_set A \<subseteq> S"
  "distinct F"
  "inv X"
  "\<forall>A\<in>set (map fst L). (w \<bowtie>\<^sub>s (to_set A) (to_set X)) < 0"
  "finite F'"
  "UnionClosed.union_closed_additional F' (f_to_set Init)"
  "f_to_set F \<subseteq> F'"
  "\<forall>A\<in>F' - f_to_set F. ((w \<bowtie>\<^sub>s A (to_set X)) < 0 \<longrightarrow> A \<in> f_to_set (map fst L))"
  "distinct L"
  shows "(w \<bowtie>\<^sub>f F' (to_set X)) \<ge> 0"
using assms
using exists_zip[of L "\<lambda> x. set_share x w X"]
apply (subst (asm) some_share_negative_aux_3_some_share_negative_aux_2[of S shares w X])
apply simp_all
apply (subst (asm) some_share_negative_aux_2_some_share_negative_aux_1[of L "map fst L"])
apply (simp_all add: comp_def)
apply (subst (asm) some_share_negative_aux_1_some_share_negative_aux)
apply simp_all
apply (rule some_share_negative_aux_soundness[of "map to_set (map fst L)" "f_to_set F" "f_to_set Init" w "to_set X" F'])
apply (simp_all add: comp_def)
proof-
  assume *: "\<forall>A\<in>set L. inv (fst A) \<and> to_set (fst A) \<subseteq> S" "distinct L" "\<forall>x\<in>set L. case x of (x, y) \<Rightarrow> y = set_share x w X"
  have "\<forall>a\<in>set (map fst L). inv a"
    using `\<forall>A\<in>set L. inv (fst A) \<and> to_set (fst A) \<subseteq> S`
    by simp
  hence "inj_on to_set (set (map fst L))"
    by (rule to_set_inj_on)
  thus "distinct (map (\<lambda> x. to_set (fst x)) L)" 
    using comp_inj_on_iff[of fst "set L" to_set] * inj_on_fst[of L]
    by (auto simp add: distinct_map comp_def)
qed

(* -------------------------------------------------------------------------- *)
subsubsection{* Passing the sum of shares of elements in the current list as a parameter *}

fun some_share_negative_aux_4 :: "(('s \<times> int) list \<times> int) \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "some_share_negative_aux_4 ([], _) (F, s) Init shares = (s < 0)"
| "some_share_negative_aux_4 ((h # t), ls) (F, s) Init shares = 
    (if s + ls \<ge> 0 then
        False
     else if some_share_negative_aux_4 (t, ls - snd h) (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = family_share_cached F' shares in
        some_share_negative_aux_4 (t, ls - snd h) (F', s') Init shares
    )
"

lemma some_share_negative_aux_4_some_share_negative_aux_3:
  shows "some_share_negative_aux_4 (l, sum_list (map snd l)) (F, s) Init shares = 
  some_share_negative_aux_3 l (F, s) Init shares"
by (induct l arbitrary: F s) auto

lemma some_share_negative_aux_4_equal_set:
  assumes "set F = set F'" "distinct F" "distinct F'"
  shows "some_share_negative_aux_4 (l, ls) (F, s) Init shares =
         some_share_negative_aux_4 (l, ls) (F', s) Init shares"
using assms
proof (induct l arbitrary: F F' s ls)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "s + ls \<ge> 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "some_share_negative_aux_4 (t, ls - snd h) (F, s) Init shares")
      case True
      thus ?thesis
        using `\<not> s + ls \<ge> 0`
        using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
        by auto
    next
      case False
      show ?thesis
      proof (cases "fst h \<in> set F")
        case True
        thus ?thesis
          using `\<not> s + ls \<ge> 0`
          using `\<not> some_share_negative_aux_4 (t, ls - snd h) (F, s) Init shares`
          using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
          by auto
      next
        case False
        let ?F = "insert_and_close_additional (fst h) F Init"
        let ?F' = "insert_and_close_additional (fst h) F' Init"
        have "set ?F = set ?F'"
          using `set F = set F'` `distinct F` `distinct F'`
          by (rule insert_and_close_additional_cong)
        hence "family_share_cached ?F shares = family_share_cached ?F' shares"
          using family_share_cached_cong[of ?F ?F' shares]
          using `distinct F` `distinct F'`
          by (simp add: insert_sets_distinct)
        thus ?thesis
          using `fst h \<notin> set F`
          using `\<not> s + ls \<ge> 0`
          using `\<not> some_share_negative_aux_4 (t, ls - snd h) (F, s) Init shares`
          using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
          using `set ?F = set ?F'`
          using Cons(1)[of ?F ?F']
          by (simp add: Let_def insert_sets_distinct)
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)
subsubsection{* Incremental insert and close operation and calculation of share of the extended family *}

fun insert_and_close_additional_cached where
  "insert_and_close_additional_cached A (Ft, s) Fc shares =
      (let add = [A] @ union_with_all A Ft @ union_with_all A Fc;
           add = filter (\<lambda> x. x \<notin> set Ft) (remdups add)
        in (add @ Ft, s + family_share_cached add shares))"

lemma insert_and_close_additional_cached_family_share_cached:
  shows "let (Ft', s') = insert_and_close_additional_cached A (Ft, family_share_cached Ft shares) Fc shares 
          in s' = family_share_cached Ft' shares"
by (auto simp add: Let_def)

lemma insert_and_close_additional_cached:
assumes
  "distinct Ft"
  "insert_and_close_additional_cached A (Ft, family_share_cached Ft shares) Fc shares =
   (Ft', s')"
shows
  "set Ft' = set (insert_and_close_additional A Ft Fc) \<and> 
   s' = family_share_cached Ft' shares"
proof-
  let ?add = "[A] @ union_with_all A Ft @ union_with_all A Fc"
  let ?add = "filter (\<lambda> x. x \<notin> set Ft) (remdups ?add)"

  have "Ft' = ?add @ Ft" "distinct Ft'"
       "s' = family_share_cached Ft shares + family_share_cached ?add shares"
    using `insert_and_close_additional_cached A (Ft, family_share_cached Ft shares) Fc shares = (Ft', s')`
    using `distinct Ft`
    by (auto simp add: Let_def)
  thus ?thesis
    by auto
qed

function some_share_negative_aux_5 :: "(('s \<times> int) list \<times> int) \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "some_share_negative_aux_5 ([], _) (F, s) Init shares = 
      (if s < 0 then True else False)"
| "some_share_negative_aux_5 ((h # t), ls) (F, s) Init shares = 
    (if s + ls \<ge> 0 then
        False
     else if some_share_negative_aux_5 (t, ls - snd h) (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let (F', s') = insert_and_close_additional_cached (fst h) (F, s) Init shares in
        some_share_negative_aux_5 (t, ls - snd h) (F', s') Init shares
    )"
by pat_completeness auto
termination
by (relation "measure (\<lambda> ((L, _), _, _, _). length L)") auto

lemma some_share_negative_aux_5_some_share_negative_aux_4:
assumes "s = family_share_cached F shares" "distinct F"
shows "some_share_negative_aux_5 (L, ls) (F, s) Init shares = 
some_share_negative_aux_4 (L, ls) (F, s) Init shares"
using assms
proof (induct L arbitrary: F s ls)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "0 \<le> s + ls")
    case True
    thus ?thesis
      unfolding some_share_negative_aux_4.simps some_share_negative_aux_5.simps
      by simp
  next
    case False
    hence *: "some_share_negative_aux_5 (t, ls - snd h) (F, s) Init shares = some_share_negative_aux_4 (t, ls - snd h) (F, s) Init shares"
      using Cons(1)[of s F "ls - snd h"] Cons(2) Cons(3)
      by auto
    show ?thesis
    proof (cases "some_share_negative_aux_5 (t, ls - snd h) (F, s) Init shares")
      case True
      thus ?thesis
        using `\<not> 0 \<le> s + ls` *
        by simp
    next
      case False
      show ?thesis
      proof (cases "fst h \<in> set F")
        case True
        thus ?thesis
          using `\<not> 0 \<le> s + ls`
          using `\<not> some_share_negative_aux_5 (t, ls - snd h) (F, s) Init shares`
          using *
          by simp
      next
        case False
        let ?F1s1 = "insert_and_close_additional_cached (fst h) (F, s) Init shares"
        let ?F1 = "fst ?F1s1"
        let ?s1 = "snd ?F1s1"
        let ?F2 = "insert_and_close_additional (fst h) F Init"
        let ?s2 = "family_share_cached ?F2 shares"

        have "distinct ?F1" "distinct ?F2"
          using `distinct F`
          unfolding Let_def
          by (auto simp add: insert_sets_distinct Let_def)

        hence "set ?F1 = set ?F2 \<and> ?s1 = ?s2"
          using insert_and_close_additional_cached[OF `distinct F`, of "fst h" shares Init ?F1 ?s1] Cons(2)          by (metis family_share_cached_cong prod.collapse)
        hence "set ?F1 = set ?F2" "?s1 = ?s2"
          by (rule conjunct1, rule conjunct2)

        have "some_share_negative_aux_4 (t, ls - snd h) (?F1, ?s1) Init shares = 
          some_share_negative_aux_4 (t, ls - snd h) (?F2, ?s2) Init shares"
        proof (subst some_share_negative_aux_4_equal_set[of ?F1 ?F2 t "ls - snd h" ?s1 Init shares])
          show "set ?F1 = set ?F2"
            by fact
        next
          show "distinct ?F1" "distinct ?F2"
            by fact+
        next
          show "some_share_negative_aux_4 (t, ls - snd h) (?F2, ?s1) Init shares = 
            some_share_negative_aux_4 (t, ls - snd h) (?F2, ?s2) Init shares"
            by (subst `?s1 = ?s2`, rule refl)
        qed
        moreover
        have "some_share_negative_aux_5 (t, ls - snd h) (?F1, ?s1) Init shares = some_share_negative_aux_4 (t, ls - snd h) (?F1, ?s1) Init shares"
          apply (rule Cons(1)[of ?s1 ?F1 "ls - snd h"])
          using Cons(2) `distinct ?F1`
          using insert_and_close_additional_cached_family_share_cached[of "fst h" F shares Init]
          by (auto simp add: Let_def comp_def)
        ultimately
        show ?thesis
          using `fst h \<notin> set F`
          using `\<not> 0 \<le> s + ls`
          using `\<not> some_share_negative_aux_5 (t, ls - snd h) (F, s) Init shares` *
          by (simp add: Let_def)
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)
subsubsection{* Final implementation *}

definition some_share_negative :: "'s list \<Rightarrow> ('a, nat) mapping \<Rightarrow> bool" where
"some_share_negative A w \<equiv>
  let S = Union A;
      P = pow S;
      A = close A;
      U' = map (\<lambda> A. set_share_map A w S) P;
      U = sort_key snd (zip P U');
      shares = tabulate U;
      L =  takeWhile (\<lambda> (a, b). b < 0) U;
      F = [] in
      some_share_negative_aux_5 (L, sum_list (map snd L)) (F, 0) A shares"

(* TODO: Show that this implementation of @{text some_share_negative} refines 
   the abstract implementation of @{text some_share_negative} given in
   some_share_negative.thy (requires modifications). *)

lemma some_share_negativeFalse_FamilyShare:
  assumes 
  "some_share_negative A w = False"
  "A' = f_to_set A"
  "\<forall> l \<in> set A. inv l" 
  "finite F"
  "UnionClosed.union_closed_additional F (closure A')"
  "\<forall> x \<in> F. x \<subseteq> \<Union> A'"
  "\<forall> x \<in> \<Union>A'. Mapping.lookup w x = Some (w' x)"
  shows "(w' \<bowtie>\<^sub>f F (\<Union> A')) \<ge> 0"
proof-
  let ?S = "Union A"
  let ?P = "pow ?S"
  let ?A = "close A"
  let ?U' = "map (\<lambda> A. set_share_map A w ?S) ?P"
  let ?U = "sort_key snd (zip ?P ?U')"
  let ?shares = "tabulate ?U"
  let ?L = "takeWhile (\<lambda> (a, b). b < 0) ?U"
  let ?F = "[]"

  have "inv (Union A)"
    using `\<forall> l \<in> set A. inv l`
    using Union_inv[of A]
    by simp

  have *: "\<forall> x \<in> set ?P. set_share_map x w (Union A) = set_share x w' (Union A)"
  proof
    fix x
    assume "x \<in> set ?P"
    hence "to_set x \<subseteq> \<Union> A'" "inv x"
      using pow_set[of "Union A"]
      using pow_inv[of "Union A"]
      using Union_set[of A] `inv (Union A)`  `A' = f_to_set A`
      by auto
    hence "\<forall> a \<in> to_set x. Mapping.lookup w a = Some (w' a)"
      using `\<forall> a \<in> \<Union>A'. Mapping.lookup w a = Some (w' a)`
      by auto
    thus "set_share_map x w (Union A) = set_share x w' (Union A)"
      using set_weight_map[of x w w']
      using set_weight_map[of "Union A" w w']
      using `\<forall> a \<in> \<Union>A'. Mapping.lookup w a = Some (w' a)`
      using Union_set[of A]
      using `inv (Union A)` `inv x` `A' = f_to_set A`
      by (simp add: set_share_def)
  qed

  show ?thesis
  proof (subst `A' = f_to_set A`, subst Union_set[THEN sym], rule some_share_negative_aux_3_correct[of ?L ?F 0 ?A ?shares])
    show "some_share_negative_aux_3 ?L (?F, 0) ?A ?shares = False"
      using `some_share_negative A w = False`
      unfolding some_share_negative_def Let_def
      using some_share_negative_aux_4_some_share_negative_aux_3
      using some_share_negative_aux_5_some_share_negative_aux_4
      by simp
  next
    show "\<forall> (x, y) \<in> set ?L. y = set_share x w' (Union A)"
      using *
      by (auto dest!: set_takeWhileD simp add: set_zip)
  next
    show "0 = family_share [] w' (Union A)"
      by (simp add: family_share_def)
  next
    show "\<forall> A'. inv A' \<and> to_set A' \<subseteq> to_set ?S \<longrightarrow> Mapping.lookup ?shares A' = Some (set_share A' w' (Union A))"
    proof-
      have "distinct ?P"
        using `inv (Union A)`
        by (simp add: pow_distinct)
      hence "distinct (map fst ?U)"
        using inj_on_fst[of ?U]
        by (force simp add: distinct_map distinct_zipI1 set_zip)
      thus ?thesis
        using `distinct ?P`
        using `inv (Union A)`
        using subset_in_pow
        using *
        using tabulate_map_of[of ?U]
        by (auto simp add: tabulate_map_of map_of_sort_key map_of_zip_map Mapping.lookup.abs_eq)
    qed
  next
    show "\<forall> A' \<in> set (close A). inv A' \<and> to_set A' \<subseteq> to_set (Union A)"
      using close_inv[of A] `\<forall>l\<in>set A. inv l`
      using close_subset[of A "to_set (Union A)"]
      using Union_set[of A]
      by auto
  next
    show "\<forall> A' \<in> set (map fst ?L). inv A' \<and> to_set A' \<subseteq> to_set (Union A)"
        using pow_inv[of "Union A"] using pow_set[of "Union A"] `inv (Union A)`
        by (auto dest!: set_takeWhileD set_zip_leftD) force
  next
    show "inv (Union A)"
      by fact
  next
    show "\<forall>A'\<in>set (map fst ?L). (w' \<bowtie>\<^sub>s (to_set A') (to_set (Union A))) < 0"
    proof-
      { 
        fix a b
        assume "(a, b) \<in> set (zip ?P ?U')" "b < 0"
        hence "a \<in> set ?P" "set_share_map a w (Union A) < 0"
          by (auto simp add: set_zip)
        hence "(w' \<bowtie>\<^sub>s (to_set a) (to_set (Union A))) < 0"
          using * set_share_set[of a "Union A" w']
          using `inv (Union A)`
          using pow_inv[of "Union A"]
          by auto
      }
      thus ?thesis
        by (auto dest!: set_takeWhileD)
    qed
  next
    show "finite F"
      by fact
  next
    show "UnionClosed.union_closed_additional F (f_to_set (close A))"
      using `UnionClosed.union_closed_additional F (closure A')` `A' = f_to_set A`
      using close_set[of A]
      by simp
  next
    show "\<forall>x\<in>F - f_to_set []. ((w' \<bowtie>\<^sub>s x (to_set (Union A))) < 0 \<longrightarrow> 
      x \<in> f_to_set (map fst ?L))"
    proof(safe)
      fix x
      assume "x \<in> F" "(w' \<bowtie>\<^sub>s x (to_set (Union A))) < 0"
      have "x \<subseteq> to_set (Union A)"
        using `\<forall> x \<in> F. x \<subseteq> \<Union> A'` `x \<in> F`
        using Union_set[of A] `A' = f_to_set A`
        by simp
      hence "x \<in> f_to_set ?P"
        using pow_set[of "Union A"]
        by simp
      then obtain x' where "x = to_set x'" "x' \<in> set ?P" "inv x'"
        using pow_inv[of "Union A"] `inv (Union A)`
        by auto
      have "(x', set_share_map x' w (Union A)) \<in> set ?L"
        apply (rule sorted_takeWhile_snd_neg[of ?U ?P])
        using `x' \<in> set ?P` `x = to_set x'`
        using `(w' \<bowtie>\<^sub>s x (to_set (Union A))) < 0` `inv (Union A)` `inv x'`
        using set_share_set *
        by auto
      thus "x \<in> f_to_set (map fst ?L)"
        using `x = to_set x'`
        by (force simp add: comp_def)
    qed
  next
    show "distinct ?L"
      using `inv (Union A)`
      by (auto intro!: distinct_takeWhile distinct_zipI1 pow_distinct)
  qed simp_all
qed

lemma some_share_negativeSound:
assumes
  "\<forall>l\<in>set A. inv l"
  "A' = f_to_set A"
  "\<forall>x\<in>A'. finite x"
  "\<forall>x\<in>\<Union>A'. Mapping.lookup w x = Some (w' x)"
  shows "some_share_negative A w = False \<Longrightarrow> uce_shares_nonneg A' w'"
proof
  fix F
  assume "some_share_negative A w = False" "F \<in> \<lbrace>A'\<rbrace>"
  hence "UnionClosed.union_closed F" "F \<subseteq> Pow (\<Union> A')"  "\<forall>A''\<in>F. op \<union> A'' ` A' \<subseteq> F"
    by auto

  have "finite F" "\<forall> x \<in> F. finite x"
    using `F \<subseteq> Pow (\<Union> A')` `\<forall> X \<in> A'. finite X` `A' = f_to_set A`
    by (auto simp add: finite_subset)

  show "0 \<le> (w' \<bowtie>\<^sub>f F (\<Union>A'))"
  proof (subst `A' = f_to_set A`, rule some_share_negativeFalse_FamilyShare)
    show "some_share_negative A w = False"
      by fact
  next
    show "UnionClosed.union_closed_additional F (closure (f_to_set A))"
      apply (subst `A' = f_to_set A`[THEN sym])
      using `UnionClosed.union_closed F`
    proof (auto)
      fix A'' x
      assume "A'' \<in> F" "x \<in> closure A'"
      hence "x \<union> A'' \<in> F"
        using `UnionClosed.union_closed F` `\<forall> A'' \<in> F. image (op \<union> A'') A' \<subseteq> F`
        using closure_additional_set[of A' x A'' F] `A' = f_to_set A`
        by simp
      thus "A'' \<union> x \<in> F"
        by (simp add: Un_commute)
    qed
  next
    show "finite F"
      by fact
  next
    show "\<forall>l\<in>set A. inv l"
      by fact
  next
    show "\<forall> x \<in> F. x \<subseteq> \<Union> f_to_set A"
      using `A' = f_to_set A`
      using `F \<subseteq> Pow (\<Union> A')`
      by auto
  next
    show "\<forall> a \<in> \<Union> f_to_set A. Mapping.lookup w a = Some (w' a)"
      using `\<forall> x \<in> \<Union> A'. Mapping.lookup w x = Some (w' x)`
      using `A' = f_to_set A`
      by auto
  qed simp
qed

end

subsection{* Interpretations *}

subsubsection{* Representation of sets by lists *}

global_interpretation SomeShareNegativeImpl_lists:
  SomeShareNegativeImpl "\<lambda> (l::nat list). sorted l \<and> distinct l" List.set set_weight_l set_weight_map_l "[]" merge Pow_l  
proof qed

(*
lemma some_share_negativeSound_lists:
  assumes "finite A" "\<forall> X \<in> A. finite X" 
  "A' = sorted_list_of_set (sorted_list_of_set ` A)"
  "w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w"
  shows "SomeShareNegativeImpl_lists.some_share_negative A' w' = False \<Longrightarrow> uce_shares_nonneg A w"
proof (rule SomeShareNegativeImpl_lists.some_share_negativeSound)
  have "A = f_to_set_l A'"
  proof-
    have "\<forall> x \<in> A. x \<in> set ` sorted_list_of_set ` A"
    proof (safe)
      fix x
      assume "x \<in> A"
      show "x \<in> set ` sorted_list_of_set ` A"
        apply (rule rev_image_eqI[of "sorted_list_of_set x"])
        using  `\<forall> x \<in> A. finite x` `x \<in> A`
        by auto
    qed
    thus ?thesis
      using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set  A)`
      by auto
  qed
  thus "A = f_to_set_l A'"
    unfolding f_to_set_l_def
    by simp

  show "\<forall>x\<in>\<Union>A. Mapping.lookup w' x = Some (w x)"
    using `w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w`
    using `A = f_to_set_l A'`
    by auto

  show "\<forall>l\<in>set A'. sorted l \<and> distinct l"
    using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set A)`
    using sorted_list_of_set[of "sorted_list_of_set ` A"] `\<forall> x \<in> A. finite x`
    by auto
qed (simp_all add: assms)
*)

subsubsection{* Representation of sets by natural numbers *}

global_interpretation SomeShareNegativeImpl_nats:
  SomeShareNegativeImpl "\<lambda> n. True" "set \<circ> nat2list" set_weight_n set_weight_map_n 0 bitor pow_n 
  defines
    insert_and_close_additional_cached_n = "SomeShareNegativeImpl_nats.insert_and_close_additional_cached" and
    some_share_negative_aux_5_n = "SomeShareNegativeImpl_nats.some_share_negative_aux_5" and
    some_share_negative_n = "SomeShareNegativeImpl_nats.some_share_negative"
  by (unfold_locales)

definition some_share_negative where
  "some_share_negative A w \<equiv> some_share_negative_n (map list2nat A) w"

(*
lemma some_share_negative_soundness_nats:
  assumes "finite A" "\<forall> X \<in> A. finite X" 
  "A' = sorted_list_of_set (sorted_list_of_set ` A)"
  "w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w"
  shows "some_share_negative A' w' = False \<Longrightarrow> uce_shares_nonneg A w"
proof (rule SomeShareNegativeImpl_nats.some_share_negativeSound)
  show "A = SetImpl_nats.f_to_set (map list2nat A')"
  proof-
    have "\<forall> x \<in> A. x \<in> (set \<circ> nat2list) ` (list2nat \<circ> sorted_list_of_set) ` A"
    proof (safe)
      fix x
      assume "x \<in> A"
      show "x \<in> (set \<circ> nat2list) ` (list2nat \<circ> sorted_list_of_set) ` A"
        apply (rule rev_image_eqI[of "list2nat (sorted_list_of_set x)"])
        using  `\<forall> x \<in> A. finite x` `x \<in> A`
        using nat2list_list2nat[of "sorted_list_of_set x"]
        by auto
    qed
    thus ?thesis
      using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set A)`
      using nat2list_list2nat
      by auto
  qed

  show "\<forall>x\<in>\<Union>A. Mapping.lookup w' x = Some (w x)"
    using `w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w`
    using `A = SetImpl_nats.f_to_set (map list2nat A')`
    by auto
qed (simp_all add: assms some_share_negative_def)
*)

lemma some_share_negative_soundness_nats:
  assumes "finite A" "\<forall> X \<in> A. finite X" 
    "set (map set A') = A"
    "\<forall> X \<in> set A'. distinct X \<and> sorted X" 
    "w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w"
  shows "some_share_negative A' w' = False \<Longrightarrow> uce_shares_nonneg A w"
proof (rule SomeShareNegativeImpl_nats.some_share_negativeSound)
  show "A = f_to_set_n (map list2nat A')"
  proof-
    have "(set \<circ> nat2list \<circ> list2nat) ` set A' = set ` set A'"
      using `\<forall> X \<in> set A'. distinct X \<and> sorted X`
      using nat2list_list2nat
      by force
    thus ?thesis
      using `set (map set A') = A`
      by simp
  qed

  show "\<forall>x\<in>\<Union>A. Mapping.lookup w' x = Some (w x)"
    using `w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w`
    using `A = SetImpl_nats.f_to_set (map list2nat A')`
    by auto
qed (simp_all add: assms some_share_negative_def)

definition weights2map where
 "weights2map l = foldl (\<lambda> w (k, v). w (k := v)) (\<lambda> _. 0) l"

lemma weights2map_snoc[simp]: "weights2map (xs @ [x]) = (weights2map xs) (fst x := snd x)"
by (simp add: weights2map_def split_def)

definition ssn where
"ssn f w = some_share_negative f (tabulate w)"

(* ************************************************************************************* *)

end
