section{* Weights and shares *}

theory WeightsShares
imports Main Frankl
begin

(* ************************************************************************** *)
subsection{* Weight functions *}
(* ************************************************************************** *)

text{* A technique, introduced by Poonen, used for analyzing Frankl's conjecture 
is based on the concept of weights and shares. *}

definition weight_fun :: "('a \<Rightarrow> 'b::{zero,ord}) \<Rightarrow> 'a set \<Rightarrow> bool" where
  "weight_fun w X \<equiv> (\<forall> a \<in> X. w a \<ge> 0) \<and> (\<exists> a \<in> X. w a > 0)"

definition set_weight :: "('a \<Rightarrow> 'b::{comm_monoid_add}) \<Rightarrow> 'a set \<Rightarrow> 'b" (infixl "\<rhd>\<^sub>s" 100) where 
  "w \<rhd>\<^sub>s S = (\<Sum>x\<in>S. w x)"

definition family_weight :: "('a \<Rightarrow> 'b::{comm_monoid_add}) \<Rightarrow>'a set set \<Rightarrow>  'b" (infixl "\<rhd>\<^sub>f" 100) where 
  "w \<rhd>\<^sub>f F = (\<Sum>S\<in>F. w \<rhd>\<^sub>s S)"

lemma set_weight_cong:
  assumes "\<forall> v \<in> S. w v = w' v"
  shows "w \<rhd>\<^sub>s S = w' \<rhd>\<^sub>s S"
using assms
unfolding set_weight_def
by (subst sum.cong) auto

lemma family_weight_lemma:
  assumes "finite (\<Union> F)"
  shows "w \<rhd>\<^sub>f F = (\<Sum>a\<in>\<Union>F. (w a) * count a F)"
proof-
  have "w \<rhd>\<^sub>f F = (\<Sum>S\<in>F. \<Sum>a\<in>S. w a)"
    by (simp add: family_weight_def set_weight_def)
  also have "... = (\<Sum>a\<in>\<Union> F. (w a)* (\<Sum>_\<in>{S \<in> F. a \<in> S}. 1))"
  proof-
    let ?S = "\<lambda> a. {S \<in> F. a \<in> S} \<times> {a}"
    let ?S' = "\<lambda> x. {(S, a). S \<in> F \<and> a \<in> S}"
    let ?CS = "?S ` (\<Union> F)"

    have "(\<Sum>S\<in>F. \<Sum>a\<in>S. w a) = (\<Sum>(S, a)\<in>(SIGMA S:F. S). w a)" 
      using assms
      by (simp add: sum.Sigma finiteUn_iff)
    also have "... = (\<Sum>(S, a) \<in> ?S' a. w a)"
      using Collect_case_prod_Sigma[of "\<lambda> x. x \<in> F" "\<lambda> x y. y \<in> x", THEN sym]
      by auto
    also have "... = (\<Sum>(S, a)\<in>\<Union>?CS. w a)"
      by (rule sum.cong) auto
    also have "... = (\<Sum>A\<in>?CS. (\<Sum>x\<in>A. w(snd x)))"
      using assms
      by (subst sum.Union_disjoint) (auto simp add: split_def finiteUn_iff)
    also have "... = (\<Sum>a\<in>\<Union> F. (\<Sum>x\<in>?S a. w (snd x)))"
    proof (subst sum.reindex)
      show "sum (sum (\<lambda>x. w (snd x)) \<circ> ?S) (\<Union>F) = (\<Sum>a\<in>\<Union> F. sum (\<lambda> x. w (snd x)) (?S a))"
      proof (rule sum.cong)
        fix a
        assume "a \<in> \<Union> F"
        have "sum (\<lambda> x. w (snd x)) (?S a) = sum (\<lambda> x. (w a)) (?S a)"
          by (rule sum.cong) auto
        thus "(sum (\<lambda>x. w (snd x)) \<circ> ?S) a = (\<Sum>x\<in>{S \<in> F. a \<in> S} \<times> {a}. w (snd x))"
          using assms `a \<in> \<Union> F`
          by auto
      qed simp
    next
      show "inj_on ?S (\<Union> F)"
        unfolding inj_on_def
        by auto
    qed
    also have "... = (\<Sum>a\<in>\<Union>F. w a * (\<Sum>x\<in>{S \<in> F. a \<in> S}. 1))"
    proof (rule sum.cong)
      fix a
      assume "a \<in> \<Union> F"
      have "sum (\<lambda> x. w (snd x)) (?S a) = sum (\<lambda> x. (w a)) (?S a)"
        by (rule sum.cong) auto
      thus "(\<Sum>x\<in>{S \<in> F. a \<in> S} \<times> {a}. w (snd x)) = w a * (\<Sum>x\<in>{S \<in> F. a \<in> S}. 1)"
        unfolding count_def
        using assms `a \<in> \<Union> F`
        by (auto simp add: finiteUn_iff)
    qed simp
    finally show ?thesis
      .
  qed
  also have "... = (\<Sum>a\<in>\<Union> F. (w a)* (count a F))"
    unfolding count_def
    by simp
  finally
  show ?thesis
    .
qed

lemma sum_card_reorder:
  assumes "finite (\<Union> F)"
  shows "(\<Sum>A\<in>F. card A) = (\<Sum>a\<in>\<Union>F. count a F)"
using assms family_weight_lemma[of F "\<lambda> _. 1"]
by (simp add: family_weight_def set_weight_def)

(* ************************************************************************** *)
subsection{* Shares *}
(* ************************************************************************** *)

definition set_share :: "'a set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> int" where 
  "set_share S w X \<equiv> 2 * int (w \<rhd>\<^sub>s S) - int (w \<rhd>\<^sub>s X)"
syntax
  "_set_share" :: "'a set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> int"    ("_ \<bowtie>\<^sub>s _ _")
translations 
  "w \<bowtie>\<^sub>s S X" == "CONST set_share S w X"

definition family_share :: "'a set set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> int"  where 
  "family_share F w X \<equiv> (\<Sum>S \<in> F. (w \<bowtie>\<^sub>s S X))"
syntax
  "_family_share" :: "'a set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> int"    ("_ \<bowtie>\<^sub>f _ _")
translations 
  "w \<bowtie>\<^sub>f F X" == "CONST family_share F w X"

lemma family_share_cong:
  assumes "\<forall> v \<in> X. w v = w' v" "\<Union> F \<subseteq> X"
  shows "(w \<bowtie>\<^sub>f F X) = (w' \<bowtie>\<^sub>f F  X)"
proof-
  have "w \<rhd>\<^sub>s X = w' \<rhd>\<^sub>s X"
    using set_weight_cong[of X w w']
    using assms
    by auto
  moreover
  {
    fix S
    assume "S \<in> F"
    hence "w \<rhd>\<^sub>s S =  w' \<rhd>\<^sub>s S"
      using set_weight_cong[of S w w']
      using assms
      by auto
  }
  ultimately
  show ?thesis
    unfolding family_share_def set_share_def
    by simp
qed

lemma family_share_Pow:
  assumes "finite (\<Union> F)"
  shows "(w \<bowtie>\<^sub>f (Pow (\<Union> F)) (\<Union> F)) = 0"
proof-
  let ?X = "\<Union> F"
  let ?P = "Pow ?X"
  have "\<forall> S \<in> ?P. (w \<bowtie>\<^sub>s S ?X) + (w \<bowtie>\<^sub>s (?X - S) ?X) = 0"
  proof
    fix S
    assume "S \<in> ?P"
    hence "finite S" "finite (?X - S)" "S \<union> \<Union> F = \<Union> F"
      using assms
      by (auto simp add: finite_subset)
    thus "(w \<bowtie>\<^sub>s S ?X) + (w \<bowtie>\<^sub>s (?X - S) ?X) = 0"
      unfolding set_share_def set_weight_def
      using sum.union_disjoint[of "S" "?X - S" w]
      by (auto simp add: field_simps)
  qed
  moreover
  have "(\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s S ?X)) + (\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s (?X - S) ?X)) = 
            (\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s S ?X) + (w \<bowtie>\<^sub>s (?X - S) ?X))"
    using `finite (\<Union> F)`
    by (auto simp add: sum.distrib)
  ultimately
  have "(\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s S ?X)) + (\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s (?X - S) ?X)) = 0"
    by auto
  moreover
  have "(\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s (?X - S) ?X)) = (\<Sum>S\<in>Pow ?X. (w \<bowtie>\<^sub>s S ?X))"
  proof-
    have "inj_on (op - (\<Union>F)) ?P"
      unfolding inj_on_def
      by auto
    moreover
    have "op - (\<Union>F) ` ?P = ?P"
      by auto
    ultimately
    show ?thesis
      using sum.reindex[of "\<lambda> S. ?X - S" "Pow ?X" "\<lambda> S. (w \<bowtie>\<^sub>s S ?X)", THEN sym]
      by auto
  qed
  hence "(\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s S ?X)) + (\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s (\<Union>F - S) ?X))  = 2 * (\<Sum>S\<in>?P. (w \<bowtie>\<^sub>s S ?X))"
    by auto
  ultimately
  show ?thesis
    unfolding family_share_def
    by simp
qed

lemma family_share_lemma:
  shows "(w \<bowtie>\<^sub>f F X) = int (2 * w \<rhd>\<^sub>f F) - int (w \<rhd>\<^sub>s X * (card F))"
unfolding family_share_def set_share_def family_weight_def
unfolding diff_conv_add_uminus
by (subst sum.distrib, subst sum_distrib_left[THEN sym]) (auto simp add: int_sum)

(* ************************************************************************** *)
subsection{* Hypercube construction *}
(* ************************************************************************** *)
definition hypercube :: "'a set \<Rightarrow> 'a set \<Rightarrow> 'a set set" where 
  "hypercube K S \<equiv> {L. (K \<subseteq> L) \<and> L \<subseteq> (K \<union> S)}"
syntax
  "_hypercube" :: "'a set \<Rightarrow> 'a set \<Rightarrow> 'a set set"    ("\<langle>_, _\<rangle>")
translations 
  "\<langle>K, S\<rangle>" == "CONST hypercube K S"

lemma hypercube_Pow: "\<langle>K, S\<rangle> = (op \<union> K) ` Pow S" (is "?H = ?KP")
proof
  show "?H \<subseteq> ?KP"
  proof
    fix M
    assume "M \<in> \<langle>K, S\<rangle>"
    then obtain L where "L \<subseteq> S" "M = K \<union> L"
      unfolding hypercube_def
      by auto
    thus "M \<in> ?KP"
      by auto
  qed
  show "?KP \<subseteq> ?H"
    unfolding hypercube_def
    by auto
qed

lemma hypercube_inter:
  assumes "K1 \<noteq> K2" and "K1 \<inter> S = {}" and "K2 \<inter> S = {}"
  shows "\<langle>K1, S\<rangle> \<inter> \<langle>K2, S\<rangle> = {}"
using assms
unfolding hypercube_def
by auto

lemma hypercube_UN_Pow:
  shows "\<Union> ((\<lambda> K. \<langle>K, S\<rangle>) ` (Pow K)) = Pow (K \<union> S)" (is "?lhs = ?rhs")
proof
  show "?lhs \<subseteq> ?rhs"
    unfolding hypercube_def
    by auto
next
  show "?rhs \<subseteq> ?lhs"
  proof
    fix X
    assume "X \<in> ?rhs"
    show "X \<in> ?lhs"
    proof-
      let ?Kx = "X \<inter> K"
      let ?Cx = "\<langle>?Kx, S\<rangle>"
      have "?Kx \<in> Pow K"
        by auto
      moreover
      have "X \<in> ?Cx"
        using `X \<in> ?rhs`
        unfolding hypercube_def
        by auto
      ultimately
      show ?thesis
        by blast
    qed
  qed
qed

definition hyper_share where 
  "hyper_share K S F w X \<equiv> (\<Sum>L \<in> \<langle>K, S\<rangle> \<inter> F. (w \<bowtie>\<^sub>s L X))"
syntax
  "_hyper_share" :: "('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> 'a set \<Rightarrow> 'a set set \<Rightarrow> 'a set \<Rightarrow> int"   ("_ \<odot>\<^sub>f\<^sub> _ _ _ _")
translations 
  "w \<odot>\<^sub>f\<^sub> K S F X" == "CONST hyper_share K S F w X"

lemma family_share_hyper_share:
  assumes "finite (\<Union> F)"
  assumes "K' \<union> S = (\<Union> F)" and "K' \<inter> S = {}"
  shows "(w \<bowtie>\<^sub>f F (\<Union> F)) = (\<Sum>K \<in> Pow K'. (w \<odot>\<^sub>f\<^sub> K S F (\<Union> F)))"
proof-
  let ?w = "\<lambda> S. (w \<bowtie>\<^sub>s S (\<Union> F))"
  let ?H = "\<lambda>K. \<langle>K, S\<rangle> \<inter> F"
  let ?K = "Pow K'"
  let ?C = "?H ` ?K"

  have "\<Union> ?C = F"
    using hypercube_UN_Pow[of S K'] assms
    by auto
  moreover
  have "(\<Sum>K \<in> ?K. (w \<odot>\<^sub>f\<^sub> K S F (\<Union> F))) = (\<Sum>L \<in> \<Union> ?C. ?w L)"
  proof-
    have "(\<Sum>L \<in> \<Union> ?C. ?w L) = sum (sum ?w) ?C"
    proof (subst sum.Union_disjoint)
      show "\<forall> L \<in> ?C. finite L"
        using `finite (\<Union> F)`
        by (simp add: finiteUn_iff)
    next
      show "\<forall>A\<in>?C. \<forall>B\<in>?C. A \<noteq> B \<longrightarrow> A \<inter> B = {}"
      proof
        fix A assume "A \<in> ?C"
        then obtain Ka where *: "Ka \<in> ?K" "?H Ka = A"
          by auto
        
        show "\<forall>B\<in>?C. A \<noteq> B \<longrightarrow> A \<inter> B = {}"
        proof
          fix B assume  "B \<in> ?C"
          then obtain Kb where **: "Kb \<in> ?K" "?H Kb = B"
            by auto
          show "A \<noteq> B \<longrightarrow> A \<inter> B = {}"
          proof
            assume "A \<noteq> B"
            hence "Ka \<noteq> Kb"
              using * **
              by auto
            moreover
            have "Ka \<inter> S = {}" "Kb \<inter> S = {}"
              using `Ka \<in> ?K` `Kb \<in> ?K`
              using assms
              by auto
            ultimately
            have "\<langle>Ka, S\<rangle> \<inter> \<langle>Kb, S\<rangle> = {}"
              using hypercube_inter[of Ka Kb S]
              by simp
            thus "A \<inter> B = {}"
              using * **
              by auto
          qed
        qed
      qed
    qed simp
    also have "... = (\<Sum>K\<in>?K. sum ?w (?H K))"
    proof (subst sum.reindex_nontrivial)
      show "finite ?K"
        using assms
        using finite_subset[of K' "\<Union> F"]
        by auto
    next
      fix Kx Ky
      assume "Kx \<in> ?K" "Ky \<in> ?K" "Kx \<noteq> Ky" "?H Kx = ?H Ky"
      hence "\<langle>Kx, S\<rangle> \<inter> \<langle>Ky, S\<rangle> = {}"
        using hypercube_inter[of Kx Ky S] assms
        by force
      with `?H Kx = ?H Ky`
      have "?H Kx = {}"
        by auto
      thus "sum ?w (?H Kx) = 0"
        by auto
    qed simp
    finally show ?thesis
      unfolding hyper_share_def
      by simp
  qed
  ultimately
  show ?thesis
    unfolding family_share_def hyper_share_def
    by simp
qed

end
