subsection{* Abstract representation of sets and families with weights and shares *}

theory WeightsSharesImpl
imports WeightsShares FamilyImpl
        "HOL-Library.Mapping"
        "HOL-Library.RBT_Mapping" "HOL-Library.RBT_Impl"
begin

locale SetWeightsSharesImpl = SetImpl to_set inv for 
  inv :: "'s \<Rightarrow> bool" and to_set :: "'s \<Rightarrow> 'a set" +
  fixes set_weight :: "('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> nat"
  assumes set_weight_set: "inv A \<Longrightarrow> set_weight w A = w \<rhd>\<^sub>s to_set A"
begin

definition set_share :: "'s \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> int" where
 "set_share A w X = 2 * int (set_weight w A) - int (set_weight w X)"

definition family_share :: "'s list \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> int" where
  "family_share F w X = sum_list (map (\<lambda> A. set_share A w X) F)"

lemma set_share_set:
  assumes "inv x" and "inv X"
  shows "set_share x w X = (w \<bowtie>\<^sub>s (to_set x) (to_set X))"
unfolding WeightsShares.set_share_def set_share_def
using assms
by (auto simp add: set_weight_set)

lemma family_share_set:
  assumes "distinct F" and "\<forall> l \<in> set F. inv l" and "inv X"
  shows "family_share F w X = (w \<bowtie>\<^sub>f (f_to_set F) (to_set X))"
unfolding family_share_def WeightsShares.family_share_def
apply (subst sum_list_distinct_conv_sum_set)
using assms
apply simp_all
apply (subst sum.reindex)
using assms
apply (auto simp add: to_set_inj_on)
apply (rule sum.cong)
using assms
by (auto simp add: set_share_set)

end (* Locale *)

subsubsection{* Implementation by sorted and distinct lists *}

definition set_weight_l :: "('a \<Rightarrow> nat) \<Rightarrow> 'a list \<Rightarrow> nat"where
 "set_weight_l w S = sum_list (map w S)"

lemma set_weight_l:
  assumes "distinct A"
  shows "set_weight_l w A = w \<rhd>\<^sub>s set A"
unfolding set_weight_l_def set_weight_def
apply (subst sum_list_distinct_conv_sum_set)
using assms
by simp_all

global_interpretation SetWeightsSharesImpl_lists: SetWeightsSharesImpl "\<lambda> (l::nat list). sorted l \<and> distinct l" set set_weight_l
by (unfold_locales) (simp add: set_weight_l)

subsubsection{* Implementation by natural numbers *}

definition set_weight_n :: "(nat \<Rightarrow> nat) \<Rightarrow> nat \<Rightarrow> nat" where
  "set_weight_n w n = sum_list (map w (nat2list n))"

lemma set_weight_n:
  shows "set_weight_n w A = w \<rhd>\<^sub>s set (nat2list A)"
unfolding set_weight_n_def set_weight_def
by (subst sum_list_distinct_conv_sum_set) (simp_all add: distinct_nat2list)

global_interpretation SetWeightsSharesImpl_nats: SetWeightsSharesImpl "\<lambda> _. True" "set \<circ> nat2list" set_weight_n
by (unfold_locales) (simp add: set_weight_n)

subsection{* Weight functions implemented by mappings *}

locale SetWeightsSharesMapImpl = SetWeightsSharesImpl inv to_set set_weight for 
  inv :: "'s \<Rightarrow> bool" and to_set :: "'s \<Rightarrow> 'a set" and set_weight :: "('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> nat" + 
  
  fixes set_weight_map :: "('a, nat) mapping \<Rightarrow> 's \<Rightarrow> nat"
  assumes set_weight_map: 
  "\<lbrakk>inv A; \<forall> x \<in> to_set A. Mapping.lookup wm x = Some (w x)\<rbrakk> \<Longrightarrow> 
      set_weight_map wm A = set_weight w A"
begin

abbreviation set_share_map :: "'s \<Rightarrow> ('a, nat) mapping \<Rightarrow> 's \<Rightarrow> int" where
 "set_share_map A w X \<equiv> 2 * int(set_weight_map w A) - int (set_weight_map w X)"

end (* Locale *)

subsubsection{* Representation of sets by lists *}

definition set_weight_map_l :: "('a, nat) mapping \<Rightarrow> 'a list \<Rightarrow> nat" where
  "set_weight_map_l w S = sum_list (map (the \<circ> (Mapping.lookup w)) S)"

lemma set_weight_map_l: 
  "\<lbrakk>distinct A; \<forall> x \<in> set A. Mapping.lookup wm x = Some (w x)\<rbrakk> \<Longrightarrow> 
     set_weight_map_l wm A = set_weight_l w A"
unfolding set_weight_l_def set_weight_map_l_def
using sum_list_distinct_conv_sum_set[of A w]
using sum_list_distinct_conv_sum_set[of A "the \<circ> (Mapping.lookup wm)"]
by auto

global_interpretation SetWeightsSharesMapImpl_lists:
  SetWeightsSharesMapImpl "\<lambda> (l::nat list). sorted l \<and> distinct l" List.set set_weight_l set_weight_map_l
proof (unfold_locales)
  fix A and wm :: "('a::linorder, nat) mapping" and w
  assume "sorted A \<and> distinct A" "\<forall>x\<in>set A. Mapping.lookup wm x = Some (w x)"
  thus "set_weight_map_l wm A = set_weight_l w A"
    by (simp add: set_weight_map_l)
qed

subsubsection{* Representation of sets by natural numbers *}

definition set_weight_map_n :: "(nat, nat) Mapping.mapping \<Rightarrow> nat \<Rightarrow> nat" where
  "set_weight_map_n w n = sum_list (map (the \<circ> (Mapping.lookup w)) (nat2list n))"

global_interpretation SetWeightsSharesCachedImpl_nats:
  SetWeightsSharesMapImpl "\<lambda> _. True" "List.set \<circ> nat2list" set_weight_n set_weight_map_n
proof
  fix A wm and w :: "nat \<Rightarrow> nat"
  assume "\<forall>x\<in>(set \<circ> nat2list) A. Mapping.lookup wm x = Some (w x)"
  thus "set_weight_map_n wm A = set_weight_n w A"
    unfolding set_weight_n_def set_weight_map_n_def
    using distinct_nat2list[of A]
    by (auto simp add: sum_list_distinct_conv_sum_set)
qed

end