section{* FC families characterization using shares (Poonen's theorem) *}
theory WeightsShares_FCFamily
imports WeightsShares_Frankl
begin

subsection{* HyperCube projection *}

abbreviation hypercube_prj where
 "hypercube_prj K S F \<equiv> (\<lambda>S. S - K) ` (F \<inter> op \<union> K ` Pow S)"

syntax
  "_hypercube_prj" :: "'a set \<Rightarrow> 'a set \<Rightarrow> 'a set set \<Rightarrow> 'a set set"    ("\<langle>_, _, _\<rangle>")
translations 
  "\<langle>K, S, F\<rangle>" == "CONST hypercube_prj K S F"


lemma hypercube_prj_union_closed:
  assumes "union_closed F"
  shows "union_closed \<langle>K, S, F\<rangle>"
unfolding union_closed_def
proof ((rule allI)+, rule impI, erule conjE)
  fix A B
  let ?F = "hypercube_prj K S F"
  let ?HC = "op \<union> K ` Pow S"
  assume "A \<in> ?F" "B \<in> ?F"
  then obtain a b where 
    *: "a \<in> F" "a \<in> ?HC" "A = a - K" "A \<in> Pow S"
       "b \<in> F" "b \<in> ?HC" "B = b - K" "B \<in> Pow S"
    by auto

  show "A \<union> B \<in> ?F"
  proof (rule rev_image_eqI[of "a \<union> b"])
    show   "a \<union> b \<in> F \<inter> ?HC"
    proof
      show "a \<union> b \<in> F"
        using `a \<in> F` `b \<in> F` `union_closed F`
        unfolding union_closed_def
        by auto
    next
      show "a \<union> b \<in> ?HC"
        apply (rule rev_image_eqI[of "A \<union> B"])
        using *
        by auto
    qed
  next
    show "A \<union> B = a \<union> b - K"
      using *
      by auto
  qed
qed

lemma hypercube_prj_union_closed_additional:
  assumes "union_closed F" and "Fc \<subseteq> F" and "S = \<Union> Fc" and "K \<inter> S = {}" 
  shows "union_closed_additional \<langle>K, S, F\<rangle> Fc"
unfolding union_closed_additional_def
proof (rule conjI)
  let ?F = "\<langle>K, S, F\<rangle>"
  show "union_closed ?F"
    using assms by (simp add: hypercube_prj_union_closed)

  show "\<forall> A' \<in> ?F. (op \<union> A') ` Fc \<subseteq> ?F"
  proof (rule ballI, rule subsetI)
    fix A' x
    assume "A' \<in> ?F" "x \<in> op \<union> A' ` Fc"
    then obtain y where "x = y \<union> A'" "y \<in> Fc"
      by auto
    hence "x \<subseteq> S"
      using `S = \<Union> Fc` `A' \<in> ?F`
      by auto
    show "x \<in> ?F"
    proof (rule rev_image_eqI[of "K \<union> x"])
      show "x = K \<union> x - K"
        using `K \<inter> S = {}` `x \<subseteq> S`
        by auto
    next
      show "K \<union> x \<in> F \<inter> op \<union> K ` Pow S"
      proof
        show "K \<union> x \<in> op \<union> K ` Pow S"
          using `x \<subseteq> S`
          by auto
      next
        have "y \<in> F"
          using `y \<in> Fc` `Fc \<subseteq> F`
          by auto
        moreover
        have "K \<union> A' \<in> F"
          using `A' \<in> ?F`
          by auto
        ultimately
        have "K \<union> A' \<union> y \<in> F"
          using assms
          unfolding union_closed_def
          by auto
        thus "K \<union> x \<in> F"
          by (subst `x = y \<union> A'`) (subst Un_commute[of y A'], subst Un_assoc[THEN sym])
      qed
    qed
  qed
qed

lemma set_weight_w0:
  assumes "finite K" and "finite S"
  assumes "K \<inter> S = {}" and "\<forall> x \<in> K. w x = 0" and "S' \<subseteq> S"
  shows "w \<rhd>\<^sub>s (K \<union> S') = w \<rhd>\<^sub>s S'"
  unfolding set_weight_def
  using assms
  using sum.union_disjoint[of K "S'" w]
  by (auto simp add: finite_subset)

lemma hypercube_prj_hyper_share_w0:
  assumes "finite S" and "finite K" and "\<forall> x \<in> K. w x = 0"
  shows "(w \<odot>\<^sub>f\<^sub> K S F X) = (w \<bowtie>\<^sub>f \<langle>K, S, F\<rangle> X)"
unfolding hyper_share_def family_share_def
proof (subst sum.reindex)
  let ?HCF = "\<langle>K, S\<rangle> \<inter> F"
  let ?HCF' = "F \<inter> op \<union> K ` Pow S"
  let ?mK = "\<lambda> S. S - K"
  let ?s = "\<lambda>S. (w \<bowtie>\<^sub>s S X)"
  show "inj_on ?mK ?HCF'"
    by (auto simp add: inj_on_def)

  show "(\<Sum>L\<in>?HCF. ?s L) = (\<Sum>L\<in>?HCF'. (?s \<circ> ?mK) L)"
  proof (rule sum.cong)
    show "?HCF = ?HCF'"
      by (auto simp add: hypercube_Pow)
  next
    fix L
    assume "L \<in> ?HCF'"
    thus "?s L = (?s \<circ> ?mK) L"
    proof (auto simp add: set_share_def)
      fix x
      assume "x \<subseteq> S"
      hence "finite x"
        using `finite S`
        by (auto simp add: finite_subset)
      thus "w \<rhd>\<^sub>s (K \<union> x) = w \<rhd>\<^sub>s (K \<union> x - K)"
        using set_weight_w0[of K "K \<union> x - K" w "K \<union> x - K"]
        using `finite K` `\<forall> x \<in> K. w x = 0`
        by simp
    qed
  qed
qed

(* ************************************************************************** *)
subsection{* All shares non-negative *}
(* ************************************************************************** *)

abbreviation uce_shares_nonneg where
  "uce_shares_nonneg Fc w \<equiv> \<forall> F' \<in> \<lbrace>Fc\<rbrace>. (w \<bowtie>\<^sub>f F' (\<Union> Fc)) \<ge> 0"

theorem frankl_uce_shares_nonneg:
  assumes "F \<noteq> {}" and "finite_union_closed F" and "weight_fun w (\<Union>F)"
  assumes  "Fc \<subseteq> F" and "\<forall> x \<in> (\<Union> F) - (\<Union> Fc). w x = 0"
  assumes "uce_shares_nonneg Fc w"
  shows "\<exists> a \<in> \<Union> Fc. frankl_element a F"
proof-
  have "\<exists> a. frankl_element a F \<and> w a \<noteq> 0"
  proof (rule frankl_hyper_share)
    show "\<forall> K\<in>Pow (\<Union> F - \<Union> Fc).  (w \<odot>\<^sub>f\<^sub> K (\<Union> Fc) F (\<Union> F)) \<ge> 0"
    proof
      fix K
      assume "K \<in> Pow (\<Union>F - \<Union>Fc)"
      show "0 \<le> (w \<odot>\<^sub>f\<^sub> K (\<Union> Fc) F (\<Union> F))"
      proof (subst hypercube_prj_hyper_share_w0)
        show "finite (\<Union>Fc)" 
          using `finite_union_closed F` `Fc \<subseteq> F`
          using finite_subset[of "\<Union> Fc" "\<Union> F"]
          by auto
        show "finite K" 
          using `K \<in> Pow (\<Union>F - \<Union>Fc)` `finite (\<Union> Fc)` `finite_union_closed F`
          by (auto simp add: finite_subset)
        show "\<forall> x \<in> K. w x = 0"
          using `K \<in> Pow (\<Union>F - \<Union>Fc)`
          using `\<forall>x\<in>\<Union>F - \<Union>Fc. w x = 0`
          by blast
        show "0 \<le> (w \<bowtie>\<^sub>f \<langle>K, \<Union>Fc, F\<rangle> (\<Union>F))"
        proof-
          let ?P = "\<langle>K, \<Union>Fc, F\<rangle>"
          have "0 \<le> (w \<bowtie>\<^sub>f ?P (\<Union>Fc))"
          proof (subst `\<forall> F' \<in> \<lbrace>Fc\<rbrace>. (w \<bowtie>\<^sub>f F' (\<Union> Fc)) \<ge> 0`)
            show "?P \<in> \<lbrace>Fc\<rbrace>"
            proof-
              have "?P \<subseteq> Pow (\<Union> Fc)"
                by auto
              moreover
              have "K \<inter> \<Union> Fc = {}"
                using `K \<in> Pow (\<Union>F - \<Union>Fc)`
                by auto
              hence "union_closed_additional ?P Fc"
                using hypercube_prj_union_closed_additional[of F Fc "\<Union> Fc" K]
                using `Fc \<subseteq> F` `K \<in> Pow (\<Union>F - \<Union>Fc)` `finite_union_closed F`
                by simp
              ultimately
              show ?thesis
                by simp
            qed
          qed simp

          moreover
          have "w \<rhd>\<^sub>s (\<Union> Fc) = w \<rhd>\<^sub>s (\<Union> F)"
          proof-
          have "\<Union> F - \<Union> Fc \<union> \<Union> Fc = \<Union> F"
            using `Fc \<subseteq> F` 
            by auto
          thus ?thesis
            using set_weight_w0[of "\<Union> F - \<Union> Fc" "\<Union> Fc" w "\<Union> Fc"]
            using `\<forall> x \<in> (\<Union> F) - (\<Union> Fc). w x = 0` `finite_union_closed F` `finite (\<Union> Fc)`
            by force
        qed
        ultimately
        show ?thesis
          unfolding family_share_def set_share_def
          by simp
      qed
    qed
  qed
next
  show "\<Union>F - \<Union>Fc \<union> \<Union>Fc = \<Union>F"
    using `Fc \<subseteq> F`
    by auto
qed (auto simp add: assms)
then obtain a where  "a \<in> \<Union> F" "card F \<le> 2 * count a F" "w a \<noteq> 0"
  by auto
moreover
have "a \<in> \<Union> Fc"
proof-
  have "a \<in> \<Union> Fc \<or> a \<in> (\<Union> F - \<Union> Fc)"
    using `a \<in> \<Union> F` `Fc \<subseteq> F`
    by auto
  moreover
  have "a \<notin> \<Union> F - \<Union> Fc"
    apply (rule ccontr)
    using `\<forall> a \<in> \<Union> F - \<Union> Fc. w a = 0` `w a \<noteq> 0`
    by auto
  ultimately
  show ?thesis
    by auto
qed
ultimately
show ?thesis
  by auto
qed

theorem FC_family_uce_shares_nonneg:
  assumes "weight_fun w (\<Union> Fc)" and "uce_shares_nonneg Fc w"
  shows "FC_family Fc"
using assms
unfolding FC_family_def
proof (safe)
  fix F
  assume "uce_shares_nonneg Fc w" "Fc \<subseteq> F" "union_closed F" "finite (\<Union> F)"
  let ?w'  = "\<lambda> a. if a \<in> \<Union> Fc then w a else 0"
  have "\<exists>a\<in>\<Union>Fc. frankl_element a F"
  proof (rule frankl_uce_shares_nonneg)
    have "\<Union> Fc \<subseteq> \<Union> F"
      using `Fc \<subseteq> F`
      by auto
    show "weight_fun ?w' (\<Union> F)"
      using `weight_fun w (\<Union> Fc)` `Fc \<subseteq> F`
      unfolding weight_fun_def
      by auto 
  next
    show "\<forall>x\<in>\<Union>F - \<Union>Fc. ?w' x = 0"
      by auto
  next
    show "uce_shares_nonneg Fc ?w'"
    proof
      fix F'
      assume "F' \<in> \<lbrace>Fc\<rbrace>"
      hence "\<Union> F' \<subseteq> \<Union> Fc"
        by auto
      hence "(?w' \<bowtie>\<^sub>f F' (\<Union>Fc)) = (w \<bowtie>\<^sub>f F' (\<Union>Fc))"
        using family_share_cong[of "\<Union> Fc" w ?w' F']
        by auto
      thus "0 \<le> (?w' \<bowtie>\<^sub>f F' (\<Union>Fc))"
        using `uce_shares_nonneg Fc w` `F' \<in> \<lbrace>Fc\<rbrace>`
        by simp
    qed
  next
    show "Fc \<subseteq> F"
      by fact
  next
    have "Fc \<noteq> {}"
      using `weight_fun w (\<Union> Fc)`
      unfolding weight_fun_def
      by auto
    thus "F \<noteq> {}"
      using `Fc \<subseteq> F`
      by auto
  next
    show "finite_union_closed F"
      using `union_closed F` `finite (\<Union> F)`
      by simp
  qed
  thus "\<exists> a \<in> \<Union> Fc. 2 * count a F \<ge> card F"
    by auto
qed

end
