subsection{* Frankl's families characterization using weights *}

theory WeightsShares_Frankl
imports Main WeightsShares
        More.MoreBigOperators
begin

lemma frankl_weight':
  fixes w :: "'a \<Rightarrow> nat"
  assumes "F \<noteq> {}" and "finite (\<Union> F)" and "weight_fun w (\<Union> F)" and 
          "2 * (w \<rhd>\<^sub>f F) \<ge> (w \<rhd>\<^sub>s (\<Union> F)) * card F"
  shows "\<exists> x. frankl_element x F \<and> w x \<noteq> 0"
proof (rule ccontr)
  assume "\<not> ?thesis"
  hence *: "\<forall> x. x \<in> \<Union> F \<and> w x \<noteq> 0 \<longrightarrow> 2 * count x F < card F"
    by force
  obtain a0 where "a0 \<in> \<Union> F" "w a0 > 0" "\<forall>a\<in>\<Union>F. 0 \<le> w a"
    using `weight_fun w (\<Union> F)`
    unfolding weight_fun_def
    by auto

  have "2 * (w \<rhd>\<^sub>f F) = 2 * (\<Sum>a\<in>\<Union> F. (w a)* (count a F))"
    using assms family_weight_lemma
    by simp
    
  have "(\<Sum>a\<in>\<Union> F. 2 * (w a)* (count a F)) < (\<Sum>a\<in>\<Union> F. (w a) * card F)"
  proof (rule sum_mono_single_lt_nat)
    show "finite (\<Union>F)" using assms by simp
  next
    fix a
    assume "a \<in> \<Union>F" 
    thus "2 * w a * (count a F) \<le> w a * (card F)"
      using *
      by auto
  next
    show "a0 \<in> \<Union>F" using `a0 \<in> \<Union>F`  .
  next
    show "2 * w a0 * (count a0 F) < w a0 * (card F)"
      using * `a0 \<in> \<Union>F` `w a0 > 0`
      by auto
  qed
  also have "... = (w \<rhd>\<^sub>s (\<Union> F)) * card F"
    unfolding set_weight_def
    by (auto simp add: sum_distrib_right)
  finally have "2 * (\<Sum>a\<in>\<Union> F. (w a)* (count a F)) < (w \<rhd>\<^sub>s (\<Union>F)) * (card F)"
    by (auto simp add: sum_distrib_left mult.assoc)
  
  show False
    using `2 * (\<Sum>a\<in>\<Union> F. (w a)* (count a F)) < (w \<rhd>\<^sub>s (\<Union>F)) * (card F)`
    using `2 * w \<rhd>\<^sub>f F = 2 * (\<Sum>a\<in>\<Union> F. (w a)* (count a F))`
    using `2 * w \<rhd>\<^sub>f F \<ge> (w \<rhd>\<^sub>s (\<Union> F)) * (card F)`
    by simp
qed

lemma frankl_weight'':
  assumes "frankl F" and "F \<noteq> {}" and "finite (\<Union> F)"
  shows "\<exists> w::('a \<Rightarrow> nat). weight_fun w (\<Union> F) \<and>
                    2 * (w \<rhd>\<^sub>f F) \<ge> (w \<rhd>\<^sub>s (\<Union> F)) * card F"
proof-
  from `frankl F` obtain a where "a \<in> \<Union> F"
    "2 * count a F \<ge> card F"
    unfolding frankl_def
    by auto

  let ?w = "\<lambda> x. if x = a then (1::nat) else 0"
  have "card (\<Union>F \<inter> {a}) = 1"
    using `a \<in> \<Union> F`
    by auto
  hence "?w \<rhd>\<^sub>s (\<Union> F) = 1"
    using `a \<in> \<Union> F` `finite (\<Union> F)`
    unfolding set_weight_def
    by (auto simp add: sum.If_cases)

  have "\<forall> S \<in> F. ?w \<rhd>\<^sub>s S = (if a \<in> S then 1 else 0)"
    using `finite (\<Union> F)`
    unfolding set_weight_def
    by (auto simp add: sum.If_cases finiteUn_iff)
  hence "?w \<rhd>\<^sub>f F = count a F"
    unfolding count_def family_weight_def
    using `finite (\<Union> F)`
    by (auto simp add: sum.If_cases Collect_conj_eq finiteUn_iff)
  hence "2 * (?w \<rhd>\<^sub>f F) \<ge> card(F)"
    using `2 * count a F \<ge> card F`
    by auto
  hence "2 * (?w \<rhd>\<^sub>f F) \<ge> (?w \<rhd>\<^sub>s (\<Union> F)) * card F"
    by (subst `?w \<rhd>\<^sub>s (\<Union> F) = 1`) simp

  moreover
  have "weight_fun ?w (\<Union> F)"
    using `a \<in> \<Union> F`
    unfolding weight_fun_def
    by auto
  ultimately
  show ?thesis
    by auto
qed

theorem frankl_weight:
  assumes "F \<noteq> {}" and "finite (\<Union> F)"
  shows "frankl F \<longleftrightarrow>
         (\<exists> w::'a \<Rightarrow> nat. weight_fun w (\<Union> F) \<and>
                    2 * (w \<rhd>\<^sub>f F) \<ge> (w \<rhd>\<^sub>s (\<Union> F)) * card F)" (is "?lhs \<longleftrightarrow> ?rhs")
proof
  assume ?lhs
  thus ?rhs
    using assms frankl_weight''[of F]
    by auto
next
  assume ?rhs
  then obtain w where "weight_fun w (\<Union> F)" "w \<rhd>\<^sub>s (\<Union>F) * card F \<le> 2 * w \<rhd>\<^sub>f F"
    by auto
  thus ?lhs
    using assms frankl_weight'[of F w]
    unfolding frankl_def
    by auto
qed


subsection{* Frankl's families characterization using shares *}

lemma frankl_share':
  assumes "F \<noteq> {}" and "finite (\<Union> F)" "weight_fun w (\<Union> F) \<and> (w \<bowtie>\<^sub>f F (\<Union> F)) \<ge> 0"
  shows "\<exists> a. frankl_element a F \<and> w a \<noteq> (0::nat)"
 using assms
 apply (subst frankl_weight', simp_all)
 using family_share_lemma[of F w "\<Union> F"]
 by linarith

lemma frankl_share'':
  assumes "F \<noteq> {}" and "finite (\<Union> F)" and "frankl F"
  shows "\<exists> w. weight_fun w (\<Union> F) \<and> (w \<bowtie>\<^sub>f F (\<Union> F)) \<ge> 0"
using assms 
using frankl_weight''[of F]
using family_share_lemma[of F _ "\<Union>F"]
by (smt of_nat_le_iff)  

text{* Sufficient condition for Frankl using hypershares. *}
theorem frankl_share:
  assumes "F \<noteq> {}" and "finite (\<Union> F)"
  shows "frankl F \<longleftrightarrow> (\<exists> w. weight_fun w (\<Union> F) \<and> (w \<bowtie>\<^sub>f F (\<Union> F)) \<ge> 0)"
using assms frankl_share'[of F] frankl_share''[of F]
unfolding frankl_def
by force

theorem frankl_hyper_share:
  assumes "F \<noteq> {}" and "finite (\<Union> F)"
  assumes "weight_fun w (\<Union>F)"
  assumes "K' \<union> S = \<Union> F" and "K' \<inter> S = {}"
  assumes "\<forall> K \<in> Pow K'.  (w \<odot>\<^sub>f\<^sub> K S F (\<Union> F)) \<ge> 0"
  shows "\<exists> a. frankl_element a F \<and> w a \<noteq> 0 "
using assms
apply (subst frankl_share', simp_all)
using family_share_hyper_share[of F K' S] sum_nonneg
by fastforce

end
