section{* nonFC families characterization using shares (Poonen's theorem) *}
theory WeightsShares_NotFCFamily
imports Main WeightsShares_FCFamily
begin

lemma frankl_fun_hypercube:
  assumes "S = \<Union> F" and "K \<inter> S = {}" and "a \<notin> K" 
  shows "frankl_fun a (op \<union> K ` F) = frankl_fun a F"
proof-
  have inj: "inj_on (op \<union> K) F"
    using assms
    by (auto simp add: inj_on_def)
  have "count a (op \<union> K ` F) = count a F"
  proof-
    have *: "{A \<in> op \<union> K ` F. a \<in> A} = op \<union> K ` {A \<in> F. a \<in> A}"
      using `a \<notin> K`
      by auto
    show ?thesis
      unfolding count_def
      using `S = \<Union> F` `K \<inter> S = {}` inj
      by (subst *) (rule card_image, simp add: inj inj_on_def)
  qed
  moreover
  have "card (op \<union> K ` F) = card F"
    by (rule card_image) (simp add: inj)
  ultimately
  show "frankl_fun a (op \<union> K ` F)= frankl_fun a F"
    by simp
qed

lemma sum_over_spread:
  fixes d c :: nat and f
  assumes "d \<noteq> 0"
  shows "(\<Sum>s\<leftarrow>[0..<d * c]. f (s div d)) = int d * (\<Sum>s\<leftarrow>[0..<c]. f s)"
proof (induct c)
  case 0
  thus ?case
    by simp
next
  case (Suc c)
  show ?case
  proof-
    have "[0..<d * Suc c] = [0..<d * c] @ [d * c..<d * Suc c]"
      using upt_add_eq_append[of 0 "d * c" "d * (Suc c) - d * c"]
      by (auto simp add: add.commute)
    hence "(\<Sum>s\<leftarrow>[0..<d * Suc c]. f (s div d)) = 
              (\<Sum>s\<leftarrow>[0..<d * c]. f (s div d)) +  (\<Sum>s\<leftarrow>[d * c..<d * Suc c]. f (s div d))"
      by auto
    moreover
    have "(\<Sum>s\<leftarrow>[d * c..<d * Suc c]. f (s div d)) = int d * f c"
    proof-
      have "\<forall> s \<in> set [d * c..<d * Suc c]. s div d = c"
      proof
        fix s
        assume "s \<in> set [d * c..<d * Suc c]"
        hence "s \<ge> d*c" "s < d*Suc c"
          by auto
        thus "s div d = c"
          using split_div_lemma[of d c s] `d \<noteq> 0`
          by simp
      qed
      hence "(\<Sum>s\<leftarrow>[d * c..<d * Suc c]. f (s div d)) = (\<Sum>s\<leftarrow>[d * c..<d * Suc c]. f c)"
        by (subst interv_sum_list_conv_sum_set_nat)+ auto
      thus ?thesis
        using sum_list_triv[of "f c" "[d * c..<d * Suc c]"]
        by auto
    qed
    ultimately
    show ?case
      using Suc
      by (auto simp add: int_distrib(2))
  qed                                   
qed

lemma archimedean_negative:
  fixes x y :: int
  assumes "y < 0"
  shows "\<exists> d. x + int d * y < 0"
proof (cases "x \<le> 0")
  case True
  thus ?thesis
    using `y<0`
    by (rule_tac x="1" in exI) auto
next
  case False
  obtain k where "k = -y" "k > 0"
    using `y < 0` by auto
  have "x * k \<ge> x"
    using False `k > 0`
    by auto
  hence "(x + 1) * k > x"
    using `k > 0`
    by (auto simp add: int_distrib(1))
  thus ?thesis
    using `k = -y`
    by (rule_tac x="nat (x + 1)" in exI) auto
qed

lemma nonFC:
  fixes Fc :: "nat set set"
  assumes "length c = length Fs"
  assumes "\<exists> cj \<in> set c. cj > 0"
  assumes "finite (\<Union> Fc)" 
  assumes "union_closed Fc"
  assumes "\<forall> F \<in> set Fs. F \<in> \<lbrace>Fc\<rbrace>"
  assumes "let Fs' = Fs 
            in (\<forall> a \<in> \<Union> Fc. sum_list (map (\<lambda> (x, y).  int x * y) (zip c (map (frankl_fun a) Fs'))) < 0)"
  shows "\<not> FC_family Fc"
proof-
  let ?X = "\<Union> Fc"

  (* Basic finiteness results *)

  have "\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X"
    using `\<forall>F \<in> set Fs. F \<in> \<lbrace>Fc\<rbrace>`
    by auto (metis Pow_iff UnionE set_mp)

  have "\<forall> F \<in> set Fs. finite F"
  proof
    fix F 
    assume "F \<in> set Fs"
    hence "finite (\<Union> F)"
      using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X` `finite ?X`
      by (auto simp add: finite_subset)
    thus "finite F"
      by (auto simp add: finiteUn_iff)
  qed
  hence "finite (\<Union> (set Fs))"
    by (auto simp add: finiteUn_iff)                                                                            

  have "finite Fc"
    using `finite (\<Union> Fc)`
    by (auto simp add: finiteUn_iff)

  (* Sum of all coefficients c *)

  let ?sum_c = "sum_list c"

  have "?sum_c > 0"
  proof-
    obtain wj where "wj \<in> set c" "wj > 0"
      using `\<exists> wj \<in> set c. wj > 0`
      by auto
    then obtain n where "n < length c" "c ! n = wj"
      by (auto simp add: in_set_conv_nth)
    thus ?thesis
      using sum_mono_single_lt_nat[of "{0..<length c}" "\<lambda> _. 0" "op ! c" n] `wj > 0`
      by (subst sum_list_sum_nth) auto
  qed

  have div: "\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> s div d < ?sum_c"
  proof (safe)
    fix d s
    assume "d > 0" "s < d * ?sum_c"
    have "s div d \<le> ?sum_c"
      using `s < d * ?sum_c` `d > 0` div_le_mono[of s "d*?sum_c" d ]
      by auto
    thus "s div d < ?sum_c"
      using `s < d * ?sum_c` `?sum_c > 0`
      by (metis Divides.div_mult2_eq div_eq_0_iff neq0_conv)
  qed

  (* Spread families Fs *)

  let ?Gs = "spread c Fs"
  have "length ?Gs = ?sum_c"
    using `length c = length Fs`
    by (rule length_spread)

  have "\<forall> i. i < ?sum_c \<longrightarrow> ?Gs ! i \<in> set Fs"
  proof (safe)
    fix i
    assume "i < ?sum_c"
    hence "?Gs ! i \<in> set ?Gs"
      using `length ?Gs = ?sum_c` div
      by auto                                                                             
    thus "?Gs ! i \<in> set Fs"
      using set_spread[of c Fs]
      by auto
  qed
  hence "\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs"
    using div
    by auto

  have "\<forall> i A B. i < ?sum_c \<and> A \<in> Fc \<and> B \<in> ?Gs ! i \<longrightarrow> A \<union> B \<in> ?Gs ! i"
  proof (safe)
    fix A B i
    assume "A \<in> Fc" "i < ?sum_c" "B \<in> ?Gs ! i"
    then obtain j where "j < length Fs" "?Gs ! i = Fs ! j"
      by (metis `\<forall>i<sum_list c. spread c Fs ! i \<in> set Fs` in_set_conv_nth)
    hence "?Gs ! i \<in> \<lbrace>Fc\<rbrace>"
      using `\<forall>F\<in>set Fs. F \<in> \<lbrace>Fc\<rbrace>`
      by auto
    thus "A \<union> B \<in> ?Gs ! i"
      using `A \<in> Fc` `B \<in> ?Gs ! i`
      unfolding union_closed_extensions_def
      by force
  qed
  hence "\<forall> d s A B. d \<noteq> 0 \<and> s < d * ?sum_c \<and> A \<in> Fc \<and> B \<in> ?Gs ! (s div d) \<longrightarrow> A \<union> B \<in> ?Gs ! (s div d)"
    using div
    by auto

  (* Obtain a new domain, distinct from ?X *)

  have "\<exists> Bd. \<forall> d. finite (Bd d) \<and> card (Bd d) = d*?sum_c + 1 \<and> (Bd d) \<inter> ?X = {}"
  proof-                                                                                                       
    let ?Bd = "\<lambda> d. (SOME B. (finite B \<and> card B = d*?sum_c + 1 \<and> B \<inter> ?X = {}))"
    show ?thesis
    proof (rule_tac x="?Bd" in exI, rule allI, rule someI_ex)
      fix d
      show "\<exists>B. finite B \<and> card B = d*?sum_c + 1 \<and> B \<inter> ?X = {}"
        using finite_disjoint_set[of ?X "d*?sum_c + 1"] `finite ?X`
        by auto
    qed
  qed
  then obtain Bd where Bd: "\<forall> d. finite (Bd d) \<and> card (Bd d) = d*?sum_c + 1 \<and> (Bd d) \<inter> ?X = {}"
    by auto

  (* Eliminate one by one element from the domain (Bd d) *)

  let ?Bds = "\<lambda> d s. set_drop_nth s (Bd d)"

  have "\<forall> d s. d > 0 \<and> s < d*?sum_c \<longrightarrow> ?Bds d s \<noteq> {}"
  proof ((rule allI)+, rule impI, erule conjE)
    fix d s
    assume "d > 0" "s < d*?sum_c"
    hence "0 < card (set_drop_nth s (Bd d))"
      using Bd `?sum_c > 0`
      by (subst card_set_drop_nth) simp_all                                                                    
    thus "?Bds d s \<noteq> {}"
      by auto                                   
  qed

  (* Construct a counterexample  *)

  let ?Hds = "\<lambda> d s. (op \<union> (?Bds d s)) ` (?Gs ! (s div d))"
  let ?Hdl = "\<lambda> d. (map (?Hds d) [0..<d*?sum_c])"
  let ?Hd = "\<lambda> d. (op \<union> (Bd d)) ` Pow ?X"
  let ?Fd = "\<lambda> d. Fc \<union> \<Union> set (?Hdl d) \<union> (?Hd d)"

  have "\<forall> s d. s < d*?sum_c \<longrightarrow> (?Hdl d) ! s = ?Hds d s"
    by simp
  have "\<forall> d s a. d \<noteq> 0 \<and> a \<in> ?X \<and> s < d*?sum_c \<longrightarrow> 
          frankl_fun a (?Hds d s) = frankl_fun a (?Gs ! (s div d))"
  proof (rule+, (erule conjE)+, rule frankl_fun_hypercube)
    fix a s d
    assume "a \<in> ?X"
    thus "a \<notin> set_drop_nth s (Bd d)"
      using set_drop_nth_subset[of "Bd d" s] Bd
      by auto
  next
    fix d s a
    assume "a \<in> ?X" "s < d * ?sum_c" "d \<noteq> 0"
    hence "?Gs ! (s div d) \<in> set Fs"
      using `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs`
      by auto
    thus "(?Bds d s) \<inter> (\<Union> (?Gs ! (s div d))) = {}"
      using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X`
      using set_drop_nth_subset[of "Bd d" s] Bd
      by blast
  qed simp

  (* counterexample families are distinct *)

  have "\<forall> d. d > 0 \<longrightarrow> Fc \<inter> \<Union> set (?Hdl d) = {}"
  proof (rule, rule, rule ccontr)
    fix d
    assume "d > 0" "\<not> Fc \<inter> \<Union> set (?Hdl d) = {}"
    then obtain S S' where "S \<in> Fc" "S' \<in> set (?Hdl d)" "S \<in> S'"
      by auto
    then obtain s A where "s < d*?sum_c" "A \<in> ?Gs ! (s div d)" "S = A \<union> (?Bds d s)"
      by force
    obtain x where "x \<in> (?Bds d s)"
      using `s < d*?sum_c` `\<forall> d s. d > 0 \<and> s < d*?sum_c \<longrightarrow> ?Bds d s \<noteq> {}` `d > 0`
      by auto
    hence "x \<in> \<Union> Fc"
      using `S = A \<union> (?Bds d s)` `S \<in> Fc`
      by blast
    thus False
      using `x \<in> (?Bds d s)` set_drop_nth_subset[of "Bd d" s] Bd
      by auto
  qed

  have "\<forall> d. d > 0 \<longrightarrow> Fc \<inter> (?Hd d) = {}"
  proof (rule, rule, rule ccontr)
    fix d
    assume "d > 0" "\<not> Fc \<inter> (?Hd d) = {}"
    then obtain S where "S \<in> Fc" "S \<in> op \<union> (Bd d) ` Pow (\<Union>Fc)"
      by auto
    then obtain A where "A \<subseteq> \<Union> Fc" "A \<union> (Bd d) = S"
      by auto
    obtain x where "x \<in> (Bd d)"
      using Bd card_gt_0_iff[of "Bd d"]
      by auto
    hence "x \<in> \<Union> Fc"
      using `A \<union> (Bd d) = S` `S \<in> Fc`
      by blast
    thus False
      using `x \<in> Bd d` Bd
      by auto
  qed

  have "\<forall> d. d > 0 \<longrightarrow> \<Union> set (?Hdl d)  \<inter> (?Hd d) = {}"
  proof (rule, rule, rule ccontr)
    fix d
    assume "d > 0" "\<not> \<Union> set (?Hdl d) \<inter> (?Hd d) = {}"
    then obtain S S' where "S \<in> (?Hd d)" "S' \<in> set (?Hdl d)" "S \<in> S'"
      by auto

    obtain A where "A \<subseteq> \<Union> Fc" "A \<union> (Bd d) = S"
      using `S \<in> (?Hd d)`
      by auto

    obtain s B where "s < d*?sum_c" "B \<in> ?Gs ! (s div d)" "S = B \<union> (?Bds d s)"
      using `S' \<in> set (?Hdl d)` `S \<in> S'`
      by force
    
    obtain a where "a \<in> Bd d" "a \<notin> (?Bds d s)"
      using `s < d*?sum_c` set_drop_nth_drops[of s "Bd d"] Bd
      by auto
    moreover
    have "B \<in> \<Union> (set Fs)"
      using `B \<in> ?Gs ! (s div d)` `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs` `d > 0` `s < d*?sum_c`
      by auto
    hence "a \<notin> B"
      using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X` `a \<in> Bd d` Bd
      by blast
    ultimately
    have "a \<in> A \<union> (Bd d)" "a \<notin> B \<union> (?Bds d s)"
      by auto
    thus False
      using `A \<union> (Bd d) = S` `S = B \<union> (?Bds d s)`
      by auto
  qed

  (* counterexample families are finite *)

  have "\<forall> d. d > 0 \<longrightarrow> finite (\<Union> set (?Hdl d))"
    using `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs`
          `\<forall> F \<in> set Fs. finite F`
    by auto

  have "\<forall> d. d > 0 \<longrightarrow> finite (?Hd d)"
    using `finite ?X`
    by auto                                                                                                  
                                                                                                             

  (* explicitly calculate the frankl_fun of a in the counterexample *)
  let ?Si = "\<lambda> a. sum_list (map (\<lambda> s. frankl_fun a (?Gs ! s)) [0..<?sum_c])"

  have "\<forall> d a. d > 0 \<and> a \<in> ?X \<longrightarrow> frankl_fun a (?Fd d) = frankl_fun a Fc + int d * ?Si a"
  proof-
  (* frankl_fun of a in the counterexample family *)
  have "\<forall> d a. d > 0 \<longrightarrow> 
    frankl_fun a (?Fd d) = 
       frankl_fun a Fc + frankl_fun a (\<Union> set (?Hdl d)) + frankl_fun a (?Hd d)"
  proof ((rule allI)+, rule impI)
    fix d i
    assume "d > (0::nat)"
    show "frankl_fun i (?Fd d) = 
      frankl_fun i Fc + frankl_fun i (\<Union> set (?Hdl d)) + frankl_fun i (?Hd d)"
    proof (rule frankl_fun_Un_disjoint_3)
      show "finite Fc" by fact
    next
      show "finite (\<Union> set (?Hdl d))"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> finite (\<Union> set (?Hdl d))`
        by simp
    next
      show "finite (?Hd d)"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> finite (?Hd d)`
        by simp
    next
      show "Fc \<inter> (\<Union> set (?Hdl d)) = {}"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> Fc \<inter> \<Union> set (?Hdl d) = {}`
        by simp
    next
      show "Fc \<inter> (?Hd d) = {}"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> Fc \<inter> (?Hd d) = {}`
        by simp
    next
      show "(\<Union> set (?Hdl d)) \<inter> (?Hd d) = {}"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> (\<Union> set (?Hdl d)) \<inter> (?Hd d) = {}`
        by simp
    qed
  qed
  moreover

    have "\<forall> d. \<forall> a \<in> ?X. frankl_fun a (?Hd d) = frankl_fun a (Pow ?X)"
      apply (rule+, rule frankl_fun_hypercube)                                                                  
      using Bd
      by auto
    hence "\<forall> d. \<forall> a \<in> ?X. frankl_fun a (?Hd d) = 0"
      using frankl_fun_Pow[of ?X] `finite (\<Union> Fc)`
      by simp
    
    moreover

    have "\<forall> d a. d > 0 \<longrightarrow> frankl_fun a (\<Union> set (?Hdl d)) = sum_list (map (frankl_fun a) (?Hdl d))"
    proof (rule+, rule frankl_fun_UN_disjoint)
      fix d a
      assume "d > (0::nat)"
      thus "finite (\<Union> set (?Hdl d))"
      proof (auto intro!: finite_imageI)
        fix s
        assume "s < d * ?sum_c"
        hence "?Gs ! (s div d) \<in> set Fs"
          using `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs` `d > 0`
          by auto
        hence "\<Union> (?Gs ! (s div d)) \<subseteq> ?X"
          using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X` 
          by auto
        hence "finite (\<Union> (?Gs ! (s div d)))"
          using `finite ?X`
          by (auto simp add: finite_subset)
        thus "finite (?Gs ! (s div d))"
          by (auto simp add:  finiteUn_iff)
      qed
    next
      fix d a
      assume "d > (0::nat)"
      thus "\<forall> i j. i < length (?Hdl d) \<and> j < length (?Hdl d) \<and> i \<noteq> j \<longrightarrow> 
             ?Hdl d ! i \<inter> ?Hdl d ! j = {}"
      proof auto
        fix i j a b
        assume "i < d * ?sum_c" "j < d * ?sum_c" "i \<noteq> j"
          "a \<in> ?Gs ! (i div d)" "b \<in> ?Gs ! (j div d)"
          "?Bds d i \<union> a = ?Bds d j \<union> b"
        have "Bd d \<inter> ?X = {}" "finite (Bd d)" "card (Bd d) = d * ?sum_c + 1"
          using Bd `d > 0`
          by auto
        moreover
        have "a \<in> \<Union> set Fs" "b \<in> \<Union> set Fs"
          using `a \<in> ?Gs ! (i div d)` `b \<in> ?Gs ! (j div d)` 
          using `i < d * ?sum_c` `j < d * ?sum_c` `d > 0`
            `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs`
          by auto
        hence "a \<subseteq> ?X" "b \<subseteq> ?X"
          using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X`
          by auto
        ultimately
        have "a \<inter> ?Bds d i = {}" "a \<inter> ?Bds d j = {}"
             "b \<inter> ?Bds d i = {}" "b \<inter> ?Bds d j = {}"
          using set_drop_nth_subset[OF `finite (Bd d)`]
          by blast+
        hence "?Bds d i = ?Bds d j"
          using `?Bds d i \<union> a = ?Bds d j \<union> b`
          using Un_iff `Bd d \<inter> \<Union>Fc = {}` `b \<subseteq> \<Union>Fc` `finite (Bd d)`
          using inf_sup_absorb set_drop_nth_subset
          by fastforce
        thus False
          using `i \<noteq> j` set_drop_nth_inj[OF `finite (Bd d)`]
          using `card (Bd d) = d * ?sum_c + 1` `i < d * ?sum_c` `j < d * ?sum_c`
          by auto
      qed
    qed
    moreover
    have "\<forall> d a. d \<noteq> 0 \<and> a \<in> ?X \<longrightarrow> 
              sum_list (map (frankl_fun a) (?Hdl d)) =
              sum_list (map (\<lambda> s. frankl_fun a (?Gs ! (s div d))) [0..<d*?sum_c])"
      using `\<forall> d s a. d \<noteq> 0 \<and> a \<in> ?X \<and> s < d*?sum_c \<longrightarrow> 
          frankl_fun a (?Hds d s) = frankl_fun a (?Gs ! (s div d))`
      by (auto simp add: comp_def) (tactic {* cong_tac @{context} 1*}, simp, force)
    moreover
    have "\<forall> d a. d \<noteq> 0 \<longrightarrow> sum_list (map (\<lambda> s. frankl_fun a (?Gs ! (s div d))) [0..<d*?sum_c]) = 
                           int d * ?Si a"
      using sum_over_spread
      by auto
    ultimately
    show ?thesis
      using `\<forall> d. \<forall> a \<in> ?X. frankl_fun a (?Hd d) = 0`
      by auto
  qed

  moreover

  (* obtain large enough d to make all frankl_fun's negative *)
  have "\<exists> d. d > 0 \<and> (\<forall> a \<in> ?X. frankl_fun a Fc + int d * ?Si a < 0)"
  proof-
    have "\<forall> a \<in> ?X. ?Si a < 0"
    proof (rule ballI)
      fix a
      assume "a \<in> ?X"
      have *: "(\<lambda>s. frankl_fun a (spread c Fs ! s)) = (frankl_fun a) \<circ> (\<lambda> s. spread c Fs ! s)"
        by auto
      have "map (\<lambda>s. frankl_fun a (?Gs ! s)) [0..<?sum_c] =  map (frankl_fun a) (spread c Fs)"
        by (subst *, subst map_map[symmetric], subst `length (spread c Fs) = ?sum_c`[symmetric], subst map_nth[of "spread c Fs"]) (rule refl)
      hence "map (\<lambda>s. frankl_fun a (?Gs ! s)) [0..<?sum_c] = spread c (map (frankl_fun a) Fs)"
        by (simp add: map_spread)
      hence "?Si a =      
             sum_list (map (\<lambda>(x, y). int x * y) (zip c (map (frankl_fun a) Fs)))"
        using listsum_spread `length c = length Fs`
        by auto
      thus "?Si a < 0"
        using assms(6)
        using `let Fs' = Fs in (\<forall>a\<in>\<Union>Fc. (\<Sum>(x, y)\<leftarrow>zip c (map (frankl_fun a) Fs'). int x * y) < 0)` `a \<in> ?X`
        by auto
    qed

    hence "\<forall> a \<in> ?X. \<exists> da.  frankl_fun a Fc + int da * ?Si a < 0"
      using archimedean_negative
      by auto

    let ?da = "\<lambda> a. SOME da. frankl_fun a Fc + int da * ?Si a < 0"
    let ?d = "Max (?da ` ?X) + 1"

    have "\<forall> a \<in> ?X. ?d \<ge> ?da a"
    proof-
      have "\<And> x y. x \<le> y \<Longrightarrow> x \<le> y + (1::nat)"
        by auto
      moreover
      have "\<forall> a \<in> ?X. Max (?da ` ?X) \<ge> ?da a"
        using `finite ?X`
        by auto
      ultimately
      show ?thesis
        by blast
    qed

    have "\<forall> a \<in> ?X. frankl_fun a Fc + int (?da a) * ?Si a < 0"
      apply (rule, rule someI_ex)
      using `\<forall> a \<in> ?X. \<exists> da.  frankl_fun a Fc + int da * ?Si a < 0`
      by auto
    
    have "\<forall> a \<in> ?X. frankl_fun a Fc + int ?d * ?Si a < 0"
    proof
      fix a
      assume "a \<in> ?X"
      hence **: "?d \<ge> ?da a" "frankl_fun a Fc + int (?da a) * ?Si a < 0" "?Si a < 0"
        using `\<forall> a \<in> ?X. ?d \<ge> ?da a` `\<forall> a \<in> ?X. frankl_fun a Fc + int (?da a) * ?Si a < 0` `\<forall> a \<in> ?X. ?Si a < 0` 
        by auto

      show "frankl_fun a Fc + int ?d * ?Si a < 0"
      proof-
        have *: "\<And> x y y' z. \<lbrakk>x + int y * z < 0; y \<le> y'; z < 0\<rbrakk> \<Longrightarrow> x + int y' * z < (0::int)"                        
        proof-
          fix x y y' z
          assume "x + int y * z < 0" "y \<le> y'" "z < 0"
          have "x + int y * z \<ge> x + int y' * z"
            using `y \<le> y'` `z < 0`
            by auto
          thus "x + int y' * z < 0"
            using `x + int y * z < 0`
            by simp
        qed
        show ?thesis
         by (rule *[where y="?da a"]) fact+
      qed
    qed

    moreover

    have "?d > 0"
      by auto

    ultimately

    show ?thesis
      by (rule_tac x="?d" in exI) auto
  qed
  then obtain d where "d > 0" "\<forall> a \<in> ?X. frankl_fun a Fc + int d * ?Si a < 0"
    by auto

  ultimately

  have "\<forall> a \<in> ?X. frankl_fun a (?Fd d) < 0"
    by auto

  have "\<exists>F. Fc \<subseteq> F \<and>
           union_closed F \<and>
           finite (\<Union>F) \<and> (\<forall>a\<in>?X. card F > 2 * count a F)"
  proof (rule_tac x="?Fd d" in exI, intro conjI)
    show "\<forall> a \<in> ?X. 2 * count a (?Fd d) < card (?Fd d)"
      using `\<forall> a \<in> ?X. frankl_fun a (?Fd d) < 0`
      by force
    moreover
    show "Fc \<subseteq> (?Fd d)"                                                          
      by auto
    moreover
    show "union_closed (?Fd d)"
    proof-
      obtain Hdl Hd Fd where *: "Hdl = \<Union> set (?Hdl d)" "Hd = ?Hd d" "Fd = Fc \<union> Hdl \<union> Hd"
        by auto
      have "\<forall> A \<in> Fc. \<forall> B \<in> Fc. A \<union> B \<in> Fd"
        using `union_closed Fc` *
        unfolding union_closed_def
        by auto
      moreover
      have "\<forall> A \<in> Fc. \<forall> B \<in> Hdl. A \<union> B \<in> Fd"
      proof (safe)
        fix A B
        assume "A \<in> Fc" "B \<in> Hdl"
        then obtain i a where "i < d * sum_list c"
                              "a \<in> ?Gs ! (i div d)" "B = ?Bds d i \<union> a"
          using *
          by auto
      
        hence "A \<union> a \<in> ?Gs ! (i div d)"
          using `A \<in> Fc` `\<forall>d s A B. d \<noteq> 0 \<and> s < d * sum_list c \<and> A \<in> Fc \<and> B \<in> spread c Fs ! (s div d) \<longrightarrow> A \<union> B \<in> spread c Fs ! (s div d)` `d > 0`
          by simp
        
        hence "(A \<union> a) \<union> ?Bds d i \<in> \<Union> set (?Hdl d)"
          using `i < d * sum_list c`
          by auto (rule_tac x="i" in bexI, auto)
        moreover
        have "A \<union> B = (A \<union> a) \<union> ?Bds d i"
          using `B = ?Bds d i \<union> a`
          by auto
        ultimately
        show "A \<union> B \<in> Fd"
          using *
          by  simp
      qed
      moreover
      have "\<forall> A \<in> Fc. \<forall> B \<in> Hd. A \<union> B \<in> Fd"
      proof safe
        fix A B
        assume "A \<in> Fc" "B \<in> Hd"
        then obtain b where "b \<subseteq> \<Union> Fc" "B = b \<union> (Bd d)" 
          using *
          by auto
        hence "A \<union> b \<subseteq> \<Union> Fc"
          using `A \<in> Fc`
          by auto
        hence "A \<union> B \<in> ?Hd d"
          using `B = b \<union> (Bd d)`
          by (smt PowI Un_assoc Un_commute rev_image_eqI)
        thus "A \<union> B \<in> Fd"
          using *
          by simp
      qed
      moreover
      have "\<forall> A \<in> Hdl. \<forall> B \<in> Hdl. A \<union> B \<in> Fd"
      proof safe
        fix A B
        assume "A \<in> Hdl" "B \<in> Hdl"
        then obtain i j a b where
          "i < d * sum_list c" "j < d * sum_list c"
          "a \<in> ?Gs ! (i div d)" "A = ?Bds d i \<union> a"
          "b \<in> ?Gs ! (j div d)" "B = ?Bds d j \<union> b"
          using *
          by auto
        hence "a \<in> \<Union> set Fs" "b \<in> \<Union> set Fs"
          using `0 < d` `\<forall>d s. d \<noteq> 0 \<and> s < d * sum_list c \<longrightarrow> spread c Fs ! (s div d) \<in> set Fs`
          by auto
        hence "a \<union> b \<subseteq> ?X"
          using `\<forall>F\<in>set Fs. \<Union>F \<subseteq> \<Union>Fc`
          by auto
        show "A \<union> B \<in> Fd"
        proof (cases "i = j")
          case True
          hence "a \<union> b \<in> ?Gs ! (i div d)"
            using `a \<in> ?Gs ! (i div d)` `b \<in> ?Gs ! (j div d)`
            using `\<forall>F\<in>set Fs. F \<in> \<lbrace>Fc\<rbrace>` div `length ?Gs = ?sum_c`
            using `\<forall>F\<in>set Fs. \<Union>F \<subseteq> \<Union>Fc`
            unfolding union_closed_extensions_def union_closed_additional_def union_closed_def 
            using `0 < d` `\<forall>i<sum_list c. spread c Fs ! i \<in> set Fs` `j < d * sum_list c`
            by simp
          hence "(a \<union> b) \<union> ?Bds d i \<in> \<Union> set (?Hdl d)"
            using `i < d * ?sum_c`
            by auto (rule_tac x="i" in bexI, auto)
          hence "A \<union> B \<in> \<Union> set (?Hdl d)"
            using `A = ?Bds d i \<union> a` `B = ?Bds d j \<union> b` `i = j`
            by (smt Un_assoc Un_commute sup.right_idem)
          thus ?thesis
            using *
            by simp
        next
          case False
          hence "?Bds d i \<union> ?Bds d j = Bd d"
            unfolding set_drop_nth_def
            using `i < d * ?sum_c` `j < d * ?sum_c`
            using distinct_sorted_list_of_set[of "Bd d"]
            using set_drop_nth_distinct[of i "sorted_list_of_set (Bd d)"]
            using set_drop_nth_distinct[of j "sorted_list_of_set (Bd d)"]
            using length_sorted_list_of_set[of "Bd d"] Bd
            using nth_eq_iff_index_eq[of "sorted_list_of_set (Bd d)" i j]
            by auto
          hence "A \<union> B \<in> ?Hd d"
            using `A = ?Bds d i \<union> a` `B = ?Bds d j \<union> b`
            using `a \<union> b \<subseteq> \<Union> Fc`
            by (smt PowI Un_assoc image_iff sup_left_commute)
          thus "A \<union> B \<in> Fd"
            using *
            by simp
        qed
      qed
      moreover
      have "\<forall> A \<in> Hdl. \<forall> B \<in> Hd. A \<union> B \<in> Fd"
      proof safe
        fix A B
        assume "A \<in> Hdl" "B \<in> Hd"
        then obtain i a b where
          "i < d * sum_list c" 
          "a \<in> ?Gs ! (i div d)" "A = ?Bds d i \<union> a"
          "b \<subseteq> \<Union> Fc" "B = b \<union> (Bd d)"
          using *
          by auto blast
        hence "a \<union> b \<subseteq> ?X"
          using `0 < d` `\<forall>d s. d \<noteq> 0 \<and> s < d * sum_list c \<longrightarrow> spread c Fs ! (s div d) \<in> set Fs`
          using `\<forall>F\<in>set Fs. \<Union>F \<subseteq> \<Union>Fc` `b \<subseteq> \<Union> Fc`
          by (metis (mono_tags, lifting) Union_upper le_supI neq0_conv subset_trans)
        hence "(a \<union> b) \<union> Bd d \<in> ?Hd d"
          by auto
        moreover
        have "?Bds d i \<union> Bd d = Bd d"
          using set_drop_nth_subset Bd
          by auto
        ultimately
        have "A \<union> B \<in> ?Hd d"
          using `A = ?Bds d i \<union> a` `B = b \<union> (Bd d)`
          by (simp add: Un_left_commute sup_assoc)
        thus "A \<union> B \<in> Fd"
          using *
          by simp
      qed
      moreover
      have "\<forall> A \<in> Hd. \<forall> B \<in> Hd. A \<union> B \<in> Fd"
      proof safe
        fix A B
        assume "A \<in> Hd" "B \<in> Hd"
        then obtain a b where "a \<subseteq> \<Union> Fc" "A = a \<union> (Bd d)" "b \<subseteq> \<Union> Fc" "B = b \<union> (Bd d)" 
          using *
          by auto
        hence "a \<union> b \<subseteq> \<Union> Fc"
          by auto
        hence "A \<union> B \<in> ?Hd d"
          using `A = a \<union> (Bd d)` `B = b \<union> (Bd d)`
          by (smt PowI Un_commute image_iff sup.right_idem sup_left_commute)
        thus "A \<union> B \<in> Fd"
          using *
          by simp
 
      qed
      ultimately
      have "union_closed Fd"
        using `Fd = Fc \<union> Hdl \<union> Hd`
        unfolding union_closed_def
        by (metis UnE Un_commute)+
      thus ?thesis
        using *
        by simp
    qed
  next
    show "finite (\<Union> (?Fd d))"
    proof (auto)
      show "finite (\<Union> Fc)" by fact
    next
      show "finite (Bd d)" using Bd by simp
    next
      show "finite
         (\<Union> (\<Union>x\<in>{0..<d * sum_list c}.
               op \<union> (set_drop_nth x (Bd d)) ` spread c Fs ! (x div d)))"
        using `d > 0` `\<forall> d. d > 0 \<longrightarrow> finite (\<Union> set (?Hdl d))`
      proof (auto simp add: finiteUn_iff)
        fix a
        show "finite (set_drop_nth a (Bd d))"
          using Bd set_drop_nth_subset[of "Bd d" a]
          by (auto simp add: finite_subset)
      next
        fix a x
        assume "x \<in> spread c Fs ! (a div d)" "a < d * ?sum_c"
        hence "x \<in> \<Union> (set Fs)"
          using `\<forall> d s. d \<noteq> 0 \<and> s < d * ?sum_c \<longrightarrow> ?Gs ! (s div d) \<in> set Fs` `d > 0`
          by auto
        then obtain F' where "F' \<in> set Fs" "x \<in> F'"
          by auto
        hence "finite (\<Union> F')"
          using `\<forall> F \<in> set Fs. \<Union> F \<subseteq> ?X`
          using `finite ?X`
          by (auto simp add: finite_subset)
        thus "finite x"
          using `x \<in> F'`
          by (auto simp add: finiteUn_iff)
      qed
    next
      show "finite (\<Union> Fc)"
        by fact
    qed
  qed
  thus ?thesis
    unfolding FC_family_def
    by (metis linorder_not_less)
qed

end