header{* Circline *}
theory Circline
imports Moebius HermiteanMatrices ElementaryComplexGeometry RiemannSphere Angles
begin

subsection{* Circline definition *}
typedef circline_mat = "{H. hermitean H \<and> H \<noteq> mat_zero}"
by (rule_tac x="eye" in exI) (auto simp add: hermitean_def mat_adj_def mat_cnj_def)

lemma circline_mat_mult_sm_Rep [simp]:
  assumes "k \<noteq> 0"
  shows "Rep_circline_mat (Abs_circline_mat ((cor k) *\<^sub>s\<^sub>m (Rep_circline_mat H))) = (cor k) *\<^sub>s\<^sub>m (Rep_circline_mat H)"
using assms Rep_circline_mat[of H]
using hermitean_mult_real[of "Rep_circline_mat H" k] nonzero_mult_real[of "Rep_circline_mat H" "cor k"]
by (simp add: Abs_circline_mat_inverse)

definition circline_mat_eq where 
  [simp]: "circline_mat_eq A B \<longleftrightarrow> (\<exists> k::real. k \<noteq> 0 \<and> Rep_circline_mat B = complex_of_real k *\<^sub>s\<^sub>m (Rep_circline_mat A))"

lemma [simp]: "circline_mat_eq H H"
  by (simp, rule_tac x="1" in exI, simp)

quotient_type circline = circline_mat / circline_mat_eq
proof (rule equivpI)
  show "reflp circline_mat_eq"
    unfolding reflp_def
    by (auto, rule_tac x="1" in exI, simp)
next
  show "symp circline_mat_eq"
    unfolding symp_def
    by (auto, rule_tac x="1/k" in exI, simp)
next
  show "transp circline_mat_eq"
    unfolding transp_def
    by (auto, rule_tac x="ka*k" in exI, simp)
qed

text{* Circline with specified matrix *}

definition mk_circline_rep where
 "mk_circline_rep A B C D = Abs_circline_mat (A, B, C, D)"

lift_definition mk_circline :: "complex \<Rightarrow> complex \<Rightarrow> complex \<Rightarrow> complex \<Rightarrow> circline" is mk_circline_rep
by (simp del: circline_mat_eq_def)

lemma ex_mk_circline:
  shows "\<exists> A B C D. H = mk_circline A B C D \<and> hermitean (A, B, C, D) \<and> (A, B, C, D) \<noteq> mat_zero"
proof transfer
  fix H
  obtain A B C D where "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H", auto)
  hence "circline_mat_eq H (mk_circline_rep A B C D) \<and> hermitean (A, B, C, D) \<and> (A, B, C, D) \<noteq> mat_zero"
    using Rep_circline_mat[of H]
    by (auto simp add: mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x=1 in exI, simp)+
  thus "\<exists> A B C D. circline_mat_eq H (mk_circline_rep A B C D) \<and> hermitean (A, B, C, D) \<and> (A, B, C, D) \<noteq> mat_zero"
    by blast
qed

text {* circline type *}

definition circline_type_rep where
  "circline_type_rep H = sgn (Re (mat_det (Rep_circline_mat H)))"

lift_definition circline_type :: "circline \<Rightarrow> real" is circline_type_rep
proof-
  fix H H' 
  assume "circline_mat_eq H H'"
  thus "circline_type_rep H = circline_type_rep H'"
    by (auto simp add: circline_type_rep_def sgn_mult) (metis not_real_square_gt_zero real_sgn_pos sgn_mult)
qed

lemma circline_type: "circline_type H = -1 \<or> circline_type H = 0 \<or> circline_type H = 1"
proof transfer
  fix H
  show "circline_type_rep H = -1 \<or> circline_type_rep H = 0 \<or> circline_type_rep H = 1"
    unfolding circline_type_rep_def
    using Rep_circline_mat[of H]
    by (metis linorder_cases real_sgn_neg real_sgn_pos sgn_zero_iff)
qed

text{* @{term "on_circline"}, @{term "circline_set"} *}

definition on_circline_rep where
  "on_circline_rep H z \<longleftrightarrow> 
            (let z = Rep_homo_coords z; 
                 H = Rep_circline_mat H 
              in quad_form z H = 0)"


lift_definition on_circline :: "circline \<Rightarrow> complex_homo \<Rightarrow> bool" is "on_circline_rep"
by (auto simp add: on_circline_rep_def quad_form_scale_m quad_form_scale_v Let_def simp del: vec_cnj_sv quad_form_def)

definition circline_set :: "circline \<Rightarrow> complex_homo set" where
  "circline_set H = {z. on_circline H z}"

text{* Circlines trough 0 and inf *}
definition circline_A0_rep where
 "circline_A0_rep H \<longleftrightarrow> 
        (let (A, B, C, D) = Rep_circline_mat H in A = 0)"

lift_definition circline_A0 :: "circline \<Rightarrow> bool" is circline_A0_rep
by (auto simp add: circline_A0_rep_def)

definition circline_D0_rep where
 "circline_D0_rep H \<longleftrightarrow> 
        (let (A, B, C, D) = Rep_circline_mat H in D = 0)"

abbreviation is_line where
  "is_line H \<equiv> circline_A0 H"

abbreviation is_circle where
  "is_circle H \<equiv> \<not> circline_A0 H"

lift_definition circline_D0 :: "circline \<Rightarrow> bool" is circline_D0_rep
by (auto simp add: circline_D0_rep_def)

lemma inf_on_circline_rep: "on_circline_rep H inf_homo_rep \<longleftrightarrow> circline_A0_rep H"
by (simp add: on_circline_rep_def Let_def circline_A0_rep_def split_def) (cases "Rep_circline_mat H", simp add: vec_cnj_def)

lemma 
  inf_in_circline_set: "\<infinity>\<^sub>h \<in> circline_set H \<longleftrightarrow> is_line H"
unfolding circline_set_def
apply simp
apply (transfer)
using inf_on_circline_rep
by simp

lemma zero_on_circline_rep: "on_circline_rep H zero_homo_rep \<longleftrightarrow> circline_D0_rep H"
using Rep_circline_mat[of H]
by (simp add: circline_D0_rep_def on_circline_rep_def split_def Let_def Abs_homo_coords_inverse Abs_circline_mat_inverse vec_cnj_def) (cases "Rep_circline_mat H", simp)

lemma zero_in_circline_set: "0\<^sub>h \<in> circline_set H \<longleftrightarrow> circline_D0 H"
unfolding circline_set_def
apply simp
apply (transfer)
using zero_on_circline_rep
by simp


text{* Connection with circlines in classic complex plane *}
lemma classic_circline:
  assumes "H = mk_circline A B C D" "hermitean (A, B, C, D) \<and> (A, B, C, D) \<noteq> mat_zero"
  shows "circline_set H - {\<infinity>\<^sub>h} = of_complex ` circline (Re A) B (Re D)"
using assms
unfolding circline_set_def
proof (safe)
  fix z
  assume "hermitean (A, B, C, D)" "(A, B, C, D) \<noteq> mat_zero" "z \<in> circline (Re A) B (Re D)"
    thus "on_circline (mk_circline A B C D) (of_complex z)"
      using hermitean_elems[of A B C D]
      by (transfer) (simp del: mat_zero_def add: on_circline_rep_def Let_def mk_circline_rep_def Abs_circline_mat_inverse circline_def vec_cnj_def field_simps complex_of_real_Re)
next
  fix z
  assume "of_complex z = \<infinity>\<^sub>h"
  thus False
    by simp
next
  fix z
  assume "hermitean (A, B, C, D)" "(A, B, C, D) \<noteq> mat_zero" "on_circline (mk_circline A B C D) z" "z \<notin> of_complex ` circline (Re A) B (Re D)"
  moreover
  have "z \<noteq> \<infinity>\<^sub>h \<longrightarrow> z \<in> of_complex ` circline (Re A) B (Re D)"
  proof
    assume "z \<noteq> \<infinity>\<^sub>h"
    show "z \<in> of_complex ` circline (Re A) B (Re D)"
    proof
      show "z = of_complex (to_complex z)"
        using `z \<noteq> \<infinity>\<^sub>h`
        by simp
    next
      show "to_complex z \<in> circline (Re A) B (Re D)"
        using `on_circline (mk_circline A B C D) z` `z \<noteq> \<infinity>\<^sub>h` `hermitean (A, B, C, D)` `(A, B, C, D) \<noteq> mat_zero`
      proof (transfer)
        fix A B C D z
        obtain z1 z2 where zz: "Rep_homo_coords z = (z1, z2)"
          by (rule obtain_homo_coords)
        assume *: "\<not> z \<approx> inf_homo_rep" "on_circline_rep (mk_circline_rep A B C D) z" "hermitean (A, B, C, D)" "(A, B, C, D) \<noteq> mat_zero"
        have "z2 \<noteq> 0"
          using `\<not> z \<approx> inf_homo_rep` Rep_homo_coords[of z] zz
          by auto (erule_tac x="1/z1" in allE, simp)
        thus "to_complex_homo_coords z \<in> circline (Re A) B (Re D)"
          using * zz
          using hermitean_elems[of A B C D]
          by (simp add: mk_circline_rep_def on_circline_rep_def to_complex_homo_coords_def Let_def Abs_circline_mat_inverse  vec_cnj_def complex_cnj circline_def complex_of_real_Re field_simps del: mat_zero_def)
      qed
    qed
  qed
  ultimately
  show "z = \<infinity>\<^sub>h"
    by simp
qed

definition mk_circle_rep where
  "mk_circle_rep a r = Abs_circline_mat (1, -a, -cnj a, a*cnj a - cor r*cor r)"
lift_definition mk_circle :: "complex \<Rightarrow> real \<Rightarrow> circline" is mk_circle_rep
by (simp del: circline_mat_eq_def)

lemma mk_circle_rep_Rep
  [simp]: "Rep_circline_mat (mk_circle_rep a r) = (1, -a, -cnj a, a*cnj a - cor r*cor r)"
by (simp add: mk_circle_rep_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj)

lemma is_circle_mk_circle: "is_circle (mk_circle a r)"
by transfer (simp add: circline_A0_rep_def)

lemma 
  assumes "r \<ge> 0"
  shows "circline_set (mk_circle a r) = of_complex ` {z. cmod (z - a) = r}"
proof-
  let ?A = "1" and ?B = "-a" and ?C = "-cnj a" and ?D = "a*cnj a - cor r*cor r"
  have *: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj)
  have "mk_circle a r = mk_circline ?A ?B ?C ?D"
    using *
    by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse, rule_tac x="1" in exI, simp)
  hence "circline_set (mk_circle a r) - {\<infinity>\<^sub>h} = of_complex ` circline ?A ?B (Re ?D)"
    using classic_circline[of "mk_circle a r" ?A ?B ?C ?D] *
    by simp
  moreover
  have "circline ?A ?B (Re ?D) = circle a r"
    by (rule circline_circle[of ?A "Re ?D" "?B" "circline ?A ?B (Re ?D)" "a" "r*r" r], simp_all add: cmod_square `r \<ge> 0`)
  moreover
  have "\<infinity>\<^sub>h \<notin> circline_set (mk_circle a r)"
    using inf_in_circline_set[of "mk_circle a r"] is_circle_mk_circle[of a r]
    by auto
  ultimately
  show ?thesis
    unfolding circle_def
    by simp
qed

definition mk_line_rep where "mk_line_rep z1 z2 = 
  (let B = ii*(z2-z1) in Abs_circline_mat (0, B, cnj B, -cnj_mix B z1))"
lift_definition mk_line :: "complex \<Rightarrow> complex \<Rightarrow> circline" is mk_line_rep
by (simp del: circline_mat_eq_def)

lemma mk_line_rep_Rep [simp]:
  assumes "z1 \<noteq> z2"
  shows "Rep_circline_mat (mk_line_rep z1 z2) = 
     (let B = ii*(z2-z1) in (0, B, cnj B, -cnj_mix B z1))"
using assms
by (simp add: mk_line_rep_def Let_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj)

lemma circline_line':
  assumes "z1 \<noteq> z2"
  shows "circline 0 (\<i> * (z2 - z1)) (Re (- cnj_mix (\<i> * (z2 - z1)) z1)) = line z1 z2"
proof-
  let ?B = "ii * (z2 - z1)" 
  let ?D = "Re (- cnj_mix ?B z1)"
  have "circline 0 ?B ?D = {z. cnj ?B*z + ?B*cnj z + complex_of_real ?D = 0}"
    using assms
    by (simp add: circline_def)
  moreover
  have "is_real (- cnj_mix (\<i> * (z2 - z1)) z1)"
    using cnj_mix_real[of ?B z1]
    by auto
  hence "{z. cnj ?B*z + ?B*cnj z + complex_of_real ?D = 0} = 
         {z. cnj ?B*z + ?B*cnj z - (cnj ?B*z1 + ?B*cnj z1) = 0}"
    by (subst complex_of_real_Re, simp, simp add: complex_diff_def)
  moreover
  have "line z1 z2 = {z. cnj_mix (\<i> * (z2 - z1)) z - cnj_mix (\<i> * (z2 - z1)) z1 = 0}"
    using line_equation[of z1 z2 ?B] assms
    unfolding rot90_ii
    by simp
  ultimately
  show ?thesis
    by simp
qed

lemma 
  assumes "z1 \<noteq> z2"
  shows "circline_set (mk_line z1 z2) - {\<infinity>\<^sub>h} = of_complex ` line z1 z2"
proof-
  let ?A = "0" and ?B = "ii*(z2 - z1)" 
  let ?C = "cnj ?B" and ?D = "-cnj_mix ?B z1"
  have *: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    using assms
    by (simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj)
  have "mk_line z1 z2 = mk_circline ?A ?B ?C ?D"
    using * assms
    by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse Let_def, rule_tac x="1" in exI, simp)
  hence "circline_set (mk_line z1 z2) - {\<infinity>\<^sub>h} = of_complex ` circline ?A ?B (Re ?D)"
    using classic_circline[of "mk_line z1 z2" ?A ?B ?C ?D] *
    by simp
  moreover
  have "circline ?A ?B (Re ?D) = line z1 z2"
    using `z1 \<noteq> z2`
    using circline_line'
    by simp
  ultimately
  show ?thesis
    by simp
qed

definition euclidean_circle_rep where
  "euclidean_circle_rep H = (let (A, B, C, D) = Rep_circline_mat H in (-B/A, sqrt(Re ((B*C - A*D)/(A*A)))))"

lift_definition euclidean_circle :: "circline \<Rightarrow> complex \<times> real" is euclidean_circle_rep
proof-
  fix H1 H2
  obtain A1 B1 C1 D1 where HH1: "Rep_circline_mat H1 = (A1, B1, C1, D1)"
    by (cases "Rep_circline_mat H1") auto
  obtain A2 B2 C2 D2 where HH2: "Rep_circline_mat H2 = (A2, B2, C2, D2)"
    by (cases "Rep_circline_mat H2") auto
  assume "circline_mat_eq H1 H2"
  then obtain k where "k \<noteq> 0" and *: "A2 = cor k * A1" "B2 = cor k * B1" "C2 = cor k * C1" "D2 = cor k * D1"
    using HH1 HH2
    by auto
  have "(cor k * B1 * (cor k * C1) - cor k * A1 * (cor k * D1)) = (cor k)\<^sup>2 * (B1*C1 - A1*D1)"
    "(cor k * A1 * (cor k * A1)) = (cor k)\<^sup>2 * (A1*A1)"
    by (auto simp add: field_simps power2_eq_square)
  hence "(cor k * B1 * (cor k * C1) - cor k * A1 * (cor k * D1)) /
         (cor k * A1 * (cor k * A1)) = (B1*C1 - A1*D1) / (A1*A1)"
    using `k \<noteq> 0`
    by (simp add: power2_eq_square)
  thus "euclidean_circle_rep H1 = euclidean_circle_rep H2"
    using HH1 HH2 * Rep_circline_mat[of H2]
    by (auto simp add: euclidean_circle_rep_def)
qed

lemma classic_circle:
  assumes "is_circle H" "(a, r) = euclidean_circle H" "circline_type H \<le> 0"
  shows "circline_set H = of_complex ` circle a r"
proof-
  obtain A B C D where *: "H = mk_circline A B C D" "hermitean (A, B, C, D)" "(A, B, C, D) \<noteq> mat_zero"
    using ex_mk_circline[of H]
    by auto
  have "is_real A" "is_real D" "C = cnj B"
    using * hermitean_elems
    by auto

  have "Re (A*D - B*C) \<le> 0"
    using `circline_type H \<le> 0` *
    by simp (transfer, simp add: circline_type_rep_def mk_circline_rep_def Abs_circline_mat_inverse, smt real_sgn_pos)

  hence **: "Re A * Re D \<le> (cmod B)\<^sup>2"
    using `is_real A` `is_real D` `C = cnj B`
    by (simp add: cmod_square)

  have "A \<noteq> 0"
    using `is_circle H` * `is_real A`
    by simp (transfer, simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
  hence "Re A \<noteq> 0"
    using `is_real A`
    by (cases A, simp)

  have ***: "\<infinity>\<^sub>h \<notin> circline_set H"
    using * inf_in_circline_set[of H] `is_circle H`
    by simp

  let ?a = "-B/A"
  let ?r2 = "((cmod B)\<^sup>2 - Re A * Re D) / (Re A)\<^sup>2"
  let ?r = "sqrt ?r2"

  have "?a = a \<and> ?r = r"
    using `(a, r) = euclidean_circle H`
    using * `is_real A` `is_real D` `C = cnj B` `A \<noteq> 0`
    apply simp
    apply transfer
    apply (simp add: euclidean_circle_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
    apply (subst Re_divide_real)
    apply (simp_all add: cmod_square, simp add: power2_eq_square)
    done

  show ?thesis
    using * ** *** `Re A \<noteq> 0` `is_real A` `C = cnj B` `?a = a \<and> ?r = r`
    using classic_circline[of H A B C D] assms circline_circle[of "Re A" "Re D" B "circline (Re A) B (Re D)" ?a ?r2 ?r]
    by (simp add: complex_of_real_Re circle_def)
qed

definition
  "euclidean_line_rep H = 
     (let (A, B, C, D) = Rep_circline_mat H;
          z1 = -(D*B)/(2*B*C);
          z2 = z1 + ii*sgn (if arg B > 0 then -B else B)
      in (z1, z2))"

lift_definition euclidean_line :: "circline \<Rightarrow> complex \<times> complex" is euclidean_line_rep
proof-
  fix H1 H2
  obtain A1 B1 C1 D1 where HH1: "Rep_circline_mat H1 = (A1, B1, C1, D1)"
    by (cases "Rep_circline_mat H1") auto
  obtain A2 B2 C2 D2 where HH2: "Rep_circline_mat H2 = (A2, B2, C2, D2)"
    by (cases "Rep_circline_mat H2") auto
  assume "circline_mat_eq H1 H2"
  then obtain k where "k \<noteq> 0" and *: "A2 = cor k * A1" "B2 = cor k * B1" "C2 = cor k * C1" "D2 = cor k * D1"
    using HH1 HH2
    by auto
  have 1: "B1 \<noteq> 0 \<and> 0 < arg B1 \<longrightarrow> \<not> 0 < arg (- B1)"
    using MoreComplex.canon_ang_plus_pi1[of "arg B1"] arg_bounded[of B1]
    by (auto simp add: arg_uminus)
  have 2: "B1 \<noteq> 0 \<and> \<not> 0 < arg B1 \<longrightarrow> 0 < arg (- B1)"
    using MoreComplex.canon_ang_plus_pi2[of "arg B1"] arg_bounded[of B1]
    by (auto simp add: arg_uminus)

  show "euclidean_line_rep H1 = euclidean_line_rep H2"
    using HH1 HH2 * `k \<noteq> 0`
    by (cases "k > 0") (auto simp add: euclidean_line_rep_def Let_def, simp_all add: sgn_eq arg_mult_real_positive arg_mult_real_negative 1 2)
qed

lemma classic_line:
  assumes "is_line H" "(z1, z2) = euclidean_line H" "circline_type H < 0"
  shows "circline_set H - {\<infinity>\<^sub>h} = of_complex ` line z1 z2"
proof-
  obtain A B C D where *: "H = mk_circline A B C D" "hermitean (A, B, C, D)" "(A, B, C, D) \<noteq> mat_zero"
    using ex_mk_circline[of H]
    by auto
  have "is_real A" "is_real D" "C = cnj B"
    using * hermitean_elems
    by auto
  have "Re A = 0"
    using `is_line H`* `is_real A` `is_real D` `C = cnj B`
    by transfer (auto simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
  have "B \<noteq> 0"
    using `Re A = 0`  `is_real A` `is_real D` `C = cnj B` * `circline_type H < 0`
    by transfer (auto simp add: circline_type_rep_def mk_circline_rep_def Abs_circline_mat_inverse, (case_tac "Rep_circline_mat H", simp)+)
    
  let ?z1 = "- cor (Re D) * B / (2 * B * cnj B)"
  let ?z2 = "?z1 + \<i> * sgn (if 0 < arg B then - B else B)"
  have "z1 = ?z1 \<and> z2 = ?z2"
    using `(z1, z2) = euclidean_line H` * `is_real A` `is_real D` `C = cnj B`
    by simp (transfer, simp add: euclidean_line_rep_def mk_circline_rep_def Abs_circline_mat_inverse Let_def complex_of_real_Re)
  thus ?thesis
    using *
    using classic_circline[of H A B C D] circline_line[of "Re A" B "circline (Re A) B (Re D)" "Re D" ?z1 ?z2] `Re A = 0` `B \<noteq> 0`
    by simp
qed

subsection{* Connections with circles on the Riemann sphere *}
definition inv_stereographic_circline_rep where 
  "inv_stereographic_circline_rep H  =
     (let (A, B, C, D) = Rep_circline_mat H in
      Abs_plane_vec (Re (B+C), Re(ii*(C-B)), Re(A-D), Re(D+A)))"

lemma inv_stereographic_circline_rep_Rep [simp]:
  "Rep_plane_vec (inv_stereographic_circline_rep H) = 
     (let (A, B, C, D) = Rep_circline_mat H in (Re (B+C), Re(ii*(C-B)), Re(A-D), Re(D+A)))"
proof-
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  have *: "is_real A" "is_real D" "C = cnj B"
    using HH Rep_circline_mat[of H] hermitean_elems[of A B C D]
    by auto
  have "Re B + Re C = 0 \<and> Im B - Im C = 0 \<and> Re A - Re D = 0 \<and> Re A + Re D = 0 \<longrightarrow> (A, B, C, D) = mat_zero"
    using *
    by auto (metis complex_of_real_Re of_real_0)+
  hence **: "Re B + Re C \<noteq> 0 \<or>  Im B - Im C \<noteq> 0 \<or> Re A - Re D \<noteq> 0 \<or> Re D + Re A \<noteq> 0"
    using Rep_circline_mat[of H] HH
    by auto
  thus ?thesis
    using HH
    by (simp add: Abs_plane_vec_inverse inv_stereographic_circline_rep_def)
qed

lift_definition inv_stereographic_circline :: "circline \<Rightarrow> plane" is inv_stereographic_circline_rep
proof-
  fix H1 H2
  obtain A1 B1 C1 D1 where HH1: "Rep_circline_mat H1 = (A1, B1, C1, D1)"
    by (cases "Rep_circline_mat H1") auto
  obtain A2 B2 C2 D2 where HH2: "Rep_circline_mat H2 = (A2, B2, C2, D2)"
    by (cases "Rep_circline_mat H2") auto
  have *: "is_real A1" "is_real A2" "is_real D1" "is_real D2" "C1 = cnj B1" "C2 = cnj B2"
    using HH1 HH2 Rep_circline_mat[of H1] Rep_circline_mat[of H2] hermitean_elems[of A1 B1 C1 D1]  hermitean_elems[of A2 B2 C2 D2]
    by auto

  assume "circline_mat_eq H1 H2"
  thus "plane_vec_eq (inv_stereographic_circline_rep H1) (inv_stereographic_circline_rep H2)"
    using HH1 HH2 *
    by (simp add: plane_vec_eq_def) (erule exE, rule_tac x=k in exI, simp add: field_simps)
qed

definition stereographic_circline_rep where
"stereographic_circline_rep \<alpha> = 
     (let (a, b, c, d) = Rep_plane_vec \<alpha> in
       Abs_circline_mat (cor ((c+d)/2) , ((cor a+ii* cor b)/2), ((cor a-ii*cor b)/2), cor ((d-c)/2)))"

lemma stereographic_circline_rep_Rep:
  "Rep_circline_mat (stereographic_circline_rep \<alpha>) = 
      (let (a, b, c, d) = Rep_plane_vec \<alpha> in
         (cor ((c+d)/2) , ((cor a+ii* cor b)/2), ((cor a-ii*cor b)/2), cor ((d-c)/2)))"
proof-
  obtain a b c d where AA: "(a, b, c, d) = Rep_plane_vec \<alpha>"
    by (cases "Rep_plane_vec \<alpha>") auto
  let ?M = "(cor ((c+d)/2) , ((cor a+ii* cor b)/2), ((cor a-ii*cor b)/2), cor ((d-c)/2))"
  have "?M \<in> {M. hermitean M \<and> M \<noteq> mat_zero}"
    using Rep_plane_vec[of \<alpha>] AA
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj complex_of_real_def)
  thus ?thesis
    using AA[symmetric]
    by (simp add: Abs_circline_mat_inverse stereographic_circline_rep_def)
qed

lift_definition stereographic_circline :: "plane \<Rightarrow> circline" is stereographic_circline_rep
proof-
  fix \<alpha>1 \<alpha>2
  assume "plane_vec_eq \<alpha>1 \<alpha>2"
  thus "circline_mat_eq (stereographic_circline_rep \<alpha>1) (stereographic_circline_rep \<alpha>2)"
    apply (cases "Rep_plane_vec \<alpha>2", cases "Rep_plane_vec \<alpha>1")
    apply (auto simp add: plane_vec_eq_def stereographic_circline_rep_Rep)
    apply (rule_tac x=k in exI, simp add: field_simps)
    by (metis (hide_lams, mono_tags) comm_semiring_1_class.normalizing_semiring_rules(19) complex_of_real_mult_Complex mult_zero_right) 
qed

lemma stereographic_circline_inv_stereographic_circline:
  "stereographic_circline \<circ> inv_stereographic_circline = id"
proof (rule ext, simp)
  fix H
  show "stereographic_circline (inv_stereographic_circline H) = H"
  proof transfer
    fix H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    have "is_real A" "is_real D" "C = cnj B"
      using HH Rep_circline_mat[of H] hermitean_elems[of A B C D]
      by auto
    thus "circline_mat_eq (stereographic_circline_rep (inv_stereographic_circline_rep H)) H"
      using HH
      apply (simp add: stereographic_circline_rep_Rep)
      apply (rule_tac x=1 in exI)
      apply (auto simp add: complex_of_real_Re of_real_numeral)
      apply (cases B, simp)
      apply (cases B, simp add: complex_of_real_def, metis Im.simps Re.simps comm_semiring_1_class.normalizing_semiring_rules(4) complex_diff_def complex_minus_def complex_of_real_add_Complex complex_of_real_def minus_zero monoid_add_class.add.right_neutral one_add_one) 
      done
  qed
qed

lemma [simp]: "Im (z / 2) = Im z / 2"
by (subst Im_divide_real, auto)

lemma [simp]: "(Complex a b) / 2 = Complex (a/2) (b/2)"
by (subst complex_eq_iff) auto

lemma [simp]: "Complex 2 0 = 2"
by simp

lemma inv_stereographic_circline_stereographic_circline:
  "inv_stereographic_circline \<circ> stereographic_circline = id"
proof (rule ext, simp)
  fix \<alpha>
  show "inv_stereographic_circline (stereographic_circline \<alpha>) = \<alpha>"
  proof transfer
    fix \<alpha>
    obtain a b c d where AA: "Rep_plane_vec \<alpha> = (a, b, c, d)"
      by (cases "Rep_plane_vec \<alpha>") auto
    thus "plane_vec_eq (inv_stereographic_circline_rep (stereographic_circline_rep \<alpha>)) \<alpha>"
      using AA
      by (simp add: plane_vec_eq_def stereographic_circline_rep_Rep) (rule_tac x=1 in exI, auto simp add: field_simps complex_of_real_def)
  qed
qed

lemma stereographic_sphere_circle_set'':
  "on_sphere_circle (inv_stereographic_circline H) z \<longleftrightarrow> on_circline H (stereographic z)"
proof
  assume "on_sphere_circle (inv_stereographic_circline H) z"
  thus "on_circline H (stereographic z)"
  proof transfer
    fix M H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    have *: "is_real A" "is_real D" "C = cnj B"
      using Rep_circline_mat[of H] HH hermitean_elems[of A B C D]
      by auto
    obtain x y z where MM: "Rep_riemann_sphere M = (x, y, z)"
      by (cases "Rep_riemann_sphere M") auto
    assume **: "on_sphere_circle_rep (inv_stereographic_circline_rep H) M"
    show "on_circline_rep H (stereographic_coords M)"
    proof (cases "z=1")
      case True
      hence "x = 0" "y = 0"
        using MM Rep_riemann_sphere[of M]
        by auto
      thus ?thesis
        using * ** HH MM `z=1`
        by (cases A, simp add: on_circline_rep_def stereographic_coords_rep on_sphere_circle_rep_def vec_cnj_def Let_def)
    next
      case False
      hence "Re A*(1+z) + 2*Re B*x + 2*Im B*y + Re D*(1-z) = 0"
        using * ** HH MM
        by (simp add: on_sphere_circle_rep_def Let_def field_simps)
      hence "(Re A*(1+z) + 2*Re B*x + 2*Im B*y + Re D*(1-z))*(1-z) = 0"
        by simp
      hence "Re A*(1+z)*(1-z) + 2*Re B*x*(1-z) + 2*Im B*y*(1-z) + Re D*(1-z)*(1-z) = 0"
        by (simp add: field_simps)
      moreover
      have "x*x+y*y = (1+z)*(1-z)"
        using MM Rep_riemann_sphere[of M]
        by (simp add: field_simps)
      ultimately
      have "Re A*(x*x+y*y) + 2*Re B*x*(1-z) + 2*Im B*y*(1-z) + Re D*(1-z)*(1-z) = 0"
        by simp
      hence "(x * Re A + (1 - z) * Re B) * x - (- (y * Re A) + - ((1 - z) * Im B)) * y + (x * Re B + y * Im B + (1 - z) * Re D) * (1 - z) = 0"
        by (simp add: field_simps)
      thus ?thesis
        using `z \<noteq> 1` HH MM * `Re A*(1+z) + 2*Re B*x + 2*Im B*y + Re D*(1-z) = 0`
        apply (simp add: on_circline_rep_def stereographic_coords_rep Let_def vec_cnj_def complex_cnj)
        apply (subst complex_eq_iff)
        apply (simp add: field_simps)
        done
    qed
  qed
next
  assume "on_circline H (stereographic z)"
  thus "on_sphere_circle (inv_stereographic_circline H) z"
  proof transfer
    fix H M
    fix M H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    have *: "is_real A" "is_real D" "C = cnj B"
      using Rep_circline_mat[of H] HH hermitean_elems[of A B C D]
      by auto
    obtain x y z where MM: "Rep_riemann_sphere M = (x, y, z)"
      by (cases "Rep_riemann_sphere M") auto
    assume **: "on_circline_rep H (stereographic_coords M)"
    show "on_sphere_circle_rep (inv_stereographic_circline_rep H) M"
    proof (cases "z=1")
      case True
      hence "x = 0" "y = 0"
        using MM Rep_riemann_sphere[of M]
        by auto
      thus ?thesis
        using HH MM ** `z = 1`
        by (simp add: on_sphere_circle_rep_def on_circline_rep_def Let_def vec_cnj_def stereographic_coords_rep)
    next
      case False
      hence "(x * Re A + (1 - z) * Re B) * x - (- (y * Re A) + - ((1 - z) * Im B)) * y + (x * Re B + y * Im B + (1 - z) * Re D) * (1 - z) = 0"
        using HH MM * **
        by (simp add: on_circline_rep_def Let_def vec_cnj_def stereographic_coords_rep complex_eq_iff)
      hence "Re A*(x*x+y*y) + 2*Re B*x*(1-z) + 2*Im B*y*(1-z) + Re D*(1-z)*(1-z) = 0"
        by (simp add: field_simps)
      moreover
      have "x*x + y*y = (1+z)*(1-z)"
        using MM Rep_riemann_sphere[of M]
        by (simp add: field_simps)
      ultimately
      have "Re A*(1+z)*(1-z) + 2*Re B*x*(1-z) + 2*Im B*y*(1-z) + Re D*(1-z)*(1-z) = 0"
        by simp
      hence "(Re A*(1+z) + 2*Re B*x + 2*Im B*y + Re D*(1-z))*(1-z) = 0"
        by (simp add: field_simps)
      hence "Re A*(1+z) + 2*Re B*x + 2*Im B*y + Re D*(1-z) = 0"
        using `z \<noteq> 1`
        by simp
      thus ?thesis
        using MM HH *
        by (simp add: on_sphere_circle_rep_def field_simps)
    qed
  qed
qed

lemma stereographic_sphere_circle_set':
  "stereographic ` sphere_circle_set (inv_stereographic_circline H) = circline_set H"
unfolding sphere_circle_set_def circline_set_def
apply safe
proof-
  fix x
  assume "on_sphere_circle (inv_stereographic_circline H) x"
  thus "on_circline H (stereographic x)"
    using stereographic_sphere_circle_set''
    by simp
next
  fix x
  assume "on_circline H x"
  show "x \<in> stereographic ` {z. on_sphere_circle (inv_stereographic_circline H) z}"
  proof
    show "x = stereographic (inv_stereographic x)"
      by (simp add: stereographic_inv_stereographic)
  next
    show "inv_stereographic x \<in> {z. on_sphere_circle (inv_stereographic_circline H) z}"
      using stereographic_sphere_circle_set''[of H "inv_stereographic x"] `on_circline H x`
      by (simp add: stereographic_inv_stereographic)
  qed
qed

lemma stereographic_sphere_circle_set:
  shows "stereographic ` sphere_circle_set H = circline_set (stereographic_circline H)"
using stereographic_sphere_circle_set'[of "stereographic_circline H"]
using inv_stereographic_circline_stereographic_circline
unfolding comp_def
by (metis id_apply)

lemma "bij stereographic_circline"
using stereographic_circline_inv_stereographic_circline inv_stereographic_circline_stereographic_circline
by (metis bij_def image_compose inj_iff inj_imp_surj_inv inj_on_imageI2 inv_id surj_id surj_iff)

lemma "bij inv_stereographic_circline"
using stereographic_circline_inv_stereographic_circline inv_stereographic_circline_stereographic_circline
by (metis bij_def image_compose inj_iff inj_imp_surj_inv inj_on_imageI2 inv_id surj_id surj_iff)

subsection{* Some special circlines *}
text {* Unit circle *}

definition unit_circle_rep where 
  [simp]: "unit_circle_rep = Abs_circline_mat (1, 0, 0, -1)"

lemma [simp]: "Rep_circline_mat (Abs_circline_mat (1, 0, 0, -1)) = (1, 0, 0, -1)"
by (auto simp add: Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def)

lemma [simp]: "Rep_circline_mat unit_circle_rep = (1, 0, 0, -1)"
by simp

lift_definition unit_circle :: "circline" is unit_circle_rep
done

lemma one_on_unit_circle: "1\<^sub>h \<in> circline_set unit_circle"
unfolding circline_set_def
by (simp, transfer, simp add: on_circline_rep_def Let_def vec_cnj_def)

text{* @{term "x_axis"} *}
definition x_axis_rep where "x_axis_rep = Abs_circline_mat (0, ii, -ii, 0)"
lift_definition x_axis :: "circline" is x_axis_rep
done

lemma [simp]:  "Rep_circline_mat (Abs_circline_mat (0, ii, -ii, 0)) = (0, ii, -ii, 0)"
using Abs_circline_mat_inverse[of "(0, ii, -ii, 0)"]
by (simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj)

lemma [simp]:  "Rep_circline_mat x_axis_rep = (0, ii, -ii, 0)"
unfolding x_axis_rep_def
by simp

lemma [simp]: "0\<^sub>h \<in> circline_set x_axis"  "1\<^sub>h \<in> circline_set x_axis" "\<infinity>\<^sub>h \<in> circline_set x_axis"
  unfolding circline_set_def
  by auto (transfer, simp add: on_circline_rep_def Let_def vec_cnj_def)+

text{* Point @{term "0\<^sub>h"} as a circline *}
definition circline_point_0h_rep where "circline_point_0h_rep = Abs_circline_mat (1, 0, 0, 0)"

lift_definition circline_point_0h :: "circline" is circline_point_0h_rep
done

lemma [simp]: "Rep_circline_mat (Abs_circline_mat (1, 0, 0, 0)) = (1, 0, 0, 0)"
using Abs_circline_mat_inverse 
by (simp add: hermitean_def mat_adj_def mat_cnj_def)

lemma [simp]: "Rep_circline_mat circline_point_0h_rep = (1, 0, 0, 0)"
unfolding circline_point_0h_rep_def
by simp

text{* imaginary unit circle *}
definition imag_unit_circle_rep where 
  [simp]: "imag_unit_circle_rep = Abs_circline_mat (1, 0, 0, 1)"

lemma [simp]: "Rep_circline_mat (Abs_circline_mat (1, 0, 0, 1)) = (1, 0, 0, 1)"
by (auto simp add: Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def)

lemma [simp]: "Rep_circline_mat imag_unit_circle_rep = (1, 0, 0, 1)"
by simp

lift_definition imag_unit_circle :: "circline" is imag_unit_circle_rep
done

subsection {* Moebius action on circlines *}
definition moebius_circline_rep :: "moebius_mat \<Rightarrow> circline_mat \<Rightarrow> circline_mat" where 
  "moebius_circline_rep M H = 
      (let M = Rep_moebius_mat M; 
           H = Rep_circline_mat H 
        in Abs_circline_mat (congruence (mat_inv M) H))"

lemma [simp]: "Rep_circline_mat (Abs_circline_mat (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H))) = congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)"
proof (rule Abs_circline_mat_inverse, safe)
  show "hermitean (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H))"
    using Rep_circline_mat[of H] 
    using hermitean_congruence
    by simp
next
  assume "congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H) = mat_zero"
  thus False
    using Rep_circline_mat[of H] Rep_moebius_mat[of M] mat_det_inv
    using congruence_nonzero
    by auto
qed

lemma moebius_circline_rep_Rep [simp]: "Rep_circline_mat (moebius_circline_rep M H) = congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)"
by (simp add: moebius_circline_rep_def Let_def)

lift_definition moebius_circline :: "moebius \<Rightarrow> circline \<Rightarrow> circline" is moebius_circline_rep
proof-
  fix M M' H H'
  assume "moebius_mat_eq M M'" "circline_mat_eq H H'"
  thus "circline_mat_eq (moebius_circline_rep M H) (moebius_circline_rep M' H')"
    by (auto simp add: mat_inv_mult_sm complex_cnj) (rule_tac x="ka / Re (k * cnj k)" in exI, auto simp add: complex_mult_cnj_cmod power2_eq_square)
qed

lemma moebius_preserve_circline_type:
  shows "circline_type (moebius_circline M H) = circline_type H"
proof (transfer)
  fix M H
  show "circline_type_rep (moebius_circline_rep M H) = circline_type_rep H"
    unfolding circline_type_rep_def Let_def
    apply simp
    using Re_det_sgn_congruence[of "Rep_circline_mat H" "mat_inv (Rep_moebius_mat M)"] 
    using Rep_circline_mat[of H] Rep_moebius_mat[of M]  mat_det_inv[of "Rep_moebius_mat M"]
    by simp
qed

lemma moebius_circline_rep:
  shows "moebius_pt_rep M ` {z. on_circline_rep H z} = {z. on_circline_rep (moebius_circline_rep M H) z}"
proof (safe)
  fix z
  let ?M = "Rep_moebius_mat M"
  let ?H = "Rep_circline_mat H"
  let ?z = "Rep_homo_coords z"
  let ?H' = "Rep_circline_mat H'"
  let ?z' = "Rep_moebius_mat M *\<^sub>m\<^sub>v Rep_homo_coords z" 
  let ?H'' = "mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m ?H *\<^sub>m\<^sub>m (mat_inv ?M)"
  assume "on_circline_rep H z" 
  hence "quad_form ?z ?H = 0"
    by (simp add: on_circline_rep_def Let_def)
  hence "quad_form ?z' ?H'' = 0"
    using quad_form_congruence[of ?M ?z ?H] Rep_moebius_mat[of M]
    by simp
  thus "on_circline_rep (moebius_circline_rep M H) (moebius_pt_rep M z)"
    by (auto simp add: moebius_circline_rep_def on_circline_rep_def moebius_pt_rep_def Let_def) 
next
  fix z
  let ?z = "Rep_homo_coords z"
  let ?M = "Rep_moebius_mat M"
  let ?H = "Rep_circline_mat H"
  let ?iM = "mat_inv ?M"
  let ?z' = "mat_inv ?M *\<^sub>m\<^sub>v ?z"

  assume "on_circline_rep (moebius_circline_rep M H) z"
  hence "quad_form ?z (congruence (mat_inv ?M) ?H) = 0"
    unfolding on_circline_rep_def Let_def
    by simp

  have "?z' \<noteq> (0, 0)"
    using Rep_homo_coords[of z] mult_mv_nonzero[of ?z ?iM] Rep_moebius_mat[of M] mat_det_inv[of ?M]
    by simp
  hence *: "Rep_homo_coords (Abs_homo_coords ?z') = ?z'"
    by (simp add: Abs_homo_coords_inverse)

  show "z \<in> moebius_pt_rep M ` {z. on_circline_rep H z}"
  proof
    show "z = moebius_pt_rep M (Abs_homo_coords ?z')"
      using * Rep_moebius_mat[of M] eye_mv_l[of ?z]
      unfolding moebius_pt_rep_def Let_def
      by (simp add: mat_inv_r Rep_homo_coords_inverse)
  next
    have "Rep_moebius_mat M *\<^sub>m\<^sub>m mat_inv (Rep_moebius_mat M) *\<^sub>m\<^sub>v Rep_homo_coords z = ?z"
      using Rep_moebius_mat[of M]
      by (subst mat_inv_r) (auto simp add: simp del: eye_def)
    thus "Abs_homo_coords ?z' \<in> {z. on_circline_rep H z}"
      using *
      using `quad_form ?z (congruence (mat_inv ?M) ?H) = 0` Rep_moebius_mat[of M]
      by (auto simp add: on_circline_rep_def Let_def simp del: quad_form_def) (subst quad_form_congruence[of ?M "?iM *\<^sub>m\<^sub>v ?z" ?H, symmetric], auto)
  qed
qed

lemma moebius_circline_set:
  shows "moebius_pt M ` circline_set H = circline_set (moebius_circline M H)" (is "?lhs = ?rhs")
proof
  show "?lhs \<subseteq> ?rhs"
  proof (safe)
    fix z::complex_homo
    assume "z \<in> circline_set H"
    thus "moebius_pt M z \<in> circline_set (moebius_circline M H)"
      unfolding circline_set_def
      using moebius_circline_rep
      by simp (transfer, auto)
  qed
next
  show "?rhs \<subseteq> ?lhs"
  proof
    fix z
    assume "z \<in> circline_set (moebius_circline M H)"
    thus "z \<in> moebius_pt M ` circline_set H"
      using assms
      unfolding circline_set_def
      apply (simp add: image_def)
    proof (transfer)
      fix M H z
      assume "on_circline_rep (moebius_circline_rep M H) z"
      then obtain z' where "on_circline_rep H z'" "z = moebius_pt_rep M z'"
        using moebius_circline_rep[of M H]
        by auto
      thus "\<exists>z'. on_circline_rep H z' \<and> z \<approx> moebius_pt_rep M z'"
        by (rule_tac x="z'" in exI, simp, rule_tac x="1" in exI, simp)
    qed
  qed
qed

lemma
  inj_moebius_circline: "inj (moebius_circline M)"
unfolding inj_on_def
proof (safe)
  fix H H'
  assume "moebius_circline M H = moebius_circline M H'"
  thus "H = H'"
  proof (transfer)
    fix M H H'
    let ?M = "Rep_moebius_mat M"
    let ?iM = "mat_inv ?M"
    let ?H = "Rep_circline_mat H" and ?H' = "Rep_circline_mat H'"
    assume "circline_mat_eq (moebius_circline_rep M H) (moebius_circline_rep M H')"
    then obtain k where "congruence ?iM ?H' = congruence ?iM (cor k *\<^sub>s\<^sub>m ?H)" "k \<noteq> 0"
      by auto
    thus "circline_mat_eq H H'"
      using Rep_moebius_mat[of M] inj_congruence[of ?iM ?H' "cor k *\<^sub>s\<^sub>m ?H"] mat_det_inv[of ?M]
      by auto
  qed
qed

lemma [simp]:
  "moebius_circline id_moebius H = H"
proof transfer
  fix H
  show "circline_mat_eq (moebius_circline_rep id_moebius_rep H) H"
    by (cases "Rep_circline_mat H", simp) (rule_tac x="1" in exI, simp add: mat_adj_def mat_cnj_def)
qed

lemma moebius_circline_comp: 
  "moebius_circline M1 (moebius_circline M2 H) = moebius_circline (moebius_comp M1 M2) H"
proof (transfer)
  fix M1 M2 H
  show "circline_mat_eq (moebius_circline_rep M1 (moebius_circline_rep M2 H)) (moebius_circline_rep (moebius_comp_rep M1 M2) H)"
    using congruence_congruence Rep_moebius_mat[of M1] Rep_moebius_mat[of M2]
    by (simp add: mat_inv_mult_mm, rule_tac x=1 in exI, simp)
qed

lemma moebius_circline_comp_inv [simp]: 
  "moebius_circline (moebius_inv M) (moebius_circline M H) = H"
by (subst moebius_circline_comp) simp

lemma moebius_circline_comp_inv' [simp]: 
  "moebius_circline M (moebius_circline (moebius_inv M) H) = H"
by (subst moebius_circline_comp) simp

lemma
  moebius_circline_set_mem:
  "moebius_pt M z \<in> circline_set (moebius_circline M H) \<longleftrightarrow> z \<in> circline_set H"
using moebius_circline_set[of M H, symmetric] bij_moebius_pt[of M]
by (auto simp add: bij_def inj_on_def)

subsection {* Conjugation, recpiprocation and inversion of circlines *}
text{* Conjugation of circlines *}
definition circline_cnj_rep where
  "circline_cnj_rep H = Abs_circline_mat (mat_cnj (Rep_circline_mat H))"

lemma [simp]: "Rep_circline_mat (Abs_circline_mat (mat_cnj (Rep_circline_mat H))) = mat_cnj (Rep_circline_mat H)"
using Rep_circline_mat[of H] hermitean_mat_cnj nonzero_mat_cnj
by (auto simp add: Abs_circline_mat_inverse)

lemma [simp]: "Rep_circline_mat (circline_cnj_rep H) = mat_cnj (Rep_circline_mat H)"
by (simp add: circline_cnj_rep_def)

lift_definition circline_cnj :: "circline \<Rightarrow> circline" is circline_cnj_rep
proof-
  fix H H'
  assume "circline_mat_eq H H'"
  thus "circline_mat_eq (circline_cnj_rep H) (circline_cnj_rep H')"
    using Rep_circline_mat[of H] Rep_circline_mat[of H']
    by auto
qed

lemma cnj_homo_circline_set':
  shows "cnj_homo ` circline_set H \<subseteq> circline_set (circline_cnj H)"
proof (safe)
  fix z
  assume "z \<in> circline_set H"
  thus "cnj_homo z \<in> circline_set (circline_cnj H)"
    unfolding circline_set_def
    apply simp
  proof (transfer)
    fix z H
    assume "on_circline_rep H z"
    obtain z1 z2 where zz: "Rep_homo_coords z = (z1, z2)"
      by (rule obtain_homo_coords)

    have "(cnj z1, cnj z2) *\<^sub>v\<^sub>m Rep_circline_mat H *\<^sub>v\<^sub>v (z1, z2) = 0"
      using `on_circline_rep H z` zz
      unfolding on_circline_rep_def Let_def
      by (simp add: vec_cnj_def)
    hence "cnj ((cnj z1, cnj z2) *\<^sub>v\<^sub>m Rep_circline_mat H *\<^sub>v\<^sub>v (z1, z2)) = 0"
      by simp
    hence "(z1, z2) *\<^sub>v\<^sub>m mat_cnj (Rep_circline_mat H) *\<^sub>v\<^sub>v (cnj z1, cnj z2) = 0"
      by (subst (asm) cnj_mult_vv) (cases "Rep_circline_mat H", simp add: vec_cnj_def mat_cnj_def complex_cnj)
    thus "on_circline_rep (circline_cnj_rep H) (cnj_homo_coords z)"
      unfolding on_circline_rep_def Let_def
      using zz
      by (simp add: vec_cnj_def)
  qed
qed

lemma [simp]: "circline_cnj (circline_cnj H) = H"
by (transfer) (auto simp add: circline_cnj_rep_def Rep_circline_mat_inverse, rule_tac x="1" in exI, simp)

lemma cnj_homo_circline_set:
  shows "cnj_homo ` circline_set H = circline_set (circline_cnj H)" (is "?lhs = ?rhs")
proof (safe)
  fix z
  assume "z \<in> circline_set (circline_cnj H)"
  show "z \<in> cnj_homo ` circline_set H"
  proof
    show "z = cnj_homo (cnj_homo z)"
      by simp
  next
    show "cnj_homo z \<in> circline_set H"
      using `z \<in> circline_set (circline_cnj H)`
      using cnj_homo_circline_set'[of "circline_cnj H"]
      by auto
  qed
next
  fix z
  assume "z \<in> circline_set H"
  thus "cnj_homo z \<in> circline_set (circline_cnj H)"
    using cnj_homo_circline_set'[of H]
    by auto
qed

text {* Reciprocal and inversion of circlines *}
definition circline_swap_AD_rep where 
  "circline_swap_AD_rep H = 
     (let (A, B, C, D) = Rep_circline_mat H 
      in Abs_circline_mat (D, B, C, A))"

lemma
  shows [simp]: "Rep_circline_mat (circline_swap_AD_rep H) = (let (A, B, C, D) = Rep_circline_mat H in (D, B, C, A))"
proof-
  obtain A B C D where hh: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  have "hermitean (D, B, C, A) \<and> (D, B, C, A) \<noteq> mat_zero"
    using Rep_circline_mat[of H] hh
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def)
  thus ?thesis
    using hh
    unfolding circline_swap_AD_rep_def Let_def
    by (cases "Rep_circline_mat H") (simp add: Abs_circline_mat_inverse)
qed

lift_definition circline_swap_AD :: "circline \<Rightarrow> circline" is circline_swap_AD_rep
proof-
  fix H H' :: "circline_mat"
  assume "circline_mat_eq H H'"
  thus "circline_mat_eq (circline_swap_AD_rep H) (circline_swap_AD_rep H')"
    by (cases "Rep_circline_mat H", cases "Rep_circline_mat H'") auto
qed

lemma reciprocal_circline_set:
  shows "reciprocal_homo ` circline_set H = circline_set ((circline_cnj \<circ> circline_swap_AD) H)"
proof (subst reciprocal_moebius, subst moebius_circline_set)
  have "moebius_circline reciprocal_moebius H = (circline_cnj \<circ> circline_swap_AD) H"
    unfolding reciprocal_moebius_def
  proof (transfer)
    fix H :: "circline_mat"
    obtain A B C D where H: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") blast
    thus "circline_mat_eq (moebius_circline_rep (mk_moebius_rep 0 1 1 0) H) ((circline_cnj_rep \<circ> circline_swap_AD_rep) H)"
      using Rep_circline_mat[of H]
      by (simp add: mat_adj_def mat_cnj_def hermitean_def) (rule_tac x="1" in exI, simp)
  qed
  thus "circline_set (moebius_circline reciprocal_moebius H) = circline_set ((circline_cnj \<circ> circline_swap_AD) H)"
    by simp
qed

lemma inversion_circline_set:
  shows "inversion_homo ` circline_set H = circline_set (circline_swap_AD H)"
unfolding inversion_homo_def image_comp
by (subst reciprocal_circline_set, subst cnj_homo_circline_set, rule arg_cong[where f="circline_set"]) simp

subsection{* Circline uniqueness *}

subsubsection{* Zero type circline uniqueness *}
lemma unique_circline_type_zero_0h':
  shows "(circline_type circline_point_0h = 0 \<and> 0\<^sub>h \<in> circline_set circline_point_0h) \<and> 
         (\<forall> H. circline_type H = 0 \<and> 0\<^sub>h \<in> circline_set H \<longrightarrow> H = circline_point_0h)"
unfolding circline_set_def
proof (safe)
  show "circline_type circline_point_0h = 0"
    by (transfer) (simp add: circline_type_rep_def circline_point_0h_rep_def)
next
  show "on_circline circline_point_0h 0\<^sub>h"
    by (transfer) (simp add: on_circline_rep_def Let_def vec_cnj_def)
next
  fix H
  assume "circline_type H = 0" "on_circline H 0\<^sub>h" 
  thus "H = circline_point_0h"
  proof (transfer)
    fix H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    hence *: "C = cnj B" "is_real A"
      using Rep_circline_mat[of H] hermitean_elems[of A B C D]
      by auto
    assume "circline_type_rep H = 0" "on_circline_rep H zero_homo_rep"
    thus "circline_mat_eq H circline_point_0h_rep"
      using * Rep_circline_mat[of H] HH
      by (simp add: on_circline_rep_def Let_def Abs_circline_mat_inverse vec_cnj_def circline_type_rep_def sgn_minus sgn_mult sgn_zero_iff)
         (rule_tac x="1/Re A" in exI, cases A, cases B, simp add: complex_of_real_Re sgn_zero_iff)
  qed
qed

lemma unique_circline_type_zero_0h:
  shows "\<exists>! H. circline_type H = 0 \<and> 0\<^sub>h \<in> circline_set H"
using unique_circline_type_zero_0h'
by auto

lemma unique_circline_type_zero:
  shows "\<exists>! H. circline_type H = 0 \<and> z \<in> circline_set H"
proof-
  obtain M where ++: "moebius_pt M z = 0\<^sub>h"
    using ex_moebius_1[of z]
    by auto
  have +++: "z = moebius_pt (moebius_inv M) 0\<^sub>h"
    by (subst ++[symmetric]) simp
  then obtain H0 where *: "circline_type H0 = 0 \<and> 0\<^sub>h \<in> circline_set H0" and
    **: "\<forall> H'. circline_type H' = 0 \<and> 0\<^sub>h \<in> circline_set H' \<longrightarrow> H' = H0"
    using unique_circline_type_zero_0h
    by auto
  let ?H' = "moebius_circline (moebius_inv M) H0"
  show ?thesis
    unfolding Ex1_def
    using * +++
  proof (rule_tac x="?H'" in exI, simp add: moebius_preserve_circline_type moebius_circline_set[symmetric], safe)
    fix H'
    assume "circline_type H' = 0" "moebius_pt (moebius_inv M) 0\<^sub>h \<in> circline_set H'"
    hence "0\<^sub>h \<in> circline_set (moebius_circline M H')"
      by (metis "++" "+++" imageI moebius_circline_set)
    hence "moebius_circline M H' = H0"
      using **[rule_format, of "moebius_circline M H'"]
      using moebius_preserve_circline_type[of M H'] `circline_type H' = 0`
      by simp
    thus "H' = moebius_circline (moebius_inv M) H0"
      by auto
  qed
qed

subsubsection{* Negative type circline uniqueness *}
lemma unique_circline_01inf':
  "0\<^sub>h \<in> circline_set x_axis \<and> 1\<^sub>h \<in> circline_set x_axis \<and> \<infinity>\<^sub>h \<in> circline_set x_axis \<and> 
   (\<forall> H. 0\<^sub>h \<in> circline_set H \<and> 1\<^sub>h \<in> circline_set H \<and> \<infinity>\<^sub>h \<in> circline_set H  \<longrightarrow> H = x_axis)"
proof safe
  fix H
  assume "0\<^sub>h \<in> circline_set H"  "1\<^sub>h \<in> circline_set H" "\<infinity>\<^sub>h \<in> circline_set H"
  thus "H = x_axis"
    unfolding circline_set_def
    apply simp
  proof (transfer)
    fix H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    have *: "C = cnj B" "A = 0 \<and> D = 0 \<longrightarrow> B \<noteq> 0"
      using hermitean_elems[of A B C D] Rep_circline_mat[of H] HH
      by auto
    obtain Bx By where "B = Complex Bx By"
      by (cases B) auto
    assume "on_circline_rep H zero_homo_rep" "on_circline_rep H one_homo_rep" "on_circline_rep H inf_homo_rep"
    thus "circline_mat_eq H x_axis_rep"
      using * HH `C = cnj B` `B = Complex Bx By`
      by (simp add: on_circline_rep_def Let_def mk_circline_rep_def Abs_circline_mat_inverse vec_cnj_def complex_of_real_def i_def, rule_tac x="1/By" in exI, auto )
  qed
qed simp_all

lemma unique_circline_set:
  assumes "A \<noteq> B" "A \<noteq> C" "B \<noteq> C"
  shows "\<exists>! H. A \<in> circline_set H \<and> B \<in> circline_set H \<and> C \<in> circline_set H"
proof-
  let ?P = "\<lambda> A B C. A \<noteq> B \<and> A \<noteq> C \<and> B \<noteq> C \<longrightarrow> (\<exists>! H. A \<in> circline_set H \<and> B \<in> circline_set H \<and> C \<in> circline_set H)"
  have "?P A B C"
  proof (rule wlog_moebius_01inf[of ?P])
    fix M a b c
    let ?M = "moebius_pt M"
    assume "?P a b c"
    show "?P (?M a) (?M b) (?M c)"
    proof
      assume "?M a \<noteq> ?M b \<and> ?M a \<noteq> ?M c \<and> ?M b \<noteq> ?M c"
      hence "a \<noteq> b" "b \<noteq> c" "a \<noteq> c"
        using bij_moebius_pt[of M]
        by (auto simp add: bij_def inj_on_def)
      hence "\<exists>!H. a \<in> circline_set H \<and> b \<in> circline_set H \<and> c \<in> circline_set H"
        using `?P a b c`
        by simp
      then obtain H where
        *: "a \<in> circline_set H \<and> b \<in> circline_set H \<and> c \<in> circline_set H" and
        **: "\<forall>H'. a \<in> circline_set H' \<and> b \<in> circline_set H' \<and> c \<in> circline_set H' \<longrightarrow> H' = H"
        unfolding Ex1_def
        by auto
      let ?H' = "moebius_circline M H"
      show "\<exists>! H. ?M a \<in> circline_set H \<and> moebius_pt M b \<in> circline_set H \<and> moebius_pt M c \<in> circline_set H"
        unfolding Ex1_def
      proof (rule_tac x="?H'" in exI, rule)
        show "?M a \<in> circline_set ?H' \<and> ?M b \<in> circline_set ?H' \<and> ?M c \<in> circline_set ?H'"
          using * moebius_circline_set_mem[of M _ H]
          by blast
      next
        show "\<forall>H'. ?M a \<in> circline_set H' \<and> ?M b \<in> circline_set H' \<and> ?M c \<in> circline_set H' \<longrightarrow> H' = ?H'"
        proof (safe)
          fix H'
          let ?iH' = "moebius_circline (moebius_inv M) H'"
          assume "?M a \<in> circline_set H'" "?M b \<in> circline_set H'" "?M c \<in> circline_set H'"
          hence "a \<in> circline_set ?iH' \<and> b \<in> circline_set ?iH' \<and> c \<in> circline_set ?iH'"
            using moebius_circline_set_mem[of M _ ?iH', simplified]
            by simp
          hence "H = ?iH'"
            using **
            by simp
          thus "H' = moebius_circline M H"
            by simp
        qed
      qed
    qed
  next
    show "?P 0\<^sub>h 1\<^sub>h \<infinity>\<^sub>h"
      using unique_circline_01inf'
      unfolding Ex1_def
      by (safe, rule_tac x="x_axis" in exI) auto
  qed fact+
  thus ?thesis
    using assms
    by simp
qed


subsection{* Circline set cardinality *}

subsubsection{* Diagonal circlines *}
definition circline_diag_rep where
   "circline_diag_rep H \<longleftrightarrow> mat_diagonal (Rep_circline_mat H)"
lemma [simp]: "mat_diagonal H \<longleftrightarrow> (let (A, B, C, D) = H in B = 0 \<and> C = 0)"
by (cases H) simp

lift_definition circline_diag :: "circline \<Rightarrow> bool" is circline_diag_rep
by (auto simp add: circline_diag_rep_def)


lemma det_zero_trace_zero:
  assumes "mat_det A = 0" "mat_trace A = (0::complex)" "hermitean A"
  shows "A = mat_zero"
using assms
proof-
  {
    fix a d c
    assume "a * d = cnj c * c" "a + d = 0" "cnj a = a"
    from `a + d = 0` have "d = -a"
      by (metis add_eq_0_iff)
    hence "- (cor (Re a))\<^sup>2  = (cor (cmod c))\<^sup>2"
      using `cnj a = a` eq_cnj_iff_real[of a]
      using `a*d = cnj c * c`
      using complex_mult_cnj_cmod[of "cnj c"]
      by (simp add: complex_of_real_Re power2_eq_square)
    hence "- (Re a)\<^sup>2 \<ge> 0"
      using zero_le_power2[of "cmod c"]
      by (metis Re_complex_of_real cor_squared of_real_minus)
    hence "a = 0"
      using zero_le_power2[of "Re a"]
      using `cnj a = a`  eq_cnj_iff_real[of a]
      by (cases a) simp
  } note * = this
  obtain a b c d where "A = (a, b, c, d)"
    by (cases A) auto
  thus ?thesis
    using *[of a d c]  *[of d a c]
    using assms `A = (a, b, c, d)`
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def)
qed


lemma circline_diagonalize:
  shows "\<exists> M H'. moebius_circline M H = H' \<and> circline_diag H'"
using assms
proof transfer
  fix H
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence HH_elems: "is_real A" "is_real D" "C = cnj B"
    using hermitean_elems[of A B C D]  Rep_circline_mat[of H]
    by auto
  obtain M k1 k2 where *: "mat_det M \<noteq> 0" "unitary M" "congruence M (Rep_circline_mat H) = (k1, 0, 0, k2)" "is_real k1" "is_real k2" 
    using hermitean_diagonizable[of "Rep_circline_mat H"] Rep_circline_mat[of H]
    by auto
  have "k1 \<noteq> 0 \<or> k2 \<noteq> 0"
    using `congruence M (Rep_circline_mat H) = (k1, 0, 0, k2)` Rep_circline_mat[of H] congruence_nonzero[of "Rep_circline_mat H" M] `mat_det M \<noteq> 0`
    by auto
    
  have **: "Rep_circline_mat (Abs_circline_mat (k1, 0, 0, k2)) = (k1, 0, 0, k2)"
    apply (rule Abs_circline_mat_inverse)
    using `is_real k1` `is_real k2` `k1 \<noteq> 0 \<or> k2 \<noteq> 0`
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def eq_cnj_iff_real[symmetric])

  thus "\<exists>M H'. circline_mat_eq (moebius_circline_rep M H) H' \<and> circline_diag_rep H'"
    using * mat_det_inv[of M]
    by (rule_tac x="Abs_moebius_mat (mat_inv M)" in exI, rule_tac x="Abs_circline_mat (k1, 0, 0, k2)" in exI)
       (simp add: Abs_moebius_mat_inverse circline_diag_rep_def, rule_tac x=1 in exI, simp)
qed

lemma wlog_circline_diag:
  assumes "\<And> H. circline_diag H \<Longrightarrow> P H" 
          "\<And> M H. P H \<Longrightarrow> P (moebius_circline M H)"
  shows "P H"
proof-
  obtain M H' where "moebius_circline M H = H'" "circline_diag H'"
    using circline_diagonalize[of H]
    by auto
  hence "P (moebius_circline M H)"
    using assms(1)
    by simp
  thus ?thesis
    using assms(2)[of "moebius_circline M H" "moebius_inv M"]
    by simp
qed

subsubsection{* Zero type circline set cardinality *}
lemma circline_type_zero_card_eq1_0h:
  assumes "circline_type H = 0" "0\<^sub>h \<in> circline_set H"
  shows "circline_set H = {0\<^sub>h}"
using assms
unfolding circline_set_def
proof(safe)
  fix z
  assume "on_circline H z" "circline_type H = 0" "on_circline H 0\<^sub>h"
  hence "H = circline_point_0h"
    using unique_circline_type_zero_0h'
    unfolding circline_set_def
    by simp
  thus "z = 0\<^sub>h"
    using `on_circline H z`
  proof transfer
    fix H z
    assume "circline_mat_eq H circline_point_0h_rep" "on_circline_rep H z"
    thus "z \<approx> zero_homo_rep"
      using Rep_homo_coords[of z]
      by (cases "Rep_homo_coords z", cases "Rep_circline_mat H") (simp add: circline_point_0h_rep_def on_circline_rep_def Let_def vec_cnj_def, rule_tac x="1/b" in exI, auto)
  qed
qed

lemma bij_image_singleton:
  "\<lbrakk>f ` A = {b}; f a = b; bij f\<rbrakk> \<Longrightarrow> A = {a}"
by (metis (mono_tags) bij_betw_imp_inj_on image_empty image_insert inj_vimage_image_eq)

lemma circline_type_zero_card_eq1:
  assumes "circline_type H = 0"
  shows "\<exists> z. circline_set H = {z}"
proof-
  have "\<exists> z. on_circline H z"
    using assms
  proof transfer
    fix H
    obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
      by (cases "Rep_circline_mat H") auto
    hence "C = cnj B" "is_real A" "is_real D"
      using Rep_circline_mat[of H] hermitean_elems[of A B C D]
      by auto
    assume "circline_type_rep H = 0"
    hence "mat_det (Rep_circline_mat H) = 0"
      using Rep_circline_mat[of H] mat_det_hermitean_real[of "Rep_circline_mat H"]
      by (auto simp add: circline_type_rep_def sgn_zero_iff) (metis complex_surj complex_zero_def) 
    hence "A*D = B*C"
      using HH
      by simp
    show "Ex (on_circline_rep H)"
    proof (cases "A \<noteq> 0 \<or> B \<noteq> 0")
      case True
      thus ?thesis
        using HH `A*D = B*C`
        by (rule_tac x="Abs_homo_coords (-B, A)" in exI) (auto simp add: on_circline_rep_def Let_def Abs_homo_coords_inverse vec_cnj_def complex_cnj field_simps)
    next
      case False
      thus ?thesis
        using HH `C = cnj B`
        by (rule_tac x="Abs_homo_coords (1, 0)" in exI) (simp add: Abs_homo_coords_inverse on_circline_rep_def Let_def vec_cnj_def)
    qed
  qed
  then obtain z where "on_circline H z"
    by auto
  obtain M where "moebius_pt M z = 0\<^sub>h"
    using ex_moebius_1[of z]
    by auto
  hence "0\<^sub>h \<in> circline_set (moebius_circline M H)"
    using `on_circline H z`
    by (subst moebius_circline_set[of M H, symmetric]) (force simp add: circline_set_def)
  hence "circline_set (moebius_circline M H) = {0\<^sub>h}"
    using circline_type_zero_card_eq1_0h[of "moebius_circline M H"] `circline_type H = 0`
    by (auto simp add: moebius_preserve_circline_type)
  hence "circline_set H = {z}"
    using `moebius_pt M z = 0\<^sub>h`
    using bij_moebius_pt[of M] bij_image_singleton[of "moebius_pt M" "circline_set H" _ z]
    by (subst (asm) moebius_circline_set[symmetric]) simp
  thus ?thesis
    by auto
qed

subsubsection{* Negative type circline set cardinality *}
lemma quad_form_diagonal_iff:
  assumes "k1 \<noteq> 0" "is_real k1" "is_real k2" "Re k1 * Re k2 < 0"
  shows "quad_form (z1, 1) (k1, 0, 0, k2) = 0 \<longleftrightarrow> (\<exists> \<phi>. z1 = rcis (sqrt (Re (-k2 /k1))) \<phi>)"
proof-
  have "Re (-k2/k1) \<ge> 0"
    using `Re k1 * Re k2 < 0` `is_real k1` `is_real k2` `k1 \<noteq> 0`
    by (auto simp add: Re_divide_real) (metis less_asym mult_neg_neg mult_pos_pos not_less zero_less_divide_iff)
    
  have "quad_form (z1, 1) (k1, 0, 0, k2) = 0 \<longleftrightarrow> (cor (cmod z1))\<^sup>2 = -k2 / k1"
    using assms add_eq_0_iff[of k2 "k1*(cor (cmod z1))\<^sup>2"]
    using eq_divide_imp[of k1 "(cor (cmod z1))\<^sup>2" "-k2"]
    by (auto simp add: vec_cnj_def field_simps complex_mult_cnj_cmod)
  also have "... \<longleftrightarrow> (cmod z1)\<^sup>2 = Re (-k2 /k1)"
    using assms
    apply (subst complex_eq_if_Re_eq)
    using Re_complex_of_real[of "(cmod z1)\<^sup>2"]
    by auto (metis is_real_complex_of_real of_real_power, metis div_reals)
  also have "... \<longleftrightarrow> cmod z1 = sqrt (Re (-k2 /k1))"
    by (metis norm_ge_zero real_sqrt_ge_0_iff real_sqrt_pow2 real_sqrt_power)
  also have "... \<longleftrightarrow> (\<exists> \<phi>. z1 = rcis (sqrt (Re (-k2 /k1))) \<phi>)"
    using rcis_cmod_arg[of z1, symmetric] assms abs_of_nonneg[of "sqrt (Re (-k2/k1))"]
    using `Re (-k2/k1) \<ge> 0`
    by auto
  finally show ?thesis
    .
qed

lemma circline_type_neg_card_gt3_diag:
  assumes "circline_type H < 0" "circline_diag H"
  shows "\<exists> A B C. A \<noteq> B \<and> A \<noteq> C \<and> B \<noteq> C \<and> {A, B, C} \<subseteq> circline_set H"
using assms
unfolding circline_set_def
apply (simp del: HOL.ex_simps)
proof (transfer)
  fix H
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence HH_elems: "is_real A" "is_real D" "C = cnj B"
    using hermitean_elems[of A B C D]  Rep_circline_mat[of H]
    by auto
  assume "circline_diag_rep H" "circline_type_rep H < 0"
  hence "B = 0" "C = 0" "Re A * Re D < 0" "A \<noteq> 0"
    using HH `is_real A` `is_real D`
    unfolding circline_diag_rep_def circline_type_rep_def
    by auto

  let ?x = "sqrt (Re (- D / A))"
  let ?A = "(rcis ?x 0, 1)"
  let ?B = "(rcis ?x (pi/2), 1)"
  let ?C = "(rcis ?x pi, 1)"
  from quad_form_diagonal_iff[OF `A \<noteq> 0` `is_real A` `is_real D` `Re A * Re D < 0`]
  have "quad_form ?A (A, 0, 0, D) = 0"  "quad_form ?B (A, 0, 0, D) = 0"  "quad_form ?C (A, 0, 0, D) = 0" 
    by (auto simp del: rcis_zero_arg)
  moreover
  have "Re (D / A) < 0"
    using `Re A * Re D < 0` `A \<noteq> 0` `is_real A` `is_real D`
    by (subst Re_divide_real) (auto, metis divide_less_0_iff mult_eq_0_iff mult_neg_neg mult_pos_pos not_less_iff_gr_or_eq)
  hence "\<not> Abs_homo_coords ?A \<approx> Abs_homo_coords ?B \<and> \<not> Abs_homo_coords ?A \<approx> Abs_homo_coords ?C \<and> \<not> Abs_homo_coords ?B \<approx> Abs_homo_coords ?C "
    unfolding rcis_def
    by (auto simp add: Abs_homo_coords_inverse cis_def)
  ultimately
  show "\<exists>A B C. \<not> A \<approx> B \<and> \<not> A \<approx> C \<and> \<not> B \<approx> C \<and> (on_circline_rep H A \<and> on_circline_rep H B \<and> on_circline_rep H C)"
    using HH `B = 0` `C = 0`
    by (rule_tac x="Abs_homo_coords ?A" in exI, rule_tac x="Abs_homo_coords ?B" in exI, rule_tac x="Abs_homo_coords ?C" in exI)
       (simp add: on_circline_rep_def Abs_homo_coords_inverse Let_def)
qed

lemma circline_type_neg_card_gt3:
  assumes "circline_type H < 0"
  shows "\<exists> A B C. A \<noteq> B \<and> A \<noteq> C \<and> B \<noteq> C \<and> {A, B, C} \<subseteq> circline_set H"
proof-
  obtain M H' where "moebius_circline M H = H'" "circline_diag H'"
    using circline_diagonalize[of H] assms
    by auto
  moreover
  hence "circline_type H' < 0"
    using assms moebius_preserve_circline_type
    by auto
  ultimately
  obtain A B C where "A \<noteq> B" "A \<noteq> C" "B \<noteq> C" "{A, B, C} \<subseteq> circline_set H'"
    using circline_type_neg_card_gt3_diag[of H']
    by auto
  let ?iM = "moebius_inv M"
  have "moebius_circline ?iM H' = H"
    using `moebius_circline M H = H'`[symmetric]
    by simp
  let ?A = "moebius_pt ?iM A" and ?B= "moebius_pt ?iM B" and ?C = "moebius_pt ?iM C" 
  have "?A \<in> circline_set H"  "?B \<in> circline_set H"  "?C \<in> circline_set H"
    using `moebius_circline ?iM H' = H`[symmetric] `{A, B, C} \<subseteq> circline_set H'`
    by (simp_all add: moebius_circline_set[symmetric])
  moreover
  have "?A \<noteq> ?B" "?A \<noteq> ?C" "?B \<noteq> ?C"
    using bij_moebius_pt[of "moebius_inv M"] `A \<noteq> B` `A \<noteq> C` `B \<noteq> C`
    unfolding bij_def inj_on_def
    by blast+
  ultimately
  show ?thesis
    by auto
qed

subsubsection{* Positive type circline set cardinality *}
lemma circline_type_pos_card_eq0_diag:
  assumes "circline_diag H" "circline_type H > 0"
  shows "circline_set H = {}"
using assms
unfolding circline_set_def
apply simp
proof transfer
  fix H
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence HH_elems: "is_real A" "is_real D" "C = cnj B"
    using hermitean_elems[of A B C D]  Rep_circline_mat[of H]
    by auto
  assume "circline_diag_rep H" "0 < circline_type_rep H"
  hence "B = 0" "C = 0" "Re A * Re D > 0" "A \<noteq> 0"
    using `circline_diag_rep H` HH `is_real A` `is_real D`
    unfolding circline_diag_rep_def circline_type_rep_def
    by auto
  show "\<forall>x. \<not> on_circline_rep H x"
  proof
    fix x
    obtain x1 x2 where xx:"Rep_homo_coords x = (x1, x2)"
      by (rule obtain_homo_coords)
    have "(Re A > 0 \<and> Re D > 0) \<or> (Re A < 0 \<and> Re D < 0)"
      using `Re A * Re D > 0`
      by (metis linorder_neqE_linordered_idom mult_eq_0_iff zero_less_mult_pos zero_less_mult_pos2)
    moreover
    have "(Re (x1 * cnj x1) \<ge> 0 \<and> Re (x2 * cnj x2) > 0) \<or> (Re (x1 * cnj x1) > 0 \<and> Re (x2 * cnj x2) \<ge> 0)"
      using Rep_homo_coords[of x] xx
      by auto (metis complex_surj complex_zero_def sum_squares_gt_zero_iff)+
    ultimately
    have "Re A * Re (x1 * cnj x1) + Re D * Re (x2 * cnj x2) \<noteq> 0"
      apply auto
      apply (metis add_less_cancel_left add_pos_pos mult_eq_0_iff mult_pos_pos sum_squares_eq_zero_iff sum_squares_gt_zero_iff)
      apply (metis (lifting, no_types) add_pos_pos comm_semiring_1_class.normalizing_semiring_rules(6) mult_eq_0_iff mult_pos_pos sum_squares_gt_zero_iff)
      apply (metis add_less_cancel_left add_neg_neg mult_eq_0_iff mult_pos_neg2 sum_squares_eq_zero_iff sum_squares_gt_zero_iff)
      apply (metis (lifting, no_types) add_neg_neg comm_semiring_1_class.normalizing_semiring_rules(6) mult_eq_0_iff mult_pos_neg2 sum_squares_gt_zero_iff)
      done
    hence "A * (x1 * cnj x1) + D * (x2 * cnj x2) \<noteq> 0"
      using `is_real A` `is_real D`
      by (metis Re_mult_real complex_Re_add complex_Re_zero)
    thus "\<not> on_circline_rep H x"
      using HH `B = 0` `C = 0` xx
      unfolding on_circline_rep_def Let_def
      by (simp add: vec_cnj_def field_simps)
  qed
qed

lemma circline_type_pos_card_eq0:
  assumes "circline_type H > 0"
  shows "circline_set H = {}"
proof-
  obtain M H' where "moebius_circline M H = H'" "circline_diag H'"
    using circline_diagonalize[of H] assms
    by auto
  moreover
  hence "circline_type H' > 0"
    using assms moebius_preserve_circline_type
    by auto
  ultimately
  have "circline_set H' = {}"
    using circline_type_pos_card_eq0_diag[of H']
    by auto
  let ?iM = "moebius_inv M"
  have "moebius_circline ?iM H' = H"
    using `moebius_circline M H = H'`[symmetric]
    by simp
  thus ?thesis
    using `circline_set H' = {}`
    by (auto simp add: moebius_circline_set[symmetric])
qed

subsubsection{* Cardinality determines type *}
lemma card_eq1_circline_type_zero:
  assumes "\<exists> z. circline_set H = {z}"
  shows "circline_type H = 0"
proof (cases "circline_type H < 0")
  case True
  thus ?thesis
    using circline_type_neg_card_gt3[of H] assms
    by auto
next
  case False
  show ?thesis
  proof (cases "circline_type H > 0")
    case True
    thus ?thesis
      using circline_type_pos_card_eq0[of H] assms
      by auto
  next
    case False
    thus ?thesis
      using `\<not> (circline_type H) < 0`
      by simp
  qed
qed

subsubsection{* Circline set is injective *}
lemma inj_circline_set:
  assumes "circline_set H = circline_set H'" "circline_set H \<noteq> {}"
  shows "H = H'"
proof (cases "circline_type H < 0")
  case True
  then obtain A B C where "A \<noteq> B" "A \<noteq> C" "B \<noteq> C" "{A, B, C} \<subseteq> circline_set H"
    using circline_type_neg_card_gt3[of H]
    by auto
  hence "\<exists>!H. A \<in> circline_set H \<and> B \<in> circline_set H \<and> C \<in> circline_set H"
    using unique_circline_set[of A B C]
    by simp
  thus ?thesis
    using `circline_set H = circline_set H'` `{A, B, C} \<subseteq> circline_set H`
    by auto
next
  case False
  show ?thesis
  proof (cases "circline_type H = 0")
    case True
    moreover
    then obtain A where "{A} = circline_set H"
      using circline_type_zero_card_eq1[of H]
      by auto
    moreover
    hence "circline_type H' = 0"
      using `circline_set H = circline_set H'` card_eq1_circline_type_zero[of H']
      by auto
    ultimately
    show ?thesis
      using unique_circline_type_zero[of A] `circline_set H = circline_set H'`
      by auto
  next
    case False
    hence "circline_type H > 0"
      using `\<not> (circline_type H < 0)`
      by auto
    thus ?thesis
      using `circline_set H \<noteq> {}`  circline_type_pos_card_eq0[of H]
      by auto
  qed
qed

subsection {* Symmetric points wrt. circline *}
definition circline_symmetric_rep where
  "circline_symmetric_rep z1 z2 H \<longleftrightarrow> 
     (let z1 = Rep_homo_coords z1; 
          z2 = Rep_homo_coords z2;
           H = Rep_circline_mat H in
       bilinear_form z1 z2 H = 0)"

lift_definition circline_symmetric :: "complex_homo \<Rightarrow> complex_homo \<Rightarrow> circline \<Rightarrow> bool" is circline_symmetric_rep
by (auto simp add: circline_symmetric_rep_def bilinear_form_scale_m bilinear_form_scale_v1 bilinear_form_scale_v2 simp del: vec_cnj_sv quad_form_def bilinear_form_def)

lemma symmetry_principle:
  assumes "circline_symmetric z1 z2 H"
  shows "circline_symmetric (moebius_pt M z1) (moebius_pt M z2) (moebius_circline M H)"
using assms
proof (transfer)
  fix z1 z2 H M
  assume "circline_symmetric_rep z1 z2 H" 
  thus "circline_symmetric_rep (moebius_pt_rep M z1) (moebius_pt_rep M z2) (moebius_circline_rep M H)"
    apply (auto simp add: circline_symmetric_rep_def simp del: bilinear_form_def)
    using Rep_moebius_mat[of M]
    by (subst bilinear_form_congruence[symmetric]) simp_all
qed

text {* Symmetry wrt. @{term "unit_circle"} *}
lemma circline_symmetric_0inf_disc: "circline_symmetric 0\<^sub>h \<infinity>\<^sub>h unit_circle"
by (transfer) (simp add: circline_symmetric_rep_def vec_cnj_def)

lemma circline_symmetric_inv_homo_disc: "circline_symmetric a (inversion_homo a) unit_circle"
unfolding inversion_homo_def
by (transfer) (case_tac "Rep_homo_coords a", auto simp add: circline_symmetric_rep_def vec_cnj_def split_def Let_def)

lemma circline_symmetric_inv_homo_disc': 
  assumes "circline_symmetric a a' unit_circle"
  shows "a' = inversion_homo a"
unfolding inversion_homo_def
using assms
proof (transfer)
  fix a a'
  obtain a1 a2 where aa: "Rep_homo_coords a = (a1, a2)"
    by (rule obtain_homo_coords)
  obtain a1' a2' where aa': "Rep_homo_coords a' = (a1', a2')"
    by (rule obtain_homo_coords)
  assume *: "circline_symmetric_rep a a' unit_circle_rep"
  show "a' \<approx> (cnj_homo_coords \<circ> reciprocal_homo_coords) a"
  proof (cases "a1' = 0")
    case True
    thus ?thesis
      using aa aa' * Rep_homo_coords[of a'] Rep_homo_coords[of a]
      by (auto simp add: circline_symmetric_rep_def vec_cnj_def field_simps)
  next
    case False
    show ?thesis
    proof (cases "a2 = 0")
      case True
      thus ?thesis
        using `a1' \<noteq> 0`
        using aa aa' * Rep_homo_coords[of a]
        by (simp add: circline_symmetric_rep_def vec_cnj_def field_simps)
    next
      case False
      thus ?thesis
        using `a1' \<noteq> 0` aa aa' * 
        by (simp add: circline_symmetric_rep_def vec_cnj_def field_simps) (rule_tac x="cnj a2 / a1'" in exI, simp add: field_simps)
    qed
  qed
qed

subsection {* Oriented circlines; discs *}
definition ocircline_mat_eq where 
  [simp]: "ocircline_mat_eq A B \<longleftrightarrow> (\<exists> k::real. k > 0 \<and> Rep_circline_mat B = complex_of_real k *\<^sub>s\<^sub>m (Rep_circline_mat A))"

lemma [simp]: "ocircline_mat_eq H H"
by (simp, rule_tac x=1 in exI, simp)

quotient_type ocircline = circline_mat / ocircline_mat_eq
proof (rule equivpI)
  show "reflp ocircline_mat_eq"
    unfolding reflp_def
    by (auto, rule_tac x="1" in exI, simp)
next
  show "symp ocircline_mat_eq"
    unfolding symp_def
    by (auto, rule_tac x="1/k" in exI, simp)
next
  show "transp ocircline_mat_eq"
    unfolding transp_def
    by (auto, rule_tac x="ka*k" in exI, simp add: mult_pos_pos)
qed

lift_definition on_ocircline :: "ocircline \<Rightarrow> complex_homo \<Rightarrow> bool" is on_circline_rep
by (auto simp add: on_circline_rep_def quad_form_scale_m quad_form_scale_v Let_def simp del: vec_cnj_sv quad_form_def)

definition ocircline_set :: "ocircline \<Rightarrow> complex_homo set" where
  "ocircline_set H = {z. on_ocircline H z}"

text {* disc and disc complement *}

definition in_ocircline_rep where
  "in_ocircline_rep H z \<longleftrightarrow> 
            (let z = Rep_homo_coords z; 
                 H = Rep_circline_mat H 
              in Re (quad_form z H) < 0)"
  
lift_definition in_ocircline :: "ocircline \<Rightarrow> complex_homo \<Rightarrow> bool" is "in_ocircline_rep"
proof-
  fix H H' z z'
  assume "ocircline_mat_eq H H'" "z \<approx> z'"
  then obtain k k' where
    *: "0 < k" "Rep_circline_mat H' = cor k *\<^sub>s\<^sub>m Rep_circline_mat H" "k' \<noteq> 0" "Rep_homo_coords z' = k' *\<^sub>s\<^sub>v Rep_homo_coords z"
    by auto
  hence "quad_form (Rep_homo_coords z') (Rep_circline_mat H') = cor k * cor ((cmod k')\<^sup>2) * quad_form (Rep_homo_coords z) (Rep_circline_mat H)"
    by (simp add: quad_form_scale_v quad_form_scale_m del: vec_cnj_sv quad_form_def)
  hence "Re (quad_form (Rep_homo_coords z') (Rep_circline_mat H')) = 
    k * (cmod k')\<^sup>2 * Re (quad_form (Rep_homo_coords z) (Rep_circline_mat H))"
    using Rep_circline_mat[of H] quad_form_hermitean_real[of "Rep_circline_mat H"]
    by (simp add: complex_of_real_Re power2_eq_square)
  thus "in_ocircline_rep H z = in_ocircline_rep H' z'"
    unfolding in_ocircline_rep_def Let_def
    using `k > 0` `k' \<noteq> 0`
    apply auto
    apply (metis mult_pos_neg mult_pos_pos norm_eq_zero zero_less_power2)
    apply (metis comm_semiring_1_class.normalizing_semiring_rules(10) mult_less_cancel_left_pos zero_less_norm_iff zero_less_power)
    done
qed

definition disc where 
  "disc H = {z. in_ocircline H z}"

definition out_ocircline_rep where
  "out_ocircline_rep H z \<longleftrightarrow> 
            (let z = Rep_homo_coords z; 
                 H = Rep_circline_mat H 
              in Re (quad_form z H) > 0)"
  
lift_definition out_ocircline :: "ocircline \<Rightarrow> complex_homo \<Rightarrow> bool" is "out_ocircline_rep"
proof-
  fix H H' z z'
  assume "ocircline_mat_eq H H'" "z \<approx> z'"
  then obtain k k' where
    *: "0 < k" "Rep_circline_mat H' = cor k *\<^sub>s\<^sub>m Rep_circline_mat H" "k' \<noteq> 0" "Rep_homo_coords z' = k' *\<^sub>s\<^sub>v Rep_homo_coords z"
    by auto
  hence "quad_form (Rep_homo_coords z') (Rep_circline_mat H') = cor k * cor ((cmod k')\<^sup>2) * quad_form (Rep_homo_coords z) (Rep_circline_mat H)"
    by (simp add: quad_form_scale_v quad_form_scale_m del: vec_cnj_sv quad_form_def)
  hence "Re (quad_form (Rep_homo_coords z') (Rep_circline_mat H')) = 
    k * (cmod k')\<^sup>2 * Re (quad_form (Rep_homo_coords z) (Rep_circline_mat H))"
    using Rep_circline_mat[of H] quad_form_hermitean_real[of "Rep_circline_mat H"]
    by (simp add: complex_of_real_Re power2_eq_square)
  thus "out_ocircline_rep H z = out_ocircline_rep H' z'"
    unfolding out_ocircline_rep_def Let_def
    using `k > 0` `k' \<noteq> 0`
    apply auto
    apply (metis mult_pos_pos norm_eq_zero zero_less_power2)
    apply (metis comm_semiring_1_class.normalizing_semiring_rules(10) mult_less_cancel_left_pos zero_less_norm_iff zero_less_power)
    done
qed

definition disc_compl where
  "disc_compl H = {z. out_ocircline H z}"

lemma in_on_out: "in_ocircline H z \<or> on_ocircline H z \<or> out_ocircline H z"
proof transfer
  fix z H
  show "in_ocircline_rep H z \<or> on_circline_rep H z \<or> out_ocircline_rep H z"
    using Rep_circline_mat[of H] quad_form_hermitean_real[of "Rep_circline_mat H" "Rep_homo_coords z"]
    by (simp add: in_ocircline_rep_def on_circline_rep_def out_ocircline_rep_def Let_def) (metis complex_Im_zero complex_Re_zero complex_equality linorder_cases)
qed

lemma "disc H \<union> disc_compl H \<union> ocircline_set H = UNIV"
unfolding disc_def disc_compl_def ocircline_set_def
using in_on_out[of H]
by auto

lemma
  disc_inter_disc_compl: "disc H \<inter> disc_compl H = {}"
unfolding disc_def disc_compl_def
by auto (transfer, auto simp add: in_ocircline_rep_def out_ocircline_rep_def Let_def)

lemma
  disc_inter_ocircline_set: "disc H \<inter> ocircline_set H = {}"
unfolding disc_def ocircline_set_def
by auto (transfer, simp add: in_ocircline_rep_def on_circline_rep_def Let_def)

lemma
  disc_compl_inter_ocircline_set: "disc_compl H \<inter> ocircline_set H = {}"
unfolding disc_compl_def ocircline_set_def
by auto (transfer, simp add: out_ocircline_rep_def on_circline_rep_def Let_def)

text {* Opposite orientation *}
definition opposite_ocircline_rep where
"opposite_ocircline_rep H = 
  (let H = Rep_circline_mat H in 
     Abs_circline_mat (-1 *\<^sub>s\<^sub>m H))"

lemma circline_mat_mult_m1 [simp]: "Rep_circline_mat (Abs_circline_mat (-1 *\<^sub>s\<^sub>m Rep_circline_mat H)) = (-1 *\<^sub>s\<^sub>m Rep_circline_mat H)"
proof-
  have "-1 = cor (-1)"
    by (simp add: complex_of_real_def)
  thus ?thesis
    using circline_mat_mult_sm_Rep[of "-1" H]
    by auto
qed

lemma [simp]: "Rep_circline_mat (opposite_ocircline_rep H) = (-1 *\<^sub>s\<^sub>m Rep_circline_mat H)"
  unfolding opposite_ocircline_rep_def
  by auto

lift_definition opposite_ocircline :: "ocircline \<Rightarrow> ocircline" is opposite_ocircline_rep
by auto

lemma opposite_ocircline_rep_opposite_ocircline_rep
  [simp]: "opposite_ocircline_rep (opposite_ocircline_rep H) = H"
by (simp add: opposite_ocircline_rep_def Rep_circline_mat_inverse)

lemma opposite_ocircline_opposite_ocircline
  [simp]: "opposite_ocircline (opposite_ocircline H) = H"
by (transfer) (auto, rule_tac x="1" in exI, simp)

lemma ocircline_set_opposite_ocircline 
  [simp]: "ocircline_set (opposite_ocircline H) = ocircline_set H"
unfolding ocircline_set_def
by auto (transfer, auto simp add: on_circline_rep_def quad_form_scale_m simp del: quad_form_def)+


lemma disc_compl_opposite: "disc_compl (opposite_ocircline H) = disc H"
  unfolding disc_def disc_compl_def
apply auto
apply (transfer)
apply (auto simp add: in_ocircline_rep_def out_ocircline_rep_def quad_form_scale_m simp del: quad_form_def)
apply (transfer)
apply (auto simp add: in_ocircline_rep_def out_ocircline_rep_def quad_form_scale_m simp del: quad_form_def)
done

lemma disc_opposite:
  "disc (opposite_ocircline H) = disc_compl H"
using disc_compl_opposite[of "opposite_ocircline H"]
by simp

text{* @{term "of_ocircline"}, @{term "pos_oriented"}, @{term "of_circline"}  *}

lift_definition of_ocircline :: "ocircline \<Rightarrow> circline" is "id::circline_mat \<Rightarrow> circline_mat"
by auto (rule_tac x="k" in exI, simp)

lemma of_ocircline_opposite_ocircline [simp]: 
 "of_ocircline (opposite_ocircline H) = of_ocircline H"
by (transfer) (auto, rule_tac x="-1" in exI, simp)

lemma circline_set_ocircline_set [simp]:
  "circline_set (of_ocircline H) = ocircline_set H"
  unfolding ocircline_set_def circline_set_def
by (safe) (transfer, simp)+

lemma inj_of_ocircline:
  assumes "of_ocircline H = of_ocircline H'"
  shows "H = H' \<or> H = opposite_ocircline H'"
using assms
by (transfer) (auto, metis linorder_neqE_linordered_idom neg_0_less_iff_less of_real_minus)

lemma
  inj_ocircline_set:
  assumes "ocircline_set H = ocircline_set H'" "ocircline_set H \<noteq> {}"
  shows "H = H' \<or> H = opposite_ocircline H'"
proof-
  from assms have "circline_set (of_ocircline H) = circline_set (of_ocircline H')" "circline_set (of_ocircline H') \<noteq> {}"
    using circline_set_ocircline_set[symmetric, of H] circline_set_ocircline_set[symmetric, of H']
    by blast+
  hence "of_ocircline H = of_ocircline H'"
    by (simp add: inj_circline_set)
  thus ?thesis
    by (rule inj_of_ocircline)
qed

(* ------------------- *)

definition pos_oriented_rep where
 "pos_oriented_rep H \<longleftrightarrow> 
   (let (A, B, C, D) = Rep_circline_mat H 
    in (Re A > 0 \<or> (Re A = 0 \<and> ((B \<noteq> 0 \<and> arg B > 0) \<or> (B = 0 \<and> Re D > 0)))))"

lemma pos_oriented_rep: "pos_oriented_rep H \<or> pos_oriented_rep (opposite_ocircline_rep H)"
proof-
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  moreover
  hence "Re A = 0 \<and> Re D = 0 \<longrightarrow> B \<noteq> 0"
    using Rep_circline_mat[of H] hermitean_elems[of A B C D]
    by (cases A, cases D) auto
  moreover
  have "B \<noteq> 0 \<and> \<not> 0 < arg B \<longrightarrow> 0 < arg (- B)"
    using MoreComplex.canon_ang_plus_pi2[of "arg B"] arg_bounded[of B]
    by (auto simp add: arg_uminus)
  ultimately
  show ?thesis
    by (auto simp add: pos_oriented_rep_def)
qed

lift_definition pos_oriented :: "ocircline \<Rightarrow> bool" is pos_oriented_rep
apply (auto simp add: pos_oriented_rep_def mult_pos_pos)
apply (metis arg_mult_real_positive)
apply (metis arg_mult_real_positive)
apply (metis zero_less_mult_pos)+
apply (metis arg_mult_real_positive)
apply (metis arg_mult_real_positive)
apply (metis zero_less_mult_pos)+
done

lemma pos_oriented: "pos_oriented H \<or> pos_oriented (opposite_ocircline H)"
by (transfer) (rule pos_oriented_rep)

lemma pos_oriented_opposite_ocircline: 
  "pos_oriented (opposite_ocircline H) \<longleftrightarrow> \<not> pos_oriented H" 
proof transfer
  fix H
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  moreover
  hence "Re A = 0 \<and> Re D = 0 \<longrightarrow> B \<noteq> 0"
    using Rep_circline_mat[of H] hermitean_elems[of A B C D]
    by (cases A, cases D) auto
  moreover
  have "B \<noteq> 0 \<and> \<not> 0 < arg B \<longrightarrow> 0 < arg (- B)"
    using MoreComplex.canon_ang_plus_pi2[of "arg B"] arg_bounded[of B]
    by (auto simp add: arg_uminus)
  moreover
  have "B \<noteq> 0 \<and> 0 < arg B \<longrightarrow> \<not> 0 < arg (- B)"
    using MoreComplex.canon_ang_plus_pi1[of "arg B"] arg_bounded[of B]
    by (auto simp add: arg_uminus)
  ultimately
  show "pos_oriented_rep (opposite_ocircline_rep H) = (\<not> pos_oriented_rep H)"
    unfolding pos_oriented_rep_def
    by simp (metis not_less_iff_gr_or_eq)
qed

lemma pos_oriented_circle_inf:
  assumes "\<infinity>\<^sub>h \<notin> ocircline_set H"
  shows "pos_oriented H \<longleftrightarrow> \<infinity>\<^sub>h \<notin> disc H"
using assms
unfolding ocircline_set_def disc_def
apply simp
proof transfer
  fix H
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence "is_real A"
    using Rep_circline_mat[of H] hermitean_elems
    by auto
  assume "\<not> on_circline_rep H inf_homo_rep"
  thus "pos_oriented_rep H = (\<not> in_ocircline_rep H inf_homo_rep)"
    using HH `is_real A`
    by (cases A) (auto simp add: on_circline_rep_def in_ocircline_rep_def Let_def pos_oriented_rep_def vec_cnj_def)
qed

lemma 
  assumes "is_circle (of_ocircline H)" "(a, r) = euclidean_circle (of_ocircline H)" "circline_type (of_ocircline H) < 0"
  shows "pos_oriented H \<longleftrightarrow> of_complex a \<in> disc H" 
using assms
unfolding disc_def
apply simp
proof transfer
  fix H a r
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence "is_real A" "is_real D" "C = cnj B"
    using Rep_circline_mat[of H] hermitean_elems
    by auto
  
  assume *: "\<not> circline_A0_rep (id H)" "(a, r) = euclidean_circle_rep (id H)" "circline_type_rep (id H) < 0"
  hence "A \<noteq> 0" "Re A \<noteq> 0"
    using HH `is_real A`
    by (case_tac[!] A) (auto simp add: circline_A0_rep_def)

  have "Re (A*D - B*C) < 0"
    using `circline_type_rep (id H) < 0` HH
    by (simp add: circline_type_rep_def)

  have "(A * (D * cnj A) - B * (C * cnj A)) / (A * cnj A) = (A*D - B*C) / A"
    using `A \<noteq> 0`
    by (simp add: field_simps)
  hence "0 < Re A \<longleftrightarrow> Re ((A * (D * cnj A) - B * (C * cnj A)) / (A * cnj A)) < 0"
    using `is_real A` `A \<noteq> 0` `Re (A*D - B*C) < 0`
    by (auto simp add: Re_divide_real, metis divide_less_0_iff less_iff_diff_less_0, metis divide_less_0_iff less_iff_diff_less_0 mult_neg_neg zero_less_mult_pos)
  thus "pos_oriented_rep H = in_ocircline_rep H (of_complex_coords a)"
    using HH `Re A \<noteq> 0` * `is_real A`
    by (simp add: circline_A0_rep_def euclidean_circle_rep_def pos_oriented_rep_def in_ocircline_rep_def Let_def vec_cnj_def complex_cnj field_simps)
qed

definition of_circline_rep :: "circline_mat \<Rightarrow> circline_mat" where
 "of_circline_rep H = (if pos_oriented_rep H then H else opposite_ocircline_rep H)"

lift_definition of_circline :: "circline \<Rightarrow> ocircline" is of_circline_rep
proof-
  fix H H'
  assume "circline_mat_eq H H'"
  then obtain k where *: "k \<noteq> 0" "Rep_circline_mat H' = cor k *\<^sub>s\<^sub>m Rep_circline_mat H"
    by auto
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  obtain A' B' C' D' where HH': "Rep_circline_mat H' = (A', B', C', D')"
    by (cases "Rep_circline_mat H'") auto

  show "ocircline_mat_eq (of_circline_rep H) (of_circline_rep H')"
  proof (cases "Re A > 0")
    case True
    show ?thesis
    proof (cases "k > 0")
      case True
      hence "Re A' > 0"
        using `Re A > 0` * HH HH'
        by (auto simp add: mult_pos_pos)
      thus ?thesis
        using `Re A > 0`
        using * `k > 0` HH HH'
        by (auto simp add: pos_oriented_rep_def of_circline_rep_def Let_def split_def)
    next
      case False
      hence "k < 0"
        using `k \<noteq> 0`
        by auto
      hence "Re A' < 0"
        using `Re A > 0` * HH HH'
        by (auto simp add: mult_neg_pos)
      thus ?thesis
        using `Re A > 0`
        using * `k < 0` HH HH'
        using circline_mat_mult_sm_Rep[of "-k" H]
        by (auto simp add: pos_oriented_rep_def of_circline_rep_def Let_def split_def) (rule_tac x="-k" in exI, simp)
    qed
  next
    case False
    show ?thesis
    proof (cases "Re A < 0")
      case True
      show ?thesis
      proof (cases "k > 0")
        case True
        hence "Re A' < 0"
          using `Re A < 0`
          using * HH HH'
          by (auto simp add: mult_pos_neg)
        moreover
        have "-1 = cor (-1)"
          by (simp add: complex_of_real_def)
        ultimately
        show ?thesis
          using `Re A < 0`
          using * `k > 0` HH HH'
          using circline_mat_mult_sm_Rep[of "-k" H]
          using circline_mat_mult_sm_Rep[of "-1" H]
          by (auto simp add: pos_oriented_rep_def of_circline_rep_def Let_def split_def)
      next
        case False
        hence "k < 0"
          using `k \<noteq> 0`
          by simp
        hence "Re A' > 0"
          using `Re A < 0`
          using * HH HH'
          by (auto simp add: mult_neg_neg)
        moreover
        have "-1 = cor (-1)"
          by (simp add: complex_of_real_def)
        ultimately
        show ?thesis
          using `Re A < 0`
          using * `k < 0` HH HH'
          using circline_mat_mult_sm_Rep[of "-k" H]
          using circline_mat_mult_sm_Rep[of "-1" H]
          by (auto simp add: pos_oriented_rep_def of_circline_rep_def Let_def split_def) (rule_tac x="-k" in exI, simp)
      qed
    next
      case False
      hence "Re A = 0"
        using `\<not> Re A > 0`
        by auto
      hence "Re A' = 0"
        using * HH HH'
        by auto

      show ?thesis
      proof (cases "B \<noteq> 0")
        case True
        show ?thesis
        proof (cases "arg B > 0")
          case True
          show ?thesis
          proof (cases "arg B' > 0")
            case True
            hence "k > 0"
              using `arg B > 0`
              using * HH HH' arg_mult[of "cor k" B] `B \<noteq> 0` `k \<noteq> 0`
              using arg_complex_of_real_negative[of k] arg_complex_of_real_positive[of k]
              using MoreComplex.canon_ang_plus_pi1[of "arg B"] arg_bounded[of B]
              by (cases "k > 0") (auto simp add: arg_mult field_simps)
            thus ?thesis
              using `arg B > 0` `arg B' > 0` `B \<noteq> 0` `Re A = 0` `Re A' = 0` HH HH' *
              by (auto simp add: pos_oriented_rep_def of_circline_rep_def)
          next
            case False
            hence "k < 0"
              using `arg B > 0`
              using * HH HH' arg_mult[of "cor k" B] `B \<noteq> 0` `k \<noteq> 0`
              using arg_complex_of_real_negative[of k] arg_complex_of_real_positive[of k]
              by (cases "k > 0") (auto simp add: arg_mult field_simps canon_ang_arg)
            thus ?thesis
              using `arg B > 0` `\<not> arg B' > 0` `Re A = 0` `Re A' = 0` `B \<noteq> 0` HH HH' *
              using circline_mat_mult_sm_Rep[of "-k" H]
              by (auto simp add: pos_oriented_rep_def of_circline_rep_def) (rule_tac x="-k" in exI, simp)+
          qed
        next
          case False
          show ?thesis
          proof (cases "arg B' > 0")
            case True
            hence "k < 0"
              using `\<not> arg B > 0`
              using * HH HH' arg_mult[of "cor k" B] `B \<noteq> 0` `k \<noteq> 0`
              using arg_complex_of_real_negative[of k] arg_complex_of_real_positive[of k]
              by (cases "k > 0") (auto simp add: arg_mult field_simps canon_ang_arg)
            thus ?thesis
              using `\<not> arg B > 0` `arg B' > 0` `B \<noteq> 0` `Re A = 0` `Re A' = 0` HH HH' *
              by (auto simp add: pos_oriented_rep_def of_circline_rep_def) (rule_tac x="-k" in exI, simp)+
          next
            case False
            hence "k > 0"
              using `\<not> arg B > 0`
              using * HH HH' arg_mult[of "cor k" B] `B \<noteq> 0` `k \<noteq> 0`
              using arg_complex_of_real_negative[of k] arg_complex_of_real_positive[of k]
              using MoreComplex.canon_ang_plus_pi2[of "arg B"] arg_bounded[of B]
              by (cases "k > 0") (auto simp add: arg_mult field_simps canon_ang_arg)
            thus ?thesis
              using `\<not> arg B > 0` `\<not> arg B' > 0` `Re A = 0` `Re A' = 0` `B \<noteq> 0` HH HH' *
              using circline_mat_mult_sm_Rep[of "-k" H]
              by (auto simp add: pos_oriented_rep_def of_circline_rep_def)
          qed
        qed
      next
        case False
        hence "B' = 0"
          using * HH HH'
          by simp
        have "Re D \<noteq> 0"
          using `Re A = 0` `\<not> B \<noteq> 0`
          using Rep_circline_mat[of H] HH hermitean_elems[of A B C D]
          by (cases A, cases D) auto
        show ?thesis
          using `\<not> B \<noteq> 0` `B' = 0` `Re A = 0` `Re A' = 0` `Re D \<noteq> 0` HH HH' *
          apply (auto simp add: of_circline_rep_def pos_oriented_rep_def)
          apply (metis zero_less_mult_pos2)
          apply (rule_tac x="-k" in exI, simp, metis linorder_cases mult_pos_pos)
          apply (rule_tac x="-k" in exI, simp, metis linorder_cases zero_less_mult_pos)
          apply (rule_tac x="k" in exI, simp, metis mult_neg_neg neqE)
          done
      qed
    qed
  qed
qed

lemma pos_oriented_of_circline: "pos_oriented (of_circline H)"
proof (transfer)
  fix H 
  show "pos_oriented_rep (of_circline_rep H)"
    using pos_oriented_rep[of "H"]
    unfolding of_circline_rep_def
    by auto
qed

lemma of_ocircline_of_circline [simp]: "of_ocircline (of_circline H) = H"
apply (transfer)
apply (auto simp add: of_circline_rep_def)
by (rule_tac x="1" in exI, simp) (rule_tac x="-1" in exI, auto simp add: pos_oriented_rep_def complex_of_real_def)

lemma of_circline_of_ocircline_pos_oriented [simp]:
  assumes "pos_oriented H"
  shows "of_circline (of_ocircline H) = H"
using assms
by (transfer) (simp add: of_circline_rep_def, rule_tac x="1" in exI, simp)

lemma ocircline_set_circline_set[simp]: "ocircline_set (of_circline H) = circline_set H"
  unfolding ocircline_set_def circline_set_def
proof (safe)
  fix z
  assume "on_ocircline (of_circline H) z"
  thus "on_circline H z"
    by (transfer) (auto simp add: on_circline_rep_def of_circline_rep_def Let_def quad_form_scale_m simp del: quad_form_def split: split_if_asm)
next
  fix z
  assume "on_circline H z"
  thus "on_ocircline (of_circline H) z"
    by (transfer) (auto simp add: on_circline_rep_def of_circline_rep_def Let_def quad_form_scale_m simp del: quad_form_def)
qed

lemma inj_of_circline:
  assumes "of_circline H = of_circline H'"
  shows "H = H'"
using assms
proof (transfer)
  fix H H'
  assume "ocircline_mat_eq (of_circline_rep H) (of_circline_rep H')"
  then obtain k where "k > 0" "Rep_circline_mat (of_circline_rep H') = cor k *\<^sub>s\<^sub>m Rep_circline_mat (of_circline_rep H)"
    by auto
  thus "circline_mat_eq H H'"
    using mult_sm_inv_l[of "-1" "Rep_circline_mat H'" "cor k *\<^sub>s\<^sub>m Rep_circline_mat H"]
    using mult_sm_inv_l[of "-1" "Rep_circline_mat H'" "(- (cor k)) *\<^sub>s\<^sub>m Rep_circline_mat H"]
    apply (auto simp add: of_circline_rep_def split: split_if_asm)
    apply (rule_tac x="k" in exI, simp)
    apply (rule_tac x="-k" in exI, simp)
    apply (rule_tac x="-k" in exI, simp)
    apply (rule_tac x="k" in exI, simp)
    done
qed

lemma of_circline_of_ocircline:
  shows "of_circline (of_ocircline H') = H' \<or> of_circline (of_ocircline H') = opposite_ocircline H'"
proof (cases "pos_oriented H'")
  case True
  thus ?thesis
    by auto
next
  case False
  hence "pos_oriented (opposite_ocircline H')"
    using pos_oriented
    by auto
  thus ?thesis
    using of_ocircline_opposite_ocircline[of H']
    using of_circline_of_ocircline_pos_oriented [of "opposite_ocircline H'"]
    by auto
qed

subsection{* Some special oriented circlines and discs *}

lift_definition mk_ocircline :: "complex \<Rightarrow> complex \<Rightarrow> complex \<Rightarrow> complex \<Rightarrow> ocircline" is mk_circline_rep
by (simp add: mk_circline_rep_def, rule_tac x=1 in exI, simp)

text {* oriented unit circle and unit disc *}
lift_definition ounit_circle :: "ocircline" is unit_circle_rep
done

definition "unit_disc = disc ounit_circle"

lemma zero_in_unit_disc: "0\<^sub>h \<in> unit_disc"
unfolding unit_disc_def disc_def
by (simp, transfer) (simp add: in_ocircline_rep_def Let_def vec_cnj_def)

lemma inf_notin_unit_disc: "\<infinity>\<^sub>h \<notin> unit_disc"
unfolding unit_disc_def disc_def
by (simp, transfer) (simp add: in_ocircline_rep_def Let_def vec_cnj_def)

lemma of_ocircline_ounit_circle [simp]: "of_ocircline ounit_circle = unit_circle"
by (transfer) (auto, rule_tac x="1" in exI, simp)

lemma of_circline_unit_circline [simp]: "of_circline (unit_circle) = ounit_circle"
by (transfer) (auto simp add: pos_oriented_rep_def of_circline_rep_def, rule_tac x="1" in exI, simp)

text{* Oriented x axis and lower half plane *}
lift_definition o_x_axis :: "ocircline" is x_axis_rep
done

lemma o_x_axis_pos_oriented: "pos_oriented o_x_axis"
by transfer (simp add: pos_oriented_rep_def)

lemma of_ocircline_o_x_axis [simp]: "of_ocircline o_x_axis = x_axis"
by transfer (simp del: circline_mat_eq_def)

lemma of_circline_x_axis [simp]: "of_circline x_axis = o_x_axis"
using of_circline_of_ocircline_pos_oriented[of o_x_axis]
using o_x_axis_pos_oriented
by simp

lemma ocircline_set_circline_set_x_axis: "ocircline_set o_x_axis = circline_set x_axis"
by (subst of_circline_x_axis[symmetric], subst ocircline_set_circline_set, simp)

lemma [simp]: "ii\<^sub>h \<notin> disc o_x_axis"
unfolding disc_def
by simp (transfer, simp add: in_ocircline_rep_def Let_def vec_cnj_def)

lemma [simp]: "ii\<^sub>h \<in> disc (opposite_ocircline o_x_axis)"
unfolding disc_def
by simp (transfer, simp add: in_ocircline_rep_def Let_def vec_cnj_def)

subsection{* Moebius action on oriented circlines and discs *}
lift_definition moebius_ocircline :: "moebius \<Rightarrow> ocircline \<Rightarrow> ocircline" is moebius_circline_rep
proof-
  fix M M' H H'
  assume "moebius_mat_eq M M'" "ocircline_mat_eq H H'"
  thus "ocircline_mat_eq (moebius_circline_rep M H) (moebius_circline_rep M' H')"
    by (auto simp add: mat_inv_mult_sm complex_cnj) (rule_tac x="ka / Re (k * cnj k)" in exI, auto simp add: complex_mult_cnj_cmod power2_eq_square, metis divide_pos_pos mult_eq_0_iff norm_mult zero_less_norm_iff)
qed

lemma moebius_circline_ocircline: 
  "moebius_circline M H = of_ocircline (moebius_ocircline M (of_circline H))"
apply (transfer)
apply (auto simp add: of_circline_rep_def)
apply (rule_tac x="1" in exI, simp)
apply (rule_tac x="-1" in exI, simp add: of_real_neg_numeral)
done

lemma moebius_ocircline_circline:
  "moebius_ocircline M H = of_circline (moebius_circline M (of_ocircline H)) \<or> 
   moebius_ocircline M H = opposite_ocircline (of_circline (moebius_circline M (of_ocircline H)))"
apply (transfer)
apply (auto simp add: of_circline_rep_def)
apply (rule_tac x="1" in exI, simp)
apply (erule_tac x="1" in allE, simp)
done

lemma
  inj_moebius_ocircline: "inj (moebius_ocircline M)"
unfolding inj_on_def
proof (safe)
  fix H H'
  assume "moebius_ocircline M H = moebius_ocircline M H'"
  thus "H = H'"
  proof (transfer)
    fix M H H'
    let ?M = "Rep_moebius_mat M"
    let ?iM = "mat_inv ?M"
    let ?H = "Rep_circline_mat H" and ?H' = "Rep_circline_mat H'"
    assume "ocircline_mat_eq (moebius_circline_rep M H) (moebius_circline_rep M H')"
    then obtain k where "congruence ?iM ?H' = congruence ?iM (cor k *\<^sub>s\<^sub>m ?H)" "k > 0"
      by auto
    thus "ocircline_mat_eq H H'"
      using Rep_moebius_mat[of M] inj_congruence[of ?iM ?H' "cor k *\<^sub>s\<^sub>m ?H"] mat_det_inv[of ?M]
      by auto
  qed
qed

lemma moebius_ocircline_comp: 
  "moebius_ocircline M1 (moebius_ocircline M2 H) = moebius_ocircline (moebius_comp M1 M2) H"
proof (transfer)
  fix M1 M2 H
  show "ocircline_mat_eq (moebius_circline_rep M1 (moebius_circline_rep M2 H)) (moebius_circline_rep (moebius_comp_rep M1 M2) H)"
    using congruence_congruence Rep_moebius_mat[of M1] Rep_moebius_mat[of M2]
    by (simp add: mat_inv_mult_mm, rule_tac x=1 in exI, simp)
qed

lemma [simp]:
  "moebius_ocircline id_moebius H = H"
proof transfer
  fix H
  show "ocircline_mat_eq (moebius_circline_rep id_moebius_rep H) H"
    by (cases "Rep_circline_mat H", simp) (rule_tac x="1" in exI, simp add: mat_adj_def mat_cnj_def)
qed

lemma moebius_ocircline_comp_inv[simp]: 
  "moebius_ocircline (moebius_inv M) (moebius_ocircline M H) = H"
by (subst moebius_ocircline_comp) simp

lemma moebius_circline_opposite_ocircline [simp]: 
  "moebius_ocircline M (opposite_ocircline H) = opposite_ocircline (moebius_ocircline M H)"
by transfer (auto, rule_tac x="1" in exI, simp)


lemma moebius_ocircline_set:
  shows "moebius_pt M ` ocircline_set H = ocircline_set (moebius_ocircline M H)" (is "?lhs = ?rhs")
proof-
  have "moebius_pt M ` ocircline_set H = circline_set (moebius_circline M (of_ocircline H))"
    by (subst moebius_circline_set[symmetric]) simp
  thus ?thesis
    using moebius_ocircline_circline[of M H]
    by auto
qed

lemma moebius_disc:
  "moebius_pt M ` (disc H) = disc (moebius_ocircline M H)"
proof (safe)
  fix z
  assume "z \<in> disc H"
  thus "moebius_pt M z \<in> disc (moebius_ocircline M H)"
    unfolding disc_def
  proof (safe)
    assume "in_ocircline H z"
    thus "in_ocircline (moebius_ocircline M H) (moebius_pt M z)"
    proof (transfer)
      fix H z M
      assume "in_ocircline_rep H z"
      thus "in_ocircline_rep (moebius_circline_rep M H) (moebius_pt_rep M z)"
        using Rep_moebius_mat[of M] quad_form_congruence[of "Rep_moebius_mat M" "Rep_homo_coords z"]
        by (simp add: in_ocircline_rep_def moebius_circline_rep_def Let_def)
    qed
  qed
next
  fix z
  assume "z \<in> disc (moebius_ocircline M H)"
  thus "z \<in> moebius_pt M ` disc H"
    unfolding disc_def
  proof(safe)
    assume "in_ocircline (moebius_ocircline M H) z"
    show "z \<in> moebius_pt M ` Collect (in_ocircline H)"
    proof
      show "z = moebius_pt M (moebius_pt (moebius_inv M) z)"
        using moebius_inv[of M]  bij_moebius_pt[of M]
        by (simp add: bij_def) (metis surj_f_inv_f)
    next
      show "moebius_pt (moebius_inv M) z \<in> Collect (in_ocircline H)"
        using `in_ocircline (moebius_ocircline M H) z`
      proof (safe, transfer)
        fix M H z
        have "congruence (mat_inv (mat_inv (Rep_moebius_mat M))) (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)) =
          Rep_circline_mat H"
          using Rep_moebius_mat[of M]
          by (simp add: congruence_congruence_inv)
        hence "quad_form (Rep_homo_coords z) (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)) = 
              quad_form (mat_inv (Rep_moebius_mat M) *\<^sub>m\<^sub>v Rep_homo_coords z) (Rep_circline_mat H)"
          using quad_form_congruence[of "mat_inv (Rep_moebius_mat M)" "Rep_homo_coords z" "congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)"]
          using Rep_moebius_mat[of M] mat_det_inv[of "Rep_moebius_mat M"]
          by simp
        moreover
        assume "in_ocircline_rep (moebius_circline_rep M H) z"
        ultimately
        show "in_ocircline_rep H (moebius_pt_rep (moebius_inv_rep M) z)"
          by (auto simp add: in_ocircline_rep_def Let_def)
      qed
    qed
  qed
qed

lemma moebius_disc_compl:
  "moebius_pt M ` (disc_compl H) = disc_compl (moebius_ocircline M H)"
proof (safe)
  fix z
  assume "z \<in> disc_compl H"
  thus "moebius_pt M z \<in> disc_compl (moebius_ocircline M H)"
    unfolding disc_compl_def
  proof (safe)
    assume "out_ocircline H z"
    thus "out_ocircline (moebius_ocircline M H) (moebius_pt M z)"
    proof (transfer)
      fix H z M
      assume "out_ocircline_rep H z"
      thus "out_ocircline_rep (moebius_circline_rep M H) (moebius_pt_rep M z)"
        using Rep_moebius_mat[of M] quad_form_congruence[of "Rep_moebius_mat M" "Rep_homo_coords z"]
        by (simp add: out_ocircline_rep_def moebius_circline_rep_def Let_def)
    qed
  qed
next
  fix z
  assume "z \<in> disc_compl (moebius_ocircline M H)"
  thus "z \<in> moebius_pt M ` disc_compl H"
    unfolding disc_compl_def
  proof(safe)
    assume "out_ocircline (moebius_ocircline M H) z"
    show "z \<in> moebius_pt M ` Collect (out_ocircline H)"
    proof
      show "z = moebius_pt M (moebius_pt (moebius_inv M) z)"
        using moebius_inv[of M]  bij_moebius_pt[of M]
        by (simp add: bij_def) (metis surj_f_inv_f)
    next
      show "moebius_pt (moebius_inv M) z \<in> Collect (out_ocircline H)"
        using `out_ocircline (moebius_ocircline M H) z`
      proof (safe, transfer)
        fix M H z
        have "congruence (mat_inv (mat_inv (Rep_moebius_mat M))) (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)) =
          Rep_circline_mat H"
          using Rep_moebius_mat[of M]
          by (simp add: congruence_congruence_inv)
        hence "quad_form (Rep_homo_coords z) (congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)) = 
              quad_form (mat_inv (Rep_moebius_mat M) *\<^sub>m\<^sub>v Rep_homo_coords z) (Rep_circline_mat H)"
          using quad_form_congruence[of "mat_inv (Rep_moebius_mat M)" "Rep_homo_coords z" "congruence (mat_inv (Rep_moebius_mat M)) (Rep_circline_mat H)"]
          using Rep_moebius_mat[of M] mat_det_inv[of "Rep_moebius_mat M"]
          by simp
        moreover
        assume "out_ocircline_rep (moebius_circline_rep M H) z"
        ultimately
        show "out_ocircline_rep H (moebius_pt_rep (moebius_inv_rep M) z)"
          by (auto simp add: out_ocircline_rep_def Let_def)
      qed
    qed
  qed
qed

(* Moebius orientation *)

lemma similarity_preserves_lines: 
  assumes "a \<noteq> 0"
  shows "\<infinity>\<^sub>h \<in> ocircline_set H \<longleftrightarrow> \<infinity>\<^sub>h \<in> ocircline_set (moebius_ocircline (similarity_moebius a b) H)" (is "?lhs = ?rhs")
proof
  assume "?lhs"
  thus ?rhs
    using similarity_inf_fixed[OF `a \<noteq> 0`, of b]
    by (subst moebius_ocircline_set[symmetric]) force
next
  assume ?rhs
  thus ?lhs
    using similarity_only_inf_to_inf[OF `a \<noteq> 0`, of b]
    by (subst (asm) moebius_ocircline_set[symmetric]) (auto, metis)
qed
   
lemma similarity_preserve_orientation':
  assumes "a \<noteq> 0" "M = similarity_moebius a b" "H' = moebius_ocircline M H"  "\<infinity>\<^sub>h \<notin> ocircline_set H"
  shows "pos_oriented H \<longrightarrow> pos_oriented H'"
proof
  have "\<infinity>\<^sub>h \<notin> ocircline_set H'"
    using assms similarity_preserves_lines
    by auto
  assume "pos_oriented H"
  hence "\<infinity>\<^sub>h \<in> disc_compl H"
    using `\<infinity>\<^sub>h \<notin> ocircline_set H` pos_oriented_circle_inf[of H] in_on_out
    unfolding disc_def disc_compl_def ocircline_set_def
    by auto
  hence "\<infinity>\<^sub>h \<in> disc_compl H'"
    using `M = similarity_moebius a b` `H' = moebius_ocircline M H`
    using similarity_inf_fixed[OF `a \<noteq> 0`, of b]
    by  (simp, subst moebius_disc_compl[symmetric], force)
  thus "pos_oriented H'"
    using pos_oriented_circle_inf[of H'] disc_inter_disc_compl[of H'] `\<infinity>\<^sub>h \<notin> ocircline_set H'`
    by auto
qed

lemma similarity_preserve_orientation:
  assumes "a \<noteq> 0" "M = similarity_moebius a b" "H' = moebius_ocircline M H"  "\<infinity>\<^sub>h \<notin> ocircline_set H"
  shows "pos_oriented H \<longleftrightarrow> pos_oriented H'"
proof-
  have "\<infinity>\<^sub>h \<notin> ocircline_set H'"
    using assms similarity_preserves_lines
    by auto

  have *: "H = moebius_ocircline (- similarity_moebius a b) H'"
    using `H' = moebius_ocircline M H` `M = similarity_moebius a b`
    by simp
  thus ?thesis
    using `a \<noteq> 0`
    using similarity_preserve_orientation'[OF `a \<noteq> 0` `M = similarity_moebius a b` `H' = moebius_ocircline M H` `\<infinity>\<^sub>h \<notin> ocircline_set H`]
    using similarity_preserve_orientation'[OF _ similarity_moebius_inv[of a b, OF `a \<noteq> 0`] *  `\<infinity>\<^sub>h \<notin> ocircline_set H'`]
    by auto
qed

lemma "0\<^sub>h \<in> disc_compl (mk_ocircline -1 (2*ii) (-2*ii) 1)"
unfolding disc_compl_def
by simp (transfer, simp add: out_ocircline_rep_def mk_circline_rep_def Abs_homo_coords_inverse Let_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def vec_cnj_def complex_cnj)
lemma "\<not> pos_oriented (mk_ocircline -1 (2*ii) (-2*ii) 1)"
by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj pos_oriented_rep_def)
lemma "circline_type (mk_circline -1 (2*ii) (-2*ii) 1) = -1"
by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj circline_type_rep_def)
lemma "0\<^sub>h \<in> disc_compl (mk_ocircline 1 (2*ii) (-2*ii) 1)"
unfolding disc_compl_def
by simp (transfer, simp add: out_ocircline_rep_def mk_circline_rep_def Abs_homo_coords_inverse Let_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def vec_cnj_def complex_cnj)
lemma "pos_oriented (mk_ocircline 1 (2*ii) (-2*ii) 1)"
by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj pos_oriented_rep_def)
lemma "circline_type (mk_circline 1 (2*ii) (-2*ii) 1) = -1"
by transfer (simp add: mk_circline_rep_def Abs_circline_mat_inverse hermitean_def mat_adj_def mat_cnj_def complex_cnj circline_type_rep_def)

lemma reciprocal_preserve_orientation:
  assumes "0\<^sub>h \<in> disc_compl H" "M = reciprocal_moebius" "H' = moebius_ocircline M H"
  shows "pos_oriented H'"
proof-
  have "\<infinity>\<^sub>h \<in> disc_compl H'"
    using assms
    by simp (subst moebius_disc_compl[symmetric], subst reciprocal_moebius[symmetric], force)
  thus "pos_oriented H'"
    using pos_oriented_circle_inf[of H'] disc_inter_disc_compl[of H'] disc_compl_inter_ocircline_set[of H']
    by auto
qed

lemma reciprocal_not_preserve_orientation:
  assumes "0\<^sub>h \<in> disc H" "M = reciprocal_moebius" "H' = moebius_ocircline M H"
  shows "\<not> pos_oriented H'"
proof-
  have "\<infinity>\<^sub>h \<in> disc H'"
    using assms
    by simp (subst moebius_disc[symmetric], subst reciprocal_moebius[symmetric], force)
  thus "\<not> pos_oriented H'"
    using pos_oriented_circle_inf[of H'] disc_inter_ocircline_set[of H']
    by auto
qed

lemma pole_in_disc:
  assumes "M = mk_moebius a b c d" "c \<noteq> 0" "a*d - b*c \<noteq> 0" 
  assumes "is_pole M z" "z \<in> disc H" "H' = moebius_ocircline M H"
  shows "\<not> pos_oriented H'"
proof-
  let ?t1 = "translation_moebius (a / c)"
  let ?rd = "rotation_dilatation_moebius ((b * c - a * d) / (c * c))"
  let ?r = "reciprocal_moebius"
  let ?t2 = "translation_moebius (d / c)"

  have "0\<^sub>h = moebius_pt (translation_moebius (d/c)) z"
    using pole_mk_moebius[of a b c d z] assms
    by simp

  have "z \<notin> ocircline_set H"
    using `z \<in> disc H` disc_inter_ocircline_set[of H]
    by auto
  hence "0\<^sub>h \<notin> ocircline_set (moebius_ocircline ?t2 H)"
    using `0\<^sub>h = moebius_pt ?t2 z`
    using inj_image_mem_iff[of "moebius_pt ?t2" z "ocircline_set H"] bij_moebius_pt
    by (subst moebius_ocircline_set[symmetric]) (simp add: bij_def)
  hence *: "\<infinity>\<^sub>h \<notin> ocircline_set (moebius_ocircline (?r + ?t2) H)"
    using reciprocal_homo_only_0_to_inf
    by (simp add: moebius_ocircline_comp[symmetric]) (subst moebius_ocircline_set[symmetric], subst reciprocal_moebius[symmetric], auto, metis)
  hence **: "\<infinity>\<^sub>h \<notin> ocircline_set (moebius_ocircline (?rd + ?r + ?t2) H)"
    using `a*d - b*c \<noteq> 0` `c \<noteq> 0`
    using similarity_preserves_lines
    unfolding rotation_dilatation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric])
    
  have "\<not> pos_oriented (moebius_ocircline (?r + ?t2) H)"
    using pole_mk_moebius[of a b c d z] assms
    apply (simp add: moebius_ocircline_comp[symmetric])
    apply (subst reciprocal_not_preserve_orientation, simp_all)
    apply (subst moebius_disc[symmetric])
    apply force
    done
  hence "\<not> pos_oriented (moebius_ocircline (?rd + ?r + ?t2) H)"
    using *
    using `a*d - b*c \<noteq> 0` `c \<noteq> 0`
    unfolding rotation_dilatation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric]) (subst similarity_preserve_orientation[symmetric], simp_all)
  hence "\<not> pos_oriented (moebius_ocircline (?t1 + ?rd + ?r + ?t2) H)"
    using **
    unfolding translation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric]) (subst similarity_preserve_orientation[symmetric], simp_all)
    
  thus ?thesis
    using assms
    by simp (subst moebius_decomposition, auto simp add: moebius_ocircline_comp[symmetric])
qed

lemma pole_in_disc_compl:
  assumes "M = mk_moebius a b c d" "c \<noteq> 0" "a*d - b*c \<noteq> 0" 
  assumes "is_pole M z" "z \<in> disc_compl H" "H' = moebius_ocircline M H"
  shows "pos_oriented H'"
proof-
  let ?t1 = "translation_moebius (a / c)"
  let ?rd = "rotation_dilatation_moebius ((b * c - a * d) / (c * c))"
  let ?r = "reciprocal_moebius"
  let ?t2 = "translation_moebius (d / c)"

  have "0\<^sub>h = moebius_pt (translation_moebius (d/c)) z"
    using pole_mk_moebius[of a b c d z] assms
    by simp

  have "z \<notin> ocircline_set H"
    using `z \<in> disc_compl H` disc_compl_inter_ocircline_set[of H]
    by auto
  hence "0\<^sub>h \<notin> ocircline_set (moebius_ocircline ?t2 H)"
    using `0\<^sub>h = moebius_pt ?t2 z`
    using inj_image_mem_iff[of "moebius_pt ?t2" z "ocircline_set H"] bij_moebius_pt
    by (subst moebius_ocircline_set[symmetric]) (simp add: bij_def)
  hence *: "\<infinity>\<^sub>h \<notin> ocircline_set (moebius_ocircline (?r + ?t2) H)"
    using reciprocal_homo_only_0_to_inf
    by (simp add: moebius_ocircline_comp[symmetric]) (subst moebius_ocircline_set[symmetric], subst reciprocal_moebius[symmetric], auto, metis)
  hence **: "\<infinity>\<^sub>h \<notin> ocircline_set (moebius_ocircline (?rd + ?r + ?t2) H)"
    using `a*d - b*c \<noteq> 0` `c \<noteq> 0`
    using similarity_preserves_lines
    unfolding rotation_dilatation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric])
    
  have "pos_oriented (moebius_ocircline (?r + ?t2) H)"
    using pole_mk_moebius[of a b c d z] assms
    apply (simp add: moebius_ocircline_comp[symmetric])
    apply (subst reciprocal_preserve_orientation, simp_all)
    apply (subst moebius_disc_compl[symmetric])
    apply force
    done
  hence "pos_oriented (moebius_ocircline (?rd + ?r + ?t2) H)"
    using *
    using `a*d - b*c \<noteq> 0` `c \<noteq> 0`
    unfolding rotation_dilatation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric]) (subst similarity_preserve_orientation[symmetric], simp_all)
  hence "pos_oriented (moebius_ocircline (?t1 + ?rd + ?r + ?t2) H)"
    using **
    unfolding translation_moebius_def
    by (simp add: moebius_ocircline_comp[symmetric]) (subst similarity_preserve_orientation[symmetric], simp_all)
    
  thus ?thesis
    using assms
    by simp (subst moebius_decomposition, auto simp add: moebius_ocircline_comp[symmetric])
qed

subsection{* Oriented circlines uniqueness *}

lemma ocircline_01inf:
  assumes "0\<^sub>h \<in> ocircline_set H \<and> 1\<^sub>h \<in> ocircline_set H \<and> \<infinity>\<^sub>h \<in> ocircline_set H"
  shows "H = o_x_axis \<or> H = opposite_ocircline o_x_axis"
proof-
  have "0\<^sub>h \<in> circline_set (of_ocircline H) \<and> 1\<^sub>h \<in> circline_set (of_ocircline H) \<and> \<infinity>\<^sub>h \<in> circline_set (of_ocircline H)"
    using assms
    by simp
  hence "of_ocircline H = x_axis"
    using unique_circline_01inf'
    by auto
  thus "H = o_x_axis \<or> H = opposite_ocircline o_x_axis"
    by (metis inj_of_ocircline of_ocircline_o_x_axis)
qed

lemma unique_ocircline_01inf: "\<exists>! H. 0\<^sub>h \<in> ocircline_set H \<and> 1\<^sub>h \<in> ocircline_set H \<and> \<infinity>\<^sub>h \<in> ocircline_set H \<and> ii\<^sub>h \<notin> disc H"
proof
  show "0\<^sub>h \<in> ocircline_set o_x_axis \<and> 1\<^sub>h \<in> ocircline_set o_x_axis \<and> \<infinity>\<^sub>h \<in> ocircline_set o_x_axis \<and> ii\<^sub>h \<notin> disc o_x_axis"
    by (simp add: ocircline_set_circline_set_x_axis)
next
  fix H
  assume "0\<^sub>h \<in> ocircline_set H \<and> 1\<^sub>h \<in> ocircline_set H \<and> \<infinity>\<^sub>h \<in> ocircline_set H \<and> ii\<^sub>h \<notin> disc H"
  hence "0\<^sub>h \<in> ocircline_set H \<and> 1\<^sub>h \<in> ocircline_set H \<and> \<infinity>\<^sub>h \<in> ocircline_set H" "ii\<^sub>h \<notin> disc H"
    by auto
  hence "H = o_x_axis \<or> H = opposite_ocircline o_x_axis"
    using ocircline_01inf
    by simp
  thus "H = o_x_axis"
    using `ii\<^sub>h \<notin> disc H`
    by auto
qed

lemma unique_ocircline_set:
  assumes "A \<noteq> B" "A \<noteq> C" "B \<noteq> C"
  shows "\<exists>! H. pos_oriented H \<and> (A \<in> ocircline_set H \<and> B \<in> ocircline_set H \<and> C \<in> ocircline_set H)"
proof-
  obtain M where *: "moebius_pt M A = 0\<^sub>h"  "moebius_pt M B = 1\<^sub>h" "moebius_pt M C = \<infinity>\<^sub>h"
    using ex_moebius_01inf[OF assms]
    by auto
  let ?iM = "moebius_pt (moebius_inv M)"
  have **: "?iM 0\<^sub>h = A"  "?iM 1\<^sub>h = B"  "?iM \<infinity>\<^sub>h = C"
    using bij_moebius_pt[of "moebius_inv M"] *
    by (auto simp add: moebius_inv) (metis bij_def bij_moebius_pt inv_f_eq)+
  let ?H = "moebius_ocircline (moebius_inv M) o_x_axis"
  have 1: "A \<in> ocircline_set ?H" "B \<in> ocircline_set ?H" "C \<in> ocircline_set ?H"
    by - (subst moebius_ocircline_set[symmetric], subst**[symmetric], simp add: ocircline_set_circline_set_x_axis)+

  have 2: "\<And> H'. A \<in> ocircline_set H' \<and> B \<in> ocircline_set H' \<and> C \<in> ocircline_set H' \<Longrightarrow> H' = ?H \<or> H' = opposite_ocircline ?H"
  proof-
    fix H'
    let ?H' = "ocircline_set H'" and ?H'' = "ocircline_set (moebius_ocircline M H')"
    assume "A \<in> ocircline_set H' \<and> B \<in> ocircline_set H' \<and> C \<in> ocircline_set H'"
    hence "moebius_pt M A \<in> ?H''" "moebius_pt M B \<in> ?H''" "moebius_pt M C \<in> ?H''"
      using moebius_ocircline_set[of M H']
      by auto
    hence "0\<^sub>h \<in> ?H''" "1\<^sub>h \<in> ?H''"  "\<infinity>\<^sub>h \<in> ?H''"
      using *
      by auto
    hence "moebius_ocircline M H' = o_x_axis \<or> moebius_ocircline M H' = opposite_ocircline o_x_axis"
      using ocircline_01inf
      by auto
    hence "o_x_axis = moebius_ocircline M H' \<or>  o_x_axis = opposite_ocircline (moebius_ocircline M H')"
      by auto
    thus "H' = ?H \<or> H' = opposite_ocircline ?H"
    proof
      assume *: "o_x_axis = moebius_ocircline M H'"
      show "H' = moebius_ocircline (moebius_inv M) o_x_axis \<or> H' = opposite_ocircline (moebius_ocircline (moebius_inv M) o_x_axis)"
        by (rule disjI1) (subst *, simp)
    next
      assume *: "o_x_axis = opposite_ocircline (moebius_ocircline M H')"
      show "H' = moebius_ocircline (moebius_inv M) o_x_axis \<or> H' = opposite_ocircline (moebius_ocircline (moebius_inv M) o_x_axis)"
        by (rule disjI2) (subst *, simp)
    qed
  qed

  show ?thesis
  proof (cases "pos_oriented ?H")
    case True
    thus ?thesis
      unfolding Ex1_def
    proof (rule_tac x="moebius_ocircline (moebius_inv M) o_x_axis" in exI, simp add: 1, safe)
      fix y
      assume "pos_oriented y" "A \<in> ocircline_set y" "B \<in> ocircline_set y" "C \<in> ocircline_set y"
      thus "y = moebius_ocircline (moebius_inv M) o_x_axis"
        using 2[of y] True
        by (auto simp add: pos_oriented_opposite_ocircline)
    qed
  next
    case False
    thus ?thesis
      unfolding Ex1_def
    proof (rule_tac x="opposite_ocircline (moebius_ocircline (moebius_inv M) o_x_axis)" in exI, simp add: 1 pos_oriented_opposite_ocircline, safe)
      fix y
      assume "pos_oriented y" "A \<in> ocircline_set y" "B \<in> ocircline_set y" "C \<in> ocircline_set y"
      thus "y = opposite_ocircline (moebius_ocircline (moebius_inv M) o_x_axis)"
        using 2[of y] False
        by (auto simp add: pos_oriented_opposite_ocircline)
    qed
  qed
qed

(* ---------------------------- *)
definition chordal_circle_rep where 
 "chordal_circle_rep a r = 
   (let (a1, a2) = Rep_homo_coords a in 
      mk_circline_rep (4*a2*cnj a2 - (cor r)\<^sup>2*(a1*cnj a1 + a2*cnj a2)) (-4*a1*cnj a2) (-4*cnj a1*a2) (4*a1*cnj a1 - (cor r)\<^sup>2*(a1*cnj a1 + a2*cnj a2)))"

lemma [simp]: "Rep_circline_mat (chordal_circle_rep a r) = (let (a1, a2) = Rep_homo_coords a in 
  (4*a2*cnj a2 - (cor r)\<^sup>2*(a1*cnj a1 + a2*cnj a2), -4*a1*cnj a2, -4*cnj a1*a2, 4*a1*cnj a1 - (cor r)\<^sup>2*(a1*cnj a1 + a2*cnj a2)))"
proof-
  obtain a1 a2 where aa: "Rep_homo_coords a = (a1, a2)"
    by (rule obtain_homo_coords)
  hence "(4 * a2 * cnj a2 - (cor r)\<^sup>2 * (a1 * cnj a1 + a2 * cnj a2), -4 * a1 * cnj a2, -4 * cnj a1 * a2, 4 * a1 * cnj a1 - (cor r)\<^sup>2 * (a1 * cnj a1 + a2 * cnj a2)) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    using Rep_homo_coords[of a]
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  thus ?thesis
    using aa
    by (simp add: chordal_circle_rep_def split_def Let_def mk_circline_rep_def Abs_circline_mat_inverse)
qed

lift_definition chordal_circle :: "complex_homo \<Rightarrow> real \<Rightarrow> circline" is chordal_circle_rep
proof-
  fix a b r
  obtain a1 a2 where aa: "Rep_homo_coords a = (a1, a2)"
    by (rule obtain_homo_coords)
  obtain b1 b2 where bb: "Rep_homo_coords b = (b1, b2)"
    by (rule obtain_homo_coords)
  assume "a \<approx> b"
  then obtain k where "Rep_homo_coords b = (k * a1, k * a2)" "k \<noteq> 0"
    using aa bb
    by auto
  moreover
  have "cor (Re (k * cnj k)) = k * cnj k"
    by (metis complex_In_mult_cnj_zero complex_of_real_Re)
  ultimately
  show "circline_mat_eq (chordal_circle_rep a r) (chordal_circle_rep b r)"
    using aa bb
    by (auto simp add: complex_cnj) (rule_tac x="Re (k*cnj k)" in exI, auto simp add: field_simps)
qed

lemma sqrt_1_plus_square: "sqrt (1 + a\<^sup>2) \<noteq> 0"
  by (smt real_sqrt_less_mono real_sqrt_zero realpow_square_minus_le)

lemma
  assumes "dist_homo z a = r"
  shows "z \<in> circline_set (chordal_circle a r)"
proof (cases "a \<noteq> \<infinity>\<^sub>h")
  case True
  then obtain a' where  "a = of_complex a'"
    using inf_homo_or_complex_homo[of a]
    by auto
  let ?A = "4 - (cor r)\<^sup>2 * (1 + (a'*cnj a'))" and ?B = "-4*a'" and ?C="-4*cnj a'" and ?D = "4*a'*cnj a' -  (cor r)\<^sup>2 * (1 + (a'*cnj a'))"
  have hh: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  hence *: "chordal_circle (of_complex a') r = mk_circline ?A ?B ?C ?D"
    by (transfer, simp add: mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x=1 in exI, simp)

  show ?thesis
  proof (cases "z \<noteq> \<infinity>\<^sub>h")
    case True 
    then obtain z' where "z = of_complex z'"
      using inf_homo_or_complex_homo[of z] inf_homo_or_complex_homo[of a]
      by auto
    have "2 * cmod (z' - a') / (sqrt (1 + (cmod z')\<^sup>2) * sqrt (1 + (cmod a')\<^sup>2)) = r"
      using dist_homo_finite[of z' a'] assms `z = of_complex z'` `a = of_complex a'`
      by auto
    hence "4 * (cmod (z' - a'))\<^sup>2 / ((1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2)) = r\<^sup>2 "
      by (auto simp add: power_mult_distrib power_divide field_simps)
    moreover
    have "sqrt (1 + (cmod z')\<^sup>2) \<noteq> 0" "sqrt (1 + (cmod a')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp+
    hence "(1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2) \<noteq> 0"
      by simp
    ultimately
    have "4 * (cmod (z' - a'))\<^sup>2  = r\<^sup>2 * ((1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2))"
      by (simp add: field_simps)
    hence "4 * Re ((z' - a')*cnj (z' - a')) = r\<^sup>2 * (1 + Re (z'*cnj z')) * (1 + Re (a'*cnj a'))"
      by ((subst cmod_square[symmetric])+, simp)
    hence "4 * (Re(z'*cnj z') - Re(a'*cnj z') - Re(cnj a'*z') + Re(a'*cnj a')) = r\<^sup>2 * (1 + Re (z'*cnj z')) * (1 + Re (a'*cnj a'))"
      by (simp add: complex_cnj field_simps)
    hence "Re (?A * z' * cnj z' + ?B * cnj z' + ?C * z' + ?D) = 0"
      by (simp add: power2_eq_square field_simps)
    hence "?A * z' * cnj z' + ?B * cnj z' + ?C * z' + ?D = 0"
      by (subst complex_eq_if_Re_eq) (auto simp add: power2_eq_square)
    hence "(cnj z' * ?A + ?C) * z' + (cnj z' * ?B + ?D) = 0"
      by algebra
    hence "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using `z = of_complex z'` hh
      unfolding circline_set_def
      by simp (transfer, simp add: of_complex_coords_def Abs_homo_coords_inverse on_circline_rep_def Let_def Abs_circline_mat_inverse mk_circline_rep_def vec_cnj_def)
    thus ?thesis
      using *
      by (subst `a = of_complex a'`) simp
  next
    case False
    hence "2 / sqrt (1 + (cmod a')\<^sup>2) = r"
      using assms `a = of_complex a'`
      using dist_homo_infinite2[of a']
      by simp
    moreover
    have "sqrt (1 + (cmod a')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp
    ultimately
    have "2 = r * sqrt (1 + (cmod a')\<^sup>2)"
      by (simp add: field_simps)
    hence "4 = (r * sqrt (1 + (cmod a')\<^sup>2))\<^sup>2"
      by simp
    hence "4 = r\<^sup>2 * (1 + (cmod a')\<^sup>2)"
      by (simp add: power_mult_distrib)
    hence "Re (4 - (cor r)\<^sup>2 * (1 + (a' * cnj a'))) = 0"
      by (subst (asm) cmod_square) (simp add: field_simps power2_eq_square)
    hence "4 - (cor r)\<^sup>2 * (1 + (a'*cnj a')) = 0"
      by (subst complex_eq_if_Re_eq) (auto simp add: power2_eq_square)
    hence "circline_A0 (mk_circline ?A ?B ?C ?D)"
      using hh
      by simp (transfer, simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
    hence "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using inf_in_circline_set[of "mk_circline ?A ?B ?C ?D"]
      using `\<not> z \<noteq> \<infinity>\<^sub>h`
      by simp
    thus ?thesis
      using *
      by (subst `a = of_complex a'`) simp
  qed
next
  case False
  let ?A = "-(cor r)\<^sup>2" and ?B = "0" and ?C = "0" and ?D = "4 -(cor r)\<^sup>2"
  have hh: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  hence *: "chordal_circle a r = mk_circline ?A ?B ?C ?D"
    using `\<not> a \<noteq> \<infinity>\<^sub>h`
    by simp (transfer, simp add: mk_circline_rep_def Abs_circline_mat_inverse, rule_tac x=1 in exI, simp)

  show ?thesis
  proof (cases "z = \<infinity>\<^sub>h")
    case True
    show ?thesis
      using assms `z = \<infinity>\<^sub>h` `\<not> a \<noteq> \<infinity>\<^sub>h`
      using * hh
      by (simp, subst inf_in_circline_set, transfer, simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
  next
    case False
    then obtain z' where "z = of_complex z'"
      using inf_homo_or_complex_homo[of z]
      by auto
    have "2 / sqrt (1 + (cmod z')\<^sup>2) = r"
      using assms `z = of_complex z'``\<not> a \<noteq> \<infinity>\<^sub>h`
      using dist_homo_infinite2[of z']
      by simp
    moreover
    have "sqrt (1 + (cmod z')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp
    ultimately
    have "2 = r * sqrt (1 + (cmod z')\<^sup>2)"
      by (simp add: field_simps)
    hence "4 = (r * sqrt (1 + (cmod z')\<^sup>2))\<^sup>2"
      by simp
    hence "4 = r\<^sup>2 * (1 + (cmod z')\<^sup>2)"
      by (simp add: power_mult_distrib)
    hence "Re (4 - (cor r)\<^sup>2 * (1 + (z' * cnj z'))) = 0"
      by (subst (asm) cmod_square) (simp add: field_simps power2_eq_square)
    hence "- (cor r)\<^sup>2 * z'*cnj z' + 4 - (cor r)\<^sup>2 = 0"
      by (subst complex_eq_if_Re_eq) (auto simp add: power2_eq_square field_simps)
    hence "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using hh
      unfolding circline_set_def
      by (subst `z = of_complex z'`, simp) (transfer, auto simp add: on_circline_rep_def Let_def mk_circline_rep_def Abs_circline_mat_inverse vec_cnj_def field_simps)
    thus ?thesis
      using *
      by simp
  qed
qed

lemma [simp]: "sqrt 4 = 2"
proof-
  have "sqrt (2\<^sup>2) = 2"
    by (metis abs_numeral real_sqrt_abs)
  thus ?thesis
    by simp
qed

lemma 
  assumes "z \<in> circline_set (chordal_circle a r)" "r \<ge> 0"
  shows "dist_homo z a = r"
proof (cases "a = \<infinity>\<^sub>h")
  case False
  then obtain a' where "a = of_complex a'"
    using inf_homo_or_complex_homo[of a]
    by auto

  let ?A = "4 - (cor r)\<^sup>2 * (1 + (a'*cnj a'))" and ?B = "-4*a'" and ?C="-4*cnj a'" and ?D = "4*a'*cnj a' -  (cor r)\<^sup>2 * (1 + (a'*cnj a'))"
  have hh: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  hence *: "chordal_circle (of_complex a') r = mk_circline ?A ?B ?C ?D"
    by (transfer, simp add: mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x=1 in exI, simp)
  
  show ?thesis
  proof (cases "z = \<infinity>\<^sub>h")
    case False
    then obtain z' where "z = of_complex z'"
      using inf_homo_or_complex_homo[of z] inf_homo_or_complex_homo[of a]
      by auto
    hence "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using assms `a = of_complex a'` *
      by simp
    hence "(cnj z' * ?A + ?C) * z' + (cnj z' * ?B + ?D) = 0"
      using hh
      unfolding circline_set_def
      by (subst (asm) `z = of_complex z'`, simp) (transfer, simp add: on_circline_rep_def Let_def mk_circline_rep_def Abs_circline_mat_inverse vec_cnj_def)
    hence "?A * z' * cnj z' + ?B * cnj z' + ?C * z' + ?D = 0"
      by algebra
    hence "Re (?A * z' * cnj z' + ?B * cnj z' +?C * z' +?D) = 0"
      by (simp add: power2_eq_square field_simps)
    hence "4 * Re ((z' - a')*cnj (z' - a')) = r\<^sup>2 * (1 + Re (z'*cnj z')) * (1 + Re (a'*cnj a'))"
      by (simp add: complex_cnj field_simps power2_eq_square)
    hence "4 * (cmod (z' - a'))\<^sup>2  = r\<^sup>2 * ((1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2))"
      by (subst cmod_square)+ simp
    moreover
    have "sqrt (1 + (cmod z')\<^sup>2) \<noteq> 0" "sqrt (1 + (cmod a')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp+
    hence "(1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2) \<noteq> 0"
      by simp
    ultimately
    have "4 * (cmod (z' - a'))\<^sup>2 / ((1 + (cmod z')\<^sup>2) * (1 + (cmod a')\<^sup>2)) = r\<^sup>2 "
      by (simp add: field_simps)
    hence "2 * cmod (z' - a') / (sqrt (1 + (cmod z')\<^sup>2) * sqrt (1 + (cmod a')\<^sup>2)) = r"
      using `r \<ge> 0`
      by (subst (asm) real_sqrt_eq_iff[symmetric]) (simp add: real_sqrt_mult real_sqrt_divide)
    thus ?thesis
      using `z = of_complex z'` `a = of_complex a'`
      using dist_homo_finite[of z' a']
      by simp
  next
    case True
    have "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using assms `a = of_complex a'` *
      by simp
    hence "circline_A0 (mk_circline ?A ?B ?C ?D)"
      using inf_in_circline_set[of "mk_circline ?A ?B ?C ?D"]
      using `z = \<infinity>\<^sub>h`
      by simp
    hence "4 - (cor r)\<^sup>2 * (1 + (a'*cnj a')) = 0"
      using hh
      by transfer (simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
    hence "Re (4 - (cor r)\<^sup>2 * (1 + (a' * cnj a'))) = 0"
      by simp
    hence "4 = r\<^sup>2 * (1 + (cmod a')\<^sup>2)"
      by (subst cmod_square) (simp add: power2_eq_square)
    hence "2 = r * sqrt (1 + (cmod a')\<^sup>2)"
      using `r \<ge> 0`
      by (subst (asm) real_sqrt_eq_iff[symmetric]) (simp add: real_sqrt_mult)
    moreover
    have "sqrt (1 + (cmod a')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp
    ultimately
    have "2 / sqrt (1 + (cmod a')\<^sup>2) = r"
      by (simp add: field_simps)
    thus ?thesis
      using `a = of_complex a'` `z = \<infinity>\<^sub>h`
      using dist_homo_infinite2[of a']
      by simp
  qed
next
  case True
  let ?A = "-(cor r)\<^sup>2" and ?B = "0" and ?C = "0" and ?D = "4 -(cor r)\<^sup>2"
  have hh: "(?A, ?B, ?C, ?D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (auto simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  hence *: "chordal_circle a r = mk_circline ?A ?B ?C ?D"
    using `a = \<infinity>\<^sub>h`
    by simp (transfer, simp add: mk_circline_rep_def Abs_circline_mat_inverse, rule_tac x=1 in exI, simp)

  show ?thesis
  proof (cases "z = \<infinity>\<^sub>h")
    case True
    thus ?thesis
      using `a = \<infinity>\<^sub>h` assms * hh
      by simp (subst (asm) inf_in_circline_set, transfer, simp add: circline_A0_rep_def mk_circline_rep_def Abs_circline_mat_inverse)
  next
    case False
    then obtain z' where "z = of_complex z'"
      using inf_homo_or_complex_homo[of z] inf_homo_or_complex_homo[of a]
      by auto
    hence "z \<in> circline_set (mk_circline ?A ?B ?C ?D)"
      using assms *
      by simp
    hence "- (cor r)\<^sup>2 * z'*cnj z' + 4 - (cor r)\<^sup>2 = 0"
      using hh
      unfolding circline_set_def
      apply (subst (asm) `z = of_complex z'`)
      by (simp, transfer) (simp add: on_circline_rep_def mk_circline_rep_def Let_def vec_cnj_def Abs_circline_mat_inverse, algebra)
    hence "4 - (cor r)\<^sup>2 * (1 + (z'*cnj z')) = 0"
      by (simp add: field_simps)
    hence "Re (4 - (cor r)\<^sup>2 * (1 + (z' * cnj z'))) = 0"
      by simp
    hence "4 = r\<^sup>2 * (1 + (cmod z')\<^sup>2)"
      by (subst cmod_square) (simp add: power2_eq_square)
    hence "2 = r * sqrt (1 + (cmod z')\<^sup>2)"
      using `r \<ge> 0`
      by (subst (asm) real_sqrt_eq_iff[symmetric]) (simp add: real_sqrt_mult)
    moreover
    have "sqrt (1 + (cmod z')\<^sup>2) \<noteq> 0"
      using sqrt_1_plus_square
      by simp
    ultimately
    have "2 / sqrt (1 + (cmod z')\<^sup>2) = r"
      by (simp add: field_simps)
    thus ?thesis
      using `z = of_complex z'` `a = \<infinity>\<^sub>h`
      using dist_homo_infinite2[of z']
      by simp
  qed
qed

lemma chordal_circle_radius_positive:
  assumes "hermitean (A, B, C, D)" "Re (mat_det (A, B, C, D)) \<le> 0" "B \<noteq> 0" 
  "dsc = sqrt(Re ((D-A)\<^sup>2 + 4 * (B*cnj B)))" "a1 = (A - D + cor dsc) / (2 * C)" "a2 = (A - D - cor dsc) / (2 * C)"
  shows "Re (A*a1/B) \<ge> -1 \<and> Re (A*a2/B) \<ge> -1"
proof-
  from assms have "is_real A" "is_real D" "C = cnj B"
    using hermitean_elems
    by auto
  have *: "A*a1/B = ((A - D + cor dsc) / (2 * (B * cnj B))) * A"
    using `B \<noteq> 0` `C = cnj B` `a1 = (A - D + cor dsc) / (2 * C)`
    by (simp add: field_simps) algebra
  have **: "A*a2/B = ((A - D - cor dsc) / (2 * (B * cnj B))) * A"
    using `B \<noteq> 0` `C = cnj B` `a2 = (A - D - cor dsc) / (2 * C)`
    by (simp add: field_simps) algebra
  have "dsc \<ge> 0"
  proof-
    have "0 \<le> Re ((D - A)\<^sup>2) + 4 * Re ((cor (cmod B))\<^sup>2)"
      using `is_real A` `is_real D`
      by (subst cor_squared, subst Re_complex_of_real) (simp add: power2_eq_square)
    thus ?thesis
      using `dsc = sqrt(Re ((D-A)\<^sup>2 + 4*(B*cnj B)))`
      by (subst (asm) complex_mult_cnj_cmod) simp
  qed
  hence "Re (A - D - cor dsc) \<le> Re (A - D + cor dsc)"
    by simp
  moreover
  have "Re (2 * (B * cnj B)) > 0"
    using `B \<noteq> 0`
    by (subst complex_mult_cnj_cmod, simp add: power2_eq_square) (metis norm_eq_zero not_real_square_gt_zero)
  ultimately
  have xxx: "Re (A - D + cor dsc) / Re (2 * (B * cnj B)) \<ge> Re (A - D - cor dsc) / Re (2 * (B * cnj B))" (is "?lhs \<ge> ?rhs")
    by (metis divide_right_mono less_eq_real_def)

  have "Re A * Re D \<le> Re (B*cnj B)"
    using `Re (mat_det (A, B, C, D)) \<le> 0` `C = cnj B` `is_real A` `is_real D`
    by simp
    
  show ?thesis
  proof (cases "Re A > 0")
    case True
    hence "Re (A*a1/B) \<ge> Re (A*a2/B)"
      using * ** `Re (2 * (B * cnj B)) > 0` `B \<noteq> 0` `is_real A` `is_real D` xxx
      using mult_right_mono[of ?rhs ?lhs "Re A"]
      apply simp
      apply (subst Re_divide_real, simp, simp)
      apply (subst Re_divide_real, simp, simp)
      apply (subst Re_mult_real, simp)+
      apply simp
      done
    moreover
    have "Re (A*a2/B) \<ge> -1"
    proof-
      from `Re A * Re D \<le> Re (B*cnj B)`
      have "Re (A\<^sup>2) \<le> Re (B*cnj B) + Re ((A - D)*A)"
        using `Re A > 0` `is_real A` `is_real D`
        by (simp add: power2_eq_square field_simps)
      have "1 \<le> Re (B*cnj B) / Re (A\<^sup>2) + Re (A - D) / Re A"
        using `Re A > 0` `is_real A` `is_real D`
        using divide_right_mono[OF `Re (A\<^sup>2) \<le> Re (B*cnj B) + Re ((A - D)*A)`, of "Re (A\<^sup>2)"]
        by (simp add: power2_eq_square add_divide_distrib)
      have "4 * Re(B*cnj B) \<le> 4 * (Re (B*cnj B))\<^sup>2 / Re (A\<^sup>2)  + 2*Re (A - D) / Re A * 2 * Re(B*cnj B)"
        using mult_right_mono[OF `1 \<le> Re (B*cnj B) / Re (A\<^sup>2) + Re (A - D) / Re A`, of "4 * Re (B*cnj B)"]
        by (simp add: distrib_right) (simp add: power2_eq_square field_simps)
      moreover
      have "A \<noteq> 0"
        using `Re A > 0`
        by auto
      hence "4 * (Re (B*cnj B))\<^sup>2 / Re (A\<^sup>2) = Re (4 * (B*cnj B)\<^sup>2 / A\<^sup>2)"
        using Re_divide_real[of "A\<^sup>2" "4 * (B*cnj B)\<^sup>2"] `Re A > 0` `is_real A` 
        by (auto simp add: power2_eq_square)
      moreover
      have "2*Re (A - D) / Re A * 2 * Re(B*cnj B) = Re (2 * (A - D) / A * 2 * B * cnj B)"
        using `is_real A` `is_real D` `A \<noteq> 0`
        using Re_divide_real[of "A" "(4 * A - 4 * D) * B * cnj B"]
        by (simp add: field_simps)
      ultimately
      have "Re ((D - A)\<^sup>2 + 4 * B*cnj B) \<le> Re((A - D)\<^sup>2 + 4 * (B*cnj B)\<^sup>2 / A\<^sup>2  + 2*(A - D) / A * 2 * B*cnj B)"
        by (simp add: field_simps power2_eq_square)
      hence "Re ((D - A)\<^sup>2 + 4 * B*cnj B) \<le> Re(((A - D) +  2 * B*cnj B / A)\<^sup>2)"
        using `A \<noteq> 0`
        by (subst power2_sum) (simp add: power2_eq_square field_simps)
      hence "dsc \<le> sqrt (Re(((A - D) +  2 * B*cnj B / A)\<^sup>2))"
        using `dsc = sqrt(Re ((D-A)\<^sup>2 + 4*(B*cnj B)))`
        by simp
      moreover
      have "Re(((A - D) +  2 * B*cnj B / A)\<^sup>2) = (Re((A - D) +  2 * B*cnj B / A))\<^sup>2"
        using `is_real A` `is_real D` div_reals
        by (simp add: power2_eq_square)
      ultimately
      have "dsc \<le> \<bar>Re (A - D + 2 * B * cnj B / A)\<bar>"
        by simp
      moreover
      have "Re (A - D + 2 * B * cnj B / A) \<ge> 0"
      proof-
        have "Re (A\<^sup>2 + B*cnj B) \<ge> 0"
          using `is_real A`
          by (simp add: power2_eq_square)
        hence "Re (A\<^sup>2 + 2*B*cnj B - A*D) \<ge> 0"
          using `Re A * Re D \<le> Re (B*cnj B)`
          using `is_real A` `is_real D`
          by simp
        show ?thesis
          using divide_right_mono[OF `Re (A\<^sup>2 + 2*B*cnj B - A*D) \<ge> 0`, of "Re A"] `Re A > 0` `is_real A` `A \<noteq> 0`
          by (simp add: add_divide_distrib diff_divide_distrib del: complex_Re_mult) (subst Re_divide_real, auto simp add: power2_eq_square field_simps)
      qed
      ultimately
      have "dsc \<le> Re (A - D + 2 * B * cnj B / A)"
        by simp
      hence "- Re (2 * (B * cnj B) / A) \<le> Re ((A - D - cor dsc))"
        by (simp add: field_simps)
      hence "- (Re (2 * (B * cnj B)) / Re A) \<le> Re (A - D - cor dsc)"
        using `is_real A` `A \<noteq> 0`
        by (subst (asm) Re_divide_real, auto)
      from divide_right_mono[OF this, of "Re (2 * B * cnj B)"]
      have "- 1 / Re A \<le> Re (A - D - cor dsc) / Re (2 * B * cnj B)"
        using `Re A > 0` `B \<noteq> 0` `A \<noteq> 0` `0 < Re (2 * (B * cnj B))`
        by (simp add: field_simps del: complex_Re_mult)
      from mult_right_mono[OF this, of "Re A"]
      show ?thesis
        using `is_real A` `is_real D` `B \<noteq> 0` `Re A > 0` `A \<noteq> 0`
        apply (subst **)
        apply (subst Re_mult_real, simp add: div_reals)
        apply (subst Re_divide_real, simp, simp)
        apply (simp add: field_simps)
        done
    qed
    ultimately
    show ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "Re A < 0")
      case True
      hence "Re (A*a1/B) \<le> Re (A*a2/B)"
        using * ** `Re (2 * (B * cnj B)) > 0` `B \<noteq> 0` `is_real A` `is_real D` xxx
        using mult_right_mono_neg[of ?rhs ?lhs "Re A"]
        apply simp
        apply (subst Re_divide_real, simp, simp)
        apply (subst Re_divide_real, simp, simp)
        apply (subst Re_mult_real, simp)+
        apply simp
        done
      moreover
      have "Re (A*a1/B) \<ge> -1"
      proof-
        from `Re A * Re D \<le> Re (B*cnj B)`
        have "Re (A\<^sup>2) \<le> Re (B*cnj B) - Re ((D - A)*A)"
          using `Re A < 0` `is_real A` `is_real D`
          by (simp add: power2_eq_square field_simps)
        hence "1 \<le> Re (B*cnj B) / Re (A\<^sup>2) - Re (D - A) / Re A"
          using `Re A < 0` `is_real A` `is_real D`
          using divide_right_mono[OF `Re (A\<^sup>2) \<le> Re (B*cnj B) - Re ((D - A)*A)`, of "Re (A\<^sup>2)"]
          by (simp add: power2_eq_square diff_divide_distrib)
        have "4 * Re(B*cnj B) \<le> 4 * (Re (B*cnj B))\<^sup>2 / Re (A\<^sup>2)  - 2*Re (D - A) / Re A * 2 * Re(B*cnj B)"
          using mult_right_mono[OF `1 \<le> Re (B*cnj B) / Re (A\<^sup>2) - Re (D - A) / Re A`, of "4 * Re (B*cnj B)"]
          by (simp add: left_diff_distrib) (simp add: power2_eq_square field_simps)
        moreover
        have "A \<noteq> 0"
          using `Re A < 0`
          by auto
        hence "4 * (Re (B*cnj B))\<^sup>2 / Re (A\<^sup>2) = Re (4 * (B*cnj B)\<^sup>2 / A\<^sup>2)"
          using Re_divide_real[of "A\<^sup>2" "4 * (B*cnj B)\<^sup>2"] `Re A < 0` `is_real A` 
          by (auto simp add: power2_eq_square)
        moreover
        have "2*Re (D - A) / Re A * 2 * Re(B*cnj B) = Re (2 * (D - A) / A * 2 * B * cnj B)"
          using `is_real A` `is_real D` `A \<noteq> 0`
          using Re_divide_real[of "A" "(4 * D - 4 * A) * B * cnj B"]
          by (simp add: field_simps)
        ultimately
        have "Re ((D - A)\<^sup>2 + 4 * B*cnj B) \<le> Re((D - A)\<^sup>2 + 4 * (B*cnj B)\<^sup>2 / A\<^sup>2  - 2*(D - A) / A * 2 * B*cnj B)"
          by (simp add: field_simps power2_eq_square)
        hence "Re ((D - A)\<^sup>2 + 4 * B*cnj B) \<le> Re(((D - A) -  2 * B*cnj B / A)\<^sup>2)"
          using `A \<noteq> 0`
          by (subst power2_diff) (simp add: power2_eq_square field_simps)
        hence "dsc \<le> sqrt (Re(((D - A) -  2 * B*cnj B / A)\<^sup>2))"
          using `dsc = sqrt(Re ((D-A)\<^sup>2 + 4*(B*cnj B)))`
          by simp
        moreover
        have "Re(((D - A) -  2 * B*cnj B / A)\<^sup>2) = (Re((D - A) -  2 * B*cnj B / A))\<^sup>2"
          using `is_real A` `is_real D` div_reals
          by (simp add: power2_eq_square)
        ultimately
        have "dsc \<le> \<bar>Re (D - A - 2 * B * cnj B / A)\<bar>"
          by simp
        moreover
        have "Re (D - A - 2 * B * cnj B / A) \<ge> 0"
        proof-
          have "Re (A\<^sup>2 + B*cnj B) \<ge> 0"
            using `is_real A`
            by (simp add: power2_eq_square)
          hence "Re (A\<^sup>2 + 2*B*cnj B - A*D) \<ge> 0"
            using `Re A * Re D \<le> Re (B*cnj B)`
            using `is_real A` `is_real D`
            by simp
          show ?thesis
            using divide_right_mono_neg[OF `Re (A\<^sup>2 + 2*B*cnj B - A*D) \<ge> 0`, of "Re A"] `Re A < 0` `is_real A` `A \<noteq> 0`
            by (simp add: add_divide_distrib diff_divide_distrib del: complex_Re_mult) (subst Re_divide_real, auto simp add: power2_eq_square field_simps)
        qed
        ultimately
        have "dsc \<le> Re (D - A - 2 * B * cnj B / A)"
          by simp
        hence "- Re (2 * (B * cnj B) / A) \<ge> Re ((A - D + cor dsc))"
          by (simp add: field_simps)
        hence "- (Re (2 * (B * cnj B)) / Re A) \<ge> Re (A - D + cor dsc)"
          using `is_real A` `A \<noteq> 0`
          by (subst (asm) Re_divide_real, auto)
        from divide_right_mono[OF this, of "Re (2 * B * cnj B)"]
        have "- 1 / Re A \<ge> Re (A - D + cor dsc) / Re (2 * B * cnj B)"
          using `Re A < 0` `B \<noteq> 0` `A \<noteq> 0` `0 < Re (2 * (B * cnj B))`
          by (simp add: field_simps del: complex_Re_mult)
        from mult_right_mono_neg[OF this, of "Re A"]
        show ?thesis
          using `is_real A` `is_real D` `B \<noteq> 0` `Re A < 0` `A \<noteq> 0`
          apply (subst *)
          apply (subst Re_mult_real, simp add: div_reals)
          apply (subst Re_divide_real, simp, simp)
          apply (simp add: field_simps)
          done
      qed
      ultimately
      show ?thesis
        by simp
    next
      case False
      hence "A = 0"
        using `\<not> Re A > 0` `is_real A`
        by (cases A) simp
      thus ?thesis
        by simp
    qed
  qed
qed

definition chordal_circles_rep where
  "chordal_circles_rep H = 
     (let (A, B, C, D) = Rep_circline_mat H;
          dsc = sqrt(Re ((D-A)\<^sup>2 + 4 * (B*cnj B)));
          a1 = (A - D + cor dsc) / (2 * C);
          r1 = sqrt((4 - Re((-4 * a1/B) * A)) / (1 + Re (a1*cnj a1)));
          a2 = (A - D - cor dsc) / (2 * C);
          r2 = sqrt((4 - Re((-4 * a2/B) * A)) / (1 + Re (a2*cnj a2)))
       in ((a1, r1), (a2, r2)))"

lift_definition chordal_circles :: "ocircline \<Rightarrow> (complex \<times> real) \<times> (complex \<times> real)" is chordal_circles_rep
proof-
  fix H1 H2
  obtain A1 B1 C1 D1 where hh1: "(A1, B1, C1, D1) = Rep_circline_mat H1"
    by (cases "Rep_circline_mat H1") auto
  obtain A2 B2 C2 D2 where hh2: "(A2, B2, C2, D2) = Rep_circline_mat H2"
    by (cases "Rep_circline_mat H2") auto

  assume "ocircline_mat_eq H1 H2"
  then obtain k where *: "k > 0" "A2 = cor k * A1" "B2 = cor k * B1" "C2 = cor k * C1" "D2 = cor k * D1"
    using hh1[symmetric] hh2[symmetric]
    by auto
  let ?dsc1 = "sqrt (Re ((D1 - A1)\<^sup>2 + 4 * (B1 * cnj B1)))" and ?dsc2 = "sqrt (Re ((D2 - A2)\<^sup>2 + 4 * (B2 * cnj B2)))"
  let ?a11 = "(A1 - D1 + cor ?dsc1) / (2 * C1)" and ?a12 = "(A2 - D2 + cor ?dsc2) / (2 * C2)"
  let ?a21 = "(A1 - D1 - cor ?dsc1) / (2 * C1)" and ?a22 = "(A2 - D2 - cor ?dsc2) / (2 * C2)"
  let ?r11 = "sqrt((4 - Re((-4 * ?a11/B1) * A1)) / (1 + Re (?a11*cnj ?a11)))"
  let ?r12 = "sqrt((4 - Re((-4 * ?a12/B2) * A2)) / (1 + Re (?a12*cnj ?a12)))"
  let ?r21 = "sqrt((4 - Re((-4 * ?a21/B1) * A1)) / (1 + Re (?a21*cnj ?a21)))"
  let ?r22 = "sqrt((4 - Re((-4 * ?a22/B2) * A2)) / (1 + Re (?a22*cnj ?a22)))"

  have "Re ((D2 - A2)\<^sup>2 + 4 * (B2 * cnj B2)) = k\<^sup>2 * Re ((D1 - A1)\<^sup>2 + 4 * (B1 * cnj B1))"
    using *
    by (simp add: power2_eq_square field_simps)
  hence "?dsc2 = k * ?dsc1"
    using `k > 0`
    by (simp add: real_sqrt_mult)
  hence "A2 - D2 + cor ?dsc2 = cor k * (A1 - D1 + cor ?dsc1)" "A2 - D2 - cor ?dsc2 = cor k * (A1 - D1 - cor ?dsc1)" "2*C2 = cor k * (2*C1)"
    using *
    by (auto simp add: field_simps)
  hence "?a12 = ?a11" "?a22 = ?a21"
    using `k > 0`
    by simp_all
  moreover
  have "Re((-4 * ?a12/B2) * A2) = Re((-4 * ?a11/B1) * A1)"
    using *
    by (subst `?a12 = ?a11`) (simp, simp add: field_simps)
  have "?r12 = ?r11"
    by (subst `Re((-4 * ?a12/B2) * A2) = Re((-4 * ?a11/B1) * A1)`, (subst `?a12 = ?a11`)+) simp
  moreover
  have "Re((-4 * ?a22/B2) * A2) = Re((-4 * ?a21/B1) * A1)"
    using *
    by (subst `?a22 = ?a21`) (simp, simp add: field_simps)
  have "?r22 = ?r21"
    by (subst `Re((-4 * ?a22/B2) * A2) = Re((-4 * ?a21/B1) * A1)`, (subst `?a22 = ?a21`)+) simp
  moreover
  have "chordal_circles_rep H1 = ((?a11, ?r11), (?a21, ?r21))"
    using hh1[symmetric] hh2[symmetric]
    unfolding chordal_circles_rep_def Let_def
    by simp
  moreover
  have "chordal_circles_rep H1 = ((?a11, ?r11), (?a21, ?r21))"
    using hh1[symmetric] 
    unfolding chordal_circles_rep_def Let_def
    by simp
  moreover
  have "chordal_circles_rep H2 = ((?a12, ?r12), (?a22, ?r22))"
    using hh2[symmetric] 
    unfolding chordal_circles_rep_def Let_def
    by simp
  ultimately
  show "chordal_circles_rep H1 = chordal_circles_rep H2"
    by metis
qed

lemma chordal_circle_det_positive:
  fixes x y :: real
  assumes "x * y < 0"
  shows "x / (x - y) > 0"
proof (cases "x > 0")
  case True
  hence "y < 0"
    using `x * y < 0`
    by (metis mult_less_cancel_left_pos mult_zero_right)
  have "x - y > 0"
    using `x > 0` `y < 0`
    by auto
  thus ?thesis
    using `x > 0`
    by (metis zero_less_divide_iff) 
next
  case False
  hence "y > 0" "x < 0"
    using `x * y < 0`
    by - (metis mult_less_cancel_left_disj mult_zero_right, metis less_linear mult_zero_left)
  have "x - y < 0"
    using `x < 0` `y > 0`
    by auto
  thus ?thesis
    using `x < 0`
    by (metis zero_less_divide_iff)
qed

lemma chordal_circle1:
  assumes "is_real A" "is_real D" "Re (A * D) < 0" "r = sqrt(Re ((4*A)/(A-D)))"
  shows "mk_circline A 0 0 D = chordal_circle \<infinity>\<^sub>h r"
using assms
proof transfer
  fix A D r
  assume *: "is_real A" "is_real D" "Re (A * D) < 0" "r = sqrt (Re ((4*A)/(A-D)))"
  hence "A \<noteq> 0 \<or> D \<noteq> 0"
    by auto
  hence "(A, 0, 0, D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    using eq_cnj_iff_real[of A] eq_cnj_iff_real[of D] *
    unfolding hermitean_def
    by (simp add: mat_adj_def mat_cnj_def)
  moreover
  have "(- (cor r)\<^sup>2, 0, 0, 4 - (cor r)\<^sup>2) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square)
  moreover
  have "A \<noteq> D"
    using `Re (A * D) < 0` `is_real A` `is_real D`
    by auto
  have "Re ((4*A)/(A-D)) \<ge> 0"
  proof-
    have "Re A / Re (A - D) \<ge> 0"
      using `Re (A * D) < 0` `is_real A` `is_real D`
      using chordal_circle_det_positive[of "Re A" "Re D"]
      by simp
    thus ?thesis
      using `is_real A` `is_real D` `A \<noteq> D`
      by (subst Re_divide_real, auto) (metis mult_nonneg_nonpos zero_le_divide_iff zero_le_mult_iff zero_le_numeral)
  qed
  moreover
  have "- (cor (sqrt (Re (4 * A / (A - D)))))\<^sup>2 = cor (Re (4 / (D - A))) * A"
    using `Re ((4*A)/(A-D)) \<ge> 0` `is_real A` `is_real D` `A \<noteq> D`
    by (subst cor_squared, subst real_sqrt_power[symmetric], simp) (simp add: Re_divide_real Re_mult_real complex_of_real_Re of_real_numeral minus_divide_right)
  moreover
  have "4 * (A - D) - 4 * A  = 4 * -D"
    by (simp add: field_simps)
  hence "4 - 4 * A / (A - D) = -4 * D / (A - D)"
    using `A \<noteq> D`
    by (smt ab_semigroup_mult_class.mult_ac(1) diff_divide_eq_iff eq_iff_diff_eq_0 mult_minus1 mult_minus1_right mult_numeral_1_right neg_numeral_def right_diff_distrib_numeral times_divide_eq_right)
  hence "4 - 4 * A / (A - D) = 4 * D / (D - A)"
    by (metis (hide_lams, no_types) minus_diff_eq minus_divide_left minus_divide_right minus_mult_left neg_numeral_def)
  hence "4 - (cor (sqrt (Re (4 * A / (A - D)))))\<^sup>2 = cor (Re (4 / (D - A))) * D"
    using `Re ((4*A)/(A-D)) \<ge> 0` `is_real A` `is_real D` `A \<noteq> D`
    by (subst cor_squared, subst real_sqrt_power[symmetric], simp) (simp add: Re_divide_real Re_mult_real complex_of_real_Re of_real_numeral)
  ultimately
  show "circline_mat_eq (mk_circline_rep A 0 0 D) (chordal_circle_rep inf_homo_rep r)"
    using `is_real A` `is_real D` `A \<noteq> D` `r = sqrt(Re ((4*A)/(A-D)))`
    by (simp add: chordal_circle_rep_def mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x="Re(4/(D-A))" in exI, auto)
qed

lemma chordal_circle2:
  assumes "is_real A" "is_real D" "Re (A * D) < 0" "r = sqrt(Re ((4*D)/(D-A)))"
  shows "mk_circline A 0 0 D = chordal_circle 0\<^sub>h r"
using assms
proof transfer
  fix A D r
  assume *: "is_real A" "is_real D" "Re (A * D) < 0" "r = sqrt (Re ((4*D)/(D-A)))"
  hence "A \<noteq> 0 \<or> D \<noteq> 0"
    by auto
  hence "(A, 0, 0, D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    using eq_cnj_iff_real[of A] eq_cnj_iff_real[of D] *
    unfolding hermitean_def
    by (simp add: mat_adj_def mat_cnj_def)
  moreover
  have "(4 - (cor r)\<^sup>2, 0, 0, - (cor r)\<^sup>2) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}"
    by (simp add: hermitean_def mat_adj_def mat_cnj_def complex_cnj power2_eq_square) (metis mult_zero_right of_real_0 zero_neq_numeral)
  moreover
  have "A \<noteq> D"
    using `Re (A * D) < 0` `is_real A` `is_real D`
    by auto
  have "Re((4*D)/(D-A)) \<ge> 0"
  proof-
    have "Re D / Re (D - A) \<ge> 0"
      using `Re (A * D) < 0` `is_real A` `is_real D`
      using chordal_circle_det_positive[of "Re D" "Re A"]
      by (simp add: field_simps)
    thus ?thesis
      using `is_real A` `is_real D` `A \<noteq> D`
      by (subst Re_divide_real, auto) (metis mult_nonneg_nonpos zero_le_divide_iff zero_le_mult_iff zero_le_numeral)
  qed
  have "4 * (D - A) - 4 * D  = 4 * -A"
    by (simp add: field_simps)
  hence "4 - 4 * D / (D - A) = -4 * A / (D - A)"
    using `A \<noteq> D`
    by (smt ab_semigroup_mult_class.mult_ac(1) diff_divide_eq_iff eq_iff_diff_eq_0 mult_minus1 mult_minus1_right mult_numeral_1_right neg_numeral_def right_diff_distrib_numeral times_divide_eq_right)
  hence "4 - 4 * D / (D - A) = 4 * A / (A - D)"
    by (metis (hide_lams, no_types) minus_diff_eq minus_divide_left minus_divide_right minus_mult_left neg_numeral_def)
  hence "4 - (cor (sqrt (Re ((4*D)/(D-A)))))\<^sup>2 = cor (Re (4 / (A - D))) * A"
    using `is_real A` `is_real D` `A \<noteq> D` `Re (4 * D / (D - A)) \<ge> 0`
    by (subst cor_squared, subst real_sqrt_power[symmetric], simp) (simp add: Re_divide_real complex_of_real_Re of_real_numeral)

  moreover
  have "- (cor (sqrt (Re ((4*D)/(D-A)))))\<^sup>2 = cor (Re (4 / (A - D))) * D"
    using `is_real A` `is_real D` `A \<noteq> D` `Re ((4*D)/(D-A)) \<ge> 0`
    by (subst cor_squared, subst real_sqrt_power[symmetric], simp) (simp add: Re_divide_real complex_of_real_Re of_real_numeral minus_divide_right)

  ultimately
  show "circline_mat_eq (mk_circline_rep A 0 0 D) (chordal_circle_rep zero_homo_rep r)"
    using `is_real A` `is_real D` `A \<noteq> 0 \<or> D \<noteq> 0` `r = sqrt (Re ((4*D)/(D-A)))`
    by (simp add: chordal_circle_rep_def mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x="Re (4/(A-D))" in exI, auto)
qed

lemma chordal_circle':
  assumes "B \<noteq> 0" "(A, B, C, D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}" "Re (mat_det (A, B, C, D)) \<le> 0"
  "C * a\<^sup>2  + (D - A) * a - B = 0"  "r = sqrt((4 - Re((-4 * a/B) * A)) / (1 + Re (a*cnj a)))"
  shows "mk_circline A B C D = chordal_circle (of_complex a) r"
using assms
proof transfer
  fix A B C D a :: complex and r :: real

  let ?k = "-4*a / B"

  assume *: "(A, B, C, D) \<in> {H. hermitean H \<and> H \<noteq> mat_zero}" and **: "B \<noteq> 0" "C * a\<^sup>2 + (D - A) * a - B = 0" and rr: "r = sqrt ((4 - Re (?k * A)) / (1 + Re (a * cnj a)))" and det: "Re (mat_det (A, B, C, D)) \<le> 0"

  have "is_real A" "is_real D" "C = cnj B"
    using * hermitean_elems
    by auto

  from ** have a12: "let dsc = sqrt(Re ((D-A)\<^sup>2 + 4 * (B*cnj B))) 
                      in a = (A - D + cor dsc) / (2 * C) \<or> a = (A - D - cor dsc) / (2 * C)"
  proof-
    have "Re ((D-A)\<^sup>2 + 4 * (B*cnj B)) \<ge> 0"
      using `is_real A` `is_real D`
      by (subst complex_mult_cnj_cmod) (simp add: power2_eq_square)
    hence "csqrt ((D - A)\<^sup>2 - 4 * C * - B) = cor (sqrt (Re ((D - A)\<^sup>2 + 4 * (B * cnj B))))"
      using csqrt_real[of "((D - A)\<^sup>2 + 4 * (B * cnj B))"] `is_real A` `is_real D` `C = cnj B`
      by (auto simp add: power2_eq_square field_simps)
    thus ?thesis
      using complex_quadratic_equation_full[of C a "D - A" "-B"] `C * a\<^sup>2 + (D - A) * a - B = 0` `B \<noteq> 0` `C = cnj B`
      by (simp add: Let_def)
  qed

  have "is_real ?k"
    using a12 `C = cnj B` `is_real A` `is_real D`
    by (auto simp add: Let_def div_reals)
  have "a \<noteq> 0"
    using **
    by auto
  hence "Re ?k \<noteq> 0"
    using `is_real (-4*a / B)` `B \<noteq> 0`
    by (metis complex_surj complex_zero_def mult_eq_0_iff nonzero_divide_eq_eq zero_neq_neg_numeral) 
  moreover
  have "-4 * a = cor (Re ?k) * B"
    using complex_of_real_Re[OF `is_real (-4*a/B)`] `B \<noteq> 0`
    by simp
  moreover
  have "is_real (a/B)"
    using `is_real ?k`
    by (metis Im_mult_real complex_Im_neg_numeral complex_Re_neg_numeral mult_eq_0_iff times_divide_eq_right zero_neq_neg_numeral)
  hence "is_real (B * cnj a)"
    by (smt mult.commute complex_In_mult_cnj_zero complex_cnj_divide complex_cnj_zero_iff eq_cnj_iff_real eq_divide_eq times_divide_eq_right)
  hence "B * cnj a = cnj B * a"
    using eq_cnj_iff_real[of "B * cnj a"]
    by (simp add: complex_cnj)
  hence "-4 * cnj a = cor (Re ?k) * C"
    using `C = cnj B` 
    using complex_of_real_Re[OF `is_real ?k`] `B \<noteq> 0`
    by (simp, simp add: field_simps)
  moreover
  have "1 + a * cnj a \<noteq> 0"
    by (subst complex_mult_cnj_cmod) (smt cor_add of_real_0 of_real_1 of_real_eq_iff realpow_square_minus_le)
  have "r\<^sup>2 = (4 - Re (?k * A)) / (1 + Re (a * cnj a))"
  proof-
    have "Re (a / B * A) \<ge> -1"
      using a12 chordal_circle_radius_positive[of A B C D] * `B \<noteq> 0` det
      by (auto simp add: Let_def field_simps)
    from mult_right_mono_neg[OF this, of "-4"]
    have "4 - Re (?k * A) \<ge> 0"
      using Re_mult_real[of "-4" "a / B * A"]
      by (simp add: field_simps)
    moreover
    have "1 + Re (a * cnj a) > 0"
      by (subst complex_mult_cnj_cmod) (smt Re_complex_of_real `a \<noteq> 0` norm_eq_zero zero_less_power2)
    ultimately
    have "(4 - Re (?k * A)) / (1 + Re (a * cnj a)) \<ge> 0"
      by (metis divide_nonneg_pos) 
    thus ?thesis
      using rr
      by simp
  qed
  hence "r\<^sup>2 = Re ((4 - ?k * A) / (1 + a * cnj a))"
    using `is_real ?k` `is_real A` `1 + a * cnj a \<noteq> 0`
    by (subst Re_divide_real, auto)
  hence "(cor r)\<^sup>2 =  (4 - ?k * A) / (1 + a * cnj a)"
    using `is_real ?k` `is_real A`
    using mult_reals[of ?k A]
    by (simp add: cor_squared) (subst complex_of_real_Re, subst div_reals, auto)
  hence "4 - (cor r)\<^sup>2 * (a * cnj a + 1) = cor (Re ?k) * A"
    using complex_of_real_Re[OF `is_real (-4*a/B)`] 
    using `1 + a * cnj a \<noteq> 0`
    by (simp add: field_simps)
  moreover 

  have "?k = cnj ?k"
    using `is_real ?k`
    by (subst eq_cnj_iff_real) simp
  have "?k\<^sup>2 = cor ((cmod ?k)\<^sup>2)"
    using  cor_cmod_real[OF `is_real ?k`]
    unfolding power2_eq_square
    by (subst cor_mult) (metis minus_mult_minus) 
  hence "?k\<^sup>2 = ?k * cnj ?k"
    using complex_mult_cnj_cmod[of ?k]
    by simp
  hence ***: "a * cnj a = (cor ((Re ?k)\<^sup>2) * B * C) / 16"
    using complex_of_real_Re[OF `is_real (-4*a/B)`] `C = cnj B` `is_real (-4*a/B)` `B \<noteq> 0`
    by (simp add: complex_cnj)
  from ** have "cor ((Re ?k)\<^sup>2) * B * C - 4 * cor (Re ?k) * (D-A) - 16 = 0"
    using complex_of_real_Re[OF `is_real ?k`]
    by (simp add: power2_eq_square, simp add: field_simps, algebra)
  hence "?k * (D-A) = 4 * (cor ((Re ?k)\<^sup>2) * B * C / 16 - 1)" 
    by (subst (asm) complex_of_real_Re[OF `is_real ?k`]) algebra
  hence "?k * (D-A) = 4 * (a*cnj a - 1)"
    by (subst (asm)  ***[symmetric]) simp
  
  hence "4 * a * cnj a - (cor r)\<^sup>2 * (a * cnj a + 1) = cor (Re ?k) * D"
    using `4 - (cor r)\<^sup>2 * (a * cnj a + 1) = cor (Re ?k) * A`
    using complex_of_real_Re[OF `is_real (-4*a/B)`] 
    by simp algebra
  ultimately
  show "circline_mat_eq (mk_circline_rep A B C D) (chordal_circle_rep (of_complex_coords a) r)"
    using * `a \<noteq> 0`
    by (simp add: mk_circline_rep_def Abs_circline_mat_inverse) (rule_tac x="Re (-4*a / B)" in exI, simp)
qed
  
lift_definition  o_circline_point_0h :: "ocircline" is circline_point_0h_rep
done

lemma of_ocircline_o_circline_point_0h [simp]: "of_ocircline o_circline_point_0h = circline_point_0h"
  by (metis circline_point_0h_def o_circline_point_0h_def of_ocircline.abs_eq)

lemma ocircline_set_0h:
  assumes "ocircline_set H = {0\<^sub>h}"
  shows "H = o_circline_point_0h \<or> H = opposite_ocircline (o_circline_point_0h)"
proof-
  have "of_ocircline H = circline_point_0h"
    using assms
    using circline_set_ocircline_set[of H, symmetric]
    using unique_circline_type_zero_0h' card_eq1_circline_type_zero[of "of_ocircline H"]
    by blast
  thus ?thesis
    by (metis inj_of_ocircline of_ocircline_o_circline_point_0h)
qed

subsection{* Disc automorphisms *}
lemma circline_set_fix_iff_circline_fix:
  assumes "circline_set H' \<noteq> {}"
  shows "(moebius_pt M) ` (circline_set H) = circline_set H' \<longleftrightarrow> moebius_circline M H = H'"
using assms
by (subst moebius_circline_set, auto) (rule inj_circline_set[of _ H'], auto)

lemma ocircline_set_fix_iff_ocircline_fix:
  assumes "ocircline_set H' \<noteq> {}"
  shows "(moebius_pt M) ` (ocircline_set H) = ocircline_set H' \<longleftrightarrow> 
         moebius_ocircline M H = H' \<or> moebius_ocircline M H = opposite_ocircline H'"
using assms inj_ocircline_set[of _ H']
by (subst moebius_ocircline_set, auto)


definition Unitary11_gen_rep where
 "Unitary11_gen_rep M \<longleftrightarrow> unitary11_gen (Rep_moebius_mat M)"
  
lift_definition Unitary11_gen :: "moebius \<Rightarrow> bool" is Unitary11_gen_rep
apply (auto simp add: Unitary11_gen_rep_def)
apply (simp add: unitary11_gen_mult_sm)
apply (simp add: unitary11_gen_div_sm)
done

lemma unit_circle_fix_iff_Unitary11_gen:
  shows "moebius_circline M unit_circle = unit_circle \<longleftrightarrow> Unitary11_gen M" (is "?lhs = ?rhs")
proof
  assume ?lhs
  thus ?rhs
  proof (transfer)
    fix M
    assume "circline_mat_eq (moebius_circline_rep M unit_circle_rep) unit_circle_rep"
    then obtain k where "k \<noteq> 0" "(1, 0, 0, -1) = cor k *\<^sub>s\<^sub>m congruence (mat_inv (Rep_moebius_mat M)) (1, 0, 0, -1)"
      by auto
    hence "(1/cor k, 0, 0, -1/cor k) = congruence (mat_inv (Rep_moebius_mat M)) (1, 0, 0, -1)"
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv (Rep_moebius_mat M)) (1, 0, 0, -1)" ]
      by simp
    hence "congruence (Rep_moebius_mat M) (1/cor k, 0, 0, -1/cor k) = (1, 0, 0, -1)"
      using Rep_moebius_mat[of M] mat_det_inv[of "Rep_moebius_mat M"]
      using congruence_inv[of "mat_inv (Rep_moebius_mat M)" "(1, 0, 0, -1)" "(1/cor k, 0, 0, -1/cor k)"]
      by simp
    hence "congruence (Rep_moebius_mat M) (1, 0, 0, -1) = cor k *\<^sub>s\<^sub>m (1, 0, 0, -1)"
      using congruence_scale_m[of "Rep_moebius_mat M" "1/cor k" "(1, 0, 0, -1)"]
      using mult_sm_inv_l[of "1/ cor k" "congruence (Rep_moebius_mat M) (1, 0, 0, -1)"  "(1, 0, 0, -1)"] `k \<noteq> 0`
      by simp
    thus "Unitary11_gen_rep M"
      using `k \<noteq> 0`
      unfolding Unitary11_gen_rep_def unitary11_gen_def
      by simp
  qed
next
  assume ?rhs
  thus ?lhs
  proof (transfer)
    fix M
    assume "Unitary11_gen_rep M"
    hence "unitary11_gen (mat_inv (Rep_moebius_mat M))"
      using Rep_moebius_mat[of M]
      using unitary11_gen_mat_inv
      by (simp add: Unitary11_gen_rep_def)
    thus "circline_mat_eq (moebius_circline_rep M unit_circle_rep) unit_circle_rep"
      unfolding unitary11_gen_real
      by auto (rule_tac x="1/k" in exI, simp)
  qed
qed

lemma unit_circle_set_fix_iff_Unitary11_gen:
  shows "(moebius_pt M ` (circline_set unit_circle) = (circline_set unit_circle)) \<longleftrightarrow> Unitary11_gen M" (is "?lhs \<longleftrightarrow> ?rhs")
using unit_circle_fix_iff_Unitary11_gen[of M] circline_set_fix_iff_circline_fix[of unit_circle M unit_circle]
using one_on_unit_circle
by auto

definition Unitary11_gen_direct_rep where 
  "Unitary11_gen_direct_rep M \<longleftrightarrow> 
     (let (A, B, C, D) = Rep_moebius_mat M
       in unitary11_gen (A, B, C, D) \<and> (B = 0 \<or> Re ((A*D)/(B*C)) > 1))"

lift_definition Unitary11_gen_direct :: "moebius \<Rightarrow> bool" is Unitary11_gen_direct_rep
proof-
  fix M M'
  let ?M = "Rep_moebius_mat M" and ?M' = "Rep_moebius_mat M'"
  assume "moebius_mat_eq M M'"
  then obtain k where *: "k \<noteq> 0" "Rep_moebius_mat M' = k *\<^sub>s\<^sub>m Rep_moebius_mat M"
    by auto
  hence **: "unitary11_gen (Rep_moebius_mat M) \<longleftrightarrow> unitary11_gen (Rep_moebius_mat M')"
    using unitary11_gen_mult_sm[of k ?M] unitary11_gen_div_sm[of k ?M]
    by auto
  obtain A B C D where MM: "(A, B, C, D) = Rep_moebius_mat M"
    by (cases "Rep_moebius_mat M") auto
  obtain A' B' C' D' where MM': "(A', B', C', D') = Rep_moebius_mat M'"
    by (cases "Rep_moebius_mat M'") auto

  show "Unitary11_gen_direct_rep M = Unitary11_gen_direct_rep M'"
    using * ** MM MM'
    unfolding Unitary11_gen_direct_rep_def Let_def
    by auto
qed

lemma ounit_circle_fix_iff_Unitary11_gen_direct:
  shows "moebius_ocircline M ounit_circle = ounit_circle \<longleftrightarrow> Unitary11_gen_direct M" (is "?lhs \<longleftrightarrow> ?rhs")
proof
  assume *: ?lhs
  have "moebius_circline M unit_circle = unit_circle"
    apply (subst moebius_circline_ocircline[of M unit_circle])
    apply (subst of_circline_unit_circline)
    apply (subst *)
    by simp

  hence "Unitary11_gen M"
    by (simp add: unit_circle_fix_iff_Unitary11_gen)
  thus ?rhs
    using *
  proof (transfer)
    fix M
    let ?M = "Rep_moebius_mat M"
    let ?H = "(1, 0, 0, -1)"
    obtain A B C D where MM: "(A, B, C, D) = ?M"
      by (cases ?M) auto
    assume  "Unitary11_gen_rep M" "ocircline_mat_eq (moebius_circline_rep M unit_circle_rep) unit_circle_rep"
    then obtain k where "0 < k" "?H = cor k *\<^sub>s\<^sub>m congruence (mat_inv ?M) ?H"
      by auto
    hence "congruence ?M ?H = cor k *\<^sub>s\<^sub>m ?H"
      using congruence_inv[of "mat_inv ?M" "?H" "(1/cor k) *\<^sub>s\<^sub>m ?H"] Rep_moebius_mat[of M]
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv ?M) ?H" "?H"]
      using mult_sm_inv_l[of "1/cor k" "congruence ?M ?H"]
      using congruence_scale_m[of ?M "1/cor k" "?H"]
      by (auto simp add: mat_det_inv)
    then obtain a b k' where "k' \<noteq> 0" "?M = k' *\<^sub>s\<^sub>m (a, b, cnj b, cnj a)" "sgn (Re (mat_det (a, b, cnj b, cnj a))) = 1"
      using unitary11_sgn_det_orientation'[of ?M k] `k > 0`
      by auto
    moreover
    have "mat_det (a, b, cnj b, cnj a) \<noteq> 0"
      using `sgn (Re (mat_det (a, b, cnj b, cnj a))) = 1`
      by (metis complex_Re_zero sgn_zero zero_neq_one)
    ultimately
    show "Unitary11_gen_direct_rep M"
      using unitary11_sgn_det[of k' a b ?M A B C D]
      using MM[symmetric] `k > 0` `Unitary11_gen_rep M`
      by (simp add: Unitary11_gen_rep_def Unitary11_gen_direct_rep_def  sgn_1_pos split: split_if_asm)
  qed
next
  assume ?rhs
  thus ?lhs
  proof (transfer)
    fix M
    let ?M = "Rep_moebius_mat M"
    obtain A B C D where MM: "(A, B, C, D) = ?M"
      by (cases ?M) auto
    assume "Unitary11_gen_direct_rep M"
    hence "unitary11_gen ?M" "B = 0 \<or> 1 < Re (A * D / (B * C))"
      using MM[symmetric]
      by (auto simp add: Unitary11_gen_direct_rep_def)
    have "sgn (if B = 0 then 1 else sgn (Re (A * D / (B * C)) - 1)) = 1"
      using `B = 0 \<or> 1 < Re (A * D / (B * C))`
      by auto
    then obtain k' where "k' > 0" "congruence (Rep_moebius_mat M) (1, 0, 0, -1) = cor k' *\<^sub>s\<^sub>m (1, 0, 0, -1)"
      using unitary11_orientation[OF `unitary11_gen ?M` MM[symmetric]]
      by (auto simp add: sgn_1_pos)
    thus "ocircline_mat_eq (moebius_circline_rep M unit_circle_rep) unit_circle_rep"
      using congruence_inv[of ?M "(1, 0, 0, -1)" "cor k' *\<^sub>s\<^sub>m (1, 0, 0, -1)"] Rep_moebius_mat[of M]
      using congruence_scale_m[of "mat_inv ?M" "cor k'" "(1, 0, 0, -1)"]
      by auto
  qed
qed

text{* Blaschke factor *}
definition blaschke_rep where 
  "blaschke_rep a = Abs_moebius_mat (1, -a, -cnj a, 1)"

lemma blaschke_rep_Rep1:
  assumes "cmod a \<noteq> 1"
  shows "Rep_moebius_mat (blaschke_rep a) = (1, -a, -cnj a, 1)"
  using assms
  by (simp add: blaschke_rep_def Abs_moebius_mat_inverse)

lemma blaschke_rep_Rep2:
  assumes "a * cnj a \<noteq> 1"
  shows "Rep_moebius_mat (blaschke_rep a) = (1, -a, -cnj a, 1)"
  using assms
  by (simp add: blaschke_rep_def Abs_moebius_mat_inverse)

lift_definition blaschke :: "complex \<Rightarrow> moebius" is blaschke_rep
by (simp del: moebius_mat_eq_def)

lemma blaschke_a_to_zero:
  assumes "cmod a \<noteq> 1"
  shows "moebius_pt (blaschke a) (of_complex a) = 0\<^sub>h"
proof-
  from assms have "a * cnj a \<noteq> 1"
    by simp
  thus ?thesis
    by (transfer) (simp add: blaschke_rep_Rep2, rule_tac x="1/(1 - a*cnj a)" in exI, simp add: field_simps)
qed

lemma blaschke_inv_a_inf:
  assumes "cmod a \<noteq> 1"
  shows "moebius_pt (blaschke a) (inversion_homo (of_complex a)) = \<infinity>\<^sub>h"
proof-
  from assms have "a * cnj a \<noteq> 1"
    by simp
  thus ?thesis
    unfolding inversion_homo_def
    by (transfer) (simp add: blaschke_rep_Rep2 vec_cnj_def, rule_tac x="1/(1 - a*cnj a)" in exI, simp add: field_simps)   
qed

lemma blaschke_Unitary11_gen_rep:
  assumes "a * cnj a \<noteq> 1" 
  shows "Unitary11_gen_rep (blaschke_rep a)"
proof-
  have "is_real (1 - a*cnj a)"
    by auto
  moreover
  hence "cor (Re (1 - a*cnj a)) = 1 - a*cnj a"
    by (rule complex_of_real_Re)
  moreover 
  have "Re (a*cnj a) \<noteq> 1"
    using `is_real (1 - a*cnj a)` assms
    by (metis complex_In_mult_cnj_zero complex_of_real_Re of_real_1)
  ultimately
  show ?thesis
    using assms
    using blaschke_rep_Rep2
    by (auto simp add: blaschke_rep_def Unitary11_gen_rep_def unitary11_gen_real mat_adj_def mat_cnj_def complex_cnj field_simps simp del: complex_Re_mult) (rule_tac x="Re (1 - a*cnj a)" in exI, simp del: complex_Re_mult)
qed

lemma blaschke_unitary11_gen_direct_rep:
  assumes "Re (a * cnj a) < 1" 
  shows "Unitary11_gen_direct_rep (blaschke_rep a)"
proof-
  have "a * cnj a \<noteq> 1"
    using assms
    by (cases a, simp)
  show ?thesis
  proof (cases "a = 0")
    case True
    thus ?thesis
      using blaschke_Unitary11_gen_rep[of a]
      by (simp add: Unitary11_gen_direct_rep_def Unitary11_gen_rep_def blaschke_rep_def)
  next
    case False
    hence "Re (a * cnj a) > 0"
      by (subst complex_mult_cnj_cmod) (metis Re_complex_of_real zero_less_norm_iff zero_less_power)
    thus ?thesis
      using assms `a * cnj a \<noteq> 1` `a \<noteq> 0`
      using blaschke_Unitary11_gen_rep[of a] blaschke_rep_Rep2[of a] Re_divide_real[of "a*cnj a" 1]
      by (auto simp add: Unitary11_gen_direct_rep_def blaschke_rep_def Unitary11_gen_rep_def simp del: complex_Re_mult)
  qed
qed

lemma blaschke_Unitary11_gen:
  assumes "a * cnj a \<noteq> 1"
  shows "Unitary11_gen (blaschke a)"
using assms
by (transfer) (rule blaschke_Unitary11_gen_rep)

lemma blaschke_Unitary11_gen_direct:
  assumes "Re (a * cnj a) < 1"
  shows "Unitary11_gen_direct (blaschke a)"
using assms
by transfer (simp add: blaschke_unitary11_gen_direct_rep)

lemma blaschke_unit_circle_fix:
  assumes "cmod a \<noteq> 1"
  shows "moebius_circline (blaschke a) unit_circle = unit_circle"
  using assms
  using blaschke_Unitary11_gen  unit_circle_fix_iff_Unitary11_gen
  by simp

lemma blaschke_ounit_circle_fix:
  assumes "cmod a < 1"
  shows "moebius_ocircline (blaschke a) ounit_circle = ounit_circle"
proof-
  have "Re (a * cnj a) < 1"
    using assms
    by (metis complex_mod_sqrt_Re_mult_cnj real_sqrt_lt_1_iff)
  thus ?thesis
    using assms
    using blaschke_Unitary11_gen_direct  ounit_circle_fix_iff_Unitary11_gen_direct
    by simp
qed

(* ------------------- *)
lemma [simp]: "hermitean (1, 0, 0, -1)"
by (auto simp add:  hermitean_def mat_adj_def mat_cnj_def)

definition is_disc_aut where "is_disc_aut f \<longleftrightarrow> bij_betw f unit_disc unit_disc"

lemma is_disc_aut_iff_unit_disc_fix:
  shows "is_disc_aut (moebius_pt M) \<longleftrightarrow> (moebius_pt M) ` unit_disc = unit_disc"
using bij_moebius_pt[of M]
unfolding is_disc_aut_def is_moebius_def
unfolding bij_betw_def
by auto (metis injD inj_onI)

lemma comp_inv_l:
  assumes "f \<circ> inv g = h" "bij g"
  shows "f = h \<circ> g"
using assms
by (metis bij_def o_inv_o_cancel)

lemma in_unit_disc_cmod_lt_1:
  assumes "of_complex a \<in> unit_disc"
  shows "cmod a < 1"
using assms
unfolding unit_disc_def disc_def
apply auto
proof (transfer)
  fix a
  assume "in_ocircline_rep unit_circle_rep (of_complex_coords a)"
  hence "Re a * Re a + Im a * Im a  < 1"
    by (simp add: in_ocircline_rep_def Let_def vec_cnj_def)
  hence "(cmod a)\<^sup>2 < 1"
    unfolding cmod_def
    by (simp, simp add: power2_eq_square)
  thus "cmod a < 1"
    by (metis less_1_mult not_less_iff_gr_or_eq one_power2 power2_eq_square)
qed

(*------------------------------*)

subsection{* Angle between circlines *}
fun mat_det_12 :: "complex_mat \<Rightarrow> complex_mat \<Rightarrow> complex" where 
 "mat_det_12 (A1, B1, C1, D1) (A2, B2, C2, D2) = A1*D2 + A2*D1 - B1*C2 - B2*C1"

lemma mat_det_12_mm_l [simp]: "mat_det_12 (M *\<^sub>m\<^sub>m A) (M *\<^sub>m\<^sub>m B) = mat_det M * mat_det_12 A B"
by (cases M, cases A, cases B) (simp add: field_simps)

lemma mat_det_12_mm_r [simp]: "mat_det_12 (A *\<^sub>m\<^sub>m M) (B *\<^sub>m\<^sub>m M) = mat_det M * mat_det_12 A B"
by (cases M, cases A, cases B) (simp add: field_simps)

lemma mat_det_12_sm_l [simp]: "mat_det_12 (k *\<^sub>s\<^sub>m A) B = k * mat_det_12 A B"
by (cases A, cases B) (simp add: field_simps)

lemma mat_det_12_sm_r [simp]: "mat_det_12 A (k *\<^sub>s\<^sub>m B) = k * mat_det_12 A B"
by (cases A, cases B) (simp add: field_simps)

lemma mat_det_12_congruence [simp]: 
  "mat_det_12 (congruence M A) (congruence M B) = (cor ((cmod (mat_det M))\<^sup>2)) * mat_det_12 A B"
by ((subst mult_mm_assoc[symmetric])+, subst mat_det_12_mm_l, subst mat_det_12_mm_r, subst mat_det_adj) (auto simp add: field_simps complex_mult_cnj_cmod)

lemma mat_det_congruence [simp]: 
  "mat_det (congruence M A) = (cor ((cmod (mat_det M))\<^sup>2)) * mat_det A"
by (simp add: mat_det_adj complex_mult_cnj_cmod field_simps)

definition cos_angle_rep where
  "cos_angle_rep H1 H2 = 
      (let H1 = Rep_circline_mat H1; 
           H2 = Rep_circline_mat H2 in
        - Re (mat_det_12 H1 H2) / (2 * (sqrt (Re (mat_det H1 * mat_det H2)))))"

lemma [simp]: "is_real (mat_det (Rep_circline_mat H))"
  using Rep_circline_mat[of H]
  by (simp add: mat_det_hermitean_real)

lift_definition cos_angle :: "ocircline \<Rightarrow> ocircline \<Rightarrow> real" is cos_angle_rep
by (auto simp add: cos_angle_rep_def Let_def real_sqrt_mult)

lemma ang_vec_opposite_opposite': 
  assumes "a1 \<noteq> E" "a2 \<noteq> E"
  shows "∡ (E - a1) (E - a2) = ∡ (a1 - E) (a2 - E)"
using ang_vec_opposite_opposite[of "E - a1" "E - a2"] assms
by (simp add: field_simps del: ang_vec_def)

lemma cos_ang_circ_simp:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows"cos (ang_circ E \<mu>1 \<mu>2 p1 p2) = sgn_bool (p1 = p2) * cos (arg (E - \<mu>2) - arg (E - \<mu>1))"
using assms
using cos_periodic_pi2[of "arg (E - \<mu>2) - arg (E - \<mu>1)"]
using cos_periodic_pi3[of "arg (E - \<mu>2) - arg (E - \<mu>1)"]
using ang_circ_simp[OF assms, of p1 p2]
by auto (auto simp add: field_simps)

lemma Re_sgn:
  assumes "is_real A" "A \<noteq> 0"
  shows "Re (sgn A) = sgn_bool (Re A > 0)"
using assms
by (cases A) simp

lemma Re_mult_real3:
  assumes "is_real z1" "is_real z2" "is_real z3"
  shows "Re (z1 * z2 * z3) = Re z1 * Re z2 * Re z3"
using assms
by (metis Re_mult_real mult_reals) 

lemma [simp]: "sgn (sqrt x) = sgn x"
by (smt real_sqrt_eq_zero_cancel_iff real_sqrt_lt_0_iff sgn_real_def)

lemma sgn_divide:
  fixes x y :: real
  shows "sgn (x / y) = sgn x / sgn y"
by (metis divide_inverse inverse_sgn real_scaleR_def sgn_scaleR)

lemma real_circle_sgn_r:
  assumes "is_circle H" "(a, r) = euclidean_circle H" 
  shows "sgn r = - circline_type H"
using assms
proof transfer
  fix H a r
  obtain A B C D where HH: "Rep_circline_mat H = (A, B, C, D)"
    by (cases "Rep_circline_mat H") auto
  hence "is_real A" "is_real D"
    using hermitean_elems Rep_circline_mat[of H]
    by auto
  assume "\<not> circline_A0_rep H" "(a, r) = euclidean_circle_rep H"
  hence "A \<noteq> 0"
    using `\<not> circline_A0_rep H` HH
    by (simp add: circline_A0_rep_def)
  hence "Re A * Re A > 0"
    using `is_real A` 
    by (metis complex_Im_zero complex_Re_zero complex_equality not_real_square_gt_zero) 
  thus "sgn r = - circline_type_rep H"
    using HH `(a, r) = euclidean_circle_rep H` `is_real A` `is_real D` `A \<noteq> 0`
    by (simp add: euclidean_circle_rep_def circline_type_rep_def Re_divide_real sgn_minus[symmetric] sgn_divide)
qed

lemma
  assumes
  "is_circle (of_ocircline H1)" "is_circle (of_ocircline H2)"
  "circline_type (of_ocircline H1) < 0" "circline_type (of_ocircline H2) < 0"
  "(a1, r1) = euclidean_circle (of_ocircline H1)" "(a2, r2) = euclidean_circle (of_ocircline H2)"
          "of_complex E \<in> ocircline_set H1 \<inter> ocircline_set H2"
  shows "cos_angle H1 H2 = cos (ang_circ E a1 a2 (pos_oriented H1) (pos_oriented H2))"
proof-
  let ?p1 = "pos_oriented H1" and ?p2 = "pos_oriented H2"
  have "E \<in> circle a1 r1" "E \<in> circle a2 r2"
    using classic_circle[of "of_ocircline H1" a1 r1]  classic_circle[of "of_ocircline H2" a2 r2] 
    using assms of_complex_inj
    by auto
  hence *: "cdist E a1 = r1" "cdist E a2 = r2"
    unfolding circle_def
    by (simp_all add: norm_minus_commute)
  have "r1 > 0" "r2 > 0"
    using assms(1-6) real_circle_sgn_r[of "of_ocircline H1" a1 r1]  real_circle_sgn_r[of "of_ocircline H2" a2 r2]
    by auto (metis neg_0_less_iff_less sgn_1_pos sgn_sgn)+
  hence "E \<noteq> a1" "E \<noteq> a2"
    using `cdist E a1 = r1` `cdist E a2 = r2`
    by auto
  
  let ?k = "sgn_bool (?p1 = ?p2)"
  let ?xx = "?k * (r1\<^sup>2 + r2\<^sup>2 - (cdist a2 a1)\<^sup>2) / (2 * r1 * r2)"

  have "cos (ang_circ E a1 a2 ?p1 ?p2) = ?xx"
    using law_of_cosines[of a2 a1 E] * `r1 > 0` `r2 > 0` cos_ang_circ_simp[OF `E \<noteq> a1` `E \<noteq> a2`]
    by (subst (asm) ang_vec_opposite_opposite'[OF `E \<noteq> a1`[symmetric] `E \<noteq> a2`[symmetric], symmetric]) simp
  moreover
  have "cos_angle H1 H2 = ?xx"
    using `r1 > 0` `r2 > 0`
    using `(a1, r1) = euclidean_circle (of_ocircline H1)` `(a2, r2) = euclidean_circle (of_ocircline H2)`
    using `is_circle (of_ocircline H1)` `is_circle (of_ocircline H2)`
    using `circline_type (of_ocircline H1) < 0` `circline_type (of_ocircline H2) < 0`
  proof transfer
    fix a1 r1 H1 H2 a2 r2
    obtain A1 B1 C1 D1 where HH1: "Rep_circline_mat H1 = (A1, B1, C1, D1)"
      by (cases "Rep_circline_mat H1") auto
    obtain A2 B2 C2 D2 where HH2: "Rep_circline_mat H2 = (A2, B2, C2, D2)"
      by (cases "Rep_circline_mat H2") auto
    have *: "is_real A1" "is_real A2" "is_real D1" "is_real D2" "cnj B1 = C1" "cnj B2 = C2"
      using Rep_circline_mat[of H1] Rep_circline_mat[of H2] hermitean_elems[of A1 B1 C1 D1] hermitean_elems[of A2 B2 C2 D2] HH1 HH2
      by auto
    have "cnj A1 = A1" "cnj A2 = A2"
      using `is_real A1` `is_real A2`
      by (case_tac[!] A1, case_tac[!] A2, auto)

    assume "\<not> circline_A0_rep (id H1)" "\<not> circline_A0_rep (id H2)"
    hence "A1 \<noteq> 0" "A2 \<noteq> 0"
      using HH1 HH2
      by (auto simp add: circline_A0_rep_def)
    hence "Re A1 \<noteq> 0" "Re A2 \<noteq> 0"
      using `is_real A1` `is_real A2`
      by (metis complex_Im_zero complex_Re_zero complex_equality)+

    assume "circline_type_rep (id H1) < 0" "circline_type_rep (id H2) < 0"
    assume "(a1, r1) = euclidean_circle_rep (id H1)" "(a2, r2) = euclidean_circle_rep (id H2)"
    assume "r1 > 0" "r2 > 0"

    let ?D12 = "mat_det_12 (Rep_circline_mat H1) (Rep_circline_mat H2)" and ?D1 = "mat_det (Rep_circline_mat H1)" and ?D2 = "mat_det (Rep_circline_mat H2)"
    let ?x1 = "(cdist a2 a1)\<^sup>2 - r1\<^sup>2 - r2\<^sup>2" and ?x2 = "2*r1*r2"
    let ?x = "?x1 / ?x2"
    have *:  "Re (?D12) / (2 * (sqrt (Re (?D1 * ?D2)))) = Re (sgn A1) * Re (sgn A2) * ?x"
    proof-
      let ?M1 = "(A1, B1, C1, D1)" and ?M2 = "(A2, B2, C2, D2)"
      let ?d1 = "B1 * C1 - A1 * D1" and ?d2 = "B2 * C2 - A2 * D2"
      have "Re ?d1 > 0" "Re ?d2 > 0"
        using HH1 HH2 `circline_type_rep (id H1) < 0`  `circline_type_rep (id H2) < 0`
        by (auto simp add: circline_type_rep_def)
      hence **: "Re (?d1 / (A1 * A1)) > 0" "Re (?d2 / (A2 * A2)) > 0"
        using `is_real A1` `is_real A2` `A1 \<noteq> 0` `A2 \<noteq> 0`
        by - (simp add: Re_divide_real, metis Re_divide_real complex_Re_mult divide_pos_pos eq_divide_imp mult_eq_0_iff not_real_square_gt_zero)+
      have ***: "is_real (?d1 / (A1 * A1)) \<and> is_real (?d2 / (A2 * A2))"
        using `is_real A1`  `is_real A2` `A1 \<noteq> 0` `A2 \<noteq> 0` `cnj B1 = C1`[symmetric] `cnj B2 = C2`[symmetric] `is_real D1` `is_real D2`
        by (subst div_reals, simp, simp, simp)+

      have "cor ?x = mat_det_12 ?M1 ?M2 / (2 * sgn A1 * sgn A2 * cor (sqrt (Re ?d1) * sqrt (Re ?d2)))"
      proof-
        have "A1*A2*cor ?x1 = mat_det_12 ?M1 ?M2"
        proof-
          have 1: "A1*A2*(cor ((cdist a2 a1)\<^sup>2)) = ((B2*A1 - A2*B1)*(C2*A1 - C1*A2)) / (A1*A2)"
            using `(a1, r1) = euclidean_circle_rep (id H1)` `(a2, r2) = euclidean_circle_rep (id H2)`
            unfolding cdist_def cmod_square
            using HH1 HH2 * `A1 \<noteq> 0` `A2 \<noteq> 0` `cnj A1 = A1` `cnj A2 = A2`
            apply (subst complex_of_real_Re)
            apply (simp add: complex_mult_cnj_cmod power2_eq_square)
            apply (simp add: euclidean_circle_rep_def complex_cnj power2_eq_square field_simps)
            done
          have 2: "A1*A2*cor (-r1\<^sup>2) = A2*D1 - B1*C1*A2/A1"
            using `(a1, r1) = euclidean_circle_rep (id H1)`
            using HH1 ** * *** `A1 \<noteq> 0`
            apply (simp add: euclidean_circle_rep_def power2_eq_square)
            apply (subst complex_of_real_Re, simp)
            apply (simp add: field_simps)
            done
          have 3: "A1*A2*cor (-r2\<^sup>2) = A1*D2 - B2*C2*A1/A2"
            using `(a2, r2) = euclidean_circle_rep (id H2)`
            using HH2 ** * *** `A2 \<noteq> 0`
            apply (simp add: euclidean_circle_rep_def power2_eq_square)
            apply (subst complex_of_real_Re, simp)
            apply (simp add: field_simps)
            done
          have "A1*A2*cor((cdist a2 a1)\<^sup>2) + A1*A2*cor(-r1\<^sup>2) + A1*A2*cor(-r2\<^sup>2) = mat_det_12 ?M1 ?M2"
            using `A1 \<noteq> 0` `A2 \<noteq> 0`
            by (subst 1, subst 2, subst 3) (simp add: field_simps)
          thus ?thesis
            by (simp add: field_simps)
        qed

        moreover
        
        have "A1 * A2 * cor (?x2) = 2 * sgn A1 * sgn A2 * cor (sqrt (Re ?d1) * sqrt (Re ?d2))"
        proof-
          have 1: "sqrt (Re (?d1/ (A1 * A1))) = sqrt (Re ?d1) / \<bar>Re A1\<bar>"
            using `A1 \<noteq> 0` `is_real A1`
            by (subst Re_divide_real, simp, simp, subst real_sqrt_divide, simp)
          
          have 2: "sqrt (Re (?d2/ (A2 * A2))) = sqrt (Re ?d2) / \<bar>Re A2\<bar>"
            using `A2 \<noteq> 0` `is_real A2`
            by (subst Re_divide_real, simp, simp, subst real_sqrt_divide, simp)
          have "sgn A1 = A1 / cor \<bar>Re A1\<bar>"
            using `is_real A1`
            unfolding sgn_eq
            by (cases A1, simp)
          moreover
          have "sgn A2 = A2 / cor \<bar>Re A2\<bar>"
            using `is_real A2`
            unfolding sgn_eq
            by (cases A2, simp)
          ultimately
          show ?thesis
            using `(a1, r1) = euclidean_circle_rep (id H1)` `(a2, r2) = euclidean_circle_rep (id H2)`  HH1 HH2
            using *** `is_real A1` `is_real A2`
            by (simp add: euclidean_circle_rep_def) (subst 1, subst 2, simp add: of_real_numeral)
        qed

        ultimately

        have "(A1 * A2 * cor ?x1) / (A1 * A2 * (cor ?x2)) = 
               mat_det_12 ?M1 ?M2 / (2 * sgn A1 * sgn A2 * cor (sqrt (Re ?d1) * sqrt (Re ?d2)))"
          by simp
        thus ?thesis
          using `A1 \<noteq> 0` `A2 \<noteq> 0`
          by simp
      qed
      hence "cor ?x * sgn A1 * sgn A2 = mat_det_12 ?M1 ?M2 / (2 * cor (sqrt (Re ?d1) * sqrt (Re ?d2)))"
        using `A1 \<noteq> 0` `A2 \<noteq> 0`
        by (simp add: sgn_zero_iff)
      moreover
      have "Re (cor ?x * sgn A1 * sgn A2) = Re (sgn A1) * Re (sgn A2) * ?x"
      proof-
        have "is_real (cor ?x)" "is_real (sgn A1)" "is_real (sgn A2)"
          using `is_real A1` `is_real A2` Im_complex_of_real[of ?x]
          by auto
        thus ?thesis
          using Re_complex_of_real[of ?x]
          by (subst Re_mult_real3, auto simp add: field_simps)
      qed
      moreover
      have *: "sqrt (Re ?D1) * sqrt (Re ?D2) = sqrt (Re ?d1) * sqrt (Re ?d2)"
        using HH1 HH2
        by (subst real_sqrt_mult[symmetric])+ (simp add: field_simps)
      have "2 * (sqrt (Re (?D1 * ?D2))) \<noteq> 0"
        using `Re ?d1 > 0`  `Re ?d2 > 0` HH1 HH2 `is_real A1` `is_real A2`  `is_real D1` `is_real D2`
        using Rep_circline_mat[of H1] mat_det_hermitean_real[of "Rep_circline_mat H1"]
        by (subst Re_mult_real, auto)
      hence **: "Re (?D12 / (2 * cor (sqrt (Re (?D1 * ?D2))))) = Re (?D12) / (2 * (sqrt (Re (?D1 * ?D2))))"
        using `Re ?d1 > 0`  `Re ?d2 > 0` HH1 HH2 `is_real A1` `is_real A2`  `is_real D1` `is_real D2`
        by (subst Re_divide_real) (auto simp add: Im_complex_of_real)
      have "Re (mat_det_12 ?M1 ?M2 / (2 * cor (sqrt (Re ?d1) * sqrt (Re ?d2)))) = Re (?D12) / (2 * (sqrt (Re (?D1 * ?D2))))"
        using HH1 HH2 Rep_circline_mat[of H1] mat_det_hermitean_real[of "Rep_circline_mat H1"]
        by (subst **[symmetric], subst Re_mult_real, simp, subst real_sqrt_mult, subst *, simp)
      ultimately
      show ?thesis
        by simp
    qed
    have **: "pos_oriented_rep H1 \<longleftrightarrow> Re A1 > 0"  "pos_oriented_rep H2 \<longleftrightarrow> Re A2 > 0"
      using `Re A1 \<noteq> 0` HH1  `Re A2 \<noteq> 0` HH2
      by (auto simp add: pos_oriented_rep_def)
    show "cos_angle_rep H1 H2 = sgn_bool (pos_oriented_rep H1 = pos_oriented_rep H2) * (r1\<^sup>2 + r2\<^sup>2 - (cdist a2 a1)\<^sup>2) /  (2 * r1 * r2)"
      unfolding cos_angle_rep_def Let_def
      using `r1 > 0` `r2 > 0`
      by (subst divide_minus_left, subst *, subst Re_sgn[OF `is_real A1` `A1 \<noteq> 0`], subst Re_sgn[OF `is_real A2` `A2 \<noteq> 0`], subst **, subst **, simp add: field_simps)
  qed
  ultimately
  show ?thesis
    by simp
qed

lemma [simp]: "sqrt a * sqrt a = \<bar>a\<bar>"
by (subst real_sqrt_mult[symmetric]) simp

lemma "cos_angle H1 H2 = cos_angle (moebius_ocircline M H1) (moebius_ocircline M H2)"
proof transfer
  fix H1 H2 M
  show "cos_angle_rep H1 H2 = cos_angle_rep (moebius_circline_rep M H1) (moebius_circline_rep M H2)"
    unfolding cos_angle_rep_def Let_def moebius_circline_rep_Rep mat_det_12_congruence mat_det_congruence
    using Rep_moebius_mat[of M] mat_det_inv[of "Rep_moebius_mat M"] 
    by (auto simp add: power2_eq_square real_sqrt_mult field_simps)
qed

(* ------------------------ *)

lemma
  assumes "mat_det (A, B, C, D) \<noteq> 0"
  shows "moebius_circline (mk_moebius A B C D) imag_unit_circle = imag_unit_circle \<longleftrightarrow> 
         unitary_gen (A, B, C, D)" (is "?lhs = ?rhs")
proof
  assume ?lhs
  thus ?rhs
    using assms
  proof transfer
    fix A B C D :: complex
    let ?M = "(A, B, C, D)" and ?E = "(1, 0, 0, 1)"
    assume "circline_mat_eq (moebius_circline_rep (mk_moebius_rep A B C D) imag_unit_circle_rep) imag_unit_circle_rep" "mat_det ?M \<noteq> 0"
    then obtain k where "k \<noteq> 0" "?E = cor k *\<^sub>s\<^sub>m congruence (mat_inv ?M) ?E"
      by (auto simp add: mk_moebius_rep_Rep)
    hence "unitary_gen (mat_inv ?M)"
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv ?M) ?E" "?E"]
      unfolding unitary_gen_def
      by (rule_tac x="1/cor k" in exI, simp del: mat_inv.simps, metis eye_def mat_eye_r)
    thus "unitary_gen ?M"
      using unitary_gen_inv[of "mat_inv ?M"] `mat_det ?M \<noteq> 0`
      by (simp add: mat_inv_inv del: mat_inv.simps)
  qed
next
  assume ?rhs
  thus ?lhs
    using assms
  proof transfer
    fix A B C D :: complex
    let ?M = "(A, B, C, D)" and ?E = "(1, 0, 0, 1)"
    assume "unitary_gen ?M" "mat_det ?M \<noteq> 0"
    hence "unitary_gen (mat_inv ?M)"
      using unitary_gen_inv[of ?M]
      by simp
    then obtain k where "k \<noteq> 0" "mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M) = cor k *\<^sub>s\<^sub>m eye"
      using unitary_gen_real[of "mat_inv ?M"] mat_det_inv[of ?M]
      by auto
    hence *: "?E = (1 / cor k) *\<^sub>s\<^sub>m (mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M))"
      using mult_sm_inv_l[of "cor k" eye "mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M)"]
      by simp
    show "circline_mat_eq (moebius_circline_rep (mk_moebius_rep A B C D) imag_unit_circle_rep) imag_unit_circle_rep"
      using `mat_det ?M \<noteq> 0` `k \<noteq> 0`
      by (simp add: mk_moebius_rep_Rep del: mat_inv.simps) (rule_tac x="1/k" in exI, subst *, simp del: mat_inv.simps, metis eye_def mat_eye_r)
  qed
qed

end